/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.conf.valueset;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.conf.IRIExpander;
import org.protege.editor.owl.model.conf.valueset.LabelledValue;
import org.protege.editor.owl.model.conf.valueset.ValueSet;
import org.protege.editor.owl.ui.renderer.RenderingEscapeUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;

@JsonTypeName(value="Individuals")
public class IndividualsValueSet
implements ValueSet {
    @Nonnull
    private final String classIri;

    @JsonCreator
    public IndividualsValueSet(@Nonnull @JsonProperty(value="classIri") String classIri) {
        this.classIri = (String)Preconditions.checkNotNull((Object)classIri);
    }

    @Nonnull
    public Optional<IRI> getClassIri() {
        return IRIExpander.expand(this.classIri);
    }

    @Override
    @Nonnull
    public List<LabelledValue> getLabelledValues(@Nonnull OWLModelManager modelManager) {
        return this.getClassIri().map(iri -> {
            OWLClass cls = modelManager.getOWLDataFactory().getOWLClass(iri);
            return modelManager.getActiveOntologies().stream().flatMap(o -> o.getClassAssertionAxioms((OWLClassExpression)cls).stream()).map(OWLClassAssertionAxiom::getIndividual).filter(IsAnonymous::isNamed).filter(i -> !modelManager.isDeprecated((OWLObject)i)).map(ind -> new LabelledValue(ind, RenderingEscapeUtils.unescape(modelManager.getRendering((OWLObject)ind)))).sorted((o1, o2) -> o1.getLabel().compareToIgnoreCase(o2.getLabel())).collect(Collectors.toList());
        }).orElse(Collections.emptyList());
    }
}

