import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ListDistributionsResultFilterSensitiveLog, } from "../models/models_1";
import { de_ListDistributionsCommand, se_ListDistributionsCommand } from "../protocols/Aws_restXml";
export { $Command };
export class ListDistributionsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "ListDistributions", {})
    .n("CloudFrontClient", "ListDistributionsCommand")
    .f(void 0, ListDistributionsResultFilterSensitiveLog)
    .ser(se_ListDistributionsCommand)
    .de(de_ListDistributionsCommand)
    .build() {
}
