#!/usr/bin/sh
#
# Copyright (C) 2003-2021 the pekwm development team
#
# Add this to your menu to use this script:
#
# SubMenu = "Themes" {
#   Entry { Actions = "Dynamic /path/to/this/file /path/to/themedir" }
# }
#

# Check usage
if test -z "${1}"; then
    echo "usage: $0 /path/to/themedir (theme)";
    exit 1
fi

# pekwm configuration directory, setup by pekwm but use this to ensure
# that the script will run properly without running from pekwm.
if test -z "$PEKWM_CONFIG_PATH"; then
    PEKWM_CONFIG_PATH="$HOME/.pekwm"
fi

if test -z "${2}"; then
    theme_dir="${1}"

    echo "Dynamic {"

    # Check that theme directory exists, if it does not exist create a
    # dummy entry that says the dir does not exist.
    if test -d "${theme_dir}"; then
        ( cd ${theme_dir};
          for theme_name in *; do
            # Themes must be directories. This test also prevents * globbing
            # problems if theme_dir is empty.
            if test -d "${theme_name}"; then
                theme_path="${theme_dir}/${theme_name}"
                echo "Entry = \"${theme_name}\" { Actions = \"Exec ${0} ${1} ${theme_path}\" }"
                for theme_variant in `ls ${theme_path}/theme-* 2>/dev/null | /usr/bin/grep -v '~'`; do
                    variant=`basename ${theme_variant} | /usr/bin/sed 's/theme-//'`
                    echo "Entry = \"${theme_name} (${variant})\" { Actions = \"Exec ${0} ${1} ${theme_path} ${variant}\" }"
                done
            fi
          done )
    else
        echo "Entry = \"No such directory ${theme_dir}\" { Actions = \"None\" }"
    fi

    echo "}"

else
    # Check for configuration file, if the environment is not set the
    # script is not being run from pekwm, then exit with failure.
    if ! test -f "${PEKWM_CONFIG_FILE}"; then
        exit 1;
    fi

    theme=`echo "${2}" | /usr/bin/sed -e "s@^${HOME}@~@" | /usr/bin/sed -e 's@\/@\\\/@g'`
    variant="${3}"

    # Get temporary file, not all platforms have mktemp though
    if test -x "/bin/mktemp"; then
        tmp_file=`mktemp -t pekwm_themeset.XXXXXX` || exit 1;
    else
        tmp_file="/tmp/pekwm_themeset.${USER}"
    fi

    # Change theme

    # Literal tab-character, whitespace and double quote
    tab="	"
    wspc="\\([ $tab]*\\)"
    qq='\"'
    text='[Tt][Hh][Ee][Mm][Ee]'

    /usr/bin/sed -e "/^\([^#]*\)ThemeVariant/d" \
     -e "s/^\([^#]*\)$text$wspc=$wspc$qq[^$qq]*$qq/\1Theme\2=\3$qq${theme}$qq@    ThemeVariant = $qq${variant}$qq/" \
     "${PEKWM_CONFIG_FILE}" \
     | tr '@' '\n' > "${tmp_file}"
    mv "${tmp_file}" "${PEKWM_CONFIG_FILE}"

    # Reload pekwm
    kill -HUP `xprop -root _NET_WM_PID | /usr/bin/awk '/_NET_WM_PID/ { print $3 }'`
fi

exit 0
