/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.index.fielddata.LeafFieldData;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.KNNVectorScriptDocValues;
import org.opensearch.knn.index.VectorDataType;

public class KNNVectorDVLeafFieldData
implements LeafFieldData {
    private final LeafReader reader;
    private final String fieldName;
    private final VectorDataType vectorDataType;

    public KNNVectorDVLeafFieldData(LeafReader reader, String fieldName, VectorDataType vectorDataType) {
        this.reader = reader;
        this.fieldName = fieldName;
        this.vectorDataType = vectorDataType;
    }

    public void close() {
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public ScriptDocValues<?> getScriptValues() {
        try {
            FieldInfo fieldInfo = FieldInfoExtractor.getFieldInfo(this.reader, this.fieldName);
            if (fieldInfo == null) {
                return KNNVectorScriptDocValues.emptyValues(this.fieldName, this.vectorDataType);
            }
            if (fieldInfo.hasVectorValues()) {
                return KNNVectorScriptDocValues.create((KnnVectorValues)(switch (fieldInfo.getVectorEncoding()) {
                    case VectorEncoding.FLOAT32 -> this.reader.getFloatVectorValues(this.fieldName);
                    case VectorEncoding.BYTE -> this.reader.getByteVectorValues(this.fieldName);
                    default -> throw new IllegalStateException("Unsupported Lucene vector encoding: " + String.valueOf(fieldInfo.getVectorEncoding()));
                }), this.fieldName, this.vectorDataType);
            }
            BinaryDocValues values = DocValues.getBinary((LeafReader)this.reader, (String)this.fieldName);
            return KNNVectorScriptDocValues.create((DocIdSetIterator)values, this.fieldName, this.vectorDataType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load values for knn vector field: " + this.fieldName, e);
        }
    }

    public SortedBinaryDocValues getBytesValues() {
        throw new UnsupportedOperationException("knn vector field '" + this.fieldName + "' doesn't support sorting");
    }
}

