/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.timeseries.stats.Stats;
import org.opensearch.timeseries.transport.StatsRequest;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;

public abstract class RestStatsAction
extends BaseRestHandler {
    private Stats timeSeriesStats;
    private DiscoveryNodeFilterer nodeFilter;

    public RestStatsAction(Stats timeSeriesStats, DiscoveryNodeFilterer nodeFilter) {
        this.timeSeriesStats = timeSeriesStats;
        this.nodeFilter = nodeFilter;
    }

    protected StatsRequest getRequest(RestRequest request) {
        String nodesIdsStr = request.param("nodeId");
        Set<String> validStats = this.timeSeriesStats.getStats().keySet();
        StatsRequest statsRequest = null;
        if (!Strings.isEmpty((CharSequence)nodesIdsStr)) {
            String[] nodeIdsArr = nodesIdsStr.split(",");
            statsRequest = new StatsRequest(nodeIdsArr);
        } else {
            DiscoveryNode[] dataNodes = this.nodeFilter.getEligibleDataNodes();
            statsRequest = new StatsRequest(dataNodes);
        }
        statsRequest.timeout(request.param("timeout"));
        HashSet<String> statsSet = null;
        String statsStr = request.param("stat");
        if (!Strings.isEmpty((CharSequence)statsStr)) {
            statsSet = new HashSet<String>(Arrays.asList(statsStr.split(",")));
        }
        if (statsSet == null) {
            statsRequest.addAll(validStats);
        } else if (statsSet.size() == 1 && statsSet.contains("_all")) {
            statsRequest.addAll(validStats);
        } else {
            if (statsSet.contains("_all")) {
                throw new IllegalArgumentException("Request " + request.path() + " contains _all and individual stats");
            }
            TreeSet<String> invalidStats = new TreeSet<String>();
            for (String stat : statsSet) {
                if (validStats.contains(stat)) {
                    statsRequest.addStat(stat);
                    continue;
                }
                invalidStats.add(stat);
            }
            if (!invalidStats.isEmpty()) {
                throw new IllegalArgumentException(this.unrecognized(request, invalidStats, statsRequest.getStatsToBeRetrieved(), "stat"));
            }
        }
        return statsRequest;
    }
}

