/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.metrics.InternalMax;
import org.opensearch.timeseries.annotation.Generated;

public class AnomalyResultBucket
implements ToXContentObject,
Writeable {
    public static final String BUCKETS_FIELD = "buckets";
    public static final String KEY_FIELD = "key";
    public static final String DOC_COUNT_FIELD = "doc_count";
    public static final String MAX_ANOMALY_GRADE_FIELD = "max_anomaly_grade";
    private final Map<String, Object> key;
    private final int docCount;
    private final double maxAnomalyGrade;

    public AnomalyResultBucket(Map<String, Object> key, int docCount, double maxAnomalyGrade) {
        this.key = key;
        this.docCount = docCount;
        this.maxAnomalyGrade = maxAnomalyGrade;
    }

    public AnomalyResultBucket(StreamInput input) throws IOException {
        this.key = input.readMap();
        this.docCount = input.readInt();
        this.maxAnomalyGrade = input.readDouble();
    }

    public static AnomalyResultBucket createAnomalyResultBucket(CompositeAggregation.Bucket bucket) {
        return new AnomalyResultBucket(bucket.getKey(), (int)bucket.getDocCount(), ((InternalMax)bucket.getAggregations().get(MAX_ANOMALY_GRADE_FIELD)).getValue());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(KEY_FIELD, this.key).field(DOC_COUNT_FIELD, this.docCount).field(MAX_ANOMALY_GRADE_FIELD, this.maxAnomalyGrade);
        return xContentBuilder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.key);
        out.writeInt(this.docCount);
        out.writeDouble(this.maxAnomalyGrade);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnomalyResultBucket that = (AnomalyResultBucket)o;
        return Objects.equal(this.getKey(), that.getKey()) && Objects.equal((Object)this.getDocCount(), (Object)that.getDocCount()) && Objects.equal((Object)this.getMaxAnomalyGrade(), (Object)that.getMaxAnomalyGrade());
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getKey(), this.getDocCount(), this.getMaxAnomalyGrade()});
    }

    @Generated
    public String toString() {
        return new ToStringBuilder((Object)this).append(KEY_FIELD, this.key).append("docCount", this.docCount).append("maxAnomalyGrade", this.maxAnomalyGrade).toString();
    }

    public Map<String, Object> getKey() {
        return this.key;
    }

    public int getDocCount() {
        return this.docCount;
    }

    public double getMaxAnomalyGrade() {
        return this.maxAnomalyGrade;
    }
}

