// This file was generated by qtwaylandscanner
// source file is color-representation-v1.xml

#ifndef QT_WAYLAND_SERVER_COLOR_REPRESENTATION_V1
#define QT_WAYLAND_SERVER_COLOR_REPRESENTATION_V1

#include "wayland-server-core.h"
#include "wayland-color-representation-v1-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  wp_color_representation_manager_v1
    {
    public:
        wp_color_representation_manager_v1(struct ::wl_client *client, int id, int version);
        wp_color_representation_manager_v1(struct ::wl_display *display, int version);
        wp_color_representation_manager_v1(struct ::wl_resource *resource);
        wp_color_representation_manager_v1();

        virtual ~wp_color_representation_manager_v1();

        class Resource
        {
        public:
            Resource() : wp_color_representation_manager_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_color_representation_manager_v1 *wp_color_representation_manager_v1_object;
            wp_color_representation_manager_v1 *object() { return wp_color_representation_manager_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_surface_exists = 1, // color representation surface exists already
        };

        void send_supported_alpha_mode(uint32_t alpha_mode);
        void send_supported_alpha_mode(struct ::wl_resource *resource, uint32_t alpha_mode);
        void send_supported_coefficients_and_ranges(uint32_t coefficients, uint32_t range);
        void send_supported_coefficients_and_ranges(struct ::wl_resource *resource, uint32_t coefficients, uint32_t range);
        void send_done();
        void send_done(struct ::wl_resource *resource);

    protected:
        virtual Resource *wp_color_representation_manager_v1_allocate();

        virtual void wp_color_representation_manager_v1_destroy_global();

        virtual void wp_color_representation_manager_v1_bind_resource(Resource *resource);
        virtual void wp_color_representation_manager_v1_destroy_resource(Resource *resource);

        virtual void wp_color_representation_manager_v1_destroy(Resource *resource);
        virtual void wp_color_representation_manager_v1_get_surface(Resource *resource, uint32_t id, struct ::wl_resource *surface);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wp_color_representation_manager_v1_interface m_wp_color_representation_manager_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_get_surface(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            struct ::wl_resource *surface);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_color_representation_manager_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  wp_color_representation_surface_v1
    {
    public:
        wp_color_representation_surface_v1(struct ::wl_client *client, int id, int version);
        wp_color_representation_surface_v1(struct ::wl_display *display, int version);
        wp_color_representation_surface_v1(struct ::wl_resource *resource);
        wp_color_representation_surface_v1();

        virtual ~wp_color_representation_surface_v1();

        class Resource
        {
        public:
            Resource() : wp_color_representation_surface_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_color_representation_surface_v1 *wp_color_representation_surface_v1_object;
            wp_color_representation_surface_v1 *object() { return wp_color_representation_surface_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_alpha_mode = 1, // unsupported alpha mode
            error_coefficients = 2, // unsupported coefficients
            error_pixel_format = 3, // the pixel format and a set value are incompatible
            error_inert = 4, // forbidden request on inert object
        };

        enum alpha_mode {
            alpha_mode_premultiplied_electrical = 0,
            alpha_mode_premultiplied_optical = 1,
            alpha_mode_straight = 2,
        };

        enum coefficients {
            coefficients_identity = 1,
            coefficients_bt709 = 2,
            coefficients_fcc = 3,
            coefficients_bt601 = 4,
            coefficients_smpte240 = 5,
            coefficients_bt2020 = 6,
            coefficients_bt2020_cl = 7,
            coefficients_ictcp = 8,
        };

        enum range {
            range_full = 1, // Full color range
            range_limited = 2, // Limited color range
        };

        enum chroma_location {
            chroma_location_type_0 = 1,
            chroma_location_type_1 = 2,
            chroma_location_type_2 = 3,
            chroma_location_type_3 = 4,
            chroma_location_type_4 = 5,
            chroma_location_type_5 = 6,
        };

    protected:
        virtual Resource *wp_color_representation_surface_v1_allocate();

        virtual void wp_color_representation_surface_v1_destroy_global();

        virtual void wp_color_representation_surface_v1_bind_resource(Resource *resource);
        virtual void wp_color_representation_surface_v1_destroy_resource(Resource *resource);

        virtual void wp_color_representation_surface_v1_destroy(Resource *resource);
        virtual void wp_color_representation_surface_v1_set_alpha_mode(Resource *resource, uint32_t alpha_mode);
        virtual void wp_color_representation_surface_v1_set_coefficients_and_range(Resource *resource, uint32_t coefficients, uint32_t range);
        virtual void wp_color_representation_surface_v1_set_chroma_location(Resource *resource, uint32_t chroma_location);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wp_color_representation_surface_v1_interface m_wp_color_representation_surface_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_set_alpha_mode(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t alpha_mode);
        static void handle_set_coefficients_and_range(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t coefficients,
            uint32_t range);
        static void handle_set_chroma_location(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t chroma_location);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_color_representation_surface_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
