/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.dirtyFiles;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.incremental.AbiSnapshot;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.IncrementalCompilationFeatures;
import org.jetbrains.kotlin.incremental.IncrementalCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalJvmCachesManager;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.dirtyFiles.ChangesDetectionUtilsKt;
import org.jetbrains.kotlin.incremental.dirtyFiles.ClasspathSnapshotBasedImpactDeterminer;
import org.jetbrains.kotlin.incremental.dirtyFiles.DirtyFilesContainer;
import org.jetbrains.kotlin.incremental.dirtyFiles.DirtyFilesProvider;
import org.jetbrains.kotlin.incremental.dirtyFiles.HistoryFilesBasedImpactDeterminer;
import org.jetbrains.kotlin.incremental.dirtyFiles.ImpactedFilesDeterminer;
import org.jetbrains.kotlin.incremental.dirtyFiles.JvmSourcesToCompileCalculatorKt;
import org.jetbrains.kotlin.incremental.javaInterop.JavaInteropCoordinator;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.snapshots.LazyClasspathSnapshot;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJL\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/incremental/dirtyFiles/JvmSourcesToCompileCalculator;", "", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCachesManager;", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$DeterminableFiles$Known;", "kotlinSourceFilesExtensions", "", "", "javaInteropCoordinator", "Lorg/jetbrains/kotlin/incremental/javaInterop/JavaInteropCoordinator;", "dirtyFilesProvider", "Lorg/jetbrains/kotlin/incremental/dirtyFiles/DirtyFilesProvider;", "reporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "<init>", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCachesManager;Lorg/jetbrains/kotlin/incremental/ChangedFiles$DeterminableFiles$Known;Ljava/util/Set;Lorg/jetbrains/kotlin/incremental/javaInterop/JavaInteropCoordinator;Lorg/jetbrains/kotlin/incremental/dirtyFiles/DirtyFilesProvider;Lorg/jetbrains/kotlin/build/report/BuildReporter;)V", "calculateSourcesToCompileImpl", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;", "impactedFilesDeterminer", "Lorg/jetbrains/kotlin/incremental/dirtyFiles/ImpactedFilesDeterminer;", "calculateSourcesToCompileWithKnownChanges", "changedAndImpactedSymbols", "Lorg/jetbrains/kotlin/incremental/ChangesEither$Known;", "calculateWithClasspathSnapshot", "classpathChanges", "Lorg/jetbrains/kotlin/incremental/ClasspathChanges;", "lazyClasspathSnapshot", "Lorg/jetbrains/kotlin/incremental/snapshots/LazyClasspathSnapshot;", "calculateWithBuildHistory", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "abiSnapshots", "", "Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "modulesApiHistory", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;", "buildHistoryFile", "Ljava/io/File;", "lastBuildInfoFile", "icFeatures", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationFeatures;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nJvmSourcesToCompileCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSourcesToCompileCalculator.kt\norg/jetbrains/kotlin/incremental/dirtyFiles/JvmSourcesToCompileCalculator\n+ 2 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n*L\n1#1,141:1\n31#2,5:142\n31#2,5:147\n31#2,5:152\n*S KotlinDebug\n*F\n+ 1 JvmSourcesToCompileCalculator.kt\norg/jetbrains/kotlin/incremental/dirtyFiles/JvmSourcesToCompileCalculator\n*L\n66#1:142,5\n73#1:147,5\n76#1:152,5\n*E\n"})
public final class JvmSourcesToCompileCalculator {
    @NotNull
    private final IncrementalJvmCachesManager caches;
    @NotNull
    private final ChangedFiles.DeterminableFiles.Known changedFiles;
    @NotNull
    private final Set<String> kotlinSourceFilesExtensions;
    @NotNull
    private final JavaInteropCoordinator javaInteropCoordinator;
    @NotNull
    private final DirtyFilesProvider dirtyFilesProvider;
    @NotNull
    private final BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter;

    public JvmSourcesToCompileCalculator(@NotNull IncrementalJvmCachesManager caches, @NotNull ChangedFiles.DeterminableFiles.Known changedFiles, @NotNull Set<String> kotlinSourceFilesExtensions, @NotNull JavaInteropCoordinator javaInteropCoordinator, @NotNull DirtyFilesProvider dirtyFilesProvider, @NotNull BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter) {
        Intrinsics.checkNotNullParameter((Object)caches, (String)"caches");
        Intrinsics.checkNotNullParameter((Object)changedFiles, (String)"changedFiles");
        Intrinsics.checkNotNullParameter(kotlinSourceFilesExtensions, (String)"kotlinSourceFilesExtensions");
        Intrinsics.checkNotNullParameter((Object)javaInteropCoordinator, (String)"javaInteropCoordinator");
        Intrinsics.checkNotNullParameter((Object)dirtyFilesProvider, (String)"dirtyFilesProvider");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        this.caches = caches;
        this.changedFiles = changedFiles;
        this.kotlinSourceFilesExtensions = kotlinSourceFilesExtensions;
        this.javaInteropCoordinator = javaInteropCoordinator;
        this.dirtyFilesProvider = dirtyFilesProvider;
        this.reporter = reporter;
    }

    private final IncrementalCompilerRunner.CompilationMode calculateSourcesToCompileImpl(ImpactedFilesDeterminer impactedFilesDeterminer) {
        IncrementalCompilerRunner.CompilationMode compilationMode;
        ChangesEither changedAndImpactedSymbols = impactedFilesDeterminer.determineChangedAndImpactedSymbols();
        ChangesEither changesEither = changedAndImpactedSymbols;
        if (changesEither instanceof ChangesEither.Unknown) {
            ICReporterKt.info(this.reporter, (Function0<String>)((Function0)() -> JvmSourcesToCompileCalculator.calculateSourcesToCompileImpl$lambda$0(changedAndImpactedSymbols)));
            compilationMode = new IncrementalCompilerRunner.CompilationMode.Rebuild(((ChangesEither.Unknown)changedAndImpactedSymbols).getReason());
        } else if (changesEither instanceof ChangesEither.Known) {
            compilationMode = this.calculateSourcesToCompileWithKnownChanges(this.changedFiles, (ChangesEither.Known)changedAndImpactedSymbols);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return compilationMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IncrementalCompilerRunner.CompilationMode calculateSourcesToCompileWithKnownChanges(ChangedFiles.DeterminableFiles.Known changedFiles, ChangesEither.Known changedAndImpactedSymbols) {
        DirtyData dirtyData;
        void $this$measure$iv;
        void $this$measure$iv2;
        Object object;
        void $this$measure$iv3;
        DirtyFilesContainer dirtyFiles = this.dirtyFilesProvider.getInitializedDirtyFiles(this.caches, changedFiles);
        dirtyFiles.addByDirtySymbols(changedAndImpactedSymbols.getLookupSymbols());
        dirtyFiles.addByDirtyClasses(changedAndImpactedSymbols.getFqNames());
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        Object time$iv = GradleBuildTime.IC_ANALYZE_CHANGES_IN_JAVA_SOURCES;
        boolean $i$f$measure = false;
        $this$measure$iv3.startMeasure(time$iv);
        try {
            boolean bl = false;
            IncrementalCompilerRunner.CompilationMode.Rebuild javaRebuildReason = this.javaInteropCoordinator.analyzeChangesInJavaSources(this.caches, changedFiles, dirtyFiles);
            if (javaRebuildReason != null) {
                IncrementalCompilerRunner.CompilationMode compilationMode = javaRebuildReason;
                return compilationMode;
            }
            object = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv3.endMeasure(time$iv);
        }
        time$iv = this.reporter;
        Object time$iv2 = GradleBuildTime.IC_ANALYZE_CHANGES_IN_ANDROID_LAYOUTS;
        boolean $i$f$measure2 = false;
        $this$measure$iv2.startMeasure(time$iv2);
        try {
            boolean bl = false;
            object = JvmSourcesToCompileCalculatorKt.access$processLookupSymbolsForAndroidLayouts(changedFiles);
        }
        finally {
            $this$measure$iv2.endMeasure(time$iv2);
        }
        Object androidLayoutChanges = object;
        time$iv2 = this.reporter;
        BuildTime time$iv3 = GradleBuildTime.IC_DETECT_REMOVED_CLASSES;
        boolean $i$f$measure3 = false;
        $this$measure$iv.startMeasure(time$iv3);
        try {
            boolean bl = false;
            dirtyData = ChangesDetectionUtilsKt.getRemovedClassesChanges(this.caches, changedFiles, this.kotlinSourceFilesExtensions, this.reporter);
        }
        finally {
            $this$measure$iv.endMeasure(time$iv3);
        }
        DirtyData removedClassesChanges = dirtyData;
        dirtyFiles.addByDirtySymbols((Collection<LookupSymbol>)androidLayoutChanges);
        dirtyFiles.addByDirtySymbols(removedClassesChanges.getDirtyLookupSymbols());
        dirtyFiles.addByDirtyClasses(removedClassesChanges.getDirtyClassesFqNames());
        dirtyFiles.addByDirtyClasses(removedClassesChanges.getDirtyClassesFqNamesForceRecompile());
        return new IncrementalCompilerRunner.CompilationMode.Incremental(dirtyFiles);
    }

    @NotNull
    public final IncrementalCompilerRunner.CompilationMode calculateWithClasspathSnapshot(@NotNull ClasspathChanges classpathChanges, @NotNull LazyClasspathSnapshot lazyClasspathSnapshot) {
        Intrinsics.checkNotNullParameter((Object)classpathChanges, (String)"classpathChanges");
        Intrinsics.checkNotNullParameter((Object)lazyClasspathSnapshot, (String)"lazyClasspathSnapshot");
        ClasspathSnapshotBasedImpactDeterminer impactedFilesDeterminer = new ClasspathSnapshotBasedImpactDeterminer(this.caches, classpathChanges, lazyClasspathSnapshot, this.reporter);
        return this.calculateSourcesToCompileImpl(impactedFilesDeterminer);
    }

    @NotNull
    public final IncrementalCompilerRunner.CompilationMode calculateWithBuildHistory(@NotNull K2JVMCompilerArguments args, @NotNull Map<String, ? extends AbiSnapshot> abiSnapshots, @NotNull ModulesApiHistory modulesApiHistory, @Nullable File buildHistoryFile, @NotNull File lastBuildInfoFile, @NotNull IncrementalCompilationFeatures icFeatures, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(abiSnapshots, (String)"abiSnapshots");
        Intrinsics.checkNotNullParameter((Object)modulesApiHistory, (String)"modulesApiHistory");
        Intrinsics.checkNotNullParameter((Object)lastBuildInfoFile, (String)"lastBuildInfoFile");
        Intrinsics.checkNotNullParameter((Object)icFeatures, (String)"icFeatures");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        HistoryFilesBasedImpactDeterminer impactedFilesDeterminer = new HistoryFilesBasedImpactDeterminer(args, this.caches, this.changedFiles, abiSnapshots, modulesApiHistory, buildHistoryFile, lastBuildInfoFile, icFeatures, this.reporter, messageCollector);
        return this.calculateSourcesToCompileImpl(impactedFilesDeterminer);
    }

    private static final String calculateSourcesToCompileImpl$lambda$0(ChangesEither $changedAndImpactedSymbols) {
        return "Could not get classpath changes: " + ((ChangesEither.Unknown)$changedAndImpactedSymbols).getReason();
    }
}

