/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AbstractElement;
import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedValue;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.values.AnimatableNumberValue;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedNumber;

public class SVGOMAnimatedNumber
extends AbstractSVGAnimatedValue
implements SVGAnimatedNumber {
    protected float defaultValue;
    protected boolean allowPercentage;
    protected boolean valid;
    protected float baseVal;
    protected float animVal;
    protected boolean changing;

    public SVGOMAnimatedNumber(AbstractElement abstractElement, String string, String string2, float f) {
        this(abstractElement, string, string2, f, false);
    }

    public SVGOMAnimatedNumber(AbstractElement abstractElement, String string, String string2, float f, boolean bl) {
        super(abstractElement, string, string2);
        this.defaultValue = f;
        this.allowPercentage = bl;
    }

    public float getBaseVal() {
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    protected void update() {
        Attr attr = this.element.getAttributeNodeNS(this.namespaceURI, this.localName);
        if (attr == null) {
            this.baseVal = this.defaultValue;
        } else {
            String string = attr.getValue();
            int n = string.length();
            this.baseVal = this.allowPercentage && n > 1 && string.charAt(n - 1) == '%' ? 0.01f * Float.parseFloat(string.substring(0, n - 1)) : Float.parseFloat(string);
        }
        this.valid = true;
    }

    public void setBaseVal(float f) throws DOMException {
        try {
            this.baseVal = f;
            this.valid = true;
            this.changing = true;
            this.element.setAttributeNS(this.namespaceURI, this.localName, String.valueOf(f));
        }
        finally {
            this.changing = false;
        }
    }

    public float getAnimVal() {
        if (this.hasAnimVal) {
            return this.animVal;
        }
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        return new AnimatableNumberValue(animationTarget, this.getBaseVal());
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            this.animVal = ((AnimatableNumberValue)animatableValue).getValue();
        }
        this.fireAnimatedAttributeListeners();
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }
}

