/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.RandomAccess;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ExternalArrayData;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;
import org.mozilla.javascript.typedarrays.NativeTypedArrayIterator;

public abstract class NativeTypedArrayView<T>
extends NativeArrayBufferView
implements List<T>,
RandomAccess,
ExternalArrayData {
    private static final long serialVersionUID = -4963053773152251274L;
    protected final int length;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_get = 3;
    private static final int Id_set = 4;
    private static final int Id_subarray = 5;
    private static final int Id_at = 6;
    private static final int SymbolId_iterator = 7;
    protected static final int MAX_PROTOTYPE_ID = 7;
    private static final int Id_length = 4;
    private static final int Id_BYTES_PER_ELEMENT = 5;
    private static final int MAX_INSTANCE_ID = 5;

    protected NativeTypedArrayView() {
        this.length = 0;
    }

    protected NativeTypedArrayView(NativeArrayBuffer nativeArrayBuffer, int n, int n2, int n3) {
        super(nativeArrayBuffer, n, n3);
        this.length = n2;
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        return this.js_get(n);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        int n;
        Optional<Double> optional = ScriptRuntime.canonicalNumericIndexString(string);
        if (optional.isPresent() && (n = NativeTypedArrayView.toIndex(optional.get())) >= 0) {
            return this.js_get(n);
        }
        return super.get(string, scriptable);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return !this.checkIndex(n);
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        int n;
        Optional<Double> optional = ScriptRuntime.canonicalNumericIndexString(string);
        if (optional.isPresent() && (n = NativeTypedArrayView.toIndex(optional.get())) >= 0) {
            return !this.checkIndex(n);
        }
        return super.has(string, scriptable);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        this.js_set(n, object);
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        Optional<Double> optional = ScriptRuntime.canonicalNumericIndexString(string);
        if (optional.isPresent()) {
            int n = NativeTypedArrayView.toIndex(optional.get());
            if (n >= 0) {
                this.js_set(n, object);
            }
        } else {
            super.put(string, scriptable, object);
        }
    }

    @Override
    public void delete(int n) {
    }

    @Override
    public void delete(String string) {
        Optional<Double> optional = ScriptRuntime.canonicalNumericIndexString(string);
        if (!optional.isPresent()) {
            super.delete(string);
        }
    }

    @Override
    public Object[] getIds() {
        Object[] objectArray = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            objectArray[i] = i;
        }
        return objectArray;
    }

    private static int toIndex(double d) {
        int n = (int)d;
        if ((double)n == d && n >= 0) {
            return n;
        }
        return -1;
    }

    protected boolean checkIndex(int n) {
        return n < 0 || n >= this.length;
    }

    public abstract int getBytesPerElement();

    protected abstract NativeTypedArrayView<T> construct(NativeArrayBuffer var1, int var2, int var3);

    protected abstract Object js_get(int var1);

    protected abstract Object js_set(int var1, Object var2);

    protected abstract NativeTypedArrayView<T> realThis(Scriptable var1, IdFunctionObject var2);

    private NativeArrayBuffer makeArrayBuffer(Context context, Scriptable scriptable, int n) {
        return (NativeArrayBuffer)context.newObject(scriptable, "ArrayBuffer", new Object[]{(double)n * (double)this.getBytesPerElement()});
    }

    private NativeTypedArrayView<T> js_constructor(Context context, Scriptable scriptable, Object[] objectArray) {
        if (!NativeTypedArrayView.isArg(objectArray, 0)) {
            return this.construct(new NativeArrayBuffer(), 0, 0);
        }
        Object object = objectArray[0];
        if (object == null) {
            return this.construct(new NativeArrayBuffer(), 0, 0);
        }
        if (object instanceof Number || object instanceof String) {
            int n = ScriptRuntime.toInt32(object);
            NativeArrayBuffer nativeArrayBuffer = this.makeArrayBuffer(context, scriptable, n);
            return this.construct(nativeArrayBuffer, 0, n);
        }
        if (object instanceof NativeTypedArrayView) {
            NativeTypedArrayView nativeTypedArrayView = (NativeTypedArrayView)object;
            NativeArrayBuffer nativeArrayBuffer = this.makeArrayBuffer(context, scriptable, nativeTypedArrayView.length);
            NativeTypedArrayView<T> nativeTypedArrayView2 = this.construct(nativeArrayBuffer, 0, nativeTypedArrayView.length);
            for (int i = 0; i < nativeTypedArrayView.length; ++i) {
                nativeTypedArrayView2.js_set(i, nativeTypedArrayView.js_get(i));
            }
            return nativeTypedArrayView2;
        }
        if (object instanceof NativeArrayBuffer) {
            NativeArrayBuffer nativeArrayBuffer = (NativeArrayBuffer)object;
            int n = NativeTypedArrayView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : 0;
            int n2 = NativeTypedArrayView.isArg(objectArray, 2) ? ScriptRuntime.toInt32(objectArray[2]) * this.getBytesPerElement() : nativeArrayBuffer.getLength() - n;
            if (n < 0 || n > nativeArrayBuffer.buffer.length) {
                throw ScriptRuntime.rangeError("offset out of range");
            }
            if (n2 < 0 || n + n2 > nativeArrayBuffer.buffer.length) {
                throw ScriptRuntime.rangeError("length out of range");
            }
            if (n % this.getBytesPerElement() != 0) {
                throw ScriptRuntime.rangeError("offset must be a multiple of the byte size");
            }
            if (n2 % this.getBytesPerElement() != 0) {
                throw ScriptRuntime.rangeError("offset and buffer must be a multiple of the byte size");
            }
            return this.construct(nativeArrayBuffer, n, n2 / this.getBytesPerElement());
        }
        if (object instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)object;
            NativeArrayBuffer nativeArrayBuffer = this.makeArrayBuffer(context, scriptable, nativeArray.size());
            NativeTypedArrayView<T> nativeTypedArrayView = this.construct(nativeArrayBuffer, 0, nativeArray.size());
            for (int i = 0; i < nativeArray.size(); ++i) {
                Object object2 = nativeArray.get(i, (Scriptable)nativeArray);
                if (object2 == Scriptable.NOT_FOUND || object2 == Undefined.instance) {
                    nativeTypedArrayView.js_set(i, ScriptRuntime.NaNobj);
                    continue;
                }
                if (object2 instanceof Wrapper) {
                    nativeTypedArrayView.js_set(i, ((Wrapper)object2).unwrap());
                    continue;
                }
                nativeTypedArrayView.js_set(i, object2);
            }
            return nativeTypedArrayView;
        }
        if (ScriptRuntime.isArrayObject(object)) {
            Object[] objectArray2 = ScriptRuntime.getArrayElements((Scriptable)object);
            NativeArrayBuffer nativeArrayBuffer = this.makeArrayBuffer(context, scriptable, objectArray2.length);
            NativeTypedArrayView<T> nativeTypedArrayView = this.construct(nativeArrayBuffer, 0, objectArray2.length);
            for (int i = 0; i < objectArray2.length; ++i) {
                nativeTypedArrayView.js_set(i, objectArray2[i]);
            }
            return nativeTypedArrayView;
        }
        throw ScriptRuntime.constructError("Error", "invalid argument");
    }

    private void setRange(NativeTypedArrayView<T> nativeTypedArrayView, int n) {
        if (n >= this.length) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        if (nativeTypedArrayView.length > this.length - n) {
            throw ScriptRuntime.rangeError("source array too long");
        }
        if (nativeTypedArrayView.arrayBuffer == this.arrayBuffer) {
            int n2;
            Object[] objectArray = new Object[nativeTypedArrayView.length];
            for (n2 = 0; n2 < nativeTypedArrayView.length; ++n2) {
                objectArray[n2] = nativeTypedArrayView.js_get(n2);
            }
            for (n2 = 0; n2 < nativeTypedArrayView.length; ++n2) {
                this.js_set(n2 + n, objectArray[n2]);
            }
        } else {
            for (int i = 0; i < nativeTypedArrayView.length; ++i) {
                this.js_set(i + n, nativeTypedArrayView.js_get(i));
            }
        }
    }

    private void setRange(NativeArray nativeArray, int n) {
        if (n > this.length) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        if (n + nativeArray.size() > this.length) {
            throw ScriptRuntime.rangeError("offset + length out of range");
        }
        int n2 = n;
        for (Object e : nativeArray) {
            this.js_set(n2, e);
            ++n2;
        }
    }

    private Object js_subarray(Context context, Scriptable scriptable, int n, int n2) {
        int n3 = n < 0 ? this.length + n : n;
        int n4 = n2 < 0 ? this.length + n2 : n2;
        n3 = Math.max(0, n3);
        n4 = Math.min(this.length, n4);
        int n5 = Math.max(0, n4 - n3);
        int n6 = Math.min(this.getByteOffset() + n3 * this.getBytesPerElement(), this.arrayBuffer.getLength());
        return context.newObject(scriptable, this.getClassName(), new Object[]{this.arrayBuffer, n6, n5});
    }

    private Object js_at(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        long l;
        long l2 = 0L;
        if (objectArray.length >= 1) {
            l2 = (long)ScriptRuntime.toInteger(objectArray[0]);
        }
        long l3 = l = l2 >= 0L ? l2 : (long)this.length + l2;
        if (l < 0L || l >= (long)this.length) {
            return Undefined.instance;
        }
        return NativeTypedArrayView.getProperty(scriptable2, (int)l);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(this.getClassName())) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                if (scriptable2 != null && context.getLanguageVersion() >= 200) {
                    throw ScriptRuntime.typeErrorById("msg.only.from.new", this.getClassName());
                }
                return this.js_constructor(context, scriptable, objectArray);
            }
            case 2: {
                NativeTypedArrayView<T> nativeTypedArrayView = this.realThis(scriptable2, idFunctionObject);
                int n2 = nativeTypedArrayView.getArrayLength();
                StringBuilder stringBuilder = new StringBuilder();
                if (n2 > 0) {
                    stringBuilder.append(ScriptRuntime.toString(nativeTypedArrayView.js_get(0)));
                }
                for (int i = 1; i < n2; ++i) {
                    stringBuilder.append(',');
                    stringBuilder.append(ScriptRuntime.toString(nativeTypedArrayView.js_get(i)));
                }
                return stringBuilder.toString();
            }
            case 3: {
                if (objectArray.length > 0) {
                    return this.realThis(scriptable2, idFunctionObject).js_get(ScriptRuntime.toInt32(objectArray[0]));
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 4: {
                if (objectArray.length > 0) {
                    NativeTypedArrayView<T> nativeTypedArrayView = this.realThis(scriptable2, idFunctionObject);
                    if (objectArray[0] instanceof NativeTypedArrayView) {
                        int n3 = NativeTypedArrayView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : 0;
                        NativeTypedArrayView nativeTypedArrayView2 = (NativeTypedArrayView)objectArray[0];
                        super.setRange(nativeTypedArrayView2, n3);
                        return Undefined.instance;
                    }
                    if (objectArray[0] instanceof NativeArray) {
                        int n4 = NativeTypedArrayView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : 0;
                        super.setRange((NativeArray)objectArray[0], n4);
                        return Undefined.instance;
                    }
                    if (objectArray[0] instanceof Scriptable) {
                        return Undefined.instance;
                    }
                    if (NativeTypedArrayView.isArg(objectArray, 2)) {
                        return nativeTypedArrayView.js_set(ScriptRuntime.toInt32(objectArray[0]), objectArray[1]);
                    }
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 5: {
                int n5;
                NativeTypedArrayView<T> nativeTypedArrayView = this.realThis(scriptable2, idFunctionObject);
                int n6 = NativeTypedArrayView.isArg(objectArray, 0) ? ScriptRuntime.toInt32(objectArray[0]) : 0;
                int n7 = n5 = NativeTypedArrayView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : nativeTypedArrayView.length;
                if (context.getLanguageVersion() >= 200 || objectArray.length > 0) {
                    return super.js_subarray(context, scriptable, n6, n5);
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 6: {
                NativeTypedArrayView<T> nativeTypedArrayView = this.realThis(scriptable2, idFunctionObject);
                if (context.getLanguageVersion() >= 200 || objectArray.length > 0) {
                    return super.js_at(context, scriptable, scriptable2, objectArray);
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 7: {
                return new NativeArrayIterator(scriptable, scriptable2, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        if (n == 7) {
            this.initPrototypeMethod((Object)this.getClassName(), n, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
            return;
        }
        String string2 = null;
        switch (n) {
            case 1: {
                n2 = 3;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 1;
                string = "get";
                break;
            }
            case 4: {
                n2 = 2;
                string = "set";
                break;
            }
            case 5: {
                n2 = 2;
                string = "subarray";
                break;
            }
            case 6: {
                n2 = 1;
                string = "at";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod((Object)this.getClassName(), n, string, string2, n2);
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.ITERATOR.equals(symbol)) {
            return 7;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "toString": {
                n = 2;
                break;
            }
            case "get": {
                n = 3;
                break;
            }
            case "set": {
                n = 4;
                break;
            }
            case "subarray": {
                n = 5;
                break;
            }
            case "at": {
                n = 6;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        idFunctionObject.defineProperty("BYTES_PER_ELEMENT", (Object)ScriptRuntime.wrapInt(this.getBytesPerElement()), 7);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected int getMaxInstanceId() {
        return 5;
    }

    @Override
    protected String getInstanceIdName(int n) {
        switch (n) {
            case 4: {
                return "length";
            }
            case 5: {
                return "BYTES_PER_ELEMENT";
            }
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        switch (n) {
            case 4: {
                return ScriptRuntime.wrapInt(this.length);
            }
            case 5: {
                return ScriptRuntime.wrapInt(this.getBytesPerElement());
            }
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n;
        switch (string) {
            case "length": {
                n = 4;
                break;
            }
            case "BYTES_PER_ELEMENT": {
                n = 5;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (n == 0) {
            return super.findInstanceIdInfo(string);
        }
        if (n == 5) {
            return NativeTypedArrayView.instanceIdInfo(7, n);
        }
        return NativeTypedArrayView.instanceIdInfo(5, n);
    }

    @Override
    public Object getArrayElement(int n) {
        return this.js_get(n);
    }

    @Override
    public void setArrayElement(int n, Object object) {
        this.js_set(n, object);
    }

    @Override
    public int getArrayLength() {
        return this.length;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.length; ++i) {
            if (!object.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!object.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            objectArray[i] = this.js_get(i);
        }
        return objectArray;
    }

    @Override
    public <U> U[] toArray(U[] UArray) {
        Object[] objectArray = UArray.length >= this.length ? UArray : (Object[])Array.newInstance(UArray.getClass().getComponentType(), this.length);
        for (int i = 0; i < this.length; ++i) {
            try {
                objectArray[i] = this.js_get(i);
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new ArrayStoreException();
            }
        }
        return objectArray;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            NativeTypedArrayView nativeTypedArrayView = (NativeTypedArrayView)object;
            if (this.length != nativeTypedArrayView.length) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.js_get(i).equals(nativeTypedArrayView.js_get(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.length; ++i) {
            n += this.js_get(i).hashCode();
        }
        return n;
    }

    @Override
    public Iterator<T> iterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return new NativeTypedArrayIterator(this, n);
    }

    @Override
    public List<T> subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }
}

