/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.HTMLDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class HTMLElement
extends DOMElement
implements org.w3c.dom.html.HTMLElement {
    private static final long serialVersionUID = 1L;

    HTMLElement(String string) {
        super(string, "http://www.w3.org/1999/xhtml");
    }

    HTMLElement(String string, String string2) {
        super(string, string2);
    }

    @Override
    void checkAppendNodeHierarchy(Node node) {
        super.checkAppendNodeHierarchy(node);
        if (this.isNonHTMLOrVoid()) {
            throw new DOMException(3, "This element is void");
        }
    }

    @Override
    boolean isNonHTMLOrVoid() {
        return "br".equals(this.localName) || "hr".equals(this.localName) || "input".equals(this.localName) || "area".equals(this.localName) || "col".equals(this.localName) || "embed".equals(this.localName) || "param".equals(this.localName) || "source".equals(this.localName) || "track".equals(this.localName) || "wbr".equals(this.localName);
    }

    @Override
    boolean isNonPrintableElement() {
        String string = this.getLocalName();
        return "iframe".equals(string) || "canvas".equals(string) || "video".equals(string) || "button".equals(string) || "select".equals(string) || "noscript".equals(string);
    }

    @Override
    boolean innerTextVoidElement(DOMElement dOMElement, boolean bl, StringBuilder stringBuilder) {
        if ("br".equals(dOMElement.getLocalName())) {
            this.trimBuffer(bl, stringBuilder);
            stringBuilder.append('\n');
            return true;
        }
        return bl;
    }

    @Override
    public String getDir() {
        return this.getAttribute("dir");
    }

    @Override
    public void setDir(String string) {
        this.setAttribute("dir", string);
    }

    @Override
    public String getLang() {
        return this.getAttribute("lang");
    }

    @Override
    public void setLang(String string) {
        this.setAttribute("lang", string);
    }

    @Override
    public String getTitle() {
        return this.getAttribute("title");
    }

    @Override
    public void setTitle(String string) {
        this.setAttribute("title", string);
    }

    @Override
    public abstract HTMLDocument getOwnerDocument();
}

