import { type Scanner } from "./scanner.js";
import { type DiagnosticMessage, type Identifier, type SourceFile, SyntaxKind, type SyntaxNode } from "./types";
export declare enum ParsingContext {
    None = 0,
    StatementList = 1,
    AttributeContainerList = 2,
    AssignmentList = 3,
    EdgeRhsList = 4,
    QuotedTextIdentifierConcatenation = 5,
    Count = 6
}
export declare class Parser {
    #private;
    currentToken: SyntaxKind;
    nodeCount: number;
    identifiers: Set<string>;
    identifierCount: number;
    sourceText: string;
    scanner: Scanner;
    currentNodeHasError: boolean;
    currentContext: ParsingContext;
    diagnostics: DiagnosticMessage[];
    constructor();
    parse(sourceText: string): SourceFile;
}
export declare function isIdentifier(kind: SyntaxKind): kind is SyntaxKind.HtmlIdentifier | SyntaxKind.TextIdentifier | SyntaxKind.QuotedTextIdentifier | SyntaxKind.NumericIdentifier;
export declare function isIdentifierNode(node: SyntaxNode): node is Identifier;
