#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-4byLxMpAs0k96J5OC8FHE3
key:                  dhall-1.42.3-4byLxMpAs0k96J5OC8FHE3
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  9e4c4da37c5912dec84105cac9dcc30c
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-4byLxMpAs0k96J5OC8FHE3
depends:
    Diff-0.5-HAcFInTibw312RXP7RmH2 aeson-2.1.2.1-25X5lEqka86CxkXK2BMN9E
    aeson-pretty-0.8.10-GKziu1bca0dD9tbchVmqu2
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU
    atomic-write-0.2.1.1-5cicsRZRm0pGvjbpjMH3DM base-4.17.2.1
    base16-bytestring-1.0.2.0-B3nVesNhsfW2vXGsoul62U
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-EW9gF4gHig7HSWPJPd5ucb
    cborg-0.2.10.0-H10Y7PQoOQmEBXGjuW28XC
    cborg-json-0.2.6.0-9TfhQZ7cIB9A4fGYd5TZAx containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-I8mgXhYUvZi5yA85KAdmaH
    data-fix-0.3.4-20jbuwOv5b08CP4WjwaM8i deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-Bb2zyDFdboi1bmTNGujhwK exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-pWbW6oZ5b87spk4DdOs5L
    hashable-1.4.6.0-HsdqsQ7iDyd40AcboGWr8K haskeline-0.8.2
    http-client-0.7.19-Kz39wcB8QBJAc4yHR1PeVc
    http-client-tls-0.3.6.4-9F9dnl7UwnqJiEPheKe9fy
    http-types-0.12.4-EwpVc2W1Y3M7oAuA2rwQwG
    indexed-traversable-0.1.4-10ilYqh2nxEny8IgMDEXE
    megaparsec-9.7.0-JOqeKsXL95c1CDbf8BIVid
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-9vKCxjgvNW3FsGV9sxXDe3
    optparse-applicative-0.18.1.0-EdEjIHpfurx5EyqDyJ3l4u
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-LrAtr2YQVMNBkASpTqmvwP
    pretty-simple-4.1.3.0-BEpMh1PO00VAjrQZdiQZTy
    prettyprinter-1.7.1-BNC6JafOhDbB8Lc4c1jpfV
    prettyprinter-ansi-terminal-1.1.3-6nflTrJsCkLJKMI8qneRUW
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-EroasVwH8ulAVKZ9SvWekK
    serialise-0.2.6.1-B1cnugeykAx4f4AGD1phuV template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-JHE3bvuINZd8iV5S8wDhnJ
    text-short-0.1.6-99HgOfWRtYZAxoNKeNDwXS
    th-lift-instances-0.1.20-CuZpe4dattLDAMv0Ha0CIt time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-CvhiqG4EGgD965QomVBmUt
    unordered-containers-0.2.20-DjNgsRwGYvfHy5WsKzKUzR
    vector-0.13.2.0-FmAyOUuMvM2EH0h3dDhWXJ

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

