# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_clipcat_notify_global_optspecs
	string join \n no-clipboard no-primary no-secondary h/help V/version
end

function __fish_clipcat_notify_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_clipcat_notify_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_clipcat_notify_using_subcommand
	set -l cmd (__fish_clipcat_notify_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c clipcat-notify -n "__fish_clipcat_notify_needs_command" -l no-clipboard -d 'Do not listen clipboard'
complete -c clipcat-notify -n "__fish_clipcat_notify_needs_command" -l no-primary -d 'Do not listen primary'
complete -c clipcat-notify -n "__fish_clipcat_notify_needs_command" -l no-secondary -d 'Do not listen secondary'
complete -c clipcat-notify -n "__fish_clipcat_notify_needs_command" -s h -l help -d 'Print help'
complete -c clipcat-notify -n "__fish_clipcat_notify_needs_command" -s V -l version -d 'Print version'
complete -c clipcat-notify -n "__fish_clipcat_notify_needs_command" -f -a "version" -d 'Print version information'
complete -c clipcat-notify -n "__fish_clipcat_notify_needs_command" -f -a "completions" -d 'Output shell completion code for the specified shell (bash, zsh, fish)'
complete -c clipcat-notify -n "__fish_clipcat_notify_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c clipcat-notify -n "__fish_clipcat_notify_using_subcommand version" -s h -l help -d 'Print help'
complete -c clipcat-notify -n "__fish_clipcat_notify_using_subcommand completions" -s h -l help -d 'Print help'
complete -c clipcat-notify -n "__fish_clipcat_notify_using_subcommand help; and not __fish_seen_subcommand_from version completions help" -f -a "version" -d 'Print version information'
complete -c clipcat-notify -n "__fish_clipcat_notify_using_subcommand help; and not __fish_seen_subcommand_from version completions help" -f -a "completions" -d 'Output shell completion code for the specified shell (bash, zsh, fish)'
complete -c clipcat-notify -n "__fish_clipcat_notify_using_subcommand help; and not __fish_seen_subcommand_from version completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
