/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.Connection;
import com.zeroc.Ice.Instrumentation.CommunicatorObserver;
import com.zeroc.Ice.Instrumentation.ThreadObserver;
import com.zeroc.Ice.Instrumentation.ThreadState;
import com.zeroc.Ice.OperationInterruptedException;
import com.zeroc.Ice.Properties;
import com.zeroc.IceInternal.DispatchWorkItem;
import com.zeroc.IceInternal.EventHandler;
import com.zeroc.IceInternal.EventHandlerOpPair;
import com.zeroc.IceInternal.Ex;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.ReadyCallback;
import com.zeroc.IceInternal.Selector;
import com.zeroc.IceInternal.ThreadPoolCurrent;
import com.zeroc.IceInternal.ThreadPoolWorkItem;
import com.zeroc.IceInternal.ThreadPoolWorkQueue;
import com.zeroc.IceInternal.Time;
import com.zeroc.IceInternal.Util;
import com.zeroc.IceUtilInternal.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public final class ThreadPool
implements Executor {
    private final Instance _instance;
    private final BiConsumer<Runnable, Connection> _dispatcher;
    private final ThreadPoolWorkQueue _workQueue;
    private boolean _destroyed;
    private final String _prefix;
    private final String _threadPrefix;
    private final Selector _selector;
    private final int _size;
    private final int _sizeIO;
    private final int _sizeMax;
    private final int _sizeWarn;
    private final boolean _serialize;
    private final int _priority;
    private final boolean _hasPriority;
    private final long _serverIdleTime;
    private final long _threadIdleTime;
    private final int _stackSize;
    private List<EventHandlerThread> _threads = new ArrayList<EventHandlerThread>();
    private int _threadIndex;
    private int _inUse;
    private int _inUseIO;
    private List<EventHandlerOpPair> _handlers = new ArrayList<EventHandlerOpPair>();
    private Iterator<EventHandlerOpPair> _nextHandler;
    private boolean _promote;

    public ThreadPool(Instance instance, String prefix, int timeout) {
        String s;
        int sizeWarn;
        int sizeMax;
        Properties properties = instance.initializationData().properties;
        this._instance = instance;
        this._dispatcher = instance.initializationData().dispatcher;
        this._destroyed = false;
        this._prefix = prefix;
        this._selector = new Selector(instance);
        this._threadIndex = 0;
        this._inUse = 0;
        this._inUseIO = 0;
        this._promote = true;
        this._serialize = properties.getPropertyAsInt(this._prefix + ".Serialize") > 0;
        this._serverIdleTime = timeout;
        this._threadPrefix = Util.createThreadName(properties, this._prefix);
        int nProcessors = Runtime.getRuntime().availableProcessors();
        int size = properties.getPropertyAsIntWithDefault(this._prefix + ".Size", 1);
        if (size < 1) {
            String s2 = this._prefix + ".Size < 1; Size adjusted to 1";
            this._instance.initializationData().logger.warning(s2);
            size = 1;
        }
        if ((sizeMax = properties.getPropertyAsIntWithDefault(this._prefix + ".SizeMax", size)) == -1) {
            sizeMax = nProcessors;
        }
        if (sizeMax < size) {
            String s3 = this._prefix + ".SizeMax < " + this._prefix + ".Size; SizeMax adjusted to Size (" + size + ")";
            this._instance.initializationData().logger.warning(s3);
            sizeMax = size;
        }
        if ((sizeWarn = properties.getPropertyAsInt(this._prefix + ".SizeWarn")) != 0 && sizeWarn < size) {
            s = this._prefix + ".SizeWarn < " + this._prefix + ".Size; adjusted SizeWarn to Size (" + size + ")";
            this._instance.initializationData().logger.warning(s);
            sizeWarn = size;
        } else if (sizeWarn > sizeMax) {
            s = this._prefix + ".SizeWarn > " + this._prefix + ".SizeMax; adjusted SizeWarn to SizeMax (" + sizeMax + ")";
            this._instance.initializationData().logger.warning(s);
            sizeWarn = sizeMax;
        }
        int threadIdleTime = properties.getPropertyAsIntWithDefault(this._prefix + ".ThreadIdleTime", 60);
        if (threadIdleTime < 0) {
            String s4 = this._prefix + ".ThreadIdleTime < 0; ThreadIdleTime adjusted to 0";
            this._instance.initializationData().logger.warning(s4);
            threadIdleTime = 0;
        }
        this._size = size;
        this._sizeMax = sizeMax;
        this._sizeWarn = sizeWarn;
        this._sizeIO = Math.min(sizeMax, nProcessors);
        this._threadIdleTime = threadIdleTime;
        int stackSize = properties.getPropertyAsInt(this._prefix + ".StackSize");
        if (stackSize < 0) {
            String s5 = this._prefix + ".StackSize < 0; Size adjusted to JRE default";
            this._instance.initializationData().logger.warning(s5);
            stackSize = 0;
        }
        this._stackSize = stackSize;
        boolean hasPriority = properties.getProperty(this._prefix + ".ThreadPriority").length() > 0;
        int priority = properties.getPropertyAsInt(this._prefix + ".ThreadPriority");
        if (!hasPriority) {
            hasPriority = properties.getProperty("Ice.ThreadPriority").length() > 0;
            priority = properties.getPropertyAsInt("Ice.ThreadPriority");
        }
        this._hasPriority = hasPriority;
        this._priority = priority;
        this._workQueue = new ThreadPoolWorkQueue(this._instance, this, this._selector);
        this._nextHandler = this._handlers.iterator();
        if (this._instance.traceLevels().threadPool >= 1) {
            String s6 = "creating " + this._prefix + ": Size = " + this._size + ", SizeMax = " + this._sizeMax + ", SizeWarn = " + this._sizeWarn;
            this._instance.initializationData().logger.trace(this._instance.traceLevels().threadPoolCat, s6);
        }
        try {
            for (int i = 0; i < this._size; ++i) {
                EventHandlerThread thread = new EventHandlerThread(this._threadPrefix + "-" + this._threadIndex++);
                if (this._hasPriority) {
                    thread.start(this._priority);
                } else {
                    thread.start(5);
                }
                this._threads.add(thread);
            }
        }
        catch (RuntimeException ex) {
            String s7 = "cannot create thread for `" + this._prefix + "':\n" + Ex.toString(ex);
            this._instance.initializationData().logger.error(s7);
            this.destroy();
            try {
                this.joinWithAllThreads();
            }
            catch (InterruptedException e) {
                throw new OperationInterruptedException();
            }
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._destroyed);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void destroy() {
        if (this._destroyed) {
            return;
        }
        this._destroyed = true;
        this._workQueue.destroy();
    }

    public synchronized void updateObservers() {
        for (EventHandlerThread thread : this._threads) {
            thread.updateObserver();
        }
    }

    public synchronized void initialize(final EventHandler handler) {
        assert (!this._destroyed);
        this._selector.initialize(handler);
        handler.setReadyCallback(new ReadyCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ready(int op, boolean value) {
                ThreadPool threadPool = ThreadPool.this;
                synchronized (threadPool) {
                    if (ThreadPool.this._destroyed) {
                        return;
                    }
                    ThreadPool.this._selector.ready(handler, op, value);
                }
            }
        });
    }

    public void register(EventHandler handler, int op) {
        this.update(handler, 0, op);
    }

    public synchronized void update(EventHandler handler, int remove, int add) {
        assert (!this._destroyed);
        remove &= ~add;
        if ((remove = handler._registered & remove) == (add = ~handler._registered & add)) {
            return;
        }
        this._selector.update(handler, remove, add);
    }

    public void unregister(EventHandler handler, int op) {
        this.update(handler, op, 0);
    }

    public synchronized boolean finish(EventHandler handler, boolean closeNow) {
        assert (!this._destroyed);
        this._workQueue.queue(new FinishedWorkItem(handler, !(closeNow = this._selector.finish(handler, closeNow))));
        return closeNow;
    }

    public void dispatchFromThisThread(DispatchWorkItem workItem) {
        if (this._dispatcher != null) {
            try {
                this._dispatcher.accept(workItem, workItem.getConnection());
            }
            catch (Exception ex) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 1) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    this._instance.initializationData().logger.warning("dispatch exception:\n" + sw.toString());
                }
            }
        } else {
            workItem.run();
        }
    }

    public synchronized void dispatch(DispatchWorkItem workItem) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        this._workQueue.queue(workItem);
    }

    public void joinWithAllThreads() throws InterruptedException {
        for (EventHandlerThread thread : this._threads) {
            thread.join();
        }
        this._selector.destroy();
    }

    @Override
    public void execute(final Runnable command) {
        this.dispatch(new DispatchWorkItem(){

            @Override
            public void run() {
                command.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(EventHandlerThread thread) {
        ThreadPoolCurrent current = new ThreadPoolCurrent(this._instance, this, thread);
        boolean select = false;
        while (true) {
            Object s;
            if (current._handler != null) {
                try {
                    current._handler.message(current);
                }
                catch (DestroyedException ex) {
                    ThreadPool threadPool = this;
                    synchronized (threadPool) {
                        --this._inUse;
                        thread.setState(ThreadState.ThreadStateIdle);
                    }
                    return;
                }
                catch (Exception ex) {
                    s = "exception in `" + this._prefix + "':\n" + Ex.toString(ex);
                    s = (String)s + "\nevent handler: " + current._handler.toString();
                    this._instance.initializationData().logger.error((String)s);
                }
            } else if (select) {
                try {
                    this._selector.select(this._serverIdleTime);
                }
                catch (Selector.TimeoutException ex) {
                    s = this;
                    synchronized (s) {
                        if (!this._destroyed && this._inUse == 0) {
                            this._workQueue.queue(new ShutdownWorkItem());
                        }
                        continue;
                    }
                }
            }
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (current._handler == null) {
                    if (select) {
                        this._selector.finishSelect(this._handlers);
                        select = false;
                        this._nextHandler = this._handlers.iterator();
                    } else if (!current._leader && this.followerWait(current)) {
                        return;
                    }
                } else if (this._sizeMax > 1) {
                    if (!current._ioCompleted) {
                        --this._inUseIO;
                    } else {
                        if (this._serialize) {
                            this._selector.enable(current._handler, current.operation);
                        }
                        assert (this._inUse > 0);
                        --this._inUse;
                    }
                    if (!current._leader && this.followerWait(current)) {
                        return;
                    }
                }
                current._handler = null;
                while (this._nextHandler.hasNext()) {
                    EventHandlerOpPair n = this._nextHandler.next();
                    int op = n.op & ~n.handler._disabled & n.handler._registered;
                    if (op == 0) continue;
                    current._ioCompleted = false;
                    current._handler = n.handler;
                    current.operation = op;
                    thread.setState(ThreadState.ThreadStateInUseForIO);
                    break;
                }
                if (current._handler == null) {
                    if (this._inUseIO > 0) {
                        this.promoteFollower(current);
                    } else {
                        this._handlers.clear();
                        this._selector.startSelect();
                        select = true;
                        thread.setState(ThreadState.ThreadStateIdle);
                    }
                } else if (this._sizeMax > 1) {
                    ++this._inUseIO;
                    if (this._nextHandler.hasNext() && this._inUseIO < this._sizeIO) {
                        this.promoteFollower(current);
                    }
                }
            }
        }
    }

    synchronized void ioCompleted(ThreadPoolCurrent current) {
        current._ioCompleted = true;
        current._thread.setState(ThreadState.ThreadStateInUseForUser);
        if (this._sizeMax > 1) {
            String s;
            --this._inUseIO;
            if (!this._destroyed && this._serialize) {
                this._selector.disable(current._handler, current.operation);
            }
            if (current._leader) {
                this.promoteFollower(current);
            } else if (this._promote && (this._nextHandler.hasNext() || this._inUseIO == 0)) {
                this.notify();
            }
            assert (this._inUse >= 0);
            ++this._inUse;
            if (this._inUse == this._sizeWarn) {
                s = "thread pool `" + this._prefix + "' is running low on threads\nSize=" + this._size + ", SizeMax=" + this._sizeMax + ", SizeWarn=" + this._sizeWarn;
                this._instance.initializationData().logger.warning(s);
            }
            if (!this._destroyed) {
                assert (this._inUse <= this._threads.size());
                if (this._inUse < this._sizeMax && this._inUse == this._threads.size()) {
                    if (this._instance.traceLevels().threadPool >= 1) {
                        s = "growing " + this._prefix + ": Size=" + (this._threads.size() + 1);
                        this._instance.initializationData().logger.trace(this._instance.traceLevels().threadPoolCat, s);
                    }
                    try {
                        EventHandlerThread thread = new EventHandlerThread(this._threadPrefix + "-" + this._threadIndex++);
                        this._threads.add(thread);
                        if (this._hasPriority) {
                            thread.start(this._priority);
                        } else {
                            thread.start(5);
                        }
                    }
                    catch (RuntimeException ex) {
                        String s2 = "cannot create thread for `" + this._prefix + "':\n" + Ex.toString(ex);
                        this._instance.initializationData().logger.error(s2);
                    }
                }
            }
        }
    }

    private synchronized void promoteFollower(ThreadPoolCurrent current) {
        assert (!this._promote && current._leader);
        this._promote = true;
        if (this._inUseIO < this._sizeIO && (this._nextHandler.hasNext() || this._inUseIO == 0)) {
            this.notify();
        }
        current._leader = false;
    }

    private synchronized boolean followerWait(ThreadPoolCurrent current) {
        assert (!current._leader);
        current._thread.setState(ThreadState.ThreadStateIdle);
        current._handler = null;
        current.stream.reset();
        while (!this._promote || this._inUseIO == this._sizeIO || !this._nextHandler.hasNext() && this._inUseIO > 0) {
            if (this._threadIdleTime > 0L) {
                long before = Time.currentMonotonicTimeMillis();
                boolean interrupted = false;
                try {
                    this.wait(this._threadIdleTime * 1000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                if (!interrupted && Time.currentMonotonicTimeMillis() - before < this._threadIdleTime * 1000L || this._destroyed || this._promote && this._inUseIO != this._sizeIO && (this._nextHandler.hasNext() || this._inUseIO <= 0)) continue;
                if (this._instance.traceLevels().threadPool >= 1) {
                    String s = "shrinking " + this._prefix + ": Size=" + (this._threads.size() - 1);
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().threadPoolCat, s);
                }
                assert (this._threads.size() > 1);
                this._threads.remove(current._thread);
                this._workQueue.queue(new JoinThreadWorkItem(current._thread));
                return true;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        current._leader = true;
        this._promote = false;
        return false;
    }

    final class EventHandlerThread
    implements Runnable {
        private final String _name;
        private Thread _thread;
        private ThreadState _state;
        private ThreadObserver _observer;

        EventHandlerThread(String name) {
            this._name = name;
            this._state = ThreadState.ThreadStateIdle;
            this.updateObserver();
        }

        public void updateObserver() {
            CommunicatorObserver obsv = ((ThreadPool)ThreadPool.this)._instance.initializationData().observer;
            if (obsv != null) {
                this._observer = obsv.getThreadObserver(ThreadPool.this._prefix, this._name, this._state, this._observer);
                if (this._observer != null) {
                    this._observer.attach();
                }
            }
        }

        public void setState(ThreadState s) {
            if (this._observer != null && this._state != s) {
                this._observer.stateChanged(this._state, s);
            }
            this._state = s;
        }

        public void join() throws InterruptedException {
            this._thread.join();
        }

        public void start(int priority) {
            this._thread = new Thread(null, this, this._name, ThreadPool.this._stackSize);
            this._thread.setPriority(priority);
            this._thread.start();
        }

        @Override
        public void run() {
            String s;
            if (((ThreadPool)ThreadPool.this)._instance.initializationData().threadStart != null) {
                try {
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().threadStart.run();
                }
                catch (Exception ex) {
                    s = "threadStart method raised an unexpected exception in `";
                    s = s + ThreadPool.this._prefix + "' thread " + this._name + ":\n" + Ex.toString(ex);
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().logger.error(s);
                }
            }
            try {
                ThreadPool.this.run(this);
            }
            catch (Exception ex) {
                s = "exception in `" + ThreadPool.this._prefix + "' thread " + this._name + ":\n" + Ex.toString(ex);
                ((ThreadPool)ThreadPool.this)._instance.initializationData().logger.error(s);
            }
            if (this._observer != null) {
                this._observer.detach();
            }
            if (((ThreadPool)ThreadPool.this)._instance.initializationData().threadStop != null) {
                try {
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().threadStop.run();
                }
                catch (Exception ex) {
                    s = "threadStop method raised an unexpected exception in `";
                    s = s + ThreadPool.this._prefix + "' thread " + this._name + ":\n" + Ex.toString(ex);
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().logger.error(s);
                }
            }
        }
    }

    static final class DestroyedException
    extends RuntimeException {
        public static final long serialVersionUID = 0L;

        DestroyedException() {
        }
    }

    static final class JoinThreadWorkItem
    implements ThreadPoolWorkItem {
        private final EventHandlerThread _thread;

        public JoinThreadWorkItem(EventHandlerThread thread) {
            this._thread = thread;
        }

        @Override
        public void execute(ThreadPoolCurrent current) {
            try {
                this._thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static final class FinishedWorkItem
    implements ThreadPoolWorkItem {
        private final EventHandler _handler;
        private final boolean _close;

        public FinishedWorkItem(EventHandler handler, boolean close) {
            this._handler = handler;
            this._close = close;
        }

        @Override
        public void execute(ThreadPoolCurrent current) {
            this._handler.finished(current, this._close);
        }
    }

    final class ShutdownWorkItem
    implements ThreadPoolWorkItem {
        ShutdownWorkItem() {
        }

        @Override
        public void execute(ThreadPoolCurrent current) {
            current.ioCompleted();
            try {
                ThreadPool.this._instance.objectAdapterFactory().shutdown();
            }
            catch (CommunicatorDestroyedException communicatorDestroyedException) {
                // empty catch block
            }
        }
    }
}

