/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.Serializable;
import java.util.Date;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.Revision;

public class LogMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String message;
    private long timeMicros;
    private Date date;
    private long revision;
    private String author;
    private ChangePath[] changedPaths;

    LogMessage(ChangePath[] changePathArray, long l, String string, Date date, String string2) {
        this.changedPaths = changePathArray;
        this.revision = l;
        this.author = string;
        this.timeMicros = 1000L * date.getTime();
        this.date = date;
        this.message = string2;
    }

    LogMessage(ChangePath[] changePathArray, long l, String string, long l2, String string2) {
        this.changedPaths = changePathArray;
        this.revision = l;
        this.author = string;
        this.timeMicros = l2;
        this.date = null;
        this.message = string2;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTimeMicros() {
        return this.timeMicros;
    }

    public long getTimeMillis() {
        return this.timeMicros / 1000L;
    }

    public Date getDate() {
        if (this.date == null) {
            this.date = new Date(this.timeMicros / 1000L);
        }
        return this.date;
    }

    public Revision.Number getRevision() {
        return Revision.createNumber(this.revision);
    }

    public long getRevisionNumber() {
        return this.revision;
    }

    public String getAuthor() {
        return this.author;
    }

    public ChangePath[] getChangedPaths() {
        return this.changedPaths;
    }
}

