import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetDistributionResultFilterSensitiveLog, } from "../models/models_1";
import { de_GetDistributionCommand, se_GetDistributionCommand } from "../protocols/Aws_restXml";
export { $Command };
export class GetDistributionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "GetDistribution", {})
    .n("CloudFrontClient", "GetDistributionCommand")
    .f(void 0, GetDistributionResultFilterSensitiveLog)
    .ser(se_GetDistributionCommand)
    .de(de_GetDistributionCommand)
    .build() {
}
