/**
 * ./src/classes/families/voidlinux.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import shx from 'shelljs';
/**
 * Utils: general porpourse utils
 * @remarks all the utilities
 */
export default class Voidlinux {
    static packs4calamares = [''];
    /**
     *
     */
    static async calamaresInstall(verbose = true) {
        if (verbose) {
            console.log("calamares non disponibile on VoidLinux");
        }
    }
    /**
     * calamaresPolicies
     */
    static async calamaresPolicies(verbose = false) {
        // nothing
    }
    /**
     *
     */
    static async calamaresRemove(verbose = true) {
        if (verbose) {
            console.log("calamares non disponibile on VoidLinux");
        }
        return true;
    }
    /**
     * check if it's installed wayland
     * @returns true if wayland
     */
    static isInstalledWayland() {
        return this.packageIsInstalled('wayland');
    }
    /**
     * check if it's installed xorg
     * @returns true if xorg is installed
     */
    static isInstalledXorg() {
        return this.packageIsInstalled('xorg-server');
    }
    /**
     * restuisce VERO se il pacchetto è installato
     * @param packageName
     */
    static async packageAvailable(packageName) {
        let available = false;
        const cmd = `/usr/bin/xbps-query -Rs ${packageName} | grep Package:`;
        const stdout = shx.exec(cmd, { silent: true }).stdout.trim();
        if (stdout.includes(packageName)) {
            available = true;
        }
        return available;
    }
    /**
     * Install the package packageName
     * @param packageName {string} Pacchetto da installare
     * @returns {boolean} True if success
     */
    static async packageInstall(packageName) {
        let retVal = false;
        if (shx.exec(`/usr/bin/xbps-install ${packageName}`, { silent: true }) === '0') {
            retVal = true;
        }
        return retVal;
    }
    /**
     * restuisce VERO se il pacchetto è installato
     * @param packageName
     */
    static packageIsInstalled(packageName) {
        let installed = false;
        const cmd = `/usr/bin/xbps-query -l | grep ${packageName}`;
        const stdout = shx.exec(cmd, { silent: true }).stdout.trim();
        if (stdout.includes(packageName)) {
            installed = true;
        }
        return installed;
    }
}
