/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.xmlsec.AlgorithmPolicyConfiguration;

public class BasicAlgorithmPolicyConfiguration
implements AlgorithmPolicyConfiguration {
    @Nonnull
    public static final AlgorithmPolicyConfiguration.Precedence DEFAULT_PRECEDENCE = AlgorithmPolicyConfiguration.Precedence.INCLUDE;
    @Nonnull
    private Collection<String> includes = CollectionSupport.emptySet();
    private boolean includeMerge = false;
    @Nonnull
    private Collection<String> excludes = CollectionSupport.emptySet();
    private boolean excludeMerge = true;
    @Nonnull
    private AlgorithmPolicyConfiguration.Precedence precedence = DEFAULT_PRECEDENCE;

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<String> getIncludedAlgorithms() {
        return this.includes;
    }

    public void setIncludedAlgorithms(@Nullable Collection<String> uris) {
        if (uris == null) {
            this.includes = CollectionSupport.emptySet();
            return;
        }
        this.includes = CollectionSupport.copyToSet(StringSupport.normalizeStringCollection(uris));
    }

    @Override
    public boolean isIncludeMerge() {
        return this.includeMerge;
    }

    public void setIncludeMerge(boolean flag) {
        this.includeMerge = flag;
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<String> getExcludedAlgorithms() {
        return this.excludes;
    }

    public void setExcludedAlgorithms(@Nullable Collection<String> uris) {
        if (uris == null) {
            this.excludes = CollectionSupport.emptySet();
            return;
        }
        this.excludes = CollectionSupport.copyToSet(StringSupport.normalizeStringCollection(uris));
    }

    @Override
    public boolean isExcludeMerge() {
        return this.excludeMerge;
    }

    public void setExcludeMerge(boolean flag) {
        this.excludeMerge = flag;
    }

    @Override
    @Nonnull
    public AlgorithmPolicyConfiguration.Precedence getIncludeExcludePrecedence() {
        return this.precedence;
    }

    public void setIncludeExcludePrecedence(@Nonnull AlgorithmPolicyConfiguration.Precedence value) {
        this.precedence = Constraint.isNotNull(value, "Precedence may not be null");
    }
}

