/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AzurePowerShellCredential;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.implementation.util.IdentityUtil;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.Arrays;
import java.util.List;

public class AzurePowerShellCredentialBuilder
extends CredentialBuilderBase<AzurePowerShellCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(AzurePowerShellCredentialBuilder.class);
    private String tenantId;

    public AzurePowerShellCredentialBuilder tenantId(String tenantId) {
        ValidationUtil.validateTenantIdCharacterRange(tenantId, LOGGER);
        this.tenantId = tenantId;
        return this;
    }

    public AzurePowerShellCredentialBuilder additionallyAllowedTenants(String ... additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(additionallyAllowedTenants)));
        return this;
    }

    public AzurePowerShellCredentialBuilder additionallyAllowedTenants(List<String> additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(additionallyAllowedTenants));
        return this;
    }

    public AzurePowerShellCredential build() {
        return new AzurePowerShellCredential(this.tenantId, this.identityClientOptions);
    }
}

