/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.model;

import com.google.common.base.Objects;
import java.io.IOException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.model.Order;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.util.ParseUtils;

public class Subaggregation
implements Writeable,
ToXContentObject {
    private static final String AGGREGATION_QUERY = "aggregation_query";
    private static final String ORDER = "order";
    private final AggregationBuilder aggregation;
    private final Order order;

    public Subaggregation(AggregationBuilder aggregation, Order order) {
        this.aggregation = aggregation;
        this.order = order;
    }

    public Subaggregation(StreamInput input) throws IOException {
        this.aggregation = (AggregationBuilder)input.readNamedWriteable(AggregationBuilder.class);
        this.order = (Order)input.readEnum(Order.class);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(ORDER, this.order.name()).field(AGGREGATION_QUERY).startObject().value((Object)this.aggregation).endObject();
        return xContentBuilder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.aggregation);
        out.writeEnum((Enum)this.order);
    }

    public static Subaggregation parse(XContentParser parser) throws IOException {
        Order order = Order.ASC;
        AggregationBuilder aggregation = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "order": {
                    order = Order.valueOf(parser.text());
                    break;
                }
                case "aggregation_query": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    aggregation = ParseUtils.toAggregationBuilder(parser);
                    break;
                }
            }
        }
        return new Subaggregation(aggregation, order);
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subaggregation feature = (Subaggregation)o;
        return Objects.equal((Object)((Object)this.order), (Object)((Object)feature.getOrder())) && Objects.equal((Object)this.aggregation, (Object)feature.getAggregation());
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.aggregation, this.order});
    }

    public AggregationBuilder getAggregation() {
        return this.aggregation;
    }

    public Order getOrder() {
        return this.order;
    }
}

