! Copyright (c) 2016-2024, NVIDIA CORPORATION.  All rights reserved.
!
! NVIDIA CORPORATION and its licensors retain all intellectual property
! and proprietary rights in and to this software, related documentation
! and any modifications thereto.  Any use, reproduction, disclosure or
! distribution of this software and related documentation without an express
! license agreement from NVIDIA CORPORATION is strictly prohibited.

! # This file is autogenerated. Please, do not modify.

          integer, parameter :: omp_integer_kind          = 4
          integer, parameter :: omp_logical_kind          = 4
          integer, parameter :: omp_pause_resource_kind   = 4
          integer, parameter :: omp_event_handle_kind     = 4
          integer, parameter :: omp_lock_kind             =             &
     &    int_ptr_kind()
          integer, parameter :: omp_nest_lock_kind        =             &
     &    int_ptr_kind()
          integer, parameter :: omp_sched_kind            =             &
     &    omp_integer_kind
          integer, parameter :: omp_proc_bind_kind        =             &
     &    omp_integer_kind
          integer, parameter :: omp_sync_hint_kind        =             &
     &    omp_integer_kind
          integer, parameter :: omp_depend_kind           =             &
     &    omp_integer_kind
          integer, parameter :: omp_handle_kind           =             &
     &    int_ptr_kind()
          integer, parameter :: omp_memspace_handle_kind  = 4
          integer, parameter :: omp_allocator_handle_kind = 4
          integer, parameter :: omp_alloctrait_key_kind   = 4
          integer, parameter :: omp_alloctrait_val_kind   = 4

          type omp_alloctrait
          integer (kind=omp_alloctrait_key_kind) key
          integer (kind=omp_alloctrait_val_kind) value
          end type omp_alloctrait

          integer, parameter :: omp_control_tool_kind = 8
          integer (kind=omp_control_tool_kind), parameter ::            &
     &    omp_control_tool_start = 1
          integer (kind=omp_control_tool_kind), parameter ::            &
     &    omp_control_tool_pause = 2
          integer (kind=omp_control_tool_kind), parameter ::            &
     &    omp_control_tool_flush = 3
          integer (kind=omp_control_tool_kind), parameter ::            &
     &    omp_control_tool_end = 4

          integer, parameter ::                                         &
     &    omp_control_tool_result_kind = 8
          integer (kind=omp_control_tool_result_kind), parameter ::     &
     &    omp_control_tool_notool = -2
          integer (kind=omp_control_tool_result_kind), parameter ::     &
     &    omp_control_tool_nocallback = -1
          integer (kind=omp_control_tool_result_kind), parameter ::     &
     &    omp_control_tool_success = 0
          integer (kind=omp_control_tool_result_kind), parameter ::     &
     &    omp_control_tool_ignored = 1

          integer (kind=omp_sched_kind), parameter ::                   &
     &    omp_sched_static = 1
          integer (kind=omp_sched_kind), parameter ::                   &
     &    omp_sched_dynamic = 2
          integer (kind=omp_sched_kind), parameter ::                   &
     &    omp_sched_guided = 3
          integer (kind=omp_sched_kind), parameter :: omp_sched_auto = 4

          integer (kind=omp_proc_bind_kind), parameter ::               &
     &    omp_proc_bind_false = 0
          integer (kind=omp_proc_bind_kind), parameter ::               &
     &    omp_proc_bind_true = 1
          integer (kind=omp_proc_bind_kind), parameter ::               &
     &    omp_proc_bind_master = 2
          integer (kind=omp_proc_bind_kind), parameter ::               &
     &    omp_proc_bind_close = 3
          integer (kind=omp_proc_bind_kind), parameter ::               &
     &    omp_proc_bind_spread = 4

          integer (kind=omp_pause_resource_kind), parameter ::          &
     &    omp_pause_soft = 1
          integer (kind=omp_pause_resource_kind), parameter ::          &
     &    omp_pause_hard = 2

          integer, parameter :: omp_lock_hint_kind = omp_sync_hint_kind
          integer (kind=omp_sync_hint_kind), parameter ::               &
     &    omp_sync_hint_none = int(Z'0', kind=omp_sync_hint_kind)
          integer (kind=omp_lock_hint_kind), parameter ::               &
     &    omp_lock_hint_none = omp_sync_hint_none
          integer (kind=omp_sync_hint_kind), parameter ::               &
     &    omp_sync_hint_uncontended =                                   &
     &    int(Z'1', kind=omp_sync_hint_kind)
          integer (kind=omp_lock_hint_kind), parameter ::               &
     &    omp_lock_hint_uncontended = omp_sync_hint_uncontended
          integer (kind=omp_sync_hint_kind), parameter ::               &
     &    omp_sync_hint_contended =                                     &
     &    int(Z'2', kind=omp_sync_hint_kind)
          integer (kind=omp_lock_hint_kind), parameter ::               &
     &    omp_lock_hint_contended = omp_sync_hint_contended
          integer (kind=omp_sync_hint_kind), parameter ::               &
     &    omp_sync_hint_nonspeculative =                                &
     &    int(Z'4', kind=omp_sync_hint_kind)
          integer (kind=omp_lock_hint_kind), parameter ::               &
     &    omp_lock_hint_nonspeculative =                                &
     &    omp_sync_hint_nonspeculative
          integer (kind=omp_sync_hint_kind), parameter ::               &
     &    omp_sync_hint_speculative =                                   &
     &    int(Z'8', kind=omp_sync_hint_kind)
          integer (kind=omp_lock_hint_kind), parameter ::               &
     &    omp_lock_hint_speculative = omp_sync_hint_speculative

          integer (kind=omp_event_handle_kind), parameter ::            &
     &    omp_allow_completion_event = 0
          integer (kind=omp_event_handle_kind), parameter ::            &
     &    omp_task_fulfill_event = 1

          integer (kind=omp_alloctrait_key_kind), parameter ::          &
     &    omp_atk_sync_hint = 1
          integer (kind=omp_alloctrait_key_kind), parameter ::          &
     &    omp_atk_alignment = 2
          integer (kind=omp_alloctrait_key_kind), parameter ::          &
     &    omp_atk_access = 3
          integer (kind=omp_alloctrait_key_kind), parameter ::          &
     &    omp_atk_pool_size = 4
          integer (kind=omp_alloctrait_key_kind), parameter ::          &
     &    omp_atk_fallback = 5
          integer (kind=omp_alloctrait_key_kind), parameter ::          &
     &    omp_atk_fb_data = 6
          integer (kind=omp_alloctrait_key_kind), parameter ::          &
     &    omp_atk_pinned = 7
          integer (kind=omp_alloctrait_key_kind), parameter ::          &
     &    omp_atk_partition = 8

          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_default = -1
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_false = 0
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_true = 1
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_contended = 3
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_uncontended = 4
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_sequential = 5
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_private = 6
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_all = 7
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_thread = 8
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_pteam = 9
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_cgroup = 10
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_default_mem_fb = 11
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_null_fb = 12
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_abort_fb = 13
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_allocator_fb = 14
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_environment = 15
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_nearest = 16
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_blocked = 17
          integer (kind=omp_alloctrait_val_kind), parameter ::          &
     &    omp_atv_interleaved = 18

          integer (kind=omp_allocator_handle_kind), parameter ::        &
     &    omp_null_allocator = 0

          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_default_mem_space = 0
          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_large_cap_mem_space = 0
          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_const_mem_space = 0
          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_high_bw_mem_space = 0
          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_low_lat_mem_space = 0

          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_default_mem_alloc = 1
          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_large_cap_mem_alloc = omp_default_mem_alloc
          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_const_mem_alloc = 1
          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_high_bw_mem_alloc = 1
          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_low_lat_mem_alloc = 1
          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_thread_mem_alloc = omp_atv_thread
          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_pteam_mem_alloc = omp_atv_pteam
          integer (kind=omp_memspace_handle_kind), parameter ::         &
     &    omp_cgroup_mem_alloc = omp_atv_cgroup

          integer (kind=omp_integer_kind), parameter ::                 &
     &    openmp_version = 202011

          ! Thread Team Routines

          interface omp_set_num_threads
          subroutine omp_set_num_threads_1_(nthreads) bind(c)
              import
              integer (kind=1), VALUE :: nthreads
          end subroutine omp_set_num_threads_1_

          subroutine omp_set_num_threads_2_(nthreads) bind(c)
              import
              integer (kind=2), VALUE :: nthreads
          end subroutine omp_set_num_threads_2_

          subroutine omp_set_num_threads_4_(nthreads) bind(c)
              import
              integer (kind=omp_integer_kind), VALUE :: nthreads
          end subroutine omp_set_num_threads_4_

          subroutine omp_set_num_threads_8_(nthreads) bind(c)
              import
              integer (kind=8), VALUE :: nthreads
          end subroutine omp_set_num_threads_8_
          end interface omp_set_num_threads

          interface omp_get_num_threads
          function omp_get_num_threads() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_num_threads
          end function omp_get_num_threads
          end interface omp_get_num_threads

          interface omp_get_max_threads
          function omp_get_max_threads() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_max_threads
          end function omp_get_max_threads
          end interface omp_get_max_threads

          interface omp_get_thread_num
          function omp_get_thread_num() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_thread_num
          end function omp_get_thread_num
          end interface omp_get_thread_num

          interface omp_in_parallel
          function omp_in_parallel() bind(c)
              import
              logical (kind=omp_logical_kind) omp_in_parallel
          end function omp_in_parallel
          end interface omp_in_parallel

          interface omp_set_dynamic
          subroutine omp_set_dynamic_1_(enable) bind(c)
              import
              logical (kind=1), VALUE :: enable
          end subroutine omp_set_dynamic_1_

          subroutine omp_set_dynamic_2_(enable) bind(c)
              import
              logical (kind=2), VALUE :: enable
          end subroutine omp_set_dynamic_2_

          subroutine omp_set_dynamic_4_(enable) bind(c)
              import
              logical (kind=omp_logical_kind), VALUE :: enable
          end subroutine omp_set_dynamic_4_

          subroutine omp_set_dynamic_8_(enable) bind(c)
              import
              logical (kind=8), VALUE :: enable
          end subroutine omp_set_dynamic_8_
          end interface omp_set_dynamic

          interface omp_get_dynamic
          function omp_get_dynamic() bind(c)
              import
              logical (kind=omp_logical_kind) omp_get_dynamic
          end function omp_get_dynamic
          end interface omp_get_dynamic

          interface omp_get_cancellation
          function omp_get_cancellation() bind(c)
              import
              logical (kind=omp_logical_kind) omp_get_cancellation
          end function omp_get_cancellation
          end interface omp_get_cancellation

          interface omp_set_nested
          subroutine omp_set_nested_1_(enable) bind(c)
              import
              logical (kind=1), VALUE :: enable
          end subroutine omp_set_nested_1_

          subroutine omp_set_nested_2_(enable) bind(c)
              import
              logical (kind=2), VALUE :: enable
          end subroutine omp_set_nested_2_

          subroutine omp_set_nested_4_(enable) bind(c)
              import
              logical (kind=omp_logical_kind), VALUE :: enable
          end subroutine omp_set_nested_4_

          subroutine omp_set_nested_8_(enable) bind(c)
              import
              logical (kind=8), VALUE :: enable
          end subroutine omp_set_nested_8_
          end interface omp_set_nested

          interface omp_get_nested
          function omp_get_nested() bind(c)
              import
              logical (kind=omp_logical_kind) omp_get_nested
          end function omp_get_nested
          end interface omp_get_nested

          interface omp_set_schedule
          subroutine omp_set_schedule_1_(kind, chunk_size) bind(c)
              import
              integer (kind=omp_sched_kind), VALUE :: kind
              integer (kind=1), VALUE :: chunk_size
          end subroutine omp_set_schedule_1_

          subroutine omp_set_schedule_2_(kind, chunk_size) bind(c)
              import
              integer (kind=omp_sched_kind), VALUE :: kind
              integer (kind=2), VALUE :: chunk_size
          end subroutine omp_set_schedule_2_

          subroutine omp_set_schedule_4_(kind, chunk_size) bind(c)
              import
              integer (kind=omp_sched_kind), VALUE :: kind
              integer (kind=omp_integer_kind), VALUE :: chunk_size
          end subroutine omp_set_schedule_4_

          subroutine omp_set_schedule_8_(kind, chunk_size) bind(c)
              import
              integer (kind=omp_sched_kind), VALUE :: kind
              integer (kind=8), VALUE :: chunk_size
          end subroutine omp_set_schedule_8_
          end interface omp_set_schedule

          interface omp_get_schedule
          subroutine omp_get_schedule_1_(kind, chunk_size) bind(c)
              import
              integer (kind=omp_sched_kind) :: kind
              integer (kind=1) :: chunk_size
          end subroutine omp_get_schedule_1_

          subroutine omp_get_schedule_2_(kind, chunk_size) bind(c)
              import
              integer (kind=omp_sched_kind) :: kind
              integer (kind=2) :: chunk_size
          end subroutine omp_get_schedule_2_

          subroutine omp_get_schedule_4_(kind, chunk_size) bind(c)
              import
              integer (kind=omp_sched_kind) :: kind
              integer (kind=omp_integer_kind) :: chunk_size
          end subroutine omp_get_schedule_4_

          subroutine omp_get_schedule_8_(kind, chunk_size) bind(c)
              import
              integer (kind=omp_sched_kind) :: kind
              integer (kind=8) :: chunk_size
          end subroutine omp_get_schedule_8_
          end interface omp_get_schedule

          interface omp_get_thread_limit
          function omp_get_thread_limit() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_thread_limit
          end function omp_get_thread_limit
          end interface omp_get_thread_limit

          interface omp_get_teams_thread_limit
          function omp_get_teams_thread_limit() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_teams_thread_limit
          end function omp_get_teams_thread_limit
          end interface omp_get_teams_thread_limit

          interface omp_set_teams_thread_limit
          subroutine omp_set_teams_thread_limit_1_(thread_limit) bind(c)
              import
              integer (kind=1), VALUE :: thread_limit
          end subroutine omp_set_teams_thread_limit_1_

          subroutine omp_set_teams_thread_limit_2_(thread_limit) bind(c)
              import
              integer (kind=2), VALUE :: thread_limit
          end subroutine omp_set_teams_thread_limit_2_

          subroutine omp_set_teams_thread_limit_4_(thread_limit) bind(c)
              import
              integer (kind=omp_integer_kind), VALUE :: thread_limit
          end subroutine omp_set_teams_thread_limit_4_

          subroutine omp_set_teams_thread_limit_8_(thread_limit) bind(c)
              import
              integer (kind=8), VALUE :: thread_limit
          end subroutine omp_set_teams_thread_limit_8_
          end interface omp_set_teams_thread_limit

          interface omp_get_supported_active_levels
          function omp_get_supported_active_levels() bind(c)
              import
              integer (kind=omp_integer_kind)                           &
     &        omp_get_supported_active_levels
          end function omp_get_supported_active_levels
          end interface omp_get_supported_active_levels

          interface omp_set_max_active_levels
          subroutine omp_set_max_active_levels_1_(max_levels) bind(c)
              import
              integer (kind=1), VALUE :: max_levels
          end subroutine omp_set_max_active_levels_1_

          subroutine omp_set_max_active_levels_2_(max_levels) bind(c)
              import
              integer (kind=2), VALUE :: max_levels
          end subroutine omp_set_max_active_levels_2_

          subroutine omp_set_max_active_levels_4_(max_levels) bind(c)
              import
              integer (kind=omp_integer_kind), VALUE :: max_levels
          end subroutine omp_set_max_active_levels_4_

          subroutine omp_set_max_active_levels_8_(max_levels) bind(c)
              import
              integer (kind=8), VALUE :: max_levels
          end subroutine omp_set_max_active_levels_8_
          end interface omp_set_max_active_levels

          interface omp_get_max_active_levels
          function omp_get_max_active_levels() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_max_active_levels
          end function omp_get_max_active_levels
          end interface omp_get_max_active_levels

          interface omp_get_level
          function omp_get_level() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_level
          end function omp_get_level
          end interface omp_get_level

          interface omp_get_ancestor_thread_num
          function omp_get_ancestor_thread_num_1_(level) bind(c)
              import
              integer (kind=1), VALUE :: level
              integer (kind=omp_integer_kind)                           &
     &        omp_get_ancestor_thread_num_1_
          end function omp_get_ancestor_thread_num_1_

          function omp_get_ancestor_thread_num_2_(level) bind(c)
              import
              integer (kind=2), VALUE :: level
              integer (kind=omp_integer_kind)                           &
     &        omp_get_ancestor_thread_num_2_
          end function omp_get_ancestor_thread_num_2_

          function omp_get_ancestor_thread_num_4_(level) bind(c)
              import
              integer (kind=omp_integer_kind), VALUE :: level
              integer (kind=omp_integer_kind)                           &
     &        omp_get_ancestor_thread_num_4_
          end function omp_get_ancestor_thread_num_4_

          function omp_get_ancestor_thread_num_8_(level) bind(c)
              import
              integer (kind=8), VALUE :: level
              integer (kind=omp_integer_kind)                           &
     &        omp_get_ancestor_thread_num_8_
          end function omp_get_ancestor_thread_num_8_
          end interface omp_get_ancestor_thread_num

          interface omp_get_team_size
          function omp_get_team_size_1_(level) bind(c)
              import
              integer (kind=1), VALUE :: level
              integer (kind=omp_integer_kind) omp_get_team_size_1_
          end function omp_get_team_size_1_

          function omp_get_team_size_2_(level) bind(c)
              import
              integer (kind=2), VALUE :: level
              integer (kind=omp_integer_kind) omp_get_team_size_2_
          end function omp_get_team_size_2_

          function omp_get_team_size_4_(level) bind(c)
              import
              integer (kind=omp_integer_kind), VALUE :: level
              integer (kind=omp_integer_kind) omp_get_team_size_4_
          end function omp_get_team_size_4_

          function omp_get_team_size_8_(level) bind(c)
              import
              integer (kind=8), VALUE :: level
              integer (kind=omp_integer_kind) omp_get_team_size_8_
          end function omp_get_team_size_8_
          end interface omp_get_team_size

          interface omp_get_active_level
          function omp_get_active_level() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_active_level
          end function omp_get_active_level
          end interface omp_get_active_level


          ! Thread Affinity Routines

          interface omp_get_proc_bind
          function omp_get_proc_bind() bind(c)
              import
              integer (kind=omp_proc_bind_kind) omp_get_proc_bind
          end function omp_get_proc_bind
          end interface omp_get_proc_bind

          interface omp_get_num_places
          function omp_get_num_places() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_num_places
          end function omp_get_num_places
          end interface omp_get_num_places

          interface omp_get_place_num_procs
          function omp_get_place_num_procs(place_num) bind(c)
              import
              integer (kind=omp_integer_kind), VALUE :: place_num
              integer (kind=omp_integer_kind) omp_get_place_num_procs
          end function omp_get_place_num_procs
          end interface omp_get_place_num_procs

          interface omp_get_place_proc_ids
          subroutine omp_get_place_proc_ids(place_num, ids) bind(c)
              import
              integer (kind=omp_integer_kind), VALUE :: place_num
              integer (kind=omp_integer_kind), intent(out) :: ids(*)
          end subroutine omp_get_place_proc_ids
          end interface omp_get_place_proc_ids

          interface omp_get_place_num
          function omp_get_place_num() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_place_num
          end function omp_get_place_num
          end interface omp_get_place_num

          interface omp_get_partition_num_places
          function omp_get_partition_num_places() bind(c)
              import
              integer (kind=omp_integer_kind)                           &
     &        omp_get_partition_num_places
          end function omp_get_partition_num_places
          end interface omp_get_partition_num_places

          interface omp_get_partition_place_nums
          subroutine omp_get_partition_place_nums(place_nums) bind(c)
              import
              integer (kind=omp_integer_kind),                          &
     &        intent(out) :: place_nums(*)
          end subroutine omp_get_partition_place_nums
          end interface omp_get_partition_place_nums

          interface omp_set_affinity_format
          subroutine omp_set_affinity_format(format) bind(c)
              import
              character(len=*), intent(in) :: format
          end subroutine omp_set_affinity_format
          end interface omp_set_affinity_format

          interface omp_get_affinity_format
          function omp_get_affinity_format(buffer) bind(c)
              import
              character(len=*), intent(out) :: buffer
              integer (kind=omp_integer_kind) omp_get_affinity_format
          end function omp_get_affinity_format
          end interface omp_get_affinity_format

          interface omp_display_affinity
          subroutine omp_display_affinity(format) bind(c)
              import
              character(len=*), intent(in) :: format
          end subroutine omp_display_affinity
          end interface omp_display_affinity

          interface omp_capture_affinity
          function omp_capture_affinity(buffer, format) bind(c)
              import
              character(len=*), intent(out) :: buffer
              character(len=*), intent(in) :: format
              integer (kind=omp_integer_kind) omp_capture_affinity
          end function omp_capture_affinity
          end interface omp_capture_affinity


          ! Teams Region Routines

          interface omp_get_num_teams
          function omp_get_num_teams() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_num_teams
          end function omp_get_num_teams
          end interface omp_get_num_teams

          interface omp_get_team_num
          function omp_get_team_num() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_team_num
          end function omp_get_team_num
          end interface omp_get_team_num


          ! Tasking Routines

          interface omp_get_max_task_priority
          function omp_get_max_task_priority() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_max_task_priority
          end function omp_get_max_task_priority
          end interface omp_get_max_task_priority

          interface omp_in_final
          function omp_in_final() bind(c)
              import
              logical (kind=omp_logical_kind) omp_in_final
          end function omp_in_final
          end interface omp_in_final


          ! Resource Relinquishing Routines

          interface omp_pause_resource
          function omp_pause_resource(kind, device_num) bind(c)
              import
              integer (kind=omp_pause_resource_kind), VALUE :: kind
              integer (kind=omp_integer_kind), VALUE :: device_num
              integer (kind=omp_pause_resource_kind) omp_pause_resource
          end function omp_pause_resource
          end interface omp_pause_resource

          interface omp_pause_resource_all
          function omp_pause_resource_all(kind) bind(c)
              import
              integer (kind=omp_pause_resource_kind), VALUE :: kind
              integer (kind=omp_pause_resource_kind)                    &
     &        omp_pause_resource_all
          end function omp_pause_resource_all
          end interface omp_pause_resource_all


          ! Device Information Routines

          interface omp_get_num_procs
          function omp_get_num_procs() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_num_procs
          end function omp_get_num_procs
          end interface omp_get_num_procs

          interface omp_set_default_device
          subroutine omp_set_default_device_1_(device_num) bind(c)
              import
              integer (kind=1), VALUE :: device_num
          end subroutine omp_set_default_device_1_

          subroutine omp_set_default_device_2_(device_num) bind(c)
              import
              integer (kind=2), VALUE :: device_num
          end subroutine omp_set_default_device_2_

          subroutine omp_set_default_device_4_(device_num) bind(c)
              import
              integer (kind=omp_integer_kind), VALUE :: device_num
          end subroutine omp_set_default_device_4_

          subroutine omp_set_default_device_8_(device_num) bind(c)
              import
              integer (kind=8), VALUE :: device_num
          end subroutine omp_set_default_device_8_
          end interface omp_set_default_device

          interface omp_get_default_device
          function omp_get_default_device() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_default_device
          end function omp_get_default_device
          end interface omp_get_default_device

          interface omp_get_num_devices
          function omp_get_num_devices() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_num_devices
          end function omp_get_num_devices
          end interface omp_get_num_devices

          interface omp_get_device_num
          function omp_get_device_num() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_device_num
          end function omp_get_device_num
          end interface omp_get_device_num

          interface omp_is_initial_device
          function omp_is_initial_device() bind(c)
              import
              logical (kind=omp_logical_kind) omp_is_initial_device
          end function omp_is_initial_device
          end interface omp_is_initial_device

          interface omp_get_initial_device
          function omp_get_initial_device() bind(c)
              import
              integer (kind=omp_integer_kind) omp_get_initial_device
          end function omp_get_initial_device
          end interface omp_get_initial_device


          ! Device Memory Routines

          interface omp_target_alloc
          function omp_target_alloc(size, device_num) bind(c)
              use, intrinsic :: iso_c_binding, only                     &
     &        : c_ptr, c_size_t, c_int
              integer (kind=c_size_t), VALUE :: size
              integer (kind=c_int), VALUE :: device_num
              type(c_ptr) omp_target_alloc
          end function omp_target_alloc
          end interface omp_target_alloc

          interface omp_target_free
          subroutine omp_target_free(device_ptr, device_num) bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr, c_int
              type(c_ptr), VALUE :: device_ptr
              integer (kind=c_int), VALUE :: device_num
          end subroutine omp_target_free
          end interface omp_target_free

          interface omp_target_is_present
          function omp_target_is_present(ptr, device_num) bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr, c_int
              type(c_ptr), VALUE :: ptr
              integer (kind=c_int), VALUE :: device_num
              integer (kind=c_int) omp_target_is_present
          end function omp_target_is_present
          end interface omp_target_is_present

          interface omp_target_is_accessible
          function omp_target_is_accessible(ptr, size, device_num)      &
     &    bind(c)
              use, intrinsic :: iso_c_binding, only                     &
     &        : c_ptr, c_size_t, c_int
              type(c_ptr), VALUE :: ptr
              integer (kind=c_size_t), VALUE :: size
              integer (kind=c_int), VALUE :: device_num
              integer (kind=c_int) omp_target_is_accessible
          end function omp_target_is_accessible
          end interface omp_target_is_accessible

          interface omp_target_memcpy
          function omp_target_memcpy(dst, src, length, dst_offset,      &
     &                               src_offset, dst_device_num,        &
     &                               src_device_num) bind(c)
              use, intrinsic :: iso_c_binding, only                     &
     &        : c_ptr, c_int, c_size_t
              type(c_ptr), VALUE :: dst
              type(c_ptr), VALUE :: src
              integer (kind=c_size_t), VALUE :: length
              integer (kind=c_size_t), VALUE :: dst_offset
              integer (kind=c_size_t), VALUE :: src_offset
              integer (kind=c_int), VALUE :: dst_device_num
              integer (kind=c_int), VALUE :: src_device_num
              integer (kind=c_int) omp_target_memcpy
          end function omp_target_memcpy
          end interface omp_target_memcpy

          interface omp_target_memcpy_rect
          function omp_target_memcpy_rect(dst, src, element_size,       &
     &                                    num_dims, volume, dst_offsets,&
     &                                    src_offsets, dst_dimensions,  &
     &                                    src_dimensions,               &
     &                                    dst_device_num,               &
     &                                    src_device_num) bind(c)
              use, intrinsic :: iso_c_binding, only                     &
     &        : c_ptr, c_int, c_size_t
              type(c_ptr), VALUE :: dst
              type(c_ptr), VALUE :: src
              integer (kind=c_size_t), VALUE :: element_size
              integer (kind=c_int), VALUE :: num_dims
              integer (kind=c_size_t), intent(in) :: volume(*)
              integer (kind=c_size_t), intent(in) :: dst_offsets(*)
              integer (kind=c_size_t), intent(in) :: src_offsets(*)
              integer (kind=c_size_t), intent(in) :: dst_dimensions(*)
              integer (kind=c_size_t), intent(in) :: src_dimensions(*)
              integer (kind=c_int), VALUE :: dst_device_num
              integer (kind=c_int), VALUE :: src_device_num
              integer (kind=c_int) omp_target_memcpy_rect
          end function omp_target_memcpy_rect
          end interface omp_target_memcpy_rect

          interface omp_target_memcpy_async
          function omp_target_memcpy_async(dst, src, length, dst_offset,&
     &                                     src_offset, dst_device_num,  &
     &                                     src_device_num, depobj_count,&
     &                                     depobj_list) bind(c)
              use, intrinsic :: iso_c_binding, only                     &
     &        : c_ptr, c_int, c_size_t
              import
              type(c_ptr), VALUE :: dst
              type(c_ptr), VALUE :: src
              integer (kind=c_size_t), VALUE :: length
              integer (kind=c_size_t), VALUE :: dst_offset
              integer (kind=c_size_t), VALUE :: src_offset
              integer (kind=c_int), VALUE :: dst_device_num
              integer (kind=c_int), VALUE :: src_device_num
              integer (kind=c_int), VALUE :: depobj_count
              integer (kind=omp_depend_kind), optional :: depobj_list(*)
              integer (kind=c_int) omp_target_memcpy_async
          end function omp_target_memcpy_async
          end interface omp_target_memcpy_async

          interface omp_target_memcpy_rect_async
          function omp_target_memcpy_rect_async(dst, src, element_size, &
     &                                          num_dims, volume,       &
     &                                          dst_offsets,            &
     &                                          src_offsets,            &
     &                                          dst_dimensions,         &
     &                                          src_dimensions,         &
     &                                          dst_device_num,         &
     &                                          src_device_num,         &
     &                                          depobj_count,           &
     &                                          depobj_list) bind(c)
              use, intrinsic :: iso_c_binding, only                     &
     &        : c_ptr, c_int, c_size_t
              import
              type(c_ptr), VALUE :: dst
              type(c_ptr), VALUE :: src
              integer (kind=c_size_t), VALUE :: element_size
              integer (kind=c_int), VALUE :: num_dims
              integer (kind=c_size_t), intent(in) :: volume(*)
              integer (kind=c_size_t), intent(in) :: dst_offsets(*)
              integer (kind=c_size_t), intent(in) :: src_offsets(*)
              integer (kind=c_size_t), intent(in) :: dst_dimensions(*)
              integer (kind=c_size_t), intent(in) :: src_dimensions(*)
              integer (kind=c_int), VALUE :: dst_device_num
              integer (kind=c_int), VALUE :: src_device_num
              integer (kind=c_int), VALUE :: depobj_count
              integer (kind=omp_depend_kind), optional :: depobj_list(*)
              integer (kind=c_int) omp_target_memcpy_rect_async
          end function omp_target_memcpy_rect_async
          end interface omp_target_memcpy_rect_async

          interface omp_target_associate_ptr
          function omp_target_associate_ptr(host_ptr, device_ptr, size, &
     &                                      device_offset,              &
     &                                      device_num) bind(c)
              use, intrinsic :: iso_c_binding, only                     &
     &        : c_ptr, c_size_t, c_int
              type(c_ptr), VALUE :: host_ptr
              type(c_ptr), VALUE :: device_ptr
              integer (kind=c_size_t), VALUE :: size
              integer (kind=c_size_t), VALUE :: device_offset
              integer (kind=c_int), VALUE :: device_num
              integer (kind=c_int) omp_target_associate_ptr
          end function omp_target_associate_ptr
          end interface omp_target_associate_ptr

          interface omp_get_mapped_ptr
          function omp_get_mapped_ptr(ptr, device_num) bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr, c_int
              type(c_ptr), VALUE :: ptr
              integer (kind=c_int), VALUE :: device_num
              type(c_ptr) omp_get_mapped_ptr
          end function omp_get_mapped_ptr
          end interface omp_get_mapped_ptr

          interface omp_target_disassociate_ptr
          function omp_target_disassociate_ptr(ptr, device_num) bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr, c_int
              type(c_ptr), VALUE :: ptr
              integer (kind=c_int), VALUE :: device_num
              integer (kind=c_int) omp_target_disassociate_ptr
          end function omp_target_disassociate_ptr
          end interface omp_target_disassociate_ptr


          ! Lock Routines

          interface omp_init_lock
          subroutine omp_init_lock(svar)                                &
     &    bind(c, name='omp_init_lock_ftn')
              import
              integer (kind=omp_lock_kind), intent(out) :: svar
          end subroutine omp_init_lock
          end interface omp_init_lock

          interface omp_init_lock_with_hint
          subroutine omp_init_lock_with_hint(svar, hint)                &
     &    bind(c, name='omp_init_lock_with_hint_ftn')
              import
              integer (kind=omp_lock_kind), intent(out) :: svar
              integer (kind=omp_sync_hint_kind), intent(in) :: hint
          end subroutine omp_init_lock_with_hint
          end interface omp_init_lock_with_hint

          interface omp_destroy_lock
          subroutine omp_destroy_lock(svar)                             &
     &    bind(c, name='omp_destroy_lock_ftn')
              import
              integer (kind=omp_lock_kind), intent(inout) :: svar
          end subroutine omp_destroy_lock
          end interface omp_destroy_lock

          interface omp_set_lock
          subroutine omp_set_lock(svar) bind(c, name='omp_set_lock_ftn')
              import
              integer (kind=omp_lock_kind), intent(inout) :: svar
          end subroutine omp_set_lock
          end interface omp_set_lock

          interface omp_unset_lock
          subroutine omp_unset_lock(svar)                               &
     &    bind(c, name='omp_unset_lock_ftn')
              import
              integer (kind=omp_lock_kind), intent(inout) :: svar
          end subroutine omp_unset_lock
          end interface omp_unset_lock

          interface omp_test_lock
          function omp_test_lock(svar) bind(c, name='omp_test_lock_ftn')
              import
              integer (kind=omp_lock_kind), intent(inout) :: svar
              logical (kind=omp_logical_kind) omp_test_lock
          end function omp_test_lock
          end interface omp_test_lock

          interface omp_init_nest_lock
          subroutine omp_init_nest_lock(nvar)                           &
     &    bind(c, name='omp_init_nest_lock_')
              import
              integer (kind=omp_nest_lock_kind), intent(out) :: nvar
          end subroutine omp_init_nest_lock
          end interface omp_init_nest_lock

          interface omp_init_nest_lock_with_hint
          subroutine omp_init_nest_lock_with_hint(nvar, hint)           &
     &    bind(c, name='omp_init_nest_lock_with_hint_')
              import
              integer (kind=omp_nest_lock_kind), intent(out) :: nvar
              integer (kind=omp_sync_hint_kind), intent(in) :: hint
          end subroutine omp_init_nest_lock_with_hint
          end interface omp_init_nest_lock_with_hint

          interface omp_destroy_nest_lock
          subroutine omp_destroy_nest_lock(nvar)                        &
     &    bind(c, name='omp_destroy_nest_lock_')
              import
              integer (kind=omp_nest_lock_kind), intent(inout) :: nvar
          end subroutine omp_destroy_nest_lock
          end interface omp_destroy_nest_lock

          interface omp_set_nest_lock
          subroutine omp_set_nest_lock(nvar)                            &
     &    bind(c, name='omp_set_nest_lock_')
              import
              integer (kind=omp_nest_lock_kind), intent(inout) :: nvar
          end subroutine omp_set_nest_lock
          end interface omp_set_nest_lock

          interface omp_unset_nest_lock
          subroutine omp_unset_nest_lock(nvar)                          &
     &    bind(c, name='omp_unset_nest_lock_')
              import
              integer (kind=omp_nest_lock_kind), intent(inout) :: nvar
          end subroutine omp_unset_nest_lock
          end interface omp_unset_nest_lock

          interface omp_test_nest_lock
          function omp_test_nest_lock(nvar)                             &
     &    bind(c, name='omp_test_nest_lock_')
              import
              integer (kind=omp_nest_lock_kind), intent(inout) :: nvar
              integer (kind=omp_integer_kind) omp_test_nest_lock
          end function omp_test_nest_lock
          end interface omp_test_nest_lock


          ! Timing Routines

          interface omp_get_wtime
          function omp_get_wtime() bind(c)
              import
              double precision omp_get_wtime
          end function omp_get_wtime
          end interface omp_get_wtime

          interface omp_get_wtick
          function omp_get_wtick() bind(c)
              import
              double precision omp_get_wtick
          end function omp_get_wtick
          end interface omp_get_wtick


          ! Event Routine

          interface omp_fulfill_event
          subroutine omp_fulfill_event(event) bind(c)
              import
              integer (kind=omp_event_handle_kind), VALUE :: event
          end subroutine omp_fulfill_event
          end interface omp_fulfill_event


          ! Memory Management Routines

          interface omp_init_allocator
          function omp_init_allocator(memspace, ntraits, traits) bind(c)
              import
              integer (kind=omp_memspace_handle_kind),                  &
     &        intent(in) :: memspace
              integer (kind=omp_integer_kind), intent(in) :: ntraits
              type(omp_alloctrait), intent(in) :: traits(*)
              integer (kind=omp_allocator_handle_kind) omp_init_allocator
          end function omp_init_allocator
          end interface omp_init_allocator

          interface omp_destroy_allocator
          subroutine omp_destroy_allocator(allocator) bind(c)
              import
              integer (kind=omp_allocator_handle_kind),                 &
     &        VALUE :: allocator
          end subroutine omp_destroy_allocator
          end interface omp_destroy_allocator

          interface omp_set_default_allocator
          subroutine omp_set_default_allocator(allocator) bind(c)
              import
              integer (kind=omp_allocator_handle_kind),                 &
     &        VALUE :: allocator
          end subroutine omp_set_default_allocator
          end interface omp_set_default_allocator

          interface omp_get_default_allocator
          function omp_get_default_allocator() bind(c)
              import
              integer (kind=omp_allocator_handle_kind)                  &
     &        omp_get_default_allocator
          end function omp_get_default_allocator
          end interface omp_get_default_allocator

          interface omp_alloc
          function omp_alloc(size, allocator) bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr, c_size_t
              import
              integer (kind=c_size_t), VALUE :: size
              integer (kind=omp_allocator_handle_kind),                 &
     &        VALUE :: allocator
              type(c_ptr) omp_alloc
          end function omp_alloc
          end interface omp_alloc

          interface omp_aligned_alloc
          function omp_aligned_alloc(alignment, size, allocator) bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr, c_size_t
              import
              integer (kind=c_size_t), VALUE :: alignment
              integer (kind=c_size_t), VALUE :: size
              integer (kind=omp_allocator_handle_kind),                 &
     &        VALUE :: allocator
              type(c_ptr) omp_aligned_alloc
          end function omp_aligned_alloc
          end interface omp_aligned_alloc

          interface omp_free
          subroutine omp_free(ptr, allocator) bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr
              import
              type(c_ptr), VALUE :: ptr
              integer (kind=omp_allocator_handle_kind),                 &
     &        VALUE :: allocator
          end subroutine omp_free
          end interface omp_free

          interface omp_calloc
          function omp_calloc(nmemb, size, allocator) bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr, c_size_t
              import
              integer (kind=c_size_t), VALUE :: nmemb
              integer (kind=c_size_t), VALUE :: size
              integer (kind=omp_allocator_handle_kind),                 &
     &        VALUE :: allocator
              type(c_ptr) omp_calloc
          end function omp_calloc
          end interface omp_calloc

          interface omp_aligned_calloc
          function omp_aligned_calloc(alignment, nmemb, size,           &
     &                                allocator) bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr, c_size_t
              import
              integer (kind=c_size_t), VALUE :: alignment
              integer (kind=c_size_t), VALUE :: nmemb
              integer (kind=c_size_t), VALUE :: size
              integer (kind=omp_allocator_handle_kind),                 &
     &        VALUE :: allocator
              type(c_ptr) omp_aligned_calloc
          end function omp_aligned_calloc
          end interface omp_aligned_calloc

          interface omp_realloc
          function omp_realloc(ptr, size, allocator, free_allocator)    &
     &    bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr, c_size_t
              import
              type(c_ptr), VALUE :: ptr
              integer (kind=c_size_t), VALUE :: size
              integer (kind=omp_allocator_handle_kind),                 &
     &        VALUE :: allocator
              integer (kind=omp_allocator_handle_kind),                 &
     &        VALUE :: free_allocator
              type(c_ptr) omp_realloc
          end function omp_realloc
          end interface omp_realloc


          ! Tool Control Routine

          interface omp_control_tool
          function omp_control_tool(command, modifier, arg) bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr
              import
              integer (kind=omp_control_tool_kind), VALUE :: command
              integer (kind=omp_integer_kind), VALUE :: modifier
              type(c_ptr), VALUE :: arg
              integer (kind=omp_integer_kind) omp_control_tool
          end function omp_control_tool
          end interface omp_control_tool


          ! Environment Display Routine

          interface omp_display_env
          subroutine omp_display_env(verbose) bind(c)
              import
              logical (kind=omp_logical_kind), VALUE :: verbose
          end subroutine omp_display_env
          end interface omp_display_env


          ! Implementation Defined Routines (non-standard)

          interface nvomp_proc_bind_off
          subroutine nvomp_proc_bind_off() bind(c)
          end subroutine nvomp_proc_bind_off
          end interface nvomp_proc_bind_off

          interface ompx_get_cuda_stream
          function ompx_get_cuda_stream(device, nowait) bind(c)
              use, intrinsic :: iso_c_binding, only : c_ptr
              import
              integer (kind=omp_integer_kind), VALUE :: device
              logical (kind=omp_logical_kind), VALUE :: nowait
              integer (kind=omp_handle_kind) ompx_get_cuda_stream
          end function ompx_get_cuda_stream
          end interface ompx_get_cuda_stream

          interface ompx_set_cuda_stream_auto
          subroutine ompx_set_cuda_stream_auto(enable) bind(c)
              import
              logical (kind=omp_logical_kind), VALUE :: enable
          end subroutine ompx_set_cuda_stream_auto
          end interface ompx_set_cuda_stream_auto
