system_variable_list = [ ( 'group_replication_group_name',
    'The name of the group',
    True,
    ['Replication/Group']),
  ( 'group_replication_start_on_boot',
    'Whether the server should start Group Replication or not during server start',
    True,
    ['Replication/Group']),
  ( 'group_replication_local_address',
    'The local address in host:port formatted string',
    True,
    ['Replication/Group']),
  ( 'group_replication_member_weight',
    'Chance of this member being elected as primary',
    True,
    ['Replication/Group']),
  ( 'group_replication_group_seeds',
    'A list of peer addresses, comma separated list such as host1:port1,host2:port2',
    True,
    ['Replication/Group']),
  ( 'group_replication_force_members',
    'A comma separated list of peer addresses, such as host1:port1,host2:port2',
    True,
    ['Replication/Group']),
  ( 'group_replication_bootstrap_group',
    'Configure this server to bootstrap the group',
    True,
    ['Replication/Group']),
  ( 'group_replication_poll_spin_loops',
    'The number of times the group communication thread waits',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_get_public_key',
    'Whether to accept preference about fetching public key from master',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_public_key_path',
    'To accept public key information',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_retry_count',
    'The number of times that a joining member tries to connect to the available donors before giving up',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_reconnect_interval',
    'The sleep time, in seconds, between reconnection attempts when no donor was found in the group',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_use_ssl',
    'Whether Group Replication recovery connection should use SSL',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_ssl_ca',
    'File that contains list of trusted SSL Certificate Authorities',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_ssl_capath',
    'Directory that contains trusted SSL Certificate Authority certificate files',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_ssl_cert',
    'Name of SSL certificate file to use for establishing encrypted connection',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_ssl_key',
    'Name of SSL key file to use for establishing encrypted connection',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_ssl_cipher',
    'List of permitted ciphers for SSL encryption',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_ssl_crl',
    'File that contains certificate revocation lists',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_ssl_crlpath',
    'Directory that contains certificate revocation list files',
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_ssl_verify_server_cert',
    "Make the recovery process check the server's Common Name value in the donor sent certificate",
    True,
    ['Replication/Group']),
  ( 'group_replication_recovery_complete_at',
    'Recovery policies when handling cached transactions after state transfer',
    True,
    ['Replication/Group']),
  ( 'group_replication_communication_debug_options',
    'The level of debugging messages for Group Replication components.',
    True,
    ['Replication/Group']),
  ( 'group_replication_components_stop_timeout',
    'Timeout, in seconds, that the plugin waits for each of the components when shutting down',
    True,
    ['Replication/Group']),
  ( 'group_replication_allow_local_lower_version_join',
    'Allow the current server to join the group even if it has a lower plugin version than the group',
    True,
    ['Replication/Group']),
  ( 'group_replication_allow_local_disjoint_gtids_join',
    'Allow the current server to join the group even if it has transactions not present in the group',
    True,
    ['Replication/Group']),
  ( 'group_replication_auto_increment_increment',
    'Determines the interval between successive column values for transactions that execute on this server',
    True,
    ['Replication/Group']),
  ( 'group_replication_compression_threshold',
    'The value in bytes above which (LZ4) compression is enforced; when set to zero, deactivates compression',
    True,
    ['Replication/Group']),
  ( 'group_replication_gtid_assignment_block_size',
    'The number of consecutive GTIDs that are reserved for each member; each member consumes its blocks and reserve more when needed',
    True,
    ['Replication/Group']),
  ( 'group_replication_ssl_mode',
    'Specifies the security state of the connection between Group Replication members',
    True,
    ['Replication/Group']),
  ( 'group_replication_single_primary_mode',
    'Instructs the group to use a single server for the read/write workload',
    True,
    ['Replication/Group']),
  ( 'group_replication_transaction_size_limit',
    'Sets the maximum size of transaction in bytes which the group accepts',
    True,
    ['Replication/Group']),
  ( 'group_replication_unreachable_majority_timeout',
    'How long to wait for network partitions that result in a minority to leave the group',
    True,
    ['Replication/Group']),
  ( 'group_replication_enforce_update_everywhere_checks',
    'Enable or disable strict consistency checks for multi-master update everywhere',
    True,
    ['Replication/Group']),
  ( 'group_replication_flow_control_mode',
    'Specifies the mode used for flow control',
    True,
    ['Replication/Group']),
  ( 'group_replication_flow_control_certifier_threshold',
    'Specifies the number of waiting transactions in the certifier queue that trigger flow control',
    True,
    ['Replication/Group']),
  ( 'group_replication_flow_control_applier_threshold',
    'The number of waiting transactions in the applier queue that trigger flow control',
    True,
    ['Replication/Group']),
  ( 'group_replication_flow_control_hold_percent',
    'Defines what percentage of the group quota remains unused',
    True,
    ['Replication/Group']),
  ( 'group_replication_flow_control_max_commit_quota',
    'Defines the maximum flow control quota of the group',
    True,
    ['Replication/Group']),
  ( 'group_replication_flow_control_member_quota_percent',
    'Defines the percentage of the quota that a member should assume is available for itself when calculating the quotas',
    True,
    ['Replication/Group']),
  ( 'group_replication_flow_control_min_quota',
    'Controls the lowest flow control quota that can be assigned to a member',
    True,
    ['Replication/Group']),
  ( 'group_replication_flow_control_min_recovery_quota',
    'Controls the lowest quota that can be assigned to a member because of another recovering member in the group',
    True,
    ['Replication/Group']),
  ( 'group_replication_flow_control_period',
    'Defines how many seconds to wait between flow control iterations',
    True,
    ['Replication/Group']),
  ( 'group_replication_flow_control_release_percent',
    'Defines how the group quota should be released when flow control no longer needs to throttle the writer members',
    True,
    ['Replication/Group']),
  ( 'group_replication_ip_whitelist',
    'The list of hosts permitted to connect to the group',
    True,
    ['Replication/Group']),
  ( 'mysqlx-bind-address',
    'The network address uses for connections.',
    False,
    ['Other/X']),
  ( 'mysqlx-connect-timeout',
    'Maximum permitted waiting time in seconds for a connection to set up a session',
    True,
    ['Other/X']),
  ( 'mysqlx-idle-worker-thread-timeout',
    'Time in seconds after which an idle worker thread is terminated',
    True,
    ['Other/X']),
  ( 'mysqlx-interactive-timeout',
    'Number of seconds to wait for an interactive client to timeout',
    True,
    ['Other/X']),
  ( 'mysqlx-max-allowed-packet',
    'Size of largest message that a client is going to process',
    True,
    ['Other/X']),
  ( 'mysqlx-max-connections',
    'Maximum number of concurrent client connections the can accept',
    True,
    ['Other/X']),
  ( 'mysqlx-min-worker-threads',
    'Minimum number of worker threads used for handling client requests.',
    True,
    ['Other/X']),
  ('mysqlx-port', 'Port where accepts connections', False, ['Other/X']),
  ( 'mysqlx-port-open-timeout',
    'Time which the X Plugin waits when accepting connections',
    False,
    ['Other/X']),
  ( 'mysqlx-read-timeout',
    'Number of seconds to wait for blocking read operations to complete',
    True,
    ['Other/X']),
  ('mysqlx-socket', 'Binds to a Unix socket', False, ['Other/X']),
  ('mysqlx-ssl', 'Enabled when using SSL with', False, []),
  ('mysqlx-ssl-key', 'Path to X509 key', False, []),
  ('mysqlx-ssl-ca', 'Path to SSL Certificate Authority file', False, []),
  ('mysqlx-ssl-capath', 'SSL Certificate Authority file directory', False, []),
  ('mysqlx-ssl-cert', 'Path to X509 certficate', False, []),
  ('mysqlx-ssl-crl', 'Certificate revocation list', False, []),
  ('mysqlx-ssl-crlpath', 'Certificate revocation list path', False, []),
  ( 'mysqlx-wait-timeout',
    'Number of seconds to wait for activity on a connection',
    True,
    ['Other/X']),
  ( 'mysqlx-write-timeout',
    'Number of seconds to wait for blocking write operation to complete',
    True,
    ['Other/X']),
  ( 'mysqlx_bind_address',
    'The network address uses for connections.',
    False,
    ['Other/X']),
  ( 'mysqlx_connect_timeout',
    'How long waits for a connect packet.',
    True,
    ['Other/X']),
  ( 'mysqlx_document_id_unique_prefix',
    'Use a custom prefix for document IDs.',
    True,
    ['Other/X']),
  ( 'mysqlx_idle_worker_thread_timeout',
    'Number of seconds after which an idle worker thread is terminated.',
    True,
    ['Other/X']),
  ( 'mysqlx_interactive_timeout',
    'Number of seconds to wait for an interactive client to timeout',
    True,
    ['Other/X']),
  ( 'mysqlx_max_allowed_packet',
    'Maximum size of a network packet that can be received by X Plugin.',
    True,
    ['Other/X']),
  ( 'mysqlx_max_connections',
    'Maximum number of concurrent client connections.',
    True,
    ['Other/X']),
  ( 'mysqlx_min_worker_threads',
    'Minimum number of worker threads used for handling client requests.',
    True,
    ['Other/X']),
  ('mysqlx_port', 'Port where accepts connections', False, ['Other/X']),
  ( 'mysqlx_port_open_timeout',
    'Time which the X Plugin waits when accepting connections',
    False,
    ['Other/X']),
  ( 'mysqlx_read_timeout',
    'Number of seconds to wait for blocking read operations to complete',
    True,
    ['Other/X']),
  ( 'mysqlx_socket',
    'Path to the socket where listens for connections',
    False,
    ['Other/X']),
  ( 'mysqlx_wait_timeout',
    'Number of seconds to wait for activity on a connection',
    True,
    ['Other/X']),
  ( 'mysqlx_write_timeout',
    'Number of seconds to wait for blocking write operation to complete',
    True,
    ['Other/X']),
  ( 'activate_all_roles_on_login',
    'Whether to activate all user roles at connect time',
    True,
    ['Security/Authentication']),
  ( 'audit_log_buffer_size',
    'The size of the audit log buffer',
    False,
    ['Logging/Audit']),
  ( 'audit_log_compression',
    'Audit log file compression method',
    False,
    ['Logging/Audit']),
  ( 'audit_log_connection_policy',
    'Audit logging policy for connection-related events',
    True,
    ['Logging/Audit']),
  ('audit_log_current_session', 'Whether to audit current session', False, []),
  ( 'audit_log_encryption',
    'Audit log file encryption method',
    False,
    ['Logging/Audit']),
  ( 'audit_log_exclude_accounts',
    'Accounts not to audit',
    True,
    ['Logging/Audit']),
  ( 'audit_log_file',
    'The name of the audit log file',
    False,
    ['Logging/Audit']),
  ('audit_log_filter_id', 'ID of current audit log filter', False, []),
  ('audit_log_flush', 'Close and reopen the audit log file', True, []),
  ('audit_log_format', 'The audit log file format', False, ['Logging/Audit']),
  ('audit_log_include_accounts', 'Accounts to audit', True, ['Logging/Audit']),
  ('audit_log_policy', 'Audit logging policy', True, ['Logging/Audit']),
  ( 'audit_log_read_buffer_size',
    'Audit log file read buffer size',
    False,
    ['Logging/Audit']),
  ( 'audit_log_rotate_on_size',
    'Close and reopen the audit log file at a certain size',
    True,
    ['Logging/Audit']),
  ( 'audit_log_statement_policy',
    'Audit logging policy for statement-related events',
    True,
    ['Logging/Audit']),
  ( 'audit_log_strategy',
    'The audit logging strategy',
    False,
    ['Logging/Audit']),
  ( 'auto_generate_certs',
    'Whether to autogenerate SSL key and certificate files',
    False,
    ['Security/Security']),
  ( 'auto_increment_increment',
    'AUTO_INCREMENT columns are incremented by this value',
    True,
    []),
  ( 'auto_increment_offset',
    'Offset added to AUTO_INCREMENT columns',
    True,
    []),
  ('autocommit', 'Sets the autocommit mode', True, ['General/Transactions']),
  ( 'automatic_sp_privileges',
    'Creating and dropping stored procedures alters ACLs',
    True,
    []),
  ( 'avoid_temporal_upgrade',
    'Whether ALTER TABLE should upgrade pre-5.6.4 temporal columns',
    True,
    ['General/System']),
  ( 'back_log',
    'Number of outstanding connection requests MySQL can have',
    False,
    []),
  ( 'backup_elevation',
    'Enable or disable BACKUP DATABASE privilege elevation',
    False,
    ['General/Backup']),
  ( 'backup_history_log',
    'Enable or disable MySQL Backup history log',
    True,
    ['General/Backup']),
  ( 'backup_history_log_file',
    'Name of the MySQL Backup history log file',
    True,
    ['General/Backup']),
  ( 'backup_progress_log',
    'Enable or disable MySQL Backup progress log',
    True,
    ['General/Backup']),
  ( 'backup_progress_log_file',
    'Name of the MySQL Backup progress log file',
    True,
    ['General/Backup']),
  ( 'backup_wait_timeout',
    'Number of seconds DDL statements wait for BACKUP DATABASE or RESTORE before aborting',
    True,
    []),
  ( 'backupdir',
    'Default backup image file directory',
    True,
    ['General/Backup']),
  ( 'basedir',
    'Path of installation directory',
    False,
    ['General/Directories']),
  ('bdb-data-direct', 'bdb-data-direct', False, []),
  ('bdb-home', 'Berkeley DB home directory', False, []),
  ('bdb-lock-detect', 'Berkeley DB lock detect', False, []),
  ('bdb-log-direct', 'bdb-log-direct', False, []),
  ('bdb-logdir', 'Berkeley DB log file directory', False, []),
  ('bdb-shared-data', 'Start Berkeley DB in multi-process mode', False, []),
  ('bdb-tmpdir', 'Berkeley DB tempfile name', False, []),
  ( 'bdb_cache_size',
    'The buffer that is allocated to cache index and rows for BDB tables',
    False,
    []),
  ( 'bdb_log_buffer_size',
    'The buffer that is allocated to cache index and rows for BDB tables',
    False,
    []),
  ( 'bdb_max_lock',
    'The maximum number of locks that can be active for a BDB table',
    False,
    []),
  ( 'big-tables',
    'Allow big result sets by saving all temporary sets on file',
    True,
    []),
  ('bind-address', 'IP address or host name to bind to', False, []),
  ('binlog-format', 'Specifies the format of the binary log', True, []),
  ( 'binlog_cache_size',
    'Size of the cache to hold the SQL statements for the binary log during a transaction',
    True,
    ['Logging/Binlog Options']),
  ('binlog_checksum', 'Enable/disable binary log checksums', True, []),
  ( 'binlog_direct_non_transactional_updates',
    'Causes updates using statement format to nontransactional engines to be written directly to binary log. See documentation before using.',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_error_action',
    'Controls what happens when the server cannot write to the binary log',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_expire_logs_seconds',
    'Purge binary logs after this many seconds',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_group_commit_sync_delay',
    'Sets the number of microseconds to wait before synchronizing transactions to disk',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_group_commit_sync_no_delay_count',
    'Sets the maximum number of transactions to wait for before aborting the current delay specified by binlog_group_commit_sync_delay',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_gtid_simple_recovery',
    'Controls how binary logs are iterated during GTID recovery',
    False,
    ['Logging/Binlog Options']),
  ( 'binlog_max_flush_queue_time',
    'How long to read transactions before flushing to binary log',
    True,
    []),
  ( 'binlog_order_commits',
    'Whether to commit in same order as writes to binary log',
    True,
    []),
  ( 'binlog_row_image',
    'Use full or minimal images when logging row changes',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_row_metadata',
    'Configures the amount of table related metadata binary logged when using row-based logging.',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_row_value_options',
    'Enables binary logging of partial JSON updates for row-based replication.',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_rows_query_log_events',
    'When TRUE, enables logging of rows query log events in row-based logging mode. FALSE by default. Do not enable when producing logs for pre-5.6 replication slaves or other readers.',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_stmt_cache_size',
    'Size of the cache to hold nontransactional statements for the binary log during a transaction',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_transaction_dependency_tracking',
    "Source of dependency information (commit timestamps or transaction write sets) from which to assess which transactions can be executed in parallel by slave's multi-threaded applier.",
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_transaction_dependency_history_size',
    'Number of row hashes kept for looking up transaction that last updated some row.',
    True,
    ['Logging/Binlog Options']),
  ( 'binlogging_impossible_mode',
    'Deprecated and will be removed in a future version. Use the renamed binlog_error_action instead.',
    True,
    ['Logging/Binlog Options']),
  ( 'block_encryption_mode',
    'Mode for block-based encryption algorithms',
    True,
    ['Security/Security']),
  ( 'bulk_insert_buffer_size',
    'Size of tree cache used in bulk insert optimization',
    True,
    ['Advanced/Various']),
  ( 'caching_sha2_password_auto_generate_rsa_keys',
    'Whether to autogenerate RSA key-pair files',
    False,
    ['Security/Security']),
  ( 'caching_sha2_password_private_key_path',
    'SHA2 authentication plugin private key path name',
    False,
    ['Security/Security']),
  ( 'caching_sha2_password_public_key_path',
    'SHA2 authentication plugin public key path name',
    False,
    ['Security/Security']),
  ('character-set-filesystem', 'Set the file system character set', True, []),
  ('character-set-server', 'Specify default character set', True, []),
  ( 'character-sets-dir',
    'Directory where character sets are installed',
    False,
    []),
  ('character_set', 'The default character set', False, []),
  ('character_set_client', 'Current client character set', True, []),
  ('character_set_connection', 'Current connection character set', True, []),
  ( 'character_set_database',
    'The character set used by the default database',
    True,
    []),
  ('character_set_results', 'Current result character set', True, []),
  ( 'character_set_system',
    'The character set used by the server for storing identifiers',
    False,
    []),
  ( 'check_proxy_users',
    'Whether built-in authentication plugins do proxying',
    True,
    ['Security/Authentication']),
  ('collation-server', 'Specify default collation', True, []),
  ('collation_connection', 'The collation of the connection', True, []),
  ( 'collation_database',
    'The collation used by the default database',
    True,
    []),
  ( 'completion_type',
    'Default completion type',
    True,
    ['Advanced/Transactions']),
  ( 'concurrent_insert',
    'Use concurrent insert with MyISAM',
    True,
    ['MyISAM/General']),
  ( 'connection_control_failed_connections_threshold',
    'Consecutive failed connection attempts before delays occur',
    True,
    ['Security/Authentication']),
  ( 'connection_control_max_connection_delay',
    'Maximum delay (milliseconds) for server response to failed connection attempts',
    True,
    ['Security/Authentication']),
  ( 'connection_control_min_connection_delay',
    'Minimum delay (milliseconds) for server response to failed connection attempts',
    True,
    ['Security/Authentication']),
  ( 'connect_timeout',
    "Number of seconds the mysqld server waits for a connect packet before responding with 'Bad handshake'",
    True,
    ['Networking/Timeout Settings']),
  ('core_file', 'Write core file on server crashes', False, []),
  ( 'create_old_temporals',
    'Use pre-5.6.4 storage format for temporal types when creating tables. Intended for use in replication and upgrades/downgrades between NDB 7.2 and NDB 7.3/7.4.',
    False,
    ['Other/NDB']),
  ( 'cte_max_recursion_depth',
    'Common table expression maximum recursion depth',
    True,
    ['General/SQL']),
  ('daemon_memcached_enable_binlog', '', False, ['Other/Memcached']),
  ( 'daemon_memcached_engine_lib_name',
    'Specifies the shared library that implements the InnoDB memcached plugin',
    False,
    ['Other/Memcached']),
  ( 'daemon_memcached_engine_lib_path',
    'Directory that contains the shared library that implements the InnoDB memcached plugin',
    False,
    ['Other/Memcached']),
  ( 'daemon_memcached_option',
    'Space-separated options that are passed to the underlying memcached daemon on startup',
    False,
    ['Other/Memcached']),
  ( 'daemon_memcached_r_batch_size',
    'Specifies how many memcached read operations to perform before doing a COMMIT to start a new transaction',
    False,
    ['Other/Memcached']),
  ( 'daemon_memcached_w_batch_size',
    'Specifies how many memcached write operations to perform before doing a COMMIT to start a new transaction',
    False,
    ['Other/Memcached']),
  ('datadir', 'Path of data directory', False, ['General/Directories']),
  ('date_format', 'The DATE format (unused)', False, []),
  ('datetime_format', 'The DATETIME/TIMESTAMP format (unused)', False, []),
  ( 'debug',
    'Output debug log; supported only if MySQL was built with debugging support',
    True,
    ['Advanced/General']),
  ('debug_sync', 'Interface to Debug Sync facility', True, []),
  ( 'default_collation_for_utf8mb4',
    'Default collation for utf8mb4 character set',
    True,
    ['General/International']),
  ( 'default-storage-engine',
    'The default storage engine (table type) for tables',
    True,
    []),
  ( 'default_authentication_plugin',
    'The default authentication plugin',
    False,
    ['Security/Authentication']),
  ( 'default_password_lifetime',
    'Age in days when passwords effectively expire',
    True,
    ['Security/Authentication']),
  ( 'default_tmp_storage_engine',
    'The default storage engine (table type) for TEMPORARY tables',
    True,
    ['General/General']),
  ( 'default_week_format',
    'The default week format used by WEEK() functions',
    True,
    ['General/International']),
  ('delay-key-write', 'Type of DELAY_KEY_WRITE', True, []),
  ( 'delayed_insert_limit',
    'After inserting delayed_insert_limit rows, the INSERT DELAYED handler will check if there are any SELECT statements pending. If so, it allows these to execute before continuing',
    True,
    ['Advanced/Insert delayed settings']),
  ( 'delayed_insert_timeout',
    'How many seconds an INSERT DELAYED thread should wait for INSERT statements before terminating',
    True,
    ['Advanced/Insert delayed settings']),
  ( 'delayed_queue_size',
    'What size queue (in rows) should be allocated for handling INSERT DELAYED',
    True,
    ['Advanced/Insert delayed settings']),
  ( 'disable-gtid-unsafe-statements',
    'Obsolete: Replaced by --enforce-gtid-consistency in MySQL 5.6.9',
    False,
    ['Replication/General']),
  ( 'disable_gtid_unsafe_statements',
    'Obsolete: Replaced by enforce_gtid_consistency in MySQL 5.6.9',
    False,
    ['Replication/General']),
  ( 'disabled_storage_engines',
    'Storage engines that cannot be used to create tables',
    False,
    ['General/System']),
  ( 'disconnect_on_expired_password',
    'Whether the server disconnects clients with expired passwords if clients cannot handle such accounts',
    False,
    ['Security/Authentication']),
  ( 'div_precision_increment',
    "Scale of the result of '/' operator will be increased by this many digits",
    True,
    ['Advanced/General']),
  ( 'dragnet.log_error_filter_rules',
    'Filter rules for error logging',
    True,
    ['Logging/Advanced log options']),
  ( 'end_markers_in_json',
    'Whether optimizer JSON output should add end markers',
    True,
    []),
  ( 'enforce-gtid-consistency',
    'Prevents execution of statements that cannot be logged in a transactionally safe manner',
    False,
    ['Replication/General']),
  ( 'enforce_gtid_consistency',
    'Prevents execution of statements that cannot be logged in a transactionally safe manner',
    False,
    ['Replication/General']),
  ( 'engine-condition-pushdown',
    'Push supported query conditions to the storage engine',
    True,
    []),
  ( 'eq_range_index_dive_limit',
    'The cutoff for switching from index dives to index statistics',
    True,
    []),
  ('error_count', 'Number of errors', False, []),
  ( 'event-scheduler',
    'Enable/disable and start/stop the event scheduler. Note that this variable underwent significant changes in behavior and permitted values in MySQL 5.1.11 and 5.1.12',
    True,
    []),
  ( 'executed_gtids_compression_period',
    'Deprecated and will be removed in a future version; use the renamed gtid_executed_compression_period instead',
    True,
    []),
  ( 'expire_logs_days',
    'Purge binary logs after this many days',
    True,
    ['Logging/Advanced log options']),
  ( 'explicit_defaults_for_timestamp',
    'Whether TIMESTAMP columns are nullable and have DEFAULT NULL',
    True,
    ['General/SQL']),
  ('external_user', 'The external proxy user', False, []),
  ( 'falcon_checkpoint_schedule',
    'Sets the frequency that in-memory structures are synchronized to disk',
    True,
    []),
  ('falcon_checksums', 'Enable Falcon checksum validation', True, []),
  ( 'falcon_consistent_read',
    'Sets the repeatable read isolation mode',
    True,
    []),
  ( 'falcon_debug_mask',
    'Sets the log information written to the standard output by the Falcon engine in the event of an error',
    True,
    []),
  ( 'falcon_debug_server',
    'Whether the debug server should be enabled',
    False,
    []),
  ('falcon_disable_fsync', 'Disables the periodic fsync operation', True, []),
  ('falcon_gopher_threads', 'Sets the number of gopher threads', False, []),
  ( 'falcon_index_chill_threshold',
    'Number of megabytes of pending index data that should be stored until the data is flushed to the serial log',
    True,
    []),
  ( 'falcon_initial_allocation',
    'Initial size of a Falcon tablespace file when created',
    True,
    []),
  ('falcon_io_threads', 'Number of asynchronous I/O threads', True, []),
  ( 'falcon_large_blob_threshold',
    'Blobs smaller than this value are stored in data pages not blob pages',
    False,
    []),
  ( 'falcon_lock_wait_timeout',
    'Number of seconds Falcon will force one transaction to wait on another',
    True,
    []),
  ( 'falcon_max_transaction_backlog',
    'falcon_max_transaction_backlog',
    True,
    []),
  ( 'falcon_page_cache_size',
    'Size of the memory cache (in bytes) for pages from the tablespace file',
    False,
    []),
  ( 'falcon_page_size',
    'Size of the pages (in bytes) used to store information within the tablespace',
    False,
    []),
  ( 'falcon_record_chill_threshold',
    'Number of megabytes of pending record data stored before flushing the records to the serial log',
    True,
    []),
  ( 'falcon_record_memory_max',
    'Maximum amount of memory (in bytes) that will be allocated for caching record data',
    True,
    []),
  ( 'falcon_record_scavenge_floor',
    'Percentage of falcon_record_scavenge_threshold that will be retained in the record cache after a scavenge',
    True,
    []),
  ( 'falcon_record_scavenge_threshold',
    'Percentage of falcon_record_memory_max that will cause the scavenger thread to start removing old generations of records from the record cache',
    True,
    []),
  ('falcon_scavenge_schedule', 'Record scavenging threshold', False, []),
  ( 'falcon_serial_log_buffers',
    'Memory windows (1MB each) allocated for the Falcon serial log',
    False,
    []),
  ( 'falcon_serial_log_dir',
    'Location for the Falcon serial log files',
    False,
    []),
  ( 'falcon_serial_log_priority',
    'Set the priority for writing the Falcon serial log',
    True,
    []),
  ( 'falcon_support_xa',
    'Enables two-phase commit for Falcon tables',
    False,
    []),
  ( 'falcon_use_deferred_index_hash',
    'Use a deferred index hash lookup',
    False,
    []),
  ( 'falcon_use_sectorcache',
    'Use the sector cache for reading blocks from disk',
    False,
    []),
  ('falcon_use_supernodes', 'Use index supernodes', False, []),
  ( 'flush',
    'Flush tables to disk between SQL statements',
    True,
    ['Advanced/General']),
  ( 'flush_time',
    'A dedicated thread is created to flush all tables at the given interval',
    True,
    ['Advanced/General']),
  ( 'foreign_key_checks',
    'If set to 1 (the default), foreign key constraints for InnoDB tables are checked',
    True,
    []),
  ( 'ft_boolean_syntax',
    'List of operators for MATCH ... AGAINST ( ... IN BOOLEAN MODE)',
    True,
    ['MyISAM/Fulltext search']),
  ( 'ft_max_word_len',
    'The maximum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable',
    False,
    ['MyISAM/Fulltext search']),
  ( 'ft_min_word_len',
    'The minimum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable',
    False,
    ['MyISAM/Fulltext search']),
  ( 'ft_query_expansion_limit',
    'Number of best matches to use for query expansion',
    False,
    ['MyISAM/Fulltext search']),
  ( 'ft_stopword_file',
    'Use stopwords from this file instead of built-in list',
    False,
    ['MyISAM/Fulltext search']),
  ('general-log', 'Enable|disable general log', True, []),
  ( 'general_log_file',
    'Name of the general query log file',
    True,
    ['Logging/General']),
  ( 'group_concat_max_len',
    'The maximum length of the result of function group_concat',
    True,
    ['Advanced/Various']),
  ( 'gtid-mode',
    'Controls whether GTID based logging is enabled and what type of transactions the logs can contain',
    False,
    []),
  ( 'gtid_done',
    'Obsolete: Replaced by gtid_executed in MySQL 5.6.9',
    False,
    []),
  ( 'gtid_executed',
    'Global: All GTIDs in the binary log (global) or current transaction (session). Read-only.',
    False,
    []),
  ( 'gtid_executed_compression_period',
    'Compress gtid_executed table each time this many transactions have occurred. 0 means never compress this table. Applies only when binary logging is disabled.',
    True,
    []),
  ('gtid_lost', 'Obsolete: Replaced by gtid_purged in MySQL 5.6.9', False, []),
  ( 'gtid_mode',
    'Controls whether GTID based logging is enabled and what type of transactions the logs can contain',
    False,
    []),
  ( 'gtid_next',
    'Specifies the GTID for the next statement to execute; see documentation for details',
    True,
    []),
  ( 'gtid_owned',
    'The set of GTIDs owned by this client (session), or by all clients, together with the thread ID of the owner (global). Read-only.',
    False,
    []),
  ( 'gtid_purged',
    'The set of all GTIDs that have been purged from the binary log',
    True,
    []),
  ('have_archive', 'Whether mysqld supports archive tables', False, []),
  ('have_bdb', 'Is Berkeley DB supported', False, []),
  ( 'have_blackhole_engine',
    'Whether mysqld supports BLACKHOLE tables',
    False,
    []),
  ( 'have_community_features',
    'Whether statement profiling capability is available',
    False,
    []),
  ('have_compress', 'Availability of the zlib compression library', False, []),
  ('have_crypt', 'Availability of the crypt() system call', False, []),
  ('have_csv', 'Whether mysqld supports csv tables', False, []),
  ( 'have_dynamic_loading',
    'Whether mysqld supports dynamic loading of plugins',
    False,
    []),
  ('have_example_engine', 'Whether mysqld supports EXAMPLE tables', False, []),
  ( 'have_federated_engine',
    'Whether mysqld supports FEDERATED tables',
    False,
    []),
  ('have_geometry', 'Whether mysqld supports spatial data types', False, []),
  ('have_innodb', 'Whether mysqld supports InnoDB tables', False, []),
  ('have_isam', 'Whether mysqld supports isam tables', False, []),
  ('have_merge_engine', 'Whether mysqld supports merge tables', False, []),
  ( 'have_ndbcluster',
    'Whether mysqld supports NDB Cluster tables (set by --ndbcluster option)',
    False,
    []),
  ('have_openssl', 'Whether mysqld supports SSL connections', False, []),
  ('have_partition_engine', 'Whether mysqld supports partitioning', False, []),
  ('have_partitioning', 'Whether mysqld supports partitioning', False, []),
  ( 'have_profiling',
    'Whether statement profiling capability is available',
    False,
    []),
  ('have_query_cache', 'Whether mysqld supports query cache', False, []),
  ('have_raid', 'Whether mysqld supports the raid option', False, []),
  ( 'have_row_based_replication',
    'Shows whether row-based replication is supported',
    False,
    []),
  ( 'have_rtree_keys',
    'YES if RTREE indexes are available, NO if not. (These are used for spatial indexes in MyISAM tables.)',
    False,
    []),
  ('have_ssl', 'Whether mysqld supports SSL connections', False, []),
  ( 'have_statement_timeout',
    'Whether statement execution timeout is available',
    False,
    []),
  ('have_symlink', 'Is symbolic link support enabled', False, []),
  ( 'histogram_generation_max_mem_size',
    'Maximum memory for creating histogram statistics',
    True,
    ['Performance/Optimizer']),
  ('host_cache_size', 'Size of the host cache', True, []),
  ('hostname', 'The name of the server host', False, []),
  ( 'identity',
    'This variable is a synonym for the LAST_INSERT_ID variable. It exists for compatibility with other database systems',
    True,
    []),
  ('ignore-builtin-innodb', 'Ignore the built-in InnoDB', False, []),
  ( 'ignore_db_dirs',
    'Directories treated as nondatabase directories',
    False,
    []),
  ( 'information_schema_stats_expiry',
    'Expiration setting for cached table statistics',
    True,
    ['Performance/Optimizer']),
  ('init-file', 'Read SQL statements from this file at startup', False, []),
  ( 'init_connect',
    'Statements that are executed for each new connection',
    True,
    ['Advanced/General']),
  ( 'init_slave',
    'Statements that are executed when a slave connects to a master',
    True,
    ['Advanced/General', 'Replication/Slave']),
  ( 'innodb_adaptive_flushing',
    'Control InnoDB adaptive flushing of dirty pages',
    True,
    ['InnoDB/General']),
  ( 'innodb_adaptive_flushing_lwm',
    'Low water mark representing percentage of redo log capacity at which adaptive flushing is enabled',
    True,
    ['InnoDB/General']),
  ( 'innodb_adaptive_hash_index',
    'Enable or disable InnoDB adaptive hash indexes',
    False,
    ['InnoDB/General']),
  ( 'innodb_adaptive_hash_index_parts',
    'Partitions the adaptive hash index search system into n partitions, with each partition protected by a separate latch. Each index is bound to a specific partition based on space ID and index ID attributes.',
    False,
    ['InnoDB/General']),
  ( 'innodb_adaptive_max_sleep_delay',
    'Allows InnoDB to automatically adjust the value of innodb_thread_sleep_delay up or down according to the current workload',
    True,
    ['InnoDB/General']),
  ( 'innodb_api_bk_commit_interval',
    'How often to auto-commit idle connections that use the InnoDB memcached interface, in seconds',
    True,
    ['InnoDB/General']),
  ('innodb_api_disable_rowlock', '', False, ['InnoDB/General']),
  ( 'innodb_api_enable_binlog',
    'Lets you use the InnoDB memcached plugin with the MySQL binary log',
    False,
    ['InnoDB/General']),
  ( 'innodb_api_enable_mdl',
    'Locks the table used by the InnoDB memcached plugin, so that it cannot be dropped or altered by DDL through the SQL interface',
    False,
    ['InnoDB/General']),
  ( 'innodb_api_trx_level',
    'Lets you control the transaction isolation level on queries processed by the memcached interface',
    True,
    ['InnoDB/General']),
  ( 'innodb_autoextend_increment',
    'Data file autoextend increment in megabytes',
    True,
    ['InnoDB/General']),
  ( 'innodb_autoinc_lock_mode',
    'Set InnoDB auto-increment lock mode',
    False,
    ['InnoDB/General']),
  ( 'innodb_background_drop_list_empty',
    'This debug option delays table creation until the background drop list is empty',
    True,
    ['InnoDB/General']),
  ( 'innodb_buffer_pool_awe_mem_mb',
    'If Windows AWE is used, size in Megabytes of InnoDB buffer pool allocated from the AWE memory',
    False,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_chunk_size',
    'Defines the chunk size that is used when resizing the buffer pool',
    False,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_debug',
    'Permits multiple buffer pool instances when the buffer pool is less than 1GB in size',
    False,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_dump_at_shutdown',
    'Specifies whether to record the pages cached in the InnoDB buffer pool when the MySQL server is shut down, to shorten the warmup process at the next restart',
    True,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_dump_now',
    'Immediately records the pages cached in the InnoDB buffer pool',
    True,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_dump_pct',
    'Specifies the percentage of the most recently used pages for each buffer pool to read out and dump',
    True,
    ['InnoDB/General']),
  ( 'innodb_buffer_pool_filename',
    'Specifies the file that holds the list of page numbers produced by innodb_buffer_pool_dump_at_shutdown or innodb_buffer_pool_dump_now',
    True,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_instances',
    'Specifies how many parts the InnoDB buffer pool is divided into',
    False,
    ['InnoDB/Buffer pool', 'InnoDB/Memory']),
  ( 'innodb_buffer_pool_load_abort',
    'Interrupts process of restoring InnoDB buffer pool contents triggered by innodb_buffer_pool_load_at_startup or innodb_buffer_pool_load_now',
    True,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_load_at_startup',
    'Specifies that, on MySQL server startup, the InnoDB buffer pool is automatically "warmed up" by loading the same pages it held at an earlier time',
    False,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_load_now',
    'Immediately "warms up" the InnoDB buffer pool by loading a set of data pages, without waiting for a server restart',
    True,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_size',
    'Size of the memory buffer InnoDB uses to cache data and indexes of its tables',
    False,
    ['InnoDB/Buffer pool', 'InnoDB/Memory']),
  ( 'innodb_change_buffer_max_size',
    'Maximum size for the InnoDB change buffer, as a percentage of the total size of buffer pool',
    True,
    ['InnoDB/General']),
  ( 'innodb_change_buffering',
    'Whether InnoDB performs insert buffering',
    True,
    ['InnoDB/General']),
  ( 'innodb_change_buffering_debug',
    'Sets a debug flag for InnoDB change buffering',
    True,
    ['InnoDB/General']),
  ( 'innodb_checkpoint_disabled',
    'Disables checkpoints so that a deliberate server exit always initiates recovery',
    True,
    ['InnoDB/General']),
  ( 'innodb_checksum_algorithm',
    'Specifies how to generate and verify the checksum stored in each disk block of each InnoDB tablespace',
    True,
    ['InnoDB/General']),
  ( 'innodb_checksums',
    'Enable InnoDB checksums validation',
    False,
    ['InnoDB/General']),
  ( 'innodb_cmp_per_index_enabled',
    'Enables per-index compression-related statistics in the INFORMATION_SCHEMA.INNODB_CMP_PER_INDEX table',
    True,
    ['InnoDB/General']),
  ( 'innodb_commit_concurrency',
    'Helps in performance tuning in heavily concurrent environments',
    True,
    ['InnoDB/General']),
  ( 'innodb_compress_debug',
    'Compresses all tables using a specified compression algorithm',
    True,
    ['InnoDB/General']),
  ( 'innodb_compression_failure_threshold_pct',
    'Sets the cutoff point at which MySQL begins adding padding within compressed pages to avoid expensive compression failures',
    True,
    ['InnoDB/General']),
  ( 'innodb_compression_level',
    'Specifies the level of zlib compression to use for InnoDB compressed tables and indexes',
    True,
    ['InnoDB/General']),
  ( 'innodb_compression_pad_pct_max',
    'Specifies the maximum percentage that can be reserved as free space within each compressed page, to avoid compression failures when tightly packed data is recompressed',
    True,
    ['InnoDB/General']),
  ( 'innodb_concurrency_tickets',
    'Number of times a thread is allowed to enter InnoDB within the same SQL query after it has once got the ticket',
    True,
    ['InnoDB/General']),
  ( 'innodb_data_file_path',
    'Path to individual files and their sizes',
    False,
    ['InnoDB/Datafiles']),
  ( 'innodb_data_home_dir',
    'The common part for InnoDB table spaces',
    False,
    ['InnoDB/Datafiles']),
  ( 'innodb_ddl_log_crash_reset_debug',
    'A debug option that resets DDL log crash injection counters',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_deadlock_detect',
    'Enables or disables deadlock detection',
    True,
    ['InnoDB/General']),
  ( 'innodb_dedicated_server',
    'Enables automatic configuration of buffer pool size, log file size, and flush method',
    False,
    ['InnoDB/General']),
  ( 'innodb_default_row_format',
    'Defines the default row format (ROW_FORMAT) for InnoDB tables',
    True,
    ['InnoDB/General']),
  ( 'innodb_directories',
    'Defines directories to scan at startup for tablespace data files',
    False,
    ['InnoDB/General']),
  ( 'innodb_disable_sort_file_cache',
    'Disable OS file system cache for merge-sort temporary files',
    True,
    ['InnoDB/General']),
  ( 'innodb_disable_resize_buffer_pool_debug',
    'Disables resizing of the InnoDB buffer pool',
    True,
    ['InnoDB/General']),
  ( 'innodb_doublewrite',
    'Enable InnoDB doublewrite buffer',
    False,
    ['InnoDB/General']),
  ( 'innodb_extra_dirty_writes',
    'Whether to flush dirty buffer pages when the percentage of dirty pages is less than the maximum dirty percent',
    False,
    ['InnoDB/General']),
  ( 'innodb_fast_shutdown',
    'Speeds up the shutdown process of the InnoDB storage engine',
    True,
    ['InnoDB/Various']),
  ( 'innodb_fil_make_page_dirty_debug',
    'Dirties the first page of the specified tablespace',
    True,
    ['InnoDB/General']),
  ( 'innodb_file_format',
    'The format for new InnoDB tables',
    True,
    ['InnoDB/Datafiles']),
  ( 'innodb_file_format_check',
    'Whether InnoDB performs file format compatibility checking',
    True,
    ['InnoDB/Datafiles']),
  ( 'innodb_file_format_max',
    'The file format tag in the shared tablespace',
    True,
    ['InnoDB/Datafiles']),
  ( 'innodb_file_io_threads',
    'Number of file I/O threads in InnoDB',
    False,
    ['InnoDB/General']),
  ( 'innodb_file_per_table',
    'Stores each InnoDB table and its indexes in a separate .ibd file in the database directory',
    False,
    ['InnoDB/General']),
  ( 'innodb_fill_factor',
    'Defines the percentage B-tree leaf and non-leaf page space that is to be filled with data. The remaining space is reserved for future growth.',
    True,
    ['InnoDB/General']),
  ( 'innodb_flush_log_at_timeout',
    'Write and flush logs every N seconds',
    True,
    []),
  ( 'innodb_flush_log_at_trx_commit',
    'Set to 0 (write and flush once per second), 1 (write and flush at each commit) or 2 (write at commit, flush once per second)',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_flush_method',
    'Specifies to flush data',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_flush_neighbors',
    'Specifies whether or not flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_flush_sync',
    'Enable innodb_flush_sync to ignore the innodb_io_capacity setting for bursts of I/O activity that occur at checkpoints. Disable innodb_flush_sync to adhere to the limit on I/O activity defined by the innodb_io_capacity setting.',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_flushing_avg_loops',
    'Number of iterations for which InnoDB keeps the previously calculated snapshot of the flushing state, controlling how quickly adaptive flushing responds to changing workloads',
    True,
    ['InnoDB/General']),
  ( 'innodb_force_load_corrupted',
    'Lets InnoDB load tables at startup that are marked as corrupted; use only during troubleshooting',
    False,
    ['InnoDB/General']),
  ( 'innodb_force_recovery',
    'Helps to save your data in case the disk image of the database becomes corrupt',
    False,
    ['InnoDB/General']),
  ( 'innodb_ft_aux_table',
    'Specifies which InnoDB table with a FULLTEXT index to examine by querying several innodb_ft_* tables in the information_schema',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_cache_size',
    'Size of the cache that holds a parsed document in memory while creating an InnoDB FULLTEXT index',
    False,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_enable_diag_print',
    'Whether to enable additional full-text search diagnostic output',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_enable_stopword',
    'During creation of an InnoDB FULLTEXT index, omits stopwords from the search index',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_max_token_size',
    'Maximum length of words that are stored in an InnoDB FULLTEXT index',
    False,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_min_token_size',
    'Minimum length of words that are stored in an InnoDB FULLTEXT index',
    False,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_num_word_optimize',
    'Number of words to process during each OPTIMIZE TABLE operation on an InnoDB FULLTEXT index',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_result_cache_limit',
    'The InnoDB FULLTEXT search query result cache limit',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_server_stopword_table',
    'Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and can be overridden by innodb_ft_user_stopword_table',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_sort_pll_degree',
    'Number of threads used to create an InnoDB FULLTEXT index in parallel, when building a search index for a large table',
    False,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_total_cache_size',
    'The total memory allocated for the InnoDB FULLTEXT search index cache',
    False,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_user_stopword_table',
    'Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and also innodb_ft_server_stopword_table',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_io_capacity',
    'The limit on the maximum number of I/O operations per second',
    False,
    ['InnoDB/General']),
  ( 'innodb_io_capacity_max',
    'The limit up to which InnoDB is allowed to extend the innodb_io_capacity setting in case of emergency',
    True,
    ['InnoDB/General']),
  ( 'innodb_large_prefix',
    'Enables longer keys for column prefix indexes',
    True,
    ['InnoDB/General']),
  ( 'innodb_limit_optimistic_insert_debug',
    'Limits the number of records per B-tree page',
    True,
    ['InnoDB/General']),
  ( 'innodb_lock_wait_timeout',
    'Timeout in seconds an InnoDB transaction may wait for a lock before a rollback occurs',
    False,
    ['InnoDB/General']),
  ( 'innodb_locks_unsafe_for_binlog',
    'Force InnoDB not to use next-key locking. Instead use only row-level locking',
    False,
    ['InnoDB/General']),
  ( 'innodb_log_arch_dir',
    'Where full logs should be archived',
    False,
    ['InnoDB/Logfiles']),
  ('innodb_log_archive', 'Unused', False, ['InnoDB/Logfiles']),
  ( 'innodb_log_buffer_size',
    'Size of buffer which InnoDB uses to write log to the log files on disk',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_checksum_algorithm',
    'Specifies how to generate and verify the checksum stored in each redo log disk block',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_checksums',
    'Enables or disables checksums for redo log pages',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_compressed_pages',
    'Specifies whether images of re-compressed pages are stored in InnoDB redo logs',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_file_size',
    'Size of each log file in a log group',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_files_in_group',
    'Number of InnoDB log files in the log group',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_group_home_dir',
    'Path to InnoDB log files',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_spin_cpu_abs_lwm',
    'Minimum amount of CPU usage below which user threads no longer spin while waiting for flushed redo',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_spin_cpu_pct_hwm',
    'Maximum amount of CPU usage above which user threads no longer spin while waiting for flushed redo',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_wait_for_flush_spin_hwm',
    'The maximum average log flush time beyond which user threads no longer spin while waiting for flushed redo',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_write_ahead_size',
    'The write-ahead block size for the redo log',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_lru_scan_depth',
    'Influences the algorithms and heuristics for the flush operation for the InnoDB buffer pool',
    True,
    ['InnoDB/General']),
  ( 'innodb_max_dirty_pages_pct',
    'Percentage of dirty pages allowed in buffer pool',
    True,
    ['InnoDB/General']),
  ( 'innodb_max_dirty_pages_pct_lwm',
    'Low water mark representing percentage of dirty pages where preflushing is enabled to control the dirty page ratio',
    True,
    ['InnoDB/General']),
  ( 'innodb_max_merged_io',
    'The maximum number of background I/O requests to merge to issue a larger I/O request',
    False,
    ['InnoDB/General']),
  ( 'innodb_max_purge_lag',
    'Desired maximum length of the purge queue (0 = no limit)',
    True,
    ['InnoDB/General']),
  ( 'innodb_max_purge_lag_delay',
    'Specifies the maximum delay in milliseconds for the formula calculated using the innodb_max_purge_lag configuration option',
    True,
    ['InnoDB/General']),
  ( 'innodb_max_undo_log_size',
    'Sets the threshold for truncating the InnoDB undo log',
    True,
    ['InnoDB/General']),
  ( 'innodb_additional_mem_pool_size',
    'Size of a memory pool InnoDB uses to store data dictionary information and other internal data structures',
    False,
    ['InnoDB/Memory']),
  ( 'innodb_merge_threshold_set_all_debug',
    'Overrides the current MERGE_THRESHOLD setting with the specified value for all indexes that are currently in the dictionary cache',
    True,
    ['InnoDB/General']),
  ( 'innodb_mirrored_log_groups',
    'Obsolete setting; do not use',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_monitor_disable',
    'Turns off one or more counters in the information_schema.innodb_metrics table',
    True,
    ['InnoDB/General']),
  ( 'innodb_monitor_enable',
    'Turns on one or more counters in the information_schema.innodb_metrics table',
    True,
    ['InnoDB/General']),
  ( 'innodb_monitor_reset',
    'Resets to zero the count value for one or more counters in the information_schema.innodb_metrics table',
    True,
    ['InnoDB/General']),
  ( 'innodb_monitor_reset_all',
    'Resets all values (minimum, maximum, and so on) for one or more counters in the information_schema.innodb_metrics table',
    True,
    ['InnoDB/General']),
  ( 'innodb_numa_interleave',
    'Enables the NUMA MPOL_INTERLEAVE memory policy for allocation of the InnoDB buffer pool',
    False,
    ['InnoDB/General']),
  ( 'innodb_old_blocks_pct',
    'Percentage of the InnoDB buffer pool to reserve for old blocks',
    True,
    ['InnoDB/General']),
  ( 'innodb_old_blocks_time',
    'How long (in ms) blocks must remain in old end of InnoDB buffer pool before moving to new end',
    True,
    ['InnoDB/General']),
  ( 'innodb_online_alter_log_max_size',
    'Specifies an upper limit on size of the temporary log files used during online DDL operations for InnoDB tables',
    True,
    ['InnoDB/General', 'InnoDB/Logfiles']),
  ( 'innodb_open_files',
    'The maximum number of files that InnoDB keeps open at the same time',
    False,
    ['InnoDB/General']),
  ( 'innodb_optimize_fulltext_only',
    'Makes the OPTIMIZE TABLE statement for an InnoDB table process the newly added, deleted, and updated token data for a FULLTEXT index, rather than reorganizing the data in the clustered index of the table',
    True,
    ['InnoDB/Fulltext search', 'InnoDB/General']),
  ( 'innodb_optimize_point_storage',
    'Enable this option to store POINT data as fixed-length data rather than a variable-length data',
    True,
    ['InnoDB/General']),
  ( 'innodb_page_cleaners',
    'Number of page cleaner threads',
    False,
    ['InnoDB/Memory']),
  ( 'innodb_page_size',
    'Specifies the page size for all InnoDB tablespaces in an instance',
    False,
    ['InnoDB/Memory']),
  ( 'innodb_print_all_deadlocks',
    'During shutdown, prints information about all InnoDB deadlocks to the server error log',
    True,
    ['InnoDB/General']),
  ( 'innodb_print_ddl_logs',
    'Whether or not to print DDL logs to the error log',
    True,
    ['InnoDB/General']),
  ( 'innodb_purge_batch_size',
    'Specifies the number of InnoDB redo logs that trigger a purge operation',
    True,
    ['InnoDB/General']),
  ( 'innodb_purge_rseg_truncate_frequency',
    'The rate at which undo log purge should be invoked as part of the purge action. A value of n invokes undo log purge on every nth iteration of purge invocation.',
    True,
    ['InnoDB/General']),
  ( 'innodb_purge_threads',
    'Specifies whether the InnoDB purge operation should be performed in one or more separate threads. By default, this operation is part of the InnoDB master thread.',
    False,
    ['InnoDB/General']),
  ( 'innodb_random_read_ahead',
    'Enables the random read-ahead technique for optimizing InnoDB I/O',
    True,
    ['InnoDB/General']),
  ( 'innodb_read_ahead_threshold',
    'The sensitivity of InnoDB linear read-ahead',
    True,
    ['InnoDB/General']),
  ( 'innodb_read_io_threads',
    'Number of background I/O threads for read prefetch requests',
    False,
    ['InnoDB/General']),
  ( 'innodb_read_only',
    'Starts the server in read-only mode',
    False,
    ['InnoDB/General']),
  ( 'innodb_redo_log_encrypt',
    'Controls encryption of redo log data for encrypted tablepaces',
    True,
    ['InnoDB/General']),
  ( 'innodb_replication_delay',
    'The slave server replication thread delay',
    True,
    ['InnoDB/General']),
  ( 'innodb_rollback_on_timeout',
    'Roll back entire transaction on transaction timeout, not just last statement',
    False,
    ['InnoDB/General']),
  ( 'innodb_rollback_segments',
    'Defines how many of the rollback segments in the system tablespace that InnoDB uses within a transaction',
    True,
    ['InnoDB/General']),
  ( 'innodb_saved_page_number_debug',
    'Saves a page number',
    True,
    ['InnoDB/General']),
  ( 'innodb_scan_directories',
    'Defines directories to scan for tablespace files during InnoDB recovery',
    False,
    ['InnoDB/General']),
  ( 'innodb_sort_buffer_size',
    'Specifies size of a buffer used for sorting data during creation of an InnoDB index',
    False,
    ['InnoDB/General', 'InnoDB/Memory']),
  ( 'innodb_spin_wait_delay',
    'The maximum delay between polls for a spin lock',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_auto_recalc',
    'Causes InnoDB to automatically recalculate persistent statistics after the data in a table is changed substantially',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_include_delete_marked',
    'Include delete-marked records when calculating persistent InnoDB statistics',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_method',
    'Specifies how InnoDB index statistics collection code should treat NULLs',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_on_metadata',
    'Enable or disable InnoDB table statistics updates for metadata statements',
    False,
    ['InnoDB/General']),
  ( 'innodb_stats_persistent',
    'Turns on the InnoDB persistent statistics feature',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_persistent_sample_pages',
    'Number of pages to sample in each InnoDB index, when the persistent statistics feature is also enabled',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_sample_pages',
    'Number of index pages to sample for index distribution statistics',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_transient_sample_pages',
    'Number of pages to sample in each InnoDB index, when the persistent statistics feature is turned off (the default setting)',
    True,
    ['InnoDB/General']),
  ( 'innodb_status_output',
    'Used to enable or disable periodic output for the standard InnoDB Monitor. Also used in combination with innodb_status_output_locks to enable and disable periodic output for the InnoDB Lock Monitor.',
    True,
    ['InnoDB/General']),
  ( 'innodb_status_output_locks',
    'Used to enable or disable periodic output for the standard InnoDB Lock Monitor. innodb_status_output must also be enabled to produce periodic output for the InnoDB Lock Monitor.',
    True,
    ['InnoDB/General']),
  ( 'innodb_strict_mode',
    'Whether InnoDB returns errors rather than warnings for exceptional conditions',
    True,
    ['InnoDB/General']),
  ( 'innodb_support_xa',
    'Enable InnoDB support for the XA two-phase commit',
    True,
    ['InnoDB/General']),
  ( 'innodb_sync_array_size',
    'Splits an internal data structure used to coordinate threads, for higher concurrency in workloads with large numbers of waiting threads',
    False,
    ['InnoDB/General']),
  ( 'innodb_sync_spin_loops',
    'Count of spin-loop rounds in InnoDB mutexes',
    True,
    ['InnoDB/General']),
  ( 'innodb_sync_debug',
    'Enables InnoDB sync debug checking',
    False,
    ['InnoDB/General']),
  ( 'innodb_table_locks',
    'Enable InnoDB locking in LOCK TABLES',
    True,
    ['InnoDB/General']),
  ( 'innodb_temp_data_file_path',
    'Path to temporary tablespace data files and their sizes',
    False,
    ['InnoDB/General']),
  ( 'internal_tmp_mem_storage_engine',
    'Defines the storage to use for internal in-memory temporary tables',
    True,
    ['InnoDB/General']),
  ( 'innodb_tmpdir',
    'The directory location for the temporary table files created during online ALTER TABLE operations',
    True,
    ['InnoDB/General']),
  ( 'innodb_thread_concurrency',
    'Sets the maximum number of threads allowed inside InnoDB. Value 0 will disable the thread throttling',
    True,
    ['InnoDB/General']),
  ( 'innodb_thread_concurrency_timer_based',
    'Whether to use the lock-free method of handling thread concurrency',
    False,
    ['InnoDB/General']),
  ( 'innodb_thread_sleep_delay',
    'Time, in microseconds, that an InnoDB thread sleeps before joining InnoDB queue. Value 0 disables the sleep behavior',
    True,
    ['InnoDB/General']),
  ( 'innodb_trx_purge_view_update_only_debug',
    'Pauses purging of delete-marked records while allowing the purge view to be updated',
    True,
    ['InnoDB/General']),
  ( 'innodb_trx_rseg_n_slots_debug',
    'Sets a debug flag that limits TRX_RSEG_N_SLOTS to a given value for the trx_rsegf_undo_find_free function',
    True,
    ['InnoDB/General']),
  ( 'innodb_undo_directory',
    'The relative or absolute directory path where InnoDB creates separate tablespaces for the undo logs; typically used to place those logs on a different storage device',
    False,
    ['InnoDB/General', 'InnoDB/Logfiles']),
  ( 'innodb_undo_log_encrypt',
    'Controls encryption of undo log data for encrypted tablepaces',
    True,
    ['InnoDB/General', 'InnoDB/Logfiles']),
  ( 'innodb_undo_log_truncate',
    'Enable this option to mark the InnoDB undo tablespace for truncation',
    True,
    ['InnoDB/General', 'InnoDB/Logfiles']),
  ( 'innodb_undo_logs',
    'Defines the number of undo logs (rollback segments) used by InnoDB; an alias for innodb_rollback_segments',
    True,
    ['InnoDB/General', 'InnoDB/Logfiles']),
  ( 'innodb_undo_tablespaces',
    'The number of tablespace files that rollback segments are divided between',
    False,
    ['InnoDB/General']),
  ( 'innodb_use_legacy_cardinality_algorithm',
    'Whether to use legacy InnoDB index cardinality calculation algorithm',
    True,
    ['InnoDB/General']),
  ( 'innodb_use_native_aio',
    'Specifies whether to use the Linux asynchronous I/O subsystem',
    False,
    ['InnoDB/General']),
  ( 'innodb_use_sys_malloc',
    'Whether InnoDB uses the OS or its own memory allocator',
    False,
    ['InnoDB/General']),
  ('innodb_version', 'The version of InnoDB', False, []),
  ( 'innodb_write_io_threads',
    'Number of background I/O threads for writing dirty pages from the buffer cache to disk',
    False,
    ['InnoDB/General']),
  ( 'insert_id',
    'Set the value to be used by the following INSERT or ALTER TABLE statement when inserting an AUTO_INCREMENT value',
    True,
    []),
  ( 'interactive_timeout',
    'Number of seconds the server waits for activity on an interactive connection before closing it',
    True,
    ['Networking/Timeout Settings']),
  ( 'internal_tmp_disk_storage_engine',
    'Storage engine for internal temporary tables',
    True,
    ['InnoDB/General']),
  ( 'join_buffer_size',
    'Size of buffer that is used for full joins',
    True,
    ['General/Memory usage']),
  ( 'join_cache_level',
    'How join buffers are used',
    True,
    ['General/Memory usage']),
  ( 'keep_files_on_create',
    'Do not overwrite existing .MYD/.MYI files in default database directory',
    True,
    ['MyISAM/General']),
  ( 'key_buffer_size',
    'Size of buffer used for index blocks for MyISAM tables',
    True,
    ['MyISAM/General']),
  ( 'key_cache_age_threshold',
    'This characterizes the number of hits a hot block has to be untouched until it is considered aged enough to be downgraded to a warm block. This specifies the percentage ratio of that number of hits to the total number of blocks in key cache',
    True,
    ['MyISAM/General']),
  ( 'key_cache_block_size',
    'The default size of key cache blocks',
    True,
    ['Advanced/Various']),
  ( 'key_cache_division_limit',
    'The minimum percentage of warm blocks in key cache',
    True,
    ['Advanced/Various']),
  ( 'keyring_aws_cmk_id',
    'AWS keyring plugin customer master key ID value',
    True,
    ['Security/Authentication']),
  ( 'keyring_aws_conf_file',
    'AWS keyring plugin configuration file location',
    False,
    ['Security/Authentication']),
  ( 'keyring_aws_data_file',
    'AWS keyring plugin storage file location',
    False,
    ['Security/Authentication']),
  ( 'keyring_aws_region',
    'AWS keyring plugin region',
    True,
    ['Security/Authentication']),
  ( 'keyring_encrypted_file_data',
    'keyring_encrypted_file plugin data file',
    True,
    ['Security/Authentication']),
  ( 'keyring_encrypted_file_password',
    'keyring_encrypted_file plugin password',
    True,
    ['Security/Authentication']),
  ( 'keyring_file_data',
    'keyring_file plugin data file',
    True,
    ['Security/Authentication']),
  ( 'keyring_okv_conf_dir',
    'Oracle Key Vault keyring plugin configuration directory',
    True,
    ['Security/Authentication']),
  ('keyring_operations', 'Whether keyring operations are enabled', True, []),
  ( 'language',
    'Client error messages in given language. May be given as a full path',
    False,
    ['General/International']),
  ('large-pages', 'Enable support for large pages', False, []),
  ('large_files_support', 'Whether large files are supported', False, []),
  ( 'large_page_size',
    'Size of memory pages when large page support is enabled',
    False,
    []),
  ('last_insert_id', 'The most recent AUTO_INCREMENT value', True, []),
  ('lc-messages', 'Locale for error messages', True, []),
  ( 'lc-messages-dir',
    'Directory where error messages are installed',
    False,
    []),
  ( 'lc_time_names',
    'The locale that controls the language used to display day and month names',
    True,
    []),
  ( 'authentication_ldap_sasl_auth_method_name',
    'Authentication method name',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_bind_base_dn',
    'LDAP server base distinguished name',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_bind_root_dn',
    'LDAP server root distinguished name',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_bind_root_pwd',
    'LDAP server root bind password',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_ca_path',
    'LDAP server certificate authority file name',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_group_search_attr',
    'LDAP server group search attribute',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_group_search_filter',
    'LDAP custom group search filter',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_init_pool_size',
    'LDAP server initial connection pool size',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_log_status',
    'LDAP server log level',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_max_pool_size',
    'LDAP server maximum connection pool size',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_server_host',
    'LDAP server host name or IP address',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_server_port',
    'LDAP server port number',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_tls',
    'Whether to use encrypted connections to LDAP server',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_sasl_user_search_attr',
    'LDAP server user search attribute',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_auth_method_name',
    'Authentication method name',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_bind_base_dn',
    'LDAP server base distinguished name',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_bind_root_dn',
    'LDAP server root distinguished name',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_bind_root_pwd',
    'LDAP server root bind password',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_ca_path',
    'LDAP server certificate authority file name',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_group_search_attr',
    'LDAP server group search attribute',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_group_search_filter',
    'LDAP custom group search filter',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_init_pool_size',
    'LDAP server initial connection pool size',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_log_status',
    'LDAP server log level',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_max_pool_size',
    'LDAP server maximum connection pool size',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_server_host',
    'LDAP server host name or IP address',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_server_port',
    'LDAP server port number',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_tls',
    'Whether to use encrypted connections to LDAP server',
    True,
    ['Security/Authentication']),
  ( 'authentication_ldap_simple_user_search_attr',
    'LDAP server user search attribute',
    True,
    ['Security/Authentication']),
  ('license', 'Type of license for the server', False, []),
  ( 'local_infile',
    'Whether LOCAL is supported for LOAD DATA INFILE statements. Default can be overridden by a number of server and client settings, see text for more information.',
    True,
    []),
  ( 'lock_wait_timeout',
    'Timeout for metadata locks',
    True,
    ['General/General']),
  ('locked_in_memory', 'Whether mysqld is locked in memory', False, []),
  ('log', 'Log connections and queries to file', False, ['Logging/General']),
  ( 'log-backup-output',
    'The destination for MySQL Backup history and progress log output. Syntax: log-backup-output[=value[,value...]], where "value" could be TABLE, FILE, or NONE',
    True,
    []),
  ('log-bin', 'Specifies the base name for binary log files', False, []),
  ( 'log-bin-trust-function-creators',
    'If equal to 0 (the default), then when --log-bin is used, creation of a stored function is allowed only to users having the SUPER privilege and only if the function created does not break binary logging',
    True,
    []),
  ( 'log-bin-trust-routine-creators',
    '(deprecated) Use log-bin-trust-function-creators',
    True,
    []),
  ( 'log-bin-use-v1-row-events',
    'Use version 1 binary log row events',
    False,
    ['Logging/Binlog Options']),
  ('log-error', 'Error log file', False, []),
  ( 'log-output',
    'The destination for general query log and slow query log output',
    True,
    []),
  ( 'log-queries-not-using-indexes',
    'Log queries that are executed without benefit of any index to the slow query log if it is open',
    True,
    []),
  ( 'log-slave-updates',
    'Tells the slave to log the updates performed by its SQL thread to its own binary log',
    False,
    ['Logging/General']),
  ( 'log-slow-queries',
    'Whether to log slow queries. Logging defaults to hostname-slow.log file. Must be enabled to activate other slow query log options',
    False,
    []),
  ('log-warnings', 'Log some noncritical warnings to the log file', True, []),
  ( 'log_backward_compatible_user_definitions',
    'Whether to log CREATE/ALTER USER, GRANT in backward-compatible fashion',
    True,
    ['Logging/General']),
  ('log_bin', 'Whether the binary log is enabled', False, []),
  ('log_bin_basename', 'Path and base name for binary log files', False, []),
  ('log_bin_index', 'Path and base name for binary log index file', False, []),
  ( 'log_bin_use_v1_row_events',
    'Shows whether server is using version 1 binary log row events',
    False,
    ['Logging/Binlog Options']),
  ( 'log_builtin_as_identified_by_password',
    'Whether to log CREATE/ALTER USER, GRANT in backward-compatible fashion',
    True,
    ['Logging/General']),
  ( 'log_error_filter_rules',
    'Filter rules for error logging',
    True,
    ['Logging/General']),
  ( 'log_error_services',
    'Components to use for error logging',
    True,
    ['Logging/General']),
  ( 'log_error_verbosity',
    'Error logging verbosity level',
    True,
    ['Logging/General']),
  ( 'log_slave_updates',
    'Whether the slave should log the updates performed by its SQL thread to its own binary log. Read-only; set using the --log-slave-updates server option.',
    False,
    ['Logging/General']),
  ( 'log_slow_admin_statements',
    'Log slow OPTIMIZE, ANALYZE, ALTER and other administrative statements to the slow query log if it is open',
    True,
    []),
  ( 'log_slow_slave_statements',
    'Cause slow statements as executed by the slave to be written to the slow query log',
    True,
    []),
  ( 'log_statements_unsafe_for_binlog',
    'Disables error 1592 warnings being written to the error log',
    True,
    []),
  ( 'log_syslog',
    'Whether to write error log to syslog',
    True,
    ['Logging/General']),
  ( 'log_syslog_facility',
    'Facility for syslog messages',
    True,
    ['Logging/General']),
  ( 'log_syslog_include_pid',
    'Whether to include server PID in syslog messages',
    True,
    ['Logging/General']),
  ( 'log_syslog_tag',
    'Tag for server identifier in syslog messages',
    True,
    ['Logging/General']),
  ( 'log_throttle_queries_not_using_indexes',
    'Throttle write rate to slow log for queries not using indexes slow query log if it is open',
    True,
    []),
  ('log_timestamps', 'Log timestamp format', True, ['Logging/General']),
  ( 'long_query_time',
    'Log all queries that have taken more than long_query_time seconds to execute to file',
    True,
    ['Logging/Slow query log options']),
  ( 'low-priority-updates',
    'INSERT/DELETE/UPDATE has lower priority than selects',
    True,
    []),
  ( 'lower_case_file_system',
    'This variable describes the case sensitivity of file names on the file system',
    False,
    []),
  ( 'lower_case_table_names',
    'If set to 1, table names are stored in lowercase on disk and table names will be case insensitive. Should be set to 2 if you are using a case-insensitive file system.',
    False,
    ['General/System']),
  ( 'mandatory_roles',
    'Automatically granted roles for all users',
    True,
    ['General/System']),
  ('maria-block-size', 'Sets the block size for Maria tables', False, []),
  ( 'maria-checkpoint-interval',
    'Sets the interval between automatic checkpoints',
    True,
    []),
  ( 'maria-log-file-size',
    'Sets size of each of the Maria log files',
    True,
    []),
  ( 'maria-log-purge-type',
    'Sets the mode for purging Maria log files',
    True,
    []),
  ( 'maria-max-sort-file-size',
    'The maximum size of an external sort file',
    True,
    []),
  ( 'maria-page-checksum',
    'Sets the default mode for page checksums',
    True,
    []),
  ('maria-pagecache-age-threshold', 'Sets the pagecache age', True, []),
  ( 'maria-pagecache-buffer-size',
    'Sets the buffer size for data and index pages',
    False,
    []),
  ( 'maria-pagecache-division-limit',
    'The minimum percentage of warm blocks in the page cache',
    True,
    []),
  ( 'maria-recover',
    'Force recovery of Maria tables without the log file',
    True,
    []),
  ( 'maria-repair-threads',
    'Number of threads to be used when repairing tables',
    True,
    []),
  ( 'maria-sort-buffer-size',
    'Sets the sort buffer size for indexes',
    True,
    []),
  ('maria-stats-method', 'Sets the statistics collection method', True, []),
  ( 'maria-sync-log-dir',
    'Controls the synchronization of the directory after a log file has been extended or created',
    True,
    []),
  ( 'master_info_repository',
    "Whether to write master status information and replication I/O thread location in the master's binary logs to a file or table",
    True,
    ['Replication/Master']),
  ( 'master_verify_checksum',
    'Cause master to read checksums from binary log',
    True,
    []),
  ( 'max_allowed_packet',
    'Max packet length to send to/receive from server',
    True,
    ['Networking/Data / Memory size']),
  ( 'max_binlog_cache_size',
    'Can be used to restrict the total size used to cache a multi-statement transaction',
    True,
    ['Logging/Binlog Options']),
  ( 'max_binlog_size',
    'Binary log will be rotated automatically when size exceeds this value',
    True,
    ['Logging/Binlog Options']),
  ( 'max_binlog_stmt_cache_size',
    'Can be used to restrict the total size used to cache all nontransactional statements during a transaction',
    True,
    ['Logging/Binlog Options']),
  ( 'max_connect_errors',
    'Number of interrupted connections from a host before this host is blocked from further connections',
    True,
    ['Networking/Advanced']),
  ( 'max_connections',
    'Number of simultaneous clients allowed',
    True,
    ['Networking/Advanced']),
  ( 'max_delayed_threads',
    'Do not start more than this number of threads to handle INSERT DELAYED statements. If set to zero, which means INSERT DELAYED is not used',
    True,
    ['Advanced/Insert delayed settings']),
  ( 'max_digest_length',
    'The maximum digest size in bytes',
    False,
    ['Advanced/General']),
  ( 'max_error_count',
    'Max number of errors/warnings to store for a statement',
    True,
    ['Advanced/General']),
  ( 'max_execution_time',
    'Statement execution timeout value',
    True,
    ['Advanced/Various']),
  ( 'max_heap_table_size',
    'Do not allow creation of heap tables bigger than this',
    True,
    ['Advanced/Various']),
  ( 'max_insert_delayed_threads',
    'This variable is a synonym for max_delayed_threads',
    True,
    []),
  ( 'max_join_size',
    'Joins that are probably going to read more than max_join_size records return an error',
    True,
    ['Advanced/Various']),
  ( 'max_length_for_sort_data',
    'Max number of bytes in sorted records',
    True,
    ['Advanced/Various']),
  ( 'max_long_data_size',
    'Max size of parameter values that mysql_stmt_send_long_data() can send',
    False,
    ['General/General']),
  ( 'max_points_in_geometry',
    'Maximum number of points in geometry values for ST_Buffer_Strategy()',
    True,
    ['Advanced/Various']),
  ( 'max_prepared_stmt_count',
    'Maximum number of prepared statements in the server',
    True,
    ['Advanced/General']),
  ( 'max_relay_log_size',
    'If nonzero, relay log is rotated automatically when its size exceeds this value. If zero, size at which rotation occurs is determined by the value of max_binlog_size.',
    True,
    ['Replication/Relay Log']),
  ( 'max_seeks_for_key',
    'Limit assumed max number of seeks when looking up rows based on a key',
    True,
    ['Advanced/Various']),
  ( 'max_sort_length',
    'Number of bytes to use when sorting data values',
    True,
    ['Advanced/Various']),
  ( 'max_sp_recursion_depth',
    'Maximum stored procedure recursion depth',
    True,
    ['Advanced/General']),
  ('max_statement_time', 'Statement execution timeout value', True, []),
  ('max_tmp_tables', 'Unused', True, []),
  ( 'max_user_connections',
    'The maximum number of active connections for a single user (0 = no limit)',
    True,
    ['Networking/Advanced']),
  ( 'max_write_lock_count',
    'After this many write locks, allow some read locks to run in between',
    True,
    ['Advanced/Various']),
  ( 'mecab_rc_file',
    'Path to the mecabrc configuration file for the MeCab parser for full-text search',
    False,
    ['InnoDB/Fulltext search']),
  ('metadata_locks_cache_size', 'Size of the metadata locks cache', False, []),
  ( 'metadata_locks_hash_instances',
    'Number of metadata lock hashes',
    False,
    []),
  ( 'min-examined-row-limit',
    'Queries examining fewer than this number of rows are not logged to slow query log',
    True,
    []),
  ( 'multi_range_count',
    'The maximum number of ranges to send to a table handler at once during range selects',
    True,
    ['Advanced/Various']),
  ( 'myisam_data_pointer_size',
    'Default pointer size to be used for MyISAM tables',
    True,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_max_extra_sort_file_size',
    'Deprecated option',
    False,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_max_sort_file_size',
    'Do not use the fast sort index method to create index if the temporary file would get bigger than this',
    True,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_mmap_size',
    'The maximum amount of memory to use for memory mapping compressed MyISAM files',
    False,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_recover_options',
    'The value of the --myisam-recover option',
    False,
    []),
  ( 'myisam_repair_threads',
    'Number of threads to use when repairing MyISAM tables. The value of 1 disables parallel repair',
    True,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_sort_buffer_size',
    'The buffer allocated when sorting the index for a REPAIR TABLE or when creating indexes for CREATE INDEX or ALTER TABLE',
    True,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_stats_method',
    'Specifies how MyISAM index statistics collection code should treat NULLs',
    True,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_use_mmap',
    'Use memory mapping for reading and writing MyISAM tables',
    True,
    ['MyISAM/Advanced Settings']),
  ( 'mysql_native_password_proxy_users',
    'Whether the mysql_native_password authentication plugin does proxying',
    True,
    ['Security/Authentication']),
  ( 'mysql_firewall_max_query_size',
    'Maximum size of recorded statements',
    False,
    ['General/Firewall']),
  ( 'mysql_firewall_mode',
    'Whether MySQL Enterprise Firewall is operational',
    True,
    ['General/Firewall']),
  ( 'mysql_firewall_trace',
    'Whether to enable firewall trace',
    True,
    ['General/Firewall']),
  ( 'named_pipe',
    'Whether the server supports connections over named pipes',
    False,
    []),
  ( 'ndb-batch-size',
    'Size (in bytes) to use for NDB transaction batches',
    False,
    []),
  ( 'ndb-blob-read-batch-bytes',
    'Specifies size in bytes that large BLOB reads should be batched into. 0 = no limit.',
    True,
    []),
  ( 'ndb-blob-write-batch-bytes',
    'Specifies size in bytes that large BLOB writes should be batched into. 0 = no limit.',
    True,
    []),
  ( 'ndb-cluster-connection-pool',
    'Number of connections to the cluster used by MySQL',
    False,
    []),
  ( 'ndb-cluster-connection-pool-nodeids',
    'Comma-separated list of node IDs for connections to the cluster used by MySQL; the number of nodes in the list must be the same as the value set for --ndb-cluster-connection-pool',
    False,
    []),
  ( 'ndb-default-column-format',
    'Use this value (FIXED or DYNAMIC) by default for COLUMN_FORMAT and ROW_FORMAT options when creating or adding columns to a table.',
    True,
    ['Other/NDB']),
  ( 'ndb-deferred-constraints',
    'Specifies that constraint checks on unique indexes (where these are supported) should be deferred until commit time. Not normally needed or used; for testing purposes only.',
    True,
    ['Other/NDB']),
  ( 'ndb-distribution',
    'Default distribution for new tables in NDBCLUSTER (KEYHASH or LINHASH, default is KEYHASH)',
    True,
    ['Other/NDB']),
  ( 'ndb-log-apply-status',
    'Cause a MySQL server acting as a slave to log mysql.ndb_apply_status updates received from its immediate master in its own binary log, using its own server ID. Effective only if the server is started with the --ndbcluster option.',
    False,
    ['Other/NDB']),
  ( 'ndb-log-empty-epochs',
    'When enabled, causes epochs in which there were no changes to be written to the ndb_apply_status and ndb_binlog_index tables, even when --log-slave-updates is enabled.',
    True,
    ['Other/NDB']),
  ( 'ndb-log-empty-update',
    'When enabled, causes updates that produced no changes to be written to the ndb_apply_status and ndb_binlog_index tables, even when --log-slave-updates is enabled.',
    True,
    ['Other/NDB']),
  ( 'ndb-log-exclusive-reads',
    'Log primary key reads with exclusive locks; allow conflict resolution based on read conflicts',
    True,
    ['Other/NDB']),
  ( 'ndb-log-orig',
    'Log originating server id and epoch in mysql.ndb_binlog_index table',
    False,
    ['Other/NDB']),
  ( 'ndb-log-transaction-id',
    'Write NDB transaction IDs in the binary log. Requires --log-bin-v1-events=OFF.',
    False,
    []),
  ( 'ndb-log-update-as-write',
    'Toggles logging of updates on the master between updates (OFF) and writes (ON)',
    True,
    []),
  ( 'ndb-wait-connected',
    'Time (in seconds) for the MySQL server to wait for connection to cluster management and data nodes before accepting MySQL client connections',
    False,
    []),
  ( 'ndb-wait-setup',
    'Time (in seconds) for the MySQL server to wait for NDB engine setup to complete',
    False,
    []),
  ( 'ndb-allow-copying-alter-table',
    'Set to OFF to keep ALTER TABLE from using copying operations on NDB tables',
    True,
    []),
  ( 'ndb_autoincrement_prefetch_sz',
    'NDB auto-increment prefetch size',
    True,
    ['Other/NDB']),
  ( 'ndb_cache_check_time',
    'Number of milliseconds between checks of cluster SQL nodes made by the MySQL query cache',
    True,
    ['Other/NDB']),
  ( 'ndb_clear_apply_status',
    'Causes RESET SLAVE to clear all rows from the ndb_apply_status table; ON by default',
    True,
    []),
  ( 'Ndb_conflict_last_conflict_epoch',
    'Most recent NDB epoch on this slave in which a conflict was detected',
    False,
    []),
  ( 'ndb_data_node_neighbour',
    'Specifies cluster data node "closest" to this MySQL Server, for transaction hinting and fully replicated tables',
    True,
    ['Other/NDB']),
  ( 'ndb_default_column_format',
    'Sets default row format and column format (FIXED or DYNAMIC) used for new NDB tables',
    True,
    ['Other/NDB']),
  ( 'ndb_deferred_constraints',
    'Specifies that constraint checks should be deferred (where these are supported). Not normally needed or used; for testing purposes only.',
    True,
    ['Other/NDB']),
  ( 'ndb_distribution',
    'Default distribution for new tables in NDBCLUSTER (KEYHASH or LINHASH, default is KEYHASH)',
    True,
    ['Other/NDB']),
  ( 'ndb_eventbuffer_free_percent',
    'Percentage of free memory that should be available in event buffer before resumption of buffering, after reaching limit set by ndb_eventbuffer_max_alloc',
    True,
    ['Other/NDB']),
  ( 'ndb_eventbuffer_max_alloc',
    'Maximum memory that can be allocated for buffering events by the NDB API. Defaults to 0 (no limit).',
    True,
    ['Other/NDB']),
  ( 'ndb_extra_logging',
    'Controls logging of NDB Cluster schema, connection, and data distribution events in the MySQL error log',
    True,
    ['Other/NDB']),
  ( 'ndb_force_send',
    'Forces sending of buffers to NDB immediately, without waiting for other threads',
    True,
    ['Other/NDB']),
  ( 'ndb_fully_replicated',
    'Whether new NDB tables are fully replicated',
    True,
    ['Other/NDB']),
  ( 'ndb_index_stat_cache_entries',
    'Sets the granularity of the statistics by determining the number of starting and ending keys',
    True,
    ['Other/NDB']),
  ( 'ndb_index_stat_enable',
    'Use NDB index statistics in query optimization',
    True,
    ['Other/NDB']),
  ( 'ndb_index_stat_option',
    'Comma-separated list of tunable options for NDB index statistics; the list should contain no spaces',
    True,
    ['Other/NDB']),
  ( 'ndb_index_stat_update_freq',
    'How often to query data nodes instead of the statistics cache',
    True,
    ['Other/NDB']),
  ( 'ndb_join_pushdown',
    'Enables pushing down of joins to data nodes',
    True,
    []),
  ( 'ndb_log_apply_status',
    'Whether or not a MySQL server acting as a slave logs mysql.ndb_apply_status updates received from its immediate master in its own binary log, using its own server ID',
    False,
    ['Other/NDB']),
  ( 'ndb_log_bin',
    'Write updates to NDB tables in the binary log. Effective only if binary logging is enabled with --log-bin.',
    True,
    []),
  ( 'ndb_log_binlog_index',
    'Insert mapping between epochs and binary log positions into the ndb_binlog_index table. Defaults to ON. Effective only if binary logging is enabled on the server.',
    True,
    []),
  ( 'ndb_log_empty_epochs',
    'When enabled, epochs in which there were no changes are written to the ndb_apply_status and ndb_binlog_index tables, even when log_slave_updates is enabled',
    True,
    ['Other/NDB']),
  ( 'ndb_log_empty_update',
    'When enabled, updates which produce no changes are written to the ndb_apply_status and ndb_binlog_index tables, even when log_slave_updates is enabled',
    True,
    ['Other/NDB']),
  ( 'ndb_log_exclusive_reads',
    'Log primary key reads with exclusive locks; allow conflict resolution based on read conflicts',
    True,
    ['Other/NDB']),
  ( 'ndb_log_orig',
    'Whether the id and epoch of the originating server are recorded in the mysql.ndb_binlog_index table. Set using the --ndb-log-orig option when starting mysqld.',
    False,
    ['Other/NDB']),
  ( 'ndb_log_transaction_id',
    'Whether NDB transaction IDs are written into the binary log (Read-only.)',
    False,
    []),
  ('ndb-log-update-minimal', 'Log updates in a minimal format.', True, []),
  ( 'ndb_log_updated_only',
    'Log complete rows (ON) or updates only (OFF)',
    True,
    ['Other/NDB']),
  ( 'ndb_optimization_delay',
    'Sets the number of milliseconds to wait between processing sets of rows by OPTIMIZE TABLE on NDB tables',
    True,
    []),
  ( 'ndb_optimized_node_selection',
    'Determines how an SQL node chooses a cluster data node to use as transaction coordinator',
    False,
    ['Other/NDB']),
  ('ndb_read_backup', 'Enable read from any replica', True, ['Other/NDB']),
  ( 'ndb_recv_thread_cpu_mask',
    'CPU mask for locking receiver threads to specific CPUs; specified as hexadecimal. See documentation for details.',
    True,
    []),
  ( 'ndb_report_thresh_binlog_epoch_slip',
    'NDB 7.5.4 and later: Threshold for number of epochs completely buffered, but not yet consumed by binlog injector thread which when exceeded generates BUFFERED_EPOCHS_OVER_THRESHOLD event buffer status message; prior to NDB 7.5.4: Threshold for number of epochs to lag behind before reporting binary log status',
    True,
    ['Other/NDB']),
  ( 'ndb_report_thresh_binlog_mem_usage',
    'This is a threshold on the percentage of free memory remaining before reporting binary log status',
    True,
    ['Other/NDB']),
  ( 'ndb_show_foreign_key_mock_tables',
    'Show the mock tables used to support foreign_key_checks=0',
    True,
    ['Other/NDB']),
  ( 'ndb_slave_conflict_role',
    'Role for slave to play in conflict detection and resolution. Value is one of PRIMARY, SECONDARY, PASS, or NONE (default). Can be changed only when slave SQL thread is stopped. See documentation for further information.',
    True,
    ['Other/NDB']),
  ( 'Ndb_slave_max_replicated_epoch',
    'The most recently committed NDB epoch on this slave. When this value is greater than or equal to Ndb_conflict_last_conflict_epoch, no conflicts have yet been detected.',
    False,
    []),
  ( 'Ndb_system_name',
    'Configured cluster system name; empty if server not connected to NDB',
    False,
    []),
  ( 'ndb_table_no_logging',
    'NDB tables created when this setting is enabled are not checkpointed to disk (although table schema files are created). The setting in effect when the table is created with or altered to use NDBCLUSTER persists for the lifetime of the table.',
    True,
    []),
  ( 'ndb_table_temporary',
    'NDB tables are not persistent on disk: no schema files are created and the tables are not logged',
    True,
    []),
  ( 'ndb_use_copying_alter_table',
    'Use copying ALTER TABLE operations in NDB Cluster',
    False,
    []),
  ( 'ndb_use_exact_count',
    'Use exact row count when planning queries',
    True,
    []),
  ( 'ndb_use_transactions',
    'Forces NDB to use a count of records during SELECT COUNT(*) query planning to speed up this type of query',
    True,
    ['Other/NDB']),
  ( 'ndb_version',
    'Shows build and NDB engine version as an integer',
    False,
    []),
  ( 'ndb_version_string',
    'Shows build information including NDB engine version in ndb-x.y.z format',
    False,
    []),
  ( 'ndbinfo_database',
    'The name used for the NDB information database; read only',
    False,
    []),
  ('ndbinfo_max_bytes', 'Used for debugging only', True, []),
  ('ndbinfo_max_rows', 'Used for debugging only', True, []),
  ( 'ndbinfo_offline',
    'Put the ndbinfo database into offline mode, in which no rows are returned from tables or views',
    True,
    []),
  ( 'ndbinfo_show_hidden',
    'Whether to show ndbinfo internal base tables in the mysql client. The default is OFF.',
    True,
    []),
  ( 'ndbinfo_table_prefix',
    'The prefix to use for naming ndbinfo internal base tables',
    True,
    []),
  ( 'ndbinfo_version',
    'The version of the ndbinfo engine; read only',
    False,
    []),
  ( 'net_buffer_length',
    'Buffer length for TCP/IP and socket communication',
    True,
    ['Networking/Data / Memory size']),
  ( 'net_read_timeout',
    'Number of seconds to wait for more data from a connection before aborting the read',
    True,
    ['Networking/Timeout Settings']),
  ( 'net_retry_count',
    'Number of times to retry an interrupted read or write on a communication port before giving up',
    True,
    ['Networking/Advanced']),
  ( 'net_write_timeout',
    'Number of seconds to wait for a block to be written to a connection before aborting the write',
    True,
    ['Networking/Timeout Settings']),
  ( 'new',
    "Use very new, possibly 'unsafe' functions",
    True,
    ['Advanced/Various']),
  ( 'ngram_token_size',
    'Defines the n-gram token size for the full-text search ngram parser',
    False,
    ['InnoDB/Fulltext search']),
  ('offline_mode', 'Whether server is offline', True, ['General/System']),
  ( 'old',
    'Cause the server to revert to certain behaviors present in older versions',
    False,
    ['General/General']),
  ('old-alter-table', 'Use old, nonoptimized alter table', True, []),
  ( 'old_passwords',
    'Selects password hashing method for PASSWORD()',
    True,
    []),
  ( 'open-files-limit',
    'If this is not 0, then mysqld will use this value to reserve file descriptors to use with setrlimit()',
    False,
    []),
  ( 'optimizer_join_cache_level',
    'How join buffers are used',
    True,
    ['Performance/Optimizer']),
  ( 'optimizer_prune_level',
    'Controls the heuristic(s) applied during query optimization to prune less-promising partial plans from the optimizer search space',
    True,
    ['Performance/Optimizer']),
  ( 'optimizer_search_depth',
    'Maximum depth of search performed by the query optimizer',
    True,
    ['Performance/Optimizer']),
  ( 'optimizer_switch',
    'Enable control over which optimizations to use',
    True,
    ['Performance/Optimizer']),
  ('optimizer_trace', 'Control optimizer tracing', True, []),
  ('optimizer_trace_features', 'Control optimizer tracing', True, []),
  ('optimizer_trace_limit', 'Control optimizer tracing', True, []),
  ('optimizer_trace_max_mem_size', 'Control optimizer tracing', True, []),
  ('optimizer_trace_offset', 'Control optimizer tracing', True, []),
  ( 'optimizer_use_mrr',
    'How the optimizer reads multiple ranges of index tuples',
    True,
    []),
  ( 'parser_max_mem_size',
    'Maximum amount of memory available to parser',
    True,
    ['General/SQL']),
  ( 'password_history',
    'Number of password changes required before password reuse',
    True,
    ['Security/Authentication']),
  ( 'password_reuse_interval',
    'Number of days elapsed required before password reuse',
    True,
    ['Security/Authentication']),
  ( 'performance_schema',
    'Whether Performance Schema is enabled',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_accounts_size',
    'Number of rows in the accounts table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_digests_size',
    'Number of rows in the events_statements_summary_by_digest table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_error_size',
    'Number of instrumented errors',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_stages_history_long_size',
    'Number of rows in the events_stages_history_long table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_stages_history_size',
    'Number of rows per thread in the events_stages_history table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_statements_history_long_size',
    'Number of rows in the events_statements_history_long table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_statements_history_size',
    'Number of rows per thread in the events_statements_history table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_transactions_history_long_size',
    'Number of rows in the events_transactions_history_long table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_transactions_history_size',
    'Number of rows per thread in the events_transactions_history table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_waits_history_long_size',
    'Number of rows in the events_waits_history_long table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_waits_history_size',
    'Number of rows per thread in the events_waits_history table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_hosts_size',
    'Number of rows in the hosts table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_cond_classes',
    'The maximum number of condition instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_cond_instances',
    'The maximum number of instrumented condition objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_digest_length',
    'The maximum Performance Schema digest size in bytes',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_digest_sample_age',
    'The query resample age in seconds',
    True,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_file_classes',
    'The maximum number of file instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_file_handles',
    'The maximum number of opened file objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_file_instances',
    'The maximum number of instrumented file objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_index_stat',
    'Maximum number of indexes to keep statistics for',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_memory_classes',
    'The maximum number of memory instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_metadata_locks',
    'The maximum number of metadata locks to track',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_mutex_classes',
    'The maximum number of mutex instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_mutex_instances',
    'The maximum number of instrumented mutex objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_prepared_statements_instances',
    'Number of rows in the prepared_statements_instances table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_program_instances',
    'The maximum number of stored programs for statistics',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_rwlock_classes',
    'The maximum number of rwlock instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_rwlock_instances',
    'The maximum number of instrumented rwlock objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_socket_classes',
    'The maximum number of socket instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_socket_instances',
    'The maximum number of instrumented socket objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_sql_text_length',
    'The maximum number of bytes stored from SQL statements',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_stage_classes',
    'The maximum number of stage instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_statement_classes',
    'The maximum number of statement instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_statement_stack',
    'The maximum stored program nesting for statistics',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_table_handles',
    'The maximum number of opened table objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_table_instances',
    'The maximum number of instrumented table objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_table_lock_stat',
    'Maximum number of tables to keep lock statistics for',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_thread_classes',
    'The maximum number of thread instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_thread_instances',
    'The maximum number of instrumented thread objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_session_connect_attrs_size',
    'Size of the connection attribute strings buffer per thread',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_setup_actors_size',
    'Number of rows in the setup_actors table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_setup_objects_size',
    'Number of rows in the setup_objects table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_users_size',
    'Number of rows in the users table',
    False,
    ['Performance/Performance Schema']),
  ( 'persisted_globals_load',
    'Whether to load persisted configuration settings',
    False,
    ['General/System']),
  ('pid-file', 'Process ID file used by mysqld_safe', False, []),
  ('plugin_dir', 'Directory for plugins', False, ['General/Directories']),
  ( 'port',
    'Port number on which to listen for TCP/IP connections',
    False,
    ['Networking/General']),
  ( 'preload_buffer_size',
    'Size of buffer that is allocated when preloading indexes',
    True,
    ['Advanced/Various']),
  ( 'prepared_stmt_count',
    'The current number of prepared statements',
    False,
    []),
  ('profiling', 'Enable or disable statement profiling', True, []),
  ( 'profiling_history_size',
    'How many statements to maintain profiling information for',
    True,
    ['General/Features', 'Performance/General']),
  ( 'protocol_version',
    'The version of the client/server protocol used by the MySQL server',
    False,
    []),
  ('proxy_user', 'The user proxied by the external proxy user', False, []),
  ('pseudo_slave_mode', 'For internal server use', True, []),
  ('pseudo_thread_id', 'For internal server use', True, []),
  ( 'query_alloc_block_size',
    'Allocation block size for query parsing and execution',
    True,
    ['Advanced/Various', 'General/Memory usage']),
  ( 'query_cache_limit',
    'Do not cache results that are bigger than this',
    True,
    ['Performance/Query cache']),
  ( 'query_cache_min_res_unit',
    'Minimal size of unit in which space for results is allocated (last unit will be trimmed after writing all result data)',
    True,
    ['Performance/Query cache']),
  ( 'query_cache_size',
    'The memory allocated to store results from old queries',
    True,
    ['Performance/Query cache']),
  ('query_cache_type', 'Query cache type', True, ['Performance/Query cache']),
  ( 'query_cache_wlock_invalidate',
    'Invalidate queries in query cache on LOCK for write',
    True,
    ['Performance/Query cache']),
  ( 'query_prealloc_size',
    'Persistent buffer for query parsing and execution',
    True,
    ['Advanced/Various']),
  ( 'rand_seed1',
    'Used to support replication of the RAND() function',
    True,
    []),
  ( 'rand_seed2',
    'Used to support replication of the RAND() function',
    True,
    []),
  ( 'range_alloc_block_size',
    'Allocation block size for storing ranges during optimization',
    True,
    ['Advanced/Various']),
  ( 'range_optimizer_max_mem_size',
    'Limit on range optimizer memory consumption',
    True,
    ['Advanced/Various']),
  ( 'rbr_exec_mode',
    'Allows for switching the server between IDEMPOTENT mode (key and some other errors suppressed) and STRICT mode; STRICT mode is the default',
    True,
    []),
  ( 'read_buffer_size',
    'Each thread that does a sequential scan for a MyISAM table allocates a buffer of this size for each table it scans',
    True,
    ['Advanced/Various']),
  ( 'read_only',
    'Prevent client updates except from clients with SUPER',
    True,
    ['Security/Security']),
  ( 'read_rnd_buffer_size',
    'When reading rows from a MyISAM table in sorted order after a sort, the rows are read through this buffer to avoid a disk seeks. If not set, then it is set to the value of record_buffer.',
    True,
    ['Advanced/Various']),
  ( 'regexp_stack_limit',
    'Regular expression match stack size limit',
    True,
    ['Advanced/Various']),
  ( 'regexp_time_limit',
    'Regular expression match timeout',
    True,
    ['Advanced/Various']),
  ('relay-log', 'The location and base name to use for relay logs', False, []),
  ( 'relay-log-index',
    'The location and name to use for the file that keeps a list of the last relay logs',
    False,
    ['Replication/Relay Log']),
  ( 'relay_log_basename',
    'Complete path to relay log, including filename',
    False,
    []),
  ( 'relay_log_index',
    'The name of the relay log index file',
    False,
    ['Replication/Relay Log']),
  ( 'relay_log_info_file',
    'The name of the file in which the slave records information about the relay logs',
    False,
    ['Replication/Relay Log']),
  ( 'relay_log_info_repository',
    "Whether to write the replication SQL thread's location in the relay logs to a file or a table",
    True,
    []),
  ( 'relay_log_purge',
    'Determines whether relay logs are purged',
    True,
    ['Replication/Relay Log']),
  ( 'relay_log_recovery',
    'Whether automatic recovery of relay log files from master at startup is enabled; must be enabled for a crash-safe slave',
    True,
    ['Replication/Relay Log']),
  ( 'relay_log_space_limit',
    'Maximum space to use for all relay logs',
    False,
    ['Replication/Relay Log']),
  ( 'report-host',
    'Host name or IP of the slave to be reported to the master during slave registration',
    False,
    []),
  ( 'report-password',
    'An arbitrary password that the slave server should report to the master. Not the same as the password for the MySQL replication user account.',
    False,
    []),
  ( 'report-port',
    'Port for connecting to slave reported to the master during slave registration',
    False,
    []),
  ( 'report-user',
    'An arbitrary user name that a slave server should report to the master. Not the same as the name used with the MySQL replication user account.',
    False,
    []),
  ( 'require_secure_transport',
    'Whether client connections must use secure transport',
    True,
    ['Security/Security']),
  ( 'restore_disables_events',
    'Whether RESTORE disables restored events',
    True,
    ['Advanced/General']),
  ( 'restore_elevation',
    'Enable or disable RESTORE privilege elevation',
    False,
    ['Advanced/General']),
  ( 'restore_precheck',
    'Whether RESTORE performs privilege checking before restoring',
    True,
    ['Advanced/General']),
  ( 'resultset_metadata',
    'Whether the server returns result set metadata',
    True,
    []),
  ( 'rewriter_enabled',
    'Whether the example query rewrite plugin is enabled',
    True,
    []),
  ('rewriter_verbose', 'For internal use', True, []),
  ('rpl_recovery_rank', 'Not used; removed in later versions', True, []),
  ( 'rpl_semi_sync_master_enabled',
    'Whether semisynchronous replication is enabled on the master',
    True,
    []),
  ('rpl_semi_sync_master_reply_log_file_pos', 'Internal use', True, []),
  ( 'rpl_semi_sync_master_timeout',
    'Number of milliseconds to wait for slave acknowledgment',
    True,
    []),
  ( 'rpl_semi_sync_master_trace_level',
    'The semisynchronous replication debug trace level on the master',
    True,
    []),
  ( 'rpl_semi_sync_master_wait_for_slave_count',
    'How many slave acknowledgments the master must receive per transaction before proceeding',
    True,
    []),
  ( 'rpl_semi_sync_master_wait_no_slave',
    'Whether master waits for timeout even with no slaves',
    True,
    []),
  ( 'rpl_semi_sync_master_wait_point',
    'The wait point for slave transaction receipt acknowledgment',
    True,
    []),
  ( 'rpl_semi_sync_slave_enabled',
    'Whether semisynchronous replication is enabled on slave',
    True,
    []),
  ( 'rpl_semi_sync_slave_trace_level',
    'The semisynchronous replication debug trace level on the slave',
    True,
    []),
  ( 'rpl_read_size',
    'Set the minimum amount of data in bytes that is read from the binary log files and relay log files',
    True,
    ['Replication/General']),
  ( 'rpl_stop_slave_timeout',
    'Set the number of seconds that STOP SLAVE waits before timing out',
    True,
    ['Replication/Slave']),
  ( 'safe-show-database',
    'Deprecated option; use GRANT SHOW DATABASES instead',
    True,
    []),
  ( 'schema_definition_cache',
    'Defines the number of schema definition objects that can be kept in the dictionary object cache',
    True,
    ['Security/Security']),
  ( 'secure-auth',
    'Disallow authentication for accounts that have old (pre-4.1) passwords',
    True,
    []),
  ( 'secure-backup-file-priv',
    'Limit BACKUP DATABASE and RESTORE to files in a single directory',
    False,
    []),
  ( 'secure-file-priv',
    'Limit LOAD DATA, and SELECT ... INTO OUTFILE, and LOAD_FILE() to files in specified directory',
    False,
    []),
  ( 'server-id',
    'Uniquely identifies the server instance in the community of replication partners. Required when binary logging is enabled.',
    True,
    []),
  ( 'server-id-bits',
    'Sets the number of least significant bits in the server_id actually used for identifying the server, permitting NDB API applications to store application data in the most significant bits. server_id must be less than 2 to the power of this value.',
    False,
    ['General/System']),
  ( 'server_id_bits',
    'The effective value of server_id if the server was started with the --server-id-bits option set to a nondefault value',
    False,
    ['General/System']),
  ( 'server_uuid',
    "The server's globally unique ID, automatically (re)generated at server start",
    False,
    []),
  ( 'session_track_gtids',
    'Enables a tracker which can be configured to track different GTIDs',
    True,
    ['General/General']),
  ( 'session_track_schema',
    'Whether to track schema changes',
    True,
    ['General/General']),
  ( 'session_track_state_change',
    'Whether to track session state changes',
    True,
    ['General/General']),
  ( 'session_track_system_variables',
    'Session variables to track changes for',
    True,
    ['General/General']),
  ( 'sha256_password_auto_generate_rsa_keys',
    'Whether to autogenerate RSA key-pair files',
    False,
    ['Security/Authentication']),
  ( 'sha256_password_private_key_path',
    'SHA256 authentication plugin private key path name',
    False,
    ['Security/Authentication']),
  ( 'sha256_password_proxy_users',
    'Whether the sha256_password authentication plugin does proxying',
    True,
    ['Security/Authentication']),
  ( 'sha256_password_public_key_path',
    'SHA256 authentication plugin public key path name',
    False,
    ['Security/Authentication']),
  ( 'shared_memory',
    'Whether the server allows shared-memory connections',
    False,
    ['General/System']),
  ( 'shared_memory_base_name',
    'The name of shared memory to use for shared-memory connections',
    False,
    ['General/System']),
  ( 'show_compatibility_56',
    'Compatibility for SHOW STATUS/VARIABLES',
    True,
    ['General/General']),
  ( 'show_create_table_verbosity',
    'Whether to display ROW_FORMAT in SHOW CREATE TABLE even if it has the default value',
    True,
    ['General/General']),
  ( 'show_old_temporals',
    'Whether SHOW CREATE TABLE should indicate pre-5.6.4 temporal columns',
    True,
    ['General/General']),
  ( 'simplified_binlog_gtid_recovery',
    'Controls how binary logs are iterated during GTID recovery',
    False,
    ['Logging/Binlog Options']),
  ( 'skip-name-resolve',
    "Do not resolve host names. All host names are IPs or 'localhost'",
    False,
    []),
  ('skip-networking', 'Do not allow connection with TCP/IP', False, []),
  ('skip-show-database', 'Do not allow SHOW DATABASE statements', False, []),
  ('skip-sync-bdb-logs', 'Disables synchronous BDB log flushes', False, []),
  ( 'skip_external_locking',
    'Skip system (external) locking',
    False,
    ['General/System']),
  ( 'slave-load-tmpdir',
    'The location where the slave should put its temporary files when replicating a LOAD DATA INFILE statement',
    False,
    []),
  ( 'slave-net-timeout',
    'Number of seconds to wait for more data from a master/slave connection before aborting the read',
    True,
    []),
  ( 'slave-skip-errors',
    'Tells the slave thread to continue replication when a query returns an error from the provided list',
    False,
    []),
  ( 'slave_allow_batching',
    'Turns update batching on and off for a replication slave',
    True,
    ['Replication/Slave']),
  ( 'slave_checkpoint_group',
    'Maximum number of transactions processed by a multi-threaded slave before a checkpoint operation is called to update progress status. Not supported by NDB Cluster.',
    True,
    ['Replication/Slave']),
  ( 'slave_checkpoint_period',
    'Update progress status of multi-threaded slave and flush relay log info to disk after this number of milliseconds. Not supported by NDB Cluster.',
    True,
    ['Replication/Slave']),
  ( 'slave_compressed_protocol',
    'Use compression on master/slave protocol',
    True,
    ['Replication/Slave']),
  ( 'slave_exec_mode',
    'Allows for switching the slave thread between IDEMPOTENT mode (key and some other errors suppressed) and STRICT mode; STRICT mode is the default, except for NDB Cluster, where IDEMPOTENT is always used',
    True,
    ['Replication/Slave']),
  ( 'slave_max_allowed_packet',
    'Maximum size, in bytes, of a packet that can be sent from a replication master to a slave; overrides max_allowed_packet',
    True,
    []),
  ( 'slave_parallel_type',
    'Tells the slave to use timestamp information (LOGICAL_CLOCK) or database partioning (DATABASE) to parallelize transactions.',
    True,
    []),
  ( 'slave_parallel_workers',
    'Number of applier threads for executing replication transactions in parallel. A value of 0 disables slave multi-threading. Not supported by MySQL Cluster.',
    True,
    []),
  ( 'slave_pending_jobs_size_max',
    'Maximum size of slave worker queues holding events not yet applied',
    True,
    []),
  ( 'slave_preserve_commit_order',
    'Ensures that all commits by slave workers happen in the same order as on the master to maintain consistency when using parallel applier threads.',
    True,
    []),
  ( 'slave_rows_search_algorithms',
    'Determines search algorithms used for slave update batching. Any 2 or 3 from the list INDEX_SEARCH, TABLE_SCAN, HASH_SCAN.',
    True,
    []),
  ( 'slave_sql_verify_checksum',
    'Cause slave to examine checksums when reading from relay log',
    True,
    []),
  ( 'slave_transaction_retries',
    'Number of times the slave SQL thread will retry a transaction in case it failed with a deadlock or elapsed lock wait timeout, before giving up and stopping',
    True,
    ['Replication/Slave']),
  ( 'slave_type_conversions',
    'Controls type conversion mode on replication slave. Value is a list of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY. Set to an empty string to disallow type conversions between master and slave.',
    False,
    ['Replication/Slave']),
  ('slow-query-log', 'Enable|disable slow query log', True, []),
  ( 'slow_launch_time',
    'If creating the thread takes longer than this value (in seconds), the Slow_launch_threads counter will be incremented',
    True,
    ['Advanced/Thread specific settings']),
  ( 'slow_query_log_file',
    'Name of the slow query log file',
    True,
    ['Logging/Slow query log options']),
  ( 'socket',
    'Socket file on which to listen for Unix socket or Windows named pipe connections',
    False,
    ['Networking/General']),
  ( 'sort_buffer_size',
    'Each thread that needs to do a sort allocates a buffer of this size',
    True,
    ['General/Memory usage']),
  ('sql-mode', 'Set the SQL server mode', True, []),
  ( 'sql_auto_is_null',
    'If set to 1, you can find the last inserted row for a table that contains an AUTO_INCREMENT column by using the following construct: WHERE auto_increment_column IS NULL',
    True,
    []),
  ( 'sql_big_selects',
    'If set to 0, MySQL aborts SELECT statements that are likely to take a very long time to execute',
    True,
    []),
  ( 'sql_big_tables',
    'This variable is deprecated, and is mapped to big_tables',
    True,
    []),
  ( 'sql_buffer_result',
    'Forces the result to be put into a temporary table',
    True,
    []),
  ('sql_log_bin', 'Toggle binary logging', True, []),
  ( 'sql_log_off',
    'If set to 1, no logging is done to the general query log for this client',
    True,
    []),
  ( 'sql_log_update',
    'This variable is deprecated, and is mapped to SQL_LOG_BIN',
    True,
    []),
  ( 'sql_low_priority_updates',
    'This variable is deprecated, and is mapped to low_priority_updates',
    True,
    []),
  ( 'sql_max_join_size',
    'This variable is deprecated, and is mapped to max_join_size',
    True,
    []),
  ('sql_notes', 'If set to 1, warnings of Note level are recorded', True, []),
  ( 'sql_quote_show_create',
    'If set to 1 the server quotes identifiers for SHOW CREATE TABLE and SHOW CREATE DATABASE statements',
    True,
    []),
  ( 'sql_safe_updates',
    'If set to 1, MySQL aborts UPDATE or DELETE statements that do not use a key in the WHERE clause or a LIMIT clause',
    True,
    []),
  ( 'sql_select_limit',
    'The maximum number of rows to return from SELECT statements',
    True,
    []),
  ( 'sql_slave_skip_counter',
    'Number of events from the master that a slave server should skip. Not compatible with GTID replication.',
    True,
    []),
  ( 'sql_warnings',
    'This variable controls whether single-row INSERT statements produce an information string if warnings occur',
    True,
    []),
  ( 'ssl-ca',
    'File that contains list of trusted SSL Certificate Authorities',
    False,
    []),
  ( 'ssl-capath',
    'Directory that contains trusted SSL Certificate Authority certificate files',
    False,
    []),
  ('ssl-cert', 'File that contains X509 certificate', False, []),
  ( 'ssl-cipher',
    'List of permitted ciphers for connection encryption',
    False,
    []),
  ('ssl-crl', 'File that contains certificate revocation lists', False, []),
  ( 'ssl-crlpath',
    'Directory that contains certificate revocation list files',
    False,
    []),
  ( 'ssl_fips_mode',
    'Whether to enable FIPS mode on the server side',
    True,
    ['Networking/SSL']),
  ('ssl-key', 'File that contains X509 key', False, []),
  ('storage_engine', 'The default storage engine', True, []),
  ( 'stored_program_cache',
    'Sets a "soft" upper limit for number of cached stored routines per connection. Stored procedures and stored functions are cached separately; this variable sets size for both of these.',
    True,
    ['General/General']),
  ( 'stored_program_definition_cache',
    'Defines the number of stored program and event definition objects that can be kept in the dictionary object cache',
    True,
    ['General/General']),
  ( 'super_read_only',
    'Whether to ignore SUPER exceptions to read-only mode',
    True,
    ['General/System']),
  ( 'sync-bdb-logs',
    'Synchronously flush Berkeley DB logs. Enabled by default',
    False,
    []),
  ( 'sync_binlog',
    'Synchronously flush binary log to disk after every #th event',
    True,
    ['Logging/Binlog Options']),
  ( 'sync_frm',
    'Sync .frm to disk on create. Enabled by default',
    True,
    ['Advanced/General']),
  ( 'sync_master_info',
    'Synchronize master.info to disk after every #th event',
    True,
    ['Replication/Master']),
  ( 'sync_relay_log',
    'Synchronize relay log to disk after every #th event',
    True,
    ['Replication/Relay Log']),
  ( 'sync_relay_log_info',
    'Synchronize relay.info file to disk after every #th event',
    True,
    ['Replication/Relay Log']),
  ('system_time_zone', 'The server system time zone', False, []),
  ( 'tablespace_definition_cache',
    'Defines the number of tablespace definition objects that can be kept in the dictionary object cache',
    True,
    ['General/System']),
  ( 'table_cache',
    'Number of open tables for all threads',
    True,
    ['General/System']),
  ( 'table_definition_cache',
    'Number of table definitions that can be stored in the definition cache',
    True,
    []),
  ('table_lock_wait_timeout', 'Currently unused', True, ['General/System']),
  ('table_open_cache', 'Number of open tables for all threads', True, []),
  ( 'table_open_cache_instances',
    'Number of open tables cache instances',
    False,
    []),
  ('table_type', 'A synonym for storage_engine', True, []),
  ( 'temptable_max_ram',
    'Defines the maximum amount of memory that can occupied by the TempTable storage engine before data is stored on disk',
    True,
    ['General/System']),
  ( 'thread_cache_size',
    'How many threads we should keep in a cache for reuse',
    True,
    ['Advanced/Thread specific settings']),
  ( 'thread_concurrency',
    'Permits the application to give the threads system a hint for the desired number of threads that should be run at the same time',
    False,
    ['Advanced/Thread specific settings']),
  ( 'thread_handling',
    'The thread-handling model',
    False,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_algorithm',
    'The thread pool algorithm',
    False,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_high_priority_connection',
    'Whether the current session is high priority',
    True,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_max_unused_threads',
    'The maximum permitted number of unused threads',
    True,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_prio_kickup_timer',
    'How long before a statement is moved to high-priority execution',
    True,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_size',
    'Number of thread groups in the thread pool',
    False,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_stall_limit',
    'How long before a statement is defined as stalled',
    True,
    ['Advanced/Thread specific settings']),
  ( 'thread_stack',
    'The stack size for each thread',
    False,
    ['Advanced/Thread specific settings']),
  ('time_format', 'The TIME format (unused)', False, []),
  ('time_zone', 'The current time zone', True, []),
  ( 'timed_mutexes',
    'Specify whether to time mutexes (only InnoDB mutexes are currently supported)',
    True,
    ['InnoDB/General']),
  ('timestamp', 'Change the value returned by NOW()', True, []),
  ( 'tls_version',
    'Protocols permitted for encrypted connections',
    False,
    ['Security/Authentication']),
  ( 'tmp_table_size',
    'If an in-memory temporary table exceeds this size, MySQL will automatically convert it to an on-disk MyISAM table',
    True,
    ['Advanced/Various']),
  ('tmpdir', 'Path for temporary files', False, ['General/Directories']),
  ('transaction-isolation', 'Default transaction isolation level', True, []),
  ('transaction-read-only', 'Default transaction access mode', True, []),
  ( 'transaction_alloc_block_size',
    'Allocation block size for transactions to be stored in binary log',
    True,
    ['Advanced/Transactions']),
  ( 'transaction_allow_batching',
    'Allows batching of statements within a transaction. Disable AUTOCOMMIT to use.',
    True,
    []),
  ( 'transaction_prealloc_size',
    'Persistent buffer for transactions to be stored in binary log',
    True,
    ['Advanced/Transactions']),
  ( 'transaction_write_set_extraction',
    'Defines the algorithm used to hash the writes extracted during a transaction',
    True,
    []),
  ('tx_isolation', 'The default transaction isolation level', True, []),
  ('tx_read_only', 'Default transaction access mode', True, []),
  ( 'unique_checks',
    'If set to 1 (the default), uniqueness checks for secondary indexes in InnoDB tables are performed',
    True,
    []),
  ( 'updatable_views_with_limit',
    'This variable controls whether updates to a view can be made when the view does not contain all columns of the primary key',
    True,
    ['Advanced/General']),
  ( 'validate_password.check_user_name',
    'Whether to check passwords against user name',
    True,
    ['Security/Authentication']),
  ( 'validate_password.dictionary_file',
    'validate_password dictionary file',
    True,
    []),
  ( 'validate_password.length',
    'validate_password required password length',
    True,
    []),
  ( 'validate_password.mixed_case_count',
    'validate_password required number of uppercase/lowercase characters',
    True,
    []),
  ( 'validate_password.number_count',
    'validate_password required number of digit characters',
    True,
    []),
  ('validate_password.policy', 'validate_password password policy', True, []),
  ( 'validate_password.special_char_count',
    'validate_password required number of special characters',
    True,
    []),
  ( 'validate_password_check_user_name',
    'Whether to check passwords against user name',
    True,
    ['Security/Authentication']),
  ( 'validate_password_dictionary_file',
    'validate_password dictionary file',
    True,
    []),
  ( 'validate_password_length',
    'validate_password required password length',
    True,
    []),
  ( 'validate_password_mixed_case_count',
    'validate_password required number of uppercase/lowercase characters',
    True,
    []),
  ( 'validate_password_number_count',
    'validate_password required number of digit characters',
    True,
    []),
  ('validate_password_policy', 'validate_password password policy', True, []),
  ( 'validate_password_special_char_count',
    'validate_password required number of special characters',
    True,
    []),
  ( 'validate_user_plugins',
    'Whether to perform additional validation of user plugins',
    False,
    []),
  ('version', 'Output version information and exit', False, []),
  ( 'version_comment',
    'This variable contains the value of the --with-comment option specified when building MySQL',
    False,
    []),
  ( 'version_compile_machine',
    'The type of machine or architecture on which MySQL was built',
    False,
    []),
  ( 'version_compile_os',
    'The type of operating system on which MySQL was built',
    False,
    []),
  ('version_compile_zlib', 'Version of compiled-in zlib library', False, []),
  ( 'version_tokens_session',
    'Client token list for Version Tokens',
    True,
    ['General/System']),
  ( 'version_tokens_session_number',
    'For internal use',
    False,
    ['General/System']),
  ( 'wait_timeout',
    'Number of seconds the server waits for activity on a connection before closing it',
    True,
    ['Networking/Timeout Settings']),
  ('warning_count', 'Number of warnings', False, []),
  ( 'windowing_use_high_precision',
    'Whether to compute window functions to high precision',
    True,
    ['General/System'])]



status_variable_list = [ ( 'Mysqlx_aborted_clients',
    'Number of clients that were disconnected because of an input or output timeout.',
    False,
    ['X']),
  ('Mysqlx_address', 'The network address X Plugin is bound to', False, ['X']),
  ( 'Mysqlx_bytes_sent',
    'The number of bytes sent through the network',
    False,
    ['X']),
  ( 'Mysqlx_bytes_received',
    'The number of bytes received through the network',
    False,
    ['X']),
  ('Mysqlx_socket', 'The socket which is listening on', False, ['X']),
  ( 'Mysqlx_stmt_execute_sql',
    'The number of StmtExecute requests received for the SQL namespace',
    False,
    ['X']),
  ( 'Mysqlx_stmt_execute_xplugin',
    'The number of StmtExecute requests received for the X Plugin namespace',
    False,
    ['X']),
  ( 'Mysqlx_stmt_create_collection',
    'The number of create collection statements received',
    False,
    ['X']),
  ( 'Mysqlx_stmt_create_collection_index',
    'The number of create collection index statements received',
    False,
    ['X']),
  ( 'Mysqlx_stmt_drop_collection',
    'The number of drop collection statements received',
    False,
    ['X']),
  ( 'Mysqlx_stmt_drop_collection_index',
    'The number of drop collection index statements received',
    False,
    ['X']),
  ( 'Mysqlx_stmt_ensure_collection',
    'Number of executed ensure collection admin commands; incremented on reception of Mysqlx.Sql.StmtExecute with the admin command',
    False,
    ['X']),
  ( 'Mysqlx_stmt_execute_mysqlx',
    'Incremented on reception of each StmtExecute message with namespace set to mysqlx',
    False,
    ['X']),
  ( 'Mysqlx_stmt_list_objects',
    'The number of list object statements received',
    False,
    ['X']),
  ( 'Mysqlx_stmt_enable_notices',
    'The number of enable notice statements received',
    False,
    ['X']),
  ( 'Mysqlx_stmt_disable_notices',
    'The number of disable notice statements received',
    False,
    ['X']),
  ( 'Mysqlx_stmt_list_notices',
    'The number of list notice statements received',
    False,
    ['X']),
  ( 'Mysqlx_stmt_list_clients',
    'The number of list client statements received',
    False,
    ['X']),
  ( 'Mysqlx_stmt_kill_client',
    'The number of kill client statements received',
    False,
    ['X']),
  ('Mysqlx_stmt_ping', 'The number of ping statements received', False, ['X']),
  ( 'Mysqlx_crud_insert',
    'The number of insert requests received',
    False,
    ['X']),
  ( 'Mysqlx_crud_update',
    'The number of update requests received',
    False,
    ['X']),
  ( 'Mysqlx_crud_create_view',
    'The number of create view requests received',
    False,
    ['X']),
  ( 'Mysqlx_crud_drop_view',
    'The number of drop view requests received',
    False,
    ['X']),
  ( 'Mysqlx_crud_modify_view',
    'The number of modify view requests received',
    False,
    ['X']),
  ( 'Mysqlx_crud_delete',
    'The number of delete requests received',
    False,
    ['X']),
  ('Mysqlx_crud_find', 'The number of find requests received', False, ['X']),
  ( 'Mysqlx_errors_unknown_message_type',
    'The number of unknown message types that have been received',
    False,
    ['X']),
  ( 'Mysqlx_expect_open',
    'The number of expectation blocks opened',
    False,
    ['X']),
  ( 'Mysqlx_expect_close',
    'The number of expectation blocks closed',
    False,
    ['X']),
  ( 'Mysqlx_rows_sent',
    'The number of rows sent back to clients',
    False,
    ['X']),
  ( 'Mysqlx_notice_warning_sent',
    'The number of warning notices sent back to clients',
    False,
    ['X']),
  ( 'Mysqlx_notice_other_sent',
    'The number of other types of notices sent back to clients',
    False,
    ['X']),
  ('Mysqlx_port', 'The port which X Plugin is listening on', False, ['X']),
  ( 'Mysqlx_ssl_cipher',
    'The current SSL cipher (empty for non-SSL connections)',
    False,
    ['X']),
  ( 'Mysqlx_ssl_cipher_list',
    'A list of possible SSL ciphers (empty for non-SSL connections)',
    False,
    ['X']),
  ( 'Mysqlx_ssl_verify_depth',
    'The certificate verification depth for SSL connection',
    False,
    ['X']),
  ( 'Mysqlx_ssl_verify_mode',
    'The certificate verification mode for SSL connection',
    False,
    ['X']),
  ( 'Mysqlx_ssl_version',
    'The name of the protocol used for the SSL connection',
    False,
    ['X']),
  ( 'Mysqlx_sessions',
    'The number of sessions that have been opened',
    False,
    ['X']),
  ( 'Mysqlx_sessions_closed',
    'The number of sessions that have been closed',
    False,
    ['X']),
  ( 'Mysqlx_sessions_fatal_error',
    'The number of sessions that have closed with a fatal error',
    False,
    ['X']),
  ( 'Mysqlx_init_error',
    'The number of errors during initialisation',
    False,
    ['X']),
  ( 'Mysqlx_sessions_accepted',
    'The number of session attempts which have been accepted',
    False,
    ['X']),
  ( 'Mysqlx_sessions_rejected',
    'The number of session attempts which have been rejected',
    False,
    ['X']),
  ( 'Mysqlx_sessions_killed',
    'The number of sessions which have been killed',
    False,
    ['X']),
  ( 'Mysqlx_connections_closed',
    'The number of connections which have been closed',
    False,
    ['X']),
  ( 'Mysqlx_connections_accepted',
    'The number of connections which have been accepted',
    False,
    ['X']),
  ( 'Mysqlx_connections_rejected',
    'The number of connections which have been rejected',
    False,
    ['X']),
  ( 'Mysqlx_connection_accept_errors',
    'The number of connections which have caused accept errors',
    False,
    ['X']),
  ( 'Mysqlx_connection_errors',
    'The number of connections which have been closed',
    False,
    ['X']),
  ( 'Mysqlx_worker_threads',
    'The number of worker threads available',
    False,
    ['X']),
  ( 'Mysqlx_worker_threads_active',
    'The number of worker threads currently used',
    False,
    ['X']),
  ('Mysqlx_ssl_active', 'Whether SSL is active', False, ['X']),
  ( 'Mysqlx_ssl_ctx_verify_depth',
    'The certificate verification depth limit currently set in ctx',
    False,
    ['X']),
  ( 'Mysqlx_ssl_ctx_verify_mode',
    'The certificate verification mode currently set in ctx',
    False,
    ['X']),
  ( 'Mysqlx_ssl_finished_accepts',
    'The number of successful SSL connections to the server',
    False,
    ['X']),
  ( 'Mysqlx_ssl_accepts',
    'The number of accepted SSL connections',
    False,
    ['X']),
  ( 'Mysqlx_ssl_server_not_after',
    'The last date for which the SSL certificate is valid',
    False,
    ['X']),
  ( 'Mysqlx_ssl_server_not_before',
    'The first date for which the SSL certificate is valid',
    False,
    ['X']),
  ( 'Mysqlx_ssl_accept_renegotiates',
    'The number of negotiates needed to establish the connection',
    False,
    ['X']),
  ( 'Mysqlx_errors_sent',
    'number of errors that were sent to clients',
    False,
    ['X']),
  ( 'Aborted_clients',
    'Number of connections aborted because the client died without closing the connection properly',
    False,
    ['Networking/Stats']),
  ( 'Aborted_connects',
    'Number of failed attempts to connect to MySQL server',
    False,
    ['Networking/Stats']),
  ( 'Acl_cache_items_count',
    'Number of cached privilege objects',
    False,
    ['General']),
  ( 'Audit_log_current_size',
    'Audit log file current size',
    False,
    ['General']),
  ( 'Audit_log_event_max_drop_size',
    'Size of largest dropped audited event',
    False,
    ['General']),
  ('Audit_log_events', 'Number of handled audited events', False, ['General']),
  ( 'Audit_log_events_filtered',
    'Number of filtered audited events',
    False,
    ['General']),
  ( 'Audit_log_events_lost',
    'Number of dropped audited events',
    False,
    ['General']),
  ( 'Audit_log_events_written',
    'Number of written audited events',
    False,
    ['General']),
  ( 'Audit_log_total_size',
    'Combined size of written audited events',
    False,
    ['General']),
  ( 'Audit_log_write_waits',
    'Number of write-delayed audited events',
    False,
    ['General']),
  ( 'Binlog_cache_disk_use',
    'Number of transactions that used a temporary file instead of the binary log cache',
    False,
    ['Binlog']),
  ( 'Binlog_cache_use',
    'Number of transactions that used the temporary binary log cache',
    False,
    ['Binlog']),
  ( 'Binlog_stmt_cache_disk_use',
    'Number of nontransactional statements that used a temporary file instead of the binary log statement cache',
    False,
    ['Binlog']),
  ( 'Binlog_stmt_cache_use',
    'Number of statements that used the temporary binary log statement cache',
    False,
    ['Binlog']),
  ( 'Bytes_received',
    'Number of bytes received from all clients',
    False,
    ['Networking/Stats']),
  ( 'Bytes_sent',
    'Number of bytes sent to all clients',
    False,
    ['Networking/Stats']),
  ( 'Caching_sha2_password_rsa_public_key',
    'caching_sha2_password authentication plugin RSA public key value',
    False,
    ['General']),
  ( 'Com_admin_commands',
    'Count of admin statements',
    False,
    ['Commands/Admin']),
  ( 'Com_alter_db',
    'Count of ALTER DATABASE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_db_upgrade',
    'Count of ALTER DATABASE ... UPGRADE DATA DIRECTORY NAME statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_event',
    'Count for ALTER EVENT statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_function',
    'Count of ALTER FUNCTION statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_procedure',
    'Count of ALTER PROCEDURE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_resource_group',
    'Count of ALTER RESOURCE GROUP statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_server',
    'Count of ALTER SERVER statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_table',
    'Count of ALTER TABLE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_tablespace',
    'Count of ALTER TABLESPACE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_user',
    'Count of ALTER USER statements',
    False,
    ['Commands/Admin']),
  ( 'Com_alter_user_default_role',
    'Count of ALTER USER ... DEFAULT ROLE statements',
    False,
    ['Commands/Admin']),
  ('Com_analyze', 'Count of ANALYZE statements', False, ['Commands/General']),
  ( 'Com_assign_to_keycache',
    'Count of CACHE INDEX statements',
    False,
    ['Commands/General']),
  ( 'Com_backup',
    'Count of BACKUP DATABASE statements',
    False,
    ['Commands/General']),
  ( 'Com_backup_table',
    'Count of BACKUP TABLE statements',
    False,
    ['Commands/General']),
  ('Com_begin', 'Count of BEGIN statements', False, ['Commands/Transaction']),
  ( 'Com_binlog',
    'Count of BINLOG statements',
    False,
    ['Binlog', 'Commands/General']),
  ( 'Com_call_procedure',
    'Number of calls to stored procedures',
    False,
    ['Commands/DML']),
  ( 'Com_change_db',
    'Count of CHANGE DATABASE statements',
    False,
    ['Commands/General']),
  ( 'Com_change_master',
    'Count of CHANGE MASTER TO statements',
    False,
    ['Commands/Admin']),
  ( 'Com_change_repl_filter',
    'Count of CHANGE REPLICATION FILTER statements',
    False,
    ['Commands/Replication']),
  ('Com_check', 'Count of CHECK statements', False, ['Commands/Admin']),
  ( 'Com_checksum',
    'Count of CHECKSUM statements',
    False,
    ['Commands/General']),
  ('Com_commit', 'Count of COMMIT statements', False, ['Commands/General']),
  ( 'Com_create_db',
    'Count of CREATE DATABASE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_event',
    'Count of CREATE EVENT statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_function',
    'Count of CREATE FUNCTION statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_index',
    'Count of CREATE INDEX statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_procedure',
    'Count of CREATE PROCEDURE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_resource_group',
    'Count of CREATE RESOURCE GROUP statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_resource_group',
    'Count of DROP RESOURCE GROUP statements',
    False,
    ['Commands/DDL']),
  ( 'Com_set_resource_group',
    'Count of SET RESOURCE GROUP statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_role',
    'Count of CREATE ROLE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_server',
    'Count of CREATE SERVER statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_table',
    'Count of CREATE TABLE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_trigger',
    'Count of CREATE TRIGGER statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_udf',
    'Count of CREATE FUNCTION (UDF) statements',
    False,
    ['Commands/Admin']),
  ( 'Com_create_user',
    'Count of CREATE USER statements',
    False,
    ['Commands/Admin']),
  ( 'Com_create_view',
    'Count of CREATE VIEW statements',
    False,
    ['Commands/DDL']),
  ( 'Com_dealloc_sql',
    'Count of DEALLOCATE PREPARE statements',
    False,
    ['Commands/DML']),
  ('Com_delete', 'Count of DELETE statements', False, ['Commands/DML']),
  ( 'Com_delete_multi',
    'Count of multiple table DELETE statements',
    False,
    ['Commands/DML']),
  ('Com_do', 'Count of DO statements', False, ['Commands/DML']),
  ( 'Com_drop_db',
    'Count of DROP DATABASE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_event',
    'Count of DROP EVENT statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_function',
    'Count of DROP FUNCTION statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_index',
    'Count of DROP INDEX statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_procedure',
    'Count of DROP PROCEDURE statements',
    False,
    ['Commands/DDL']),
  ('Com_drop_role', 'Count of DROP ROLE statements', False, ['Commands/DDL']),
  ( 'Com_drop_server',
    'Count of DROP SERVER statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_table',
    'Count of DROP TABLE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_trigger',
    'Count of DROP TRIGGER statements',
    False,
    ['Commands/DDL']),
  ('Com_drop_user', 'Count of DROP USER statements', False, ['Commands/DDL']),
  ('Com_drop_view', 'Count of DROP_VIEW statements', False, ['Commands/DDL']),
  ( 'Com_empty_query',
    'Count of empty statements',
    False,
    ['Commands/General']),
  ( 'Com_execute_sql',
    'Count of EXECUTE statements',
    False,
    ['Commands/General']),
  ( 'Com_explain_other',
    'Count of EXPLAIN FOR CONNECTION statements',
    False,
    ['Commands/General']),
  ('Com_flush', 'Count of FLUSH statements', False, ['Commands/General']),
  ( 'Com_get_diagnostics',
    'Count of GET DIAGNOSTICS statements',
    False,
    ['Commands/Admin']),
  ('Com_grant', 'Count of GRANT statements', False, ['Commands/Admin']),
  ( 'Com_grant_roles',
    'Count of GRANT ROLE statements',
    False,
    ['Commands/Admin']),
  ( 'Com_group_replication_start',
    'Count of START GROUP_REPLICATION statements',
    False,
    ['Commands/Replication']),
  ( 'Com_group_replication_stop',
    'Count of STOP GROUP_REPLICATION statements',
    False,
    ['Commands/Replication']),
  ( 'Com_ha_close',
    'Count of HANDLER CLOSE statements',
    False,
    ['Commands/Admin']),
  ( 'Com_ha_open',
    'Count of HANDLER OPEN statements',
    False,
    ['Commands/Admin']),
  ( 'Com_ha_read',
    'Count of HANDLER READ statements',
    False,
    ['Commands/Admin']),
  ('Com_help', 'Count of HELP statements', False, ['Commands/General']),
  ('Com_insert', 'Count of INSERT statements', False, ['Commands/DML']),
  ( 'Com_insert_select',
    'Count of INSERT SELECT statements',
    False,
    ['Commands/DML']),
  ( 'Com_install_component',
    'Count of INSTALL COMPONENT statements',
    False,
    ['Commands/Admin']),
  ( 'Com_install_plugin',
    'Count of INSTALL PLUGIN statements',
    False,
    ['Commands/Admin']),
  ('Com_kill', 'Count of KILL statements', False, ['Commands/Admin']),
  ('Com_load', 'Count of LOAD statements', False, ['Commands/Admin']),
  ( 'Com_load_master_data',
    'Count of LOAD MASTER DATA statements',
    False,
    ['Commands/Admin']),
  ( 'Com_load_master_table',
    'Count of LOAD MASTER TABLE statements',
    False,
    ['Commands/Admin']),
  ( 'Com_lock_tables',
    'Count of LOCK TABLES statements',
    False,
    ['Commands/General']),
  ('Com_optimize', 'Count of OPTIMIZE statements', False, ['Commands/Admin']),
  ( 'Com_preload_keys',
    'Count of PRELOAD KEYS statements',
    False,
    ['Commands/Admin']),
  ('Com_prepare_sql', 'Count of PREPARE statements', False, ['Commands/DML']),
  ('Com_purge', 'Count of PURGE statements', False, ['Commands/Admin']),
  ( 'Com_purge_before_date',
    'Count of PURGE BEFORE DATE statements',
    False,
    ['Commands/Admin']),
  ( 'Com_purge_bup_log',
    'Count of PURGE BACKUP LOG statements',
    False,
    ['Commands/Admin']),
  ( 'Com_release_savepoint',
    'Count of RELEASE SAVEPOINT statements',
    False,
    ['Commands/Admin']),
  ( 'Com_rename_table',
    'Count of RENAME TABLE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_rename_user',
    'Count of RENAME USER statements',
    False,
    ['Commands/Admin']),
  ('Com_repair', 'Count of REPAIR statements', False, ['Commands/Admin']),
  ('Com_replace', 'Count of REPLACE statements', False, ['Commands/DML']),
  ( 'Com_replace_select',
    'Count of REPLACE SELECT statements',
    False,
    ['Commands/DML']),
  ('Com_reset', 'Count of RESET statements', False, ['Commands/Admin']),
  ('Com_resignal', 'Count of RESIGNAL statements', False, ['Commands/Admin']),
  ( 'Com_restore',
    'Count of RESTORE DATABASE statements',
    False,
    ['Commands/Admin']),
  ( 'Com_restore_table',
    'Count of RESTORE TABLE statements',
    False,
    ['Commands/Admin']),
  ( 'Com_revoke',
    'Count of REVOKE statements that revoke roles',
    False,
    ['Commands/Admin']),
  ( 'Com_revoke_all',
    'Count of REVOKE ALL statements',
    False,
    ['Commands/Admin']),
  ( 'Com_revoke_roles',
    'Count of REVOKE ROLES statements',
    False,
    ['Commands/Admin']),
  ( 'Com_rollback',
    'Count of ROLLBACK statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_rollback_to_savepoint',
    'Count of ROLLBACK TO SAVEPOINT statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_savepoint',
    'Count of SAVEPOINT statements',
    False,
    ['Commands/Transaction']),
  ('Com_select', 'Count of SELECT statements', False, ['Commands/General']),
  ( 'Com_set_option',
    'Count of SET OPTION statements',
    False,
    ['Commands/General']),
  ( 'Com_set_role',
    'Count of SET ROLE statements',
    False,
    ['Commands/General']),
  ( 'Com_show_authors',
    'Count of SHOW AUTHORS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_binlog_events',
    'Count of SHOW BINLOG EVENTS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_binlogs',
    'Count of SHOW BINLOGS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_charsets',
    'Count of SHOW CHARSET statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_collations',
    'Count of SHOW COLLATION statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_column_types',
    'Count of SHOW COLUMN TYPES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_contributors',
    'Count of SHOW CONTRIBUTORS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_db',
    'Count of SHOW CREATE DATABASE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_event',
    'Count of SHOW CREATE EVENT statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_func',
    'Count of SHOW CREATE FUNCTION statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_proc',
    'Count of SHOW CREATE PROCEDURE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_table',
    'Count of SHOW CREATE TABLE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_trigger',
    'Count of SHOW CREATE TRIGGER statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_user',
    'Count of SHOW CREATE USER statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_databases',
    'Count of SHOW DATABASES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_engine_logs',
    'Count of SHOW ENGINE LOGS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_engine_mutex',
    'Count of SHOW ENGINE MUTEX statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_engine_status',
    'Count of SHOW ENGINE STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_errors',
    'Count of SHOW ERRORS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_events',
    'Count of SHOW EVENTS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_fields',
    'Count of SHOW FIELDS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_function_code',
    'Count of SHOW FUNCTION CODE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_function_status',
    'Count of SHOW FUNCTION STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_grants',
    'Count of SHOW GRANTS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_innodb_status',
    'Count of SHOW INNODB STATUS statements',
    False,
    ['Commands/Show']),
  ('Com_show_keys', 'Count of SHOW KEYS statements', False, ['Commands/Show']),
  ('Com_show_logs', 'Count of SHOW LOGS statements', False, ['Commands/Show']),
  ( 'Com_show_master_status',
    'Count of SHOW MASTER STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_ndb_status',
    'Count of SHOW NDB STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_new_master',
    'Count of SHOW NEW MASTER statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_open_tables',
    'Count of SHOW OPEN TABLES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_plugins',
    'Count of SHOW PLUGINS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_privileges',
    'Count of SHOW PRIVILEGES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_procedure_code',
    'Count of SHOW PROCEDURE CODE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_procedure_status',
    'Count of SHOW PROCEDURE STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_processlist',
    'Count of SHOW PROCESSLIST statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_profile',
    'Count of SHOW PROFILE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_profiles',
    'Count of SHOW PROFILES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_relaylog_events',
    'Count of SHOW RELAYLOG EVENTS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_slave_hosts',
    'Count of SHOW SLAVE HOSTS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_slave_status',
    'Count of SHOW SLAVE STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_slave_status_nonblocking',
    'Count of SHOW SLAVE STATUS NONBLOCKING statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_status',
    'Count of SHOW STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_storage_engines',
    'Count of SHOW STORAGE ENGINES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_table_status',
    'Count of SHOW TABLE STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_tables',
    'Count of SHOW TABLES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_triggers',
    'Count of SHOW TRIGGERS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_variables',
    'Count of SHOW VARIABLES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_warnings',
    'Count of SHOW WARNINGS statements',
    False,
    ['Commands/Show']),
  ('Com_shutdown', 'Count of SHUTDOWN statements', False, ['Commands/Show']),
  ('Com_signal', 'Count of SIGNAL statements', False, ['Commands/Admin']),
  ( 'Com_slave_start',
    'Count of START SLAVE statements',
    False,
    ['Commands/Replication']),
  ( 'Com_slave_stop',
    'Count of STOP SLAVE statements',
    False,
    ['Commands/Replication']),
  ( 'Com_stmt_close',
    'Count of STATEMENT CLOSE statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_execute',
    'Count of STATEMENT EXECUTE statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_fetch',
    'Count of STATEMENT FETCH statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_prepare',
    'Count of STATEMENT PREPARE statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_reprepare',
    'Count of automatic repreparations of prepared statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_reset',
    'Count of STATEMENT RESET statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_send_long_data',
    'Count of STATEMENT SEND LONG DATA statements',
    False,
    ['Commands/Prepared Statement']),
  ('Com_truncate', 'Count of TRUNCATE statements', False, ['Commands/DML']),
  ( 'Com_uninstall_component',
    'Count of UINSTALL COMPONENT statements',
    False,
    ['Commands/Admin']),
  ( 'Com_uninstall_plugin',
    'Count of UNINSTALL PLUGIN statements',
    False,
    ['Commands/Admin']),
  ( 'Com_unlock_tables',
    'Count of UNLOCK TABLES statements',
    False,
    ['Commands/Admin']),
  ('Com_update', 'Count of UPDATE statements', False, ['Commands/DML']),
  ( 'Com_update_multi',
    'Count of multiple UPDATE statements',
    False,
    ['Commands/DML']),
  ( 'Com_xa_commit',
    'Count of XA COMMIT statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_xa_end',
    'Count of XA END statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_xa_prepare',
    'Count of XA PREPARE statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_xa_recover',
    'Count of XA RECOVER statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_xa_rollback',
    'Count of XA ROLLBACK statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_xa_start',
    'Count of XA START statements',
    False,
    ['Commands/Transaction']),
  ( 'Compression',
    'Whether the client connection uses compression in the client/server protocol',
    False,
    ['General']),
  ( 'Connection_control_delay_generated',
    'How many times the server delayed a connection request',
    False,
    ['Networking/Stats']),
  ( 'Connection_errors_accept',
    'Number of errors calling accept on the listening port',
    False,
    ['Networking/Errors']),
  ( 'Connection_errors_internal',
    'Number of connections refused due to internal errors',
    False,
    ['Networking/Errors']),
  ( 'Connection_errors_max_connections',
    'Number of connections refused due to the max_connections limit',
    False,
    ['Networking/Errors']),
  ( 'Connection_errors_peer_address',
    'Number of errors searching for connection client IP addresses',
    False,
    ['Networking/Errors']),
  ( 'Connection_errors_select',
    'Number of errors calling select/poll on the listening port',
    False,
    ['Networking/Errors']),
  ( 'Connection_errors_tcpwrap',
    'Number of connections refused by libwrap',
    False,
    ['Networking/Errors']),
  ( 'Connections',
    'Number of connection attempts',
    False,
    ['Networking/Stats']),
  ( 'Created_tmp_disk_tables',
    'Number of temporary tables on disk created automatically by the server while executing statements',
    False,
    ['General']),
  ( 'Created_tmp_files',
    'How many temporary files mysqld has created',
    False,
    ['General']),
  ( 'Created_tmp_tables',
    'How many temporary tables mysqld has created',
    False,
    ['General']),
  ( 'Delayed_errors',
    'Number of rows written with INSERT DELAYED for which some error occurred',
    False,
    ['General']),
  ( 'Delayed_insert_threads',
    'Number of INSERT DELAYED thread handlers in use',
    False,
    ['General']),
  ( 'Delayed_writes',
    'Number of INSERT DELAYED rows written',
    False,
    ['General']),
  ( 'Firewall_access_denied',
    'Number of statements rejected by MySQL Enterprise Firewall',
    False,
    ['Firewall']),
  ( 'Firewall_access_granted',
    'Number of statements accepted by MySQL Enterprise Firewall',
    False,
    ['Firewall']),
  ( 'Firewall_cached_entries',
    'Number of statements recorded by MySQL Enterprise Firewall',
    False,
    ['Firewall']),
  ( 'Flush_commands',
    'Number of FLUSH statements executed',
    False,
    ['General']),
  ( 'Handler_commit',
    'Number of internal COMMIT statements',
    False,
    ['Handler']),
  ( 'Handler_delete',
    'Number of times that rows have been deleted from tables',
    False,
    ['Handler']),
  ( 'Handler_discover',
    'Number of times that tables have been discovered',
    False,
    ['Handler']),
  ( 'Handler_external_lock',
    'Number of locks started while a statement executed',
    False,
    ['Handler']),
  ( 'Handler_mrr_init',
    'Number of times storage engine MRR implementation is used for table access',
    False,
    ['Handler']),
  ( 'Handler_prepare',
    'A counter for the prepare phase of two-phase commit operations',
    False,
    ['Handler']),
  ( 'Handler_read_first',
    'Number of times the first entry in an index was read',
    False,
    ['Handler']),
  ( 'Handler_read_key',
    'Number of requests to read a row based on a key',
    False,
    ['Handler']),
  ( 'Handler_read_last',
    'Number of requests to read the last index entry',
    False,
    ['Handler']),
  ( 'Handler_read_next',
    'Number of requests to read the next row in key order',
    False,
    ['Handler']),
  ( 'Handler_read_prev',
    'Number of requests to read the previous row in key order',
    False,
    ['Handler']),
  ( 'Handler_read_rnd',
    'Number of requests to read a row based on a fixed position',
    False,
    ['Handler']),
  ( 'Handler_read_rnd_next',
    'Number of requests to read the next row in the data file',
    False,
    ['Handler']),
  ( 'Handler_rollback',
    'Number of requests for a storage engine to perform a rollback operation',
    False,
    ['Handler']),
  ( 'Handler_savepoint',
    'Number of requests for a storage engine to place a savepoint',
    False,
    ['Handler']),
  ( 'Handler_savepoint_rollback',
    'Number of requests for a storage engine to roll back to a savepoint',
    False,
    ['Handler']),
  ( 'Handler_update',
    'Number of requests to update a row in a table',
    False,
    ['Handler']),
  ( 'Handler_write',
    'Number of requests to insert a row in a table',
    False,
    ['Handler']),
  ( 'Innodb_available_undo_logs',
    'Display the total number of InnoDB rollback segments; different from innodb_rollback_segments, which displays the number of active rollback segments',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_buffer_pool_bytes_data',
    'Number of bytes containing data (dirty or clean) in the buffer pool',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_bytes_dirty',
    'Number of bytes currently dirty in the buffer pool',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_dump_status',
    'Display status of buffer pool recording operation triggered by innodb_buffer_pool_dump_at_shutdown or innodb_buffer_pool_dump_now',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_load_status',
    'Display status of buffer pool warmup operation triggered by innodb_buffer_pool_load_at_startup or innodb_buffer_pool_load_now',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_pages_data',
    'Number of pages containing data (dirty or clean) in the buffer pool',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_pages_dirty',
    'Number of pages currently dirty in the buffer pool',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_pages_flushed',
    'Number of buffer pool page-flush requests',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_pages_free',
    'Number of buffer pool pages free',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_pages_latched',
    'Number of latched pages in InnoDB buffer pool',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_pages_misc',
    'Number of pages that are busy because they have been allocated for administrative overhead',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_pages_total',
    'The total size of buffer pool, in pages',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_read_ahead',
    'Number of pages read by the InnoDB read-ahead thread',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_read_ahead_evicted',
    'Number of read-ahead pages evicted without being accessed',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_read_ahead_rnd',
    'Number of random read-aheads initiated by InnoDB',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_read_ahead_seq',
    'Number of sequential read-aheads initiated by InnoDB',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_read_requests',
    'Number of logical read requests InnoDB has done',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_reads',
    'Number of logical reads that InnoDB could not satisfy from the buffer pool and had to do a single-page read',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_resize_status',
    'The status of the dynamic buffer pool resizing operation',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_wait_free',
    'Counts number of waits for pages to be flushed',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_write_requests',
    'Number of writes done to the buffer pool',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_data_fsyncs',
    'Number of fsync() operations so far',
    False,
    ['InnoDB/Data']),
  ( 'Innodb_data_pending_fsyncs',
    'The current number of pending fsync() operations',
    False,
    ['InnoDB/Data']),
  ( 'Innodb_data_pending_reads',
    'The current number of pending reads',
    False,
    ['InnoDB/Data']),
  ( 'Innodb_data_pending_writes',
    'Number of pending writes',
    False,
    ['InnoDB/Data']),
  ( 'Innodb_data_read',
    'The amount of data read so far, in bytes',
    False,
    ['InnoDB/Data', 'InnoDB/Stats']),
  ( 'Innodb_data_reads',
    'The total number of data reads',
    False,
    ['InnoDB/Data', 'InnoDB/Stats']),
  ( 'Innodb_data_writes',
    'The total number of data writes',
    False,
    ['InnoDB/Data', 'InnoDB/Stats']),
  ( 'Innodb_data_written',
    'The amount of data written in bytes',
    False,
    ['InnoDB/Data', 'InnoDB/Stats']),
  ( 'Innodb_dblwr_pages_written',
    'Number of doublewrite pages that have been written',
    False,
    ['InnoDB/General']),
  ( 'Innodb_dblwr_writes',
    'Number of doublewrite operations that have been performed',
    False,
    ['InnoDB/General']),
  ( 'Innodb_have_atomic_builtins',
    'Whether atomic instructions are available',
    False,
    ['InnoDB/General']),
  ( 'Innodb_have_sync_atomic',
    'Whether atomic instructions are available',
    False,
    ['InnoDB/General']),
  ( 'Innodb_heap_enabled',
    'Whether the InnoDB memory heap is enabled',
    False,
    ['InnoDB/General']),
  ( 'Innodb_log_waits',
    'Number of times that the log buffer was too small and a wait was required for it to be flushed before continuing',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_log_write_requests',
    'Number of log write requests',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_log_writes',
    'Number of physical writes to the log',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_num_open_files',
    'Number of physical files currently opened by InnoDB',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_os_log_fsyncs',
    'Number of fsync() writes done to the log file',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_os_log_pending_fsyncs',
    'Number of pending log file fsync() operations',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_os_log_pending_writes',
    'Number of pending log file writes',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_os_log_written',
    'Number of bytes written to the log file',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_page_size',
    'The compiled-in InnoDB page size',
    False,
    ['InnoDB/Stats']),
  ('Innodb_pages_created', 'Number of pages created', False, ['InnoDB/Stats']),
  ('Innodb_pages_read', 'Number of pages read', False, ['InnoDB/Stats']),
  ('Innodb_pages_written', 'Number of pages written', False, ['InnoDB/Stats']),
  ( 'Innodb_row_lock_current_waits',
    'Number of row locks currently being waited for',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_row_lock_time',
    'The total time spent in acquiring row locks, in milliseconds',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_row_lock_time_avg',
    'The average time to acquire a row lock, in milliseconds',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_row_lock_time_max',
    'The maximum time to acquire a row lock, in milliseconds',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_row_lock_waits',
    'Number of times a row lock had to be waited for',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_rows_deleted',
    'Number of rows deleted from InnoDB tables',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_rows_inserted',
    'Number of rows inserted into InnoDB tables',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_rows_read',
    'Number of rows read from InnoDB tables',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_rows_updated',
    'Number of rows updated in InnoDB tables',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_truncated_status_writes',
    'Number of times output from the SHOW ENGINE INNODB STATUS statement has been truncated',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_wake_ups',
    'Number of wakeups that should not occur',
    False,
    ['InnoDB/Stats']),
  ( 'Key_blocks_not_flushed',
    'Number of key blocks in the key cache that have changed but have not yet been flushed to disk',
    False,
    ['Keycache']),
  ( 'Key_blocks_unused',
    'Number of unused blocks in the key cache',
    False,
    ['Keycache']),
  ( 'Key_blocks_used',
    'Number of used blocks in the key cache',
    False,
    ['Keycache']),
  ( 'Key_read_requests',
    'Number of requests to read a key block from the cache',
    False,
    ['Keycache']),
  ( 'Key_reads',
    'Number of physical reads of a key block from disk',
    False,
    ['Keycache']),
  ( 'Key_write_requests',
    'Number of requests to write a key block to the cache',
    False,
    ['Keycache']),
  ( 'Key_writes',
    'Number of physical writes of a key block from disk',
    False,
    ['Keycache']),
  ( 'Last_query_cost',
    'The total cost of the last compiled query as computed by the query optimizer',
    False,
    ['Performance']),
  ( 'Last_query_partial_plans',
    'Number of iterations in execution plan construction for the previous statement',
    False,
    ['Performance']),
  ( 'Locked_connects',
    'Number of attempts to connect to locked accounts',
    False,
    ['Networking/Stats']),
  ( 'Max_execution_time_exceeded',
    'Number of statements that exceeded the execution timeout value',
    False,
    ['Networking/Stats']),
  ( 'Max_execution_time_set',
    'Number of statements for which execution timeout was set',
    False,
    ['Networking/Stats']),
  ( 'Max_execution_time_set_failed',
    'Number of statements for which execution timeout setting failed',
    False,
    ['Networking/Stats']),
  ( 'Max_statement_time_exceeded',
    'Number of statements that exceeded the execution timeout value',
    False,
    ['Networking/Stats']),
  ( 'Max_statement_time_set',
    'Number of statements for which execution timeout was set',
    False,
    ['Networking/Stats']),
  ( 'Max_statement_time_set_failed',
    'Number of statements for which execution timeout setting failed',
    False,
    ['Networking/Stats']),
  ( 'Max_used_connections',
    'The maximum number of connections that have been in use simultaneously since the server started',
    False,
    ['Networking/Stats']),
  ( 'Max_used_connections_time',
    'The time at which Max_used_connections reached its current value',
    False,
    ['Networking/Stats']),
  ( 'mecab_charset',
    'The character set currently used by the MeCab full-text parser plugin',
    False,
    ['General']),
  ('ndb-nodeid', 'NDB Cluster node ID for this MySQL server', False, []),
  ( 'Ndb_api_bytes_received_count',
    'Amount of data (in bytes) received from the data nodes by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_bytes_received_count_session',
    'Amount of data (in bytes) received from the data nodes in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_bytes_received_count_slave',
    'Amount of data (in bytes) received from the data nodes by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_bytes_sent_count',
    'Amount of data (in bytes) sent to the data nodes by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_bytes_sent_count_session',
    'Amount of data (in bytes) sent to the data nodes in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_bytes_sent_count_slave',
    'Amount of data (in bytes) sent to the data nodes by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_event_bytes_count',
    'Number of bytes of events received by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_event_bytes_count_injector',
    'Number of bytes of events received by the NDB binary log injector thread',
    False,
    ['NDB']),
  ( 'Ndb_api_event_data_count',
    'Number of row change events received by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_event_data_count_injector',
    'Number of row change events received by the NDB binary log injector thread',
    False,
    ['NDB']),
  ( 'Ndb_api_event_nondata_count',
    'Number of events received, other than row change events, by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_event_nondata_count_injector',
    'Number of events received, other than row change events, by the NDB binary log injector thread',
    False,
    ['NDB']),
  ( 'Ndb_api_pk_op_count',
    'Number of operations based on or using primary keys by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_pk_op_count_session',
    'Number of operations based on or using primary keys in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_pk_op_count_slave',
    'Number of operations based on or using primary keys by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_pruned_scan_count',
    'Number of scans that have been pruned to a single partition by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_pruned_scan_count_session',
    'Number of scans that have been pruned to a single partition in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_pruned_scan_count_slave',
    'Number of scans that have been pruned to a single partition by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_range_scan_count',
    'Number of range scans that have been started by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_range_scan_count_session',
    'Number of range scans that have been started in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_range_scan_count_slave',
    'Number of range scans that have been started by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_read_row_count',
    'Total number of rows that have been read by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_read_row_count_session',
    'Total number of rows that have been read in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_read_row_count_slave',
    'Total number of rows that have been read by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_scan_batch_count',
    'Number of batches of rows received by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_scan_batch_count_session',
    'Number of batches of rows received in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_scan_batch_count_slave',
    'Number of batches of rows received by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_table_scan_count',
    'Number of table scans that have been started, including scans of internal tables, by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_table_scan_count_session',
    'Number of table scans that have been started, including scans of internal tables, in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_table_scan_count_slave',
    'Number of table scans that have been started, including scans of internal tables, by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_abort_count',
    'Number of transactions aborted by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_abort_count_session',
    'Number of transactions aborted in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_abort_count_slave',
    'Number of transactions aborted by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_close_count',
    'Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_close_count_session',
    'Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_close_count_slave',
    'Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_commit_count',
    'Number of transactions committed by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_commit_count_session',
    'Number of transactions committed in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_commit_count_slave',
    'Number of transactions committed by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_local_read_row_count',
    'Total number of rows that have been read by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_local_read_row_count_session',
    'Total number of rows that have been read in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_local_read_row_count_slave',
    'Total number of rows that have been read by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_start_count',
    'Number of transactions started by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_start_count_session',
    'Number of transactions started in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_trans_start_count_slave',
    'Number of transactions started by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_uk_op_count',
    'Number of operations based on or using unique keys by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_uk_op_count_session',
    'Number of operations based on or using unique keys in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_uk_op_count_slave',
    'Number of operations based on or using unique keys by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_exec_complete_count',
    'Number of times thread has been blocked while waiting for execution of an operation to complete by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_exec_complete_count_session',
    'Number of times thread has been blocked while waiting for execution of an operation to complete in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_exec_complete_count_slave',
    'Number of times thread has been blocked while waiting for execution of an operation to complete by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_meta_request_count',
    'Number of times thread has been blocked waiting for a metadata-based signal by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_meta_request_count_session',
    'Number of times thread has been blocked waiting for a metadata-based signal in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_meta_request_count_slave',
    'Number of times thread has been blocked waiting for a metadata-based signal by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_nanos_count',
    'Total time (in nanoseconds) spent waiting for some type of signal from the data nodes by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_nanos_count_session',
    'Total time (in nanoseconds) spent waiting for some type of signal from the data nodes in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_nanos_count_slave',
    'Total time (in nanoseconds) spent waiting for some type of signal from the data nodes by this slave',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_scan_result_count',
    'Number of times thread has been blocked while waiting for a scan-based signal by this MySQL Server (SQL node)',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_scan_result_count_session',
    'Number of times thread has been blocked while waiting for a scan-based signal in this client session',
    False,
    ['NDB']),
  ( 'Ndb_api_wait_scan_result_count_slave',
    'Number of times thread has been blocked while waiting for a scan-based signal by this slave',
    False,
    ['NDB']),
  ( 'Ndb_cluster_node_id',
    'If the server is acting as an NDB Cluster node, then the value of this variable its node ID in the cluster',
    False,
    ['NDB']),
  ( 'Ndb_config_from_host',
    'The host name or IP address of the Cluster management server Formerly Ndb_connected_host',
    False,
    ['NDB']),
  ( 'Ndb_config_from_port',
    'The port for connecting to Cluster management server. Formerly Ndb_connected_port',
    False,
    ['NDB']),
  ( 'Ndb_conflict_fn_epoch',
    'Number of rows that have been found in conflict by the NDB$EPOCH() conflict detection function',
    False,
    ['NDB']),
  ( 'Ndb_conflict_fn_epoch2',
    'Number of rows that have been found in conflict by the NDB$EPOCH2() conflict detection function',
    False,
    ['NDB']),
  ( 'Ndb_conflict_fn_epoch2_trans',
    'Number of rows that have been found in conflict by the NDB$EPOCH2_TRANS() conflict detection function',
    False,
    ['NDB']),
  ( 'Ndb_conflict_fn_epoch_trans',
    'Number of rows that have been found in conflict by the NDB$EPOCH_TRANS() conflict detection function',
    False,
    ['NDB']),
  ( 'Ndb_conflict_fn_max',
    'If the server is part of an NDB Cluster involved in cluster replication, the value of this variable indicates the number of times that conflict resolution based on "greater timestamp wins" has been applied',
    False,
    ['NDB']),
  ( 'Ndb_conflict_fn_max_del_win',
    'Number of times that conflict resolution based on outcome of NDB$MAX_DELETE_WIN() has been applied',
    False,
    ['NDB']),
  ( 'Ndb_conflict_fn_old',
    'If the server is part of an NDB Cluster involved in cluster replication, the value of this variable indicates the number of times that "same timestamp wins" conflict resolution has been applied',
    False,
    ['NDB']),
  ( 'Ndb_conflict_last_stable_epoch',
    'Number of rows found to be in conflict by a transactional conflict function',
    False,
    ['NDB']),
  ( 'Ndb_conflict_reflected_op_discard_count',
    'Number of reflected operations that were not applied due an error during execution',
    False,
    ['NDB']),
  ( 'Ndb_conflict_reflected_op_prepare_count',
    'Number of reflected operations received that have been prepared for execution',
    False,
    ['NDB']),
  ( 'Ndb_conflict_refresh_op_count',
    'Number of refresh operations that have been prepared',
    False,
    ['NDB']),
  ( 'Ndb_conflict_trans_conflict_commit_count',
    'Number of epoch transactions committed after requiring transactional conflict handling',
    False,
    ['NDB']),
  ( 'Ndb_conflict_trans_detect_iter_count',
    'Number of internal iterations required to commit an epoch transaction. Should be (slightly) greater than or equal to Ndb_conflict_trans_conflict_commit_count',
    False,
    ['NDB']),
  ( 'Ndb_conflict_trans_reject_count',
    'Number of transactions rejected after being found in conflict by a transactional conflict function',
    False,
    ['NDB']),
  ( 'Ndb_conflict_trans_row_conflict_count',
    'Number of rows found in conflict by a transactional conflict function. Includes any rows included in or dependent on conflicting transactions.',
    False,
    ['NDB']),
  ( 'Ndb_conflict_trans_row_reject_count',
    'Total number of rows realigned after being found in conflict by a transactional conflict function. Includes Ndb_conflict_trans_row_conflict_count and any rows included in or dependent on conflicting transactions.',
    False,
    ['NDB']),
  ( 'Ndb_epoch_delete_delete_count',
    'Number of delete-delete conflicts detected (delete operation is applied, but row does not exist)',
    False,
    ['NDB']),
  ( 'Ndb_execute_count',
    'Provides the number of round trips to the NDB kernel made by operations',
    False,
    ['NDB']),
  ( 'Ndb_last_commit_epoch_server',
    'Epoch most recently committed by NDB',
    False,
    ['NDB']),
  ( 'Ndb_last_commit_epoch_session',
    'Epoch most recently committed by this NDB client',
    False,
    ['NDB']),
  ( 'Ndb_number_of_data_nodes',
    'If the server is part of an NDB Cluster, the value of this variable is the number of data nodes in the cluster',
    False,
    ['NDB']),
  ( 'Ndb_pruned_scan_count',
    'Number of scans executed by NDB since the cluster was last started where partition pruning could be used',
    False,
    ['NDB']),
  ( 'Ndb_pushed_queries_defined',
    'Number of joins that API nodes have attempted to push down to the data nodes',
    False,
    ['NDB']),
  ( 'Ndb_pushed_queries_dropped',
    'Number of joins that API nodes have tried to push down, but failed',
    False,
    ['NDB']),
  ( 'Ndb_pushed_queries_executed',
    'Number of joins successfully pushed down and executed on the data nodes',
    False,
    ['NDB']),
  ( 'Ndb_pushed_reads',
    'Number of reads executed on the data nodes by pushed-down joins',
    False,
    ['NDB']),
  ( 'ndb_recv_thread_activation_threshold',
    'Activation threshold when receive thread takes over the polling of the cluster connection (measured in concurrently active threads)',
    False,
    ['NDB']),
  ( 'Ndb_scan_count',
    'The total number of scans executed by NDB since the cluster was last started',
    False,
    ['NDB']),
  ( 'Not_flushed_delayed_rows',
    'Number of rows waiting to be written in INSERT DELAY queues',
    False,
    ['General']),
  ( 'Ongoing_anonymous_gtid_violating_transaction_count',
    'Number of ongoing anonymous transactions that violate GTID consistency',
    False,
    ['Replication']),
  ( 'Ongoing_anonymous_transaction_count',
    'Number of ongoing anonymous transactions',
    False,
    ['InnoDB/Stats']),
  ( 'Ongoing_automatic_gtid_violating_transaction_count',
    'Number of ongoing automatic transactions that violate GTID consistency',
    False,
    ['Replication']),
  ('Open_files', 'Number of files that are open', False, ['General']),
  ( 'Open_streams',
    'Number of streams that are open (used mainly for logging)',
    False,
    ['General']),
  ( 'Open_table_definitions',
    'Number of cached table definitions',
    False,
    ['General']),
  ('Open_tables', 'Number of tables that are open', False, ['General']),
  ( 'Opened_files',
    'Number of files that have been opened using my_open()',
    False,
    ['General']),
  ( 'Opened_table_definitions',
    'Number of table definitions that have been cached',
    False,
    ['General']),
  ( 'Opened_tables',
    'Number of tables that have been opened',
    False,
    ['General']),
  ( 'original_commit_timestamp',
    'The time when a transaction was committed on the original master',
    True,
    ['General']),
  ( 'Performance_schema_accounts_lost',
    'How many accounts table rows could not be added',
    False,
    ['Performance schema']),
  ( 'Performance_schema_cond_classes_lost',
    'How many condition instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_cond_instances_lost',
    'How many condition instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_digest_lost',
    'How many digests could not be instrumented',
    False,
    ['Performance schema']),
  ( 'Performance_schema_file_classes_lost',
    'How many file instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_file_handles_lost',
    'How many file instrument instances could not be opened',
    False,
    ['Performance schema']),
  ( 'Performance_schema_file_instances_lost',
    'How many file instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_hosts_lost',
    'How many hosts table rows could not be added',
    False,
    ['Performance schema']),
  ( 'Performance_schema_index_stat_lost',
    'Number of indexes for which statistics were lost',
    False,
    ['Performance schema']),
  ( 'Performance_schema_locker_lost',
    'How many events are lost or not recorded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_memory_classes_lost',
    'How many memory instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_metadata_lock_lost',
    'Number of metadata locks that could not be recorded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_mutex_classes_lost',
    'How many mutex instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_mutex_instances_lost',
    'How many mutex instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_nested_statement_lost',
    'Number of stored program statements for which statistics were lost',
    False,
    ['Performance schema']),
  ( 'Performance_schema_prepared_statements_lost',
    'Number of prepared statements that could not be instrumented',
    False,
    ['Performance schema']),
  ( 'Performance_schema_program_lost',
    'Number of stored programs for which statistics were lost',
    False,
    ['Performance schema']),
  ( 'Performance_schema_rwlock_classes_lost',
    'How many rwlock instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_rwlock_instances_lost',
    'How many rwlock instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_session_connect_attrs_longest_seen',
    'The size of the longest valid connection attribute buffer seen',
    False,
    ['Performance schema']),
  ( 'Performance_schema_session_connect_attrs_lost',
    'The number of connections for which attribute strings could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_socket_classes_lost',
    'How many socket instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_socket_instances_lost',
    'How many socket instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_stage_classes_lost',
    'How many stage instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_statement_classes_lost',
    'How many statement instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_table_handles_lost',
    'How many table instrument instances could not be opened',
    False,
    ['Performance schema']),
  ( 'Performance_schema_table_instances_lost',
    'How many table instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_table_lock_stat_lost',
    'Number of tables for which lock statistics were lost',
    False,
    ['Performance schema']),
  ( 'Performance_schema_thread_classes_lost',
    'How many thread instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_thread_instances_lost',
    'How many thread instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_users_lost',
    'How many users table rows could not be added',
    False,
    ['Performance schema']),
  ( 'Prepared_stmt_count',
    'The current number of prepared statements',
    False,
    ['General']),
  ( 'Qcache_free_blocks',
    'Number of free memory blocks in the query cache',
    False,
    ['Query cache']),
  ( 'Qcache_free_memory',
    'The amount of free memory for the query cache',
    False,
    ['Query cache']),
  ('Qcache_hits', 'Number of query cache hits', False, ['Query cache']),
  ('Qcache_inserts', 'Number of query cache inserts', False, ['Query cache']),
  ( 'Qcache_lowmem_prunes',
    'Number of queries that were deleted from the query cache due to lack of free memory in the cache',
    False,
    ['Query cache']),
  ( 'Qcache_not_cached',
    'Number of noncached queries (not cacheable, or not cached due to the query_cache_type setting)',
    False,
    ['Query cache']),
  ( 'Qcache_queries_in_cache',
    'Number of queries registered in the query cache',
    False,
    ['Query cache']),
  ( 'Qcache_total_blocks',
    'The total number of blocks in the query cache',
    False,
    ['Query cache']),
  ( 'Queries',
    'Number of statements executed by the server',
    False,
    ['General']),
  ( 'Questions',
    'Number of statements that clients have sent to the server',
    False,
    ['General']),
  ( 'Rewriter_number_loaded_rules',
    'Number of rewrite rules successfully loaded into memory',
    False,
    ['General']),
  ( 'Rewriter_number_reloads',
    'Number of reloads of rules table into memory',
    False,
    ['General']),
  ( 'Rewriter_number_rewritten_queries',
    'Number of queries rewritten since the plugin was loaded',
    False,
    ['General']),
  ( 'Rewriter_reload_error',
    'Whether an error occurred when last loading the rewriting rules into memory',
    False,
    ['General']),
  ( 'Rpl_semi_sync_master_clients',
    'Number of semisynchronous slaves',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_net_avg_wait_time',
    'The average time the master waited for a slave reply',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_net_wait_time',
    'The total time the master waited for slave replies',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_net_waits',
    'The total number of times the master waited for slave replies',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_no_times',
    'Number of times the master turned off semisynchronous replication',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_no_tx',
    'Number of commits not acknowledged successfully',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_status',
    'Whether semisynchronous replication is operational on the master',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_timefunc_failures',
    'Number of times the master failed when calling time functions',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_tx_avg_wait_time',
    'The average time the master waited for each transaction',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_tx_wait_time',
    'The total time the master waited for transactions',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_tx_waits',
    'The total number of times the master waited for transactions',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_wait_pos_backtraverse',
    'The total number of times the master waited for an event with binary coordinates lower than events waited for previously',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_wait_sessions',
    'Number of sessions currently waiting for slave replies',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_master_yes_tx',
    'Number of commits acknowledged successfully',
    False,
    ['Commands/Replication']),
  ( 'Rpl_semi_sync_slave_status',
    'Whether semisynchronous replication is operational on slave',
    False,
    ['Commands/Replication']),
  ( 'Rpl_status',
    'The status of fail-safe replication (not implemented)',
    False,
    ['Commands/Replication']),
  ( 'Rsa_public_key',
    'sha256_password authentication plugin RSA public key value',
    False,
    ['General']),
  ( 'Select_full_join',
    'Number of joins that perform table scans because they do not use indexes',
    False,
    ['General']),
  ( 'Select_full_range_join',
    'Number of joins that used a range search on a reference table',
    False,
    ['General']),
  ( 'Select_range',
    'Number of joins that used ranges on the first table',
    False,
    ['General']),
  ( 'Select_range_check',
    'Number of joins without keys that check for key usage after each row',
    False,
    ['General']),
  ( 'Select_scan',
    'Number of joins that did a full scan of the first table',
    False,
    ['General']),
  ( 'Slave_heartbeat_period',
    "The slave's replication heartbeat interval, in seconds",
    False,
    ['Replication']),
  ( 'Slave_last_heartbeat',
    'Shows when the latest heartbeat signal was received, in TIMESTAMP format',
    False,
    ['Replication']),
  ( 'Slave_open_temp_tables',
    'Number of temporary tables that the slave SQL thread currently has open',
    False,
    ['Replication']),
  ( 'Slave_received_heartbeats',
    'Number of heartbeats received by a replication slave since previous reset',
    False,
    ['Replication']),
  ( 'Slave_retried_transactions',
    'The total number of times since startup that the replication slave SQL thread has retried transactions',
    False,
    ['Replication']),
  ( 'Slave_rows_last_search_algorithm_used',
    'Search algorithm most recently used by this slave to locate rows for row-based replication (index, table, or hash scan)',
    False,
    ['Replication']),
  ( 'Slave_running',
    'The state of this server as a replication slave (slave I/O thread status)',
    False,
    ['Replication']),
  ( 'Slow_launch_threads',
    'Number of threads that have taken more than slow_launch_time seconds to create',
    False,
    ['Threading']),
  ( 'Slow_queries',
    'Number of queries that have taken more than long_query_time seconds',
    False,
    ['General']),
  ( 'Sort_merge_passes',
    'Number of merge passes that the sort algorithm has had to do',
    False,
    ['General']),
  ( 'Sort_range',
    'Number of sorts that were done using ranges',
    False,
    ['General']),
  ('Sort_rows', 'Number of sorted rows', False, ['General']),
  ( 'Sort_scan',
    'Number of sorts that were done by scanning the table',
    False,
    ['General']),
  ( 'Ssl_accept_renegotiates',
    'Number of negotiates needed to establish the connection',
    False,
    ['SSL']),
  ('Ssl_accepts', 'Number of accepted SSL connections', False, ['SSL']),
  ('Ssl_callback_cache_hits', 'Number of callback cache hits', False, ['SSL']),
  ('Ssl_cipher', 'The current SSL cipher', False, ['SSL']),
  ('Ssl_cipher_list', 'The list of possible SSL ciphers', False, ['SSL']),
  ( 'Ssl_client_connects',
    'Number of SSL connection attempts to an SSL-enabled master',
    False,
    ['SSL']),
  ( 'Ssl_connect_renegotiates',
    'Number of negotiates needed to establish the connection to an SSL-enabled master',
    False,
    ['SSL']),
  ( 'Ssl_ctx_verify_depth',
    'The SSL context verification depth (how many certificates in the chain are tested)',
    False,
    ['SSL']),
  ('Ssl_ctx_verify_mode', 'The SSL context verification mode', False, ['SSL']),
  ('Ssl_default_timeout', 'The default SSL timeout', False, ['SSL']),
  ( 'Ssl_finished_accepts',
    'Number of successful SSL connections to the server',
    False,
    ['SSL']),
  ( 'Ssl_finished_connects',
    'Number of successful slave connections to an SSL-enabled master',
    False,
    ['SSL']),
  ('Ssl_server_not_after', 'SSL certificate last valid date', False, ['SSL']),
  ( 'Ssl_server_not_before',
    'SSL certificate first valid date',
    False,
    ['SSL']),
  ( 'Ssl_session_cache_hits',
    'Number of SSL session cache hits',
    False,
    ['SSL']),
  ( 'Ssl_session_cache_misses',
    'Number of SSL session cache misses',
    False,
    ['SSL']),
  ('Ssl_session_cache_mode', 'The SSL session cache mode', False, ['SSL']),
  ( 'Ssl_session_cache_overflows',
    'Number of SSL session cache overflows',
    False,
    ['SSL']),
  ('Ssl_session_cache_size', 'The SSL session cache size', False, ['SSL']),
  ( 'Ssl_session_cache_timeouts',
    'Number of SSL session cache timeouts',
    False,
    ['SSL']),
  ( 'Ssl_sessions_reused',
    'How many SSL connections were reused from the cache',
    False,
    ['SSL']),
  ( 'Ssl_used_session_cache_entries',
    'How many SSL session cache entries were used',
    False,
    ['SSL']),
  ( 'Ssl_verify_depth',
    'The verification depth for replication SSL connections',
    False,
    ['SSL']),
  ( 'Ssl_verify_mode',
    'The verification mode for replication SSL connections',
    False,
    ['SSL']),
  ('Ssl_version', 'The SSL version number', False, ['SSL']),
  ( 'Table_locks_immediate',
    'Number of times that a table lock was acquired immediately',
    False,
    ['General']),
  ( 'Table_locks_waited',
    'Number of times that a table lock could not be acquired immediately and a wait was needed',
    False,
    ['General']),
  ( 'Table_open_cache_hits',
    'Number of hits for open tables cache lookups',
    False,
    ['General']),
  ( 'Table_open_cache_misses',
    'Number of misses for open tables cache lookups',
    False,
    ['General']),
  ( 'Table_open_cache_overflows',
    'Number of overflows for the open tables cache',
    False,
    ['General']),
  ( 'Tc_log_max_pages_used',
    'When the memory-mapped implementation of the log that is used by mysqld acts as the transaction coordinator for recovery of internal XA transactions,this variable indicates the largest number of pages used for the log since the server started',
    False,
    ['General']),
  ( 'Tc_log_page_size',
    'The page size used for the memory-mapped implementation of the XA recovery log',
    False,
    ['General']),
  ( 'Tc_log_page_waits',
    'For the memory-mapped implementation of the recovery log, this variable increments each time the server was not able to commit a transaction and had to wait for a free page in the log',
    False,
    ['General']),
  ( 'Threads_cached',
    'Number of threads in the thread cache',
    False,
    ['Threading']),
  ( 'Threads_connected',
    'Number of currently open connections',
    False,
    ['Threading']),
  ( 'Threads_created',
    'Number of threads created to handle connections',
    False,
    ['Threading']),
  ( 'Threads_running',
    'Number of threads that are not sleeping',
    False,
    ['Threading']),
  ('Uptime', 'Number of seconds the server has been up', False, ['General']),
  ( 'Uptime_since_flush_status',
    'Number of seconds since the most recent FLUSH STATUS',
    False,
    ['General']),
  ( 'validate_password.dictionary_file_last_parsed',
    'When the dictionary file was last parsed',
    False,
    ['General']),
  ( 'validate_password.dictionary_file_words_count',
    'Number of words in dictionary file',
    False,
    ['General']),
  ( 'validate_password_dictionary_file_last_parsed',
    'When the dictionary file was last parsed',
    False,
    ['General']),
  ( 'validate_password_dictionary_file_words_count',
    'Number of words in dictionary file',
    False,
    ['General'])]


ro_persistable = ['audit_log_buffer_size', 'audit_log_current_session', 'audit_log_file', 'audit_log_filter_id',
                  'audit_log_format', 'audit_log_policy', 'audit_log_strategy', 'auto_generate_certs', 'back_log',
                  'basedir', 'binlog_gtid_simple_recovery', 'bind_address', 'character_sets_dir', 'character_set_system',
                  'core_file', 'daemon_memcached_enable_binlog', 'daemon_memcached_engine_lib_name', 'daemon_memcached_engine_lib_path',
                  'daemon_memcached_r_batch_size', 'daemon_memcached_w_batch_size', 'datadir', 'date_format', 'datetime_format',
                  'default_authentication_plugin', 'disabled_storage_engines', 'ft_max_word_len', 'ft_min_word_len',
                  'ft_query_expansion_limit', 'ft_stopword_file', 'have_compress', 'have_crypt', 'have_dynamic_loading',
                  'have_geometry', 'have_openssl', 'have_profiling', 'have_query_cache', 'have_rtree_keys', 'have_ssl',
                  'have_statement_timeout', 'have_symlink', 'hostname', 'ignore_builtin_innodb', 'init_file',
                  'innodb_adaptive_hash_index_parts', 'innodb_api_disable_rowlock', 'innodb_api_enable_binlog',
                  'innodb_api_enable_mdl', 'innodb_autoinc_lock_mode', 'innodb_buffer_pool_chunk_size',
                  'innodb_buffer_pool_debug', 'innodb_buffer_pool_instances', 'innodb_buffer_pool_load_at_startup',
                  'innodb_data_file_path', 'innodb_data_home_dir', 'innodb_doublewrite', 'innodb_flush_method',
                  'innodb_force_load_corrupted', 'innodb_force_recovery', 'innodb_ft_cache_size', 'innodb_ft_max_token_size',
                  'innodb_ft_min_token_size', 'innodb_ft_sort_pll_degree', 'innodb_ft_total_cache_size',
                  'innodb_log_buffer_size', 'innodb_log_file_size', 'innodb_log_files_in_group', 'innodb_log_group_home_dir',
                  'innodb_numa_interleave', 'innodb_open_files', 'innodb_page_cleaners', 'innodb_page_size',
                  'innodb_purge_threads', 'innodb_read_io_threads', 'innodb_read_only', 'innodb_rollback_on_timeout',
                  'innodb_scan_directories', 'innodb_sort_buffer_size', 'innodb_sync_array_size', 'innodb_sync_debug',
                  'innodb_temp_data_file_path', 'innodb_undo_directory', 'innodb_undo_tablespaces', 'innodb_use_native_aio',
                  'innodb_version', 'innodb_write_io_threads', 'language', 'large_files_support', 'large_pages',
                  'large_page_size', 'lc_messages_dir', 'license', 'log_error', 'locked_in_memory', 'log_bin',
                  'log_bin_basename', 'log_bin_index', 'log_bin_use_v1_row_events', 'log_slave_updates',
                  'lower_case_file_system', 'lower_case_table_names', 'max_digest_length', 'mecab_rc_file',
                  'metadata_locks_cache_size', 'metadata_locks_hash_instances', 'myisam_mmap_size',
                  'myisam_recover_options', 'mysqlx_bind_address', 'mysqlx_port', 'mysqlx_port_open_timeout',
                  'mysqlx_socket', 'mysqlx_ssl', 'mysqlx_ssl_ca', 'mysqlx_ssl_capath', 'mysqlx_ssl_cert',
                  'mysqlx_ssl_cipher', 'mysqlx_ssl_crl', 'mysqlx_ssl_crlpath', 'mysqlx_ssl_key', 'named_pipe',
                  'ndb_batch_size', 'ndb_cluster_connection_pool', 'ndb_cluster_connection_pool_nodeids',
                  'ndb_log_apply_status', 'ndb_log_transaction_id', 'ndb_optimized_node_selection',
                  'Ndb_slave_max_replicated_epoch', 'ndb_version', 'ndb_version_string', 'ndb_wait_setup',
                  'ndbinfo_database', 'ndbinfo_version', 'ngram_token_size', 'old', 'open_files_limit',
                  'performance_schema', 'performance_schema_accounts_size', 'performance_schema_digests_size',
                  'performance_schema_error_size', 'performance_schema_events_stages_history_long_size',
                  'performance_schema_events_stages_history_size', 'performance_schema_events_statements_history_long_size',
                  'performance_schema_events_statements_history_size', 'performance_schema_events_transactions_history_long_size',
                  'performance_schema_events_transactions_history_size', 'performance_schema_events_waits_history_long_size',
                  'performance_schema_events_waits_history_size', 'performance_schema_hosts_size',
                  'performance_schema_max_cond_classes', 'performance_schema_max_cond_instances',
                  'performance_schema_max_digest_length', 'performance_schema_max_file_classes',
                  'performance_schema_max_file_handles', 'performance_schema_max_file_instances',
                  'performance_schema_max_index_stat', 'performance_schema_max_memory_classes', 'performance_schema_max_metadata_locks',
                  'performance_schema_max_mutex_classes', 'performance_schema_max_mutex_instances',
                  'performance_schema_max_prepared_statements_instances', 'performance_schema_max_program_instances',
                  'performance_schema_max_rwlock_classes', 'performance_schema_max_rwlock_instances',
                  'performance_schema_max_socket_classes', 'performance_schema_max_socket_instances',
                  'performance_schema_max_sql_text_length', 'performance_schema_max_stage_classes',
                  'performance_schema_max_statement_classes', 'performance_schema_max_statement_stack',
                  'performance_schema_max_table_handles', 'performance_schema_max_table_instances',
                  'performance_schema_max_table_lock_stat', 'performance_schema_max_thread_classes',
                  'performance_schema_max_thread_instances', 'performance_schema_session_connect_attrs_size',
                  'performance_schema_setup_actors_size', 'performance_schema_setup_objects_size',
                  'performance_schema_users_size', 'persisted_globals_load', 'pid_file', 'plugin_dir',
                  'port', 'protocol_version', 'relay_log', 'relay_log_basename', 'relay_log_index',
                  'relay_log_info_file', 'relay_log_recovery', 'relay_log_space_limit', 'server_uuid',
                  'sha256_password_auto_generate_rsa_keys', 'sha256_password_private_key_path', 'sha256_password_public_key_path',
                  'shared_memory', 'shared_memory_base_name', 'skip_external_locking', 'skip_name_resolve',
                  'skip_networking', 'skip_show_database', 'slave_load_tmpdir', 'slave_type_conversions',
                  'socket', 'ssl_ca', 'ssl_capath', 'ssl_cert', 'ssl_cipher', 'ssl_crl', 'ssl_crlpath',
                  'ssl_key', 'system_time_zone', 'table_open_cache_instances', 'thread_handling', 'thread_stack',
                  'time_format', 'tls_version', 'tmpdir', 'version', 'version_comment', 'version_compile_machine',
                  'version_compile_os', 'version_tokens_session_number', 'report_host', 'report_port',
                  'report_password', 'report_user', 'daemon_memcached_option', '',
                  'From the above list we will allow following list of variables to be persisted.',
                  'audit_log_buffer_size', 'audit_log_policy', 'audit_log_strategy', 'back_log',
                  'binlog_gtid_simple_recovery', 'daemon_memcached_enable_binlog', 'daemon_memcached_r_batch_size',
                  'daemon_memcached_w_batch_size', 'date_format', 'datetime_format', 'disabled_storage_engines',
                  'ft_max_word_len', 'ft_min_word_len', 'ft_query_expansion_limit', 'ignore_builtin_innodb',
                  'innodb_adaptive_hash_index_parts', 'innodb_api_disable_rowlock', 'innodb_api_enable_binlog',
                  'innodb_api_enable_mdl', 'innodb_autoinc_lock_mode', 'innodb_buffer_pool_chunk_size',
                  'innodb_buffer_pool_debug', 'innodb_buffer_pool_instances', 'innodb_doublewrite',
                  'innodb_flush_method', 'innodb_force_recovery', 'innodb_ft_cache_size', 'innodb_ft_max_token_size',
                  'innodb_ft_min_token_size', 'innodb_ft_sort_pll_degree', 'innodb_ft_total_cache_size',
                  'innodb_log_buffer_size', 'innodb_log_file_size', 'innodb_log_files_in_group', 'innodb_numa_interleave',
                  'innodb_open_files', 'innodb_page_cleaners', 'innodb_purge_threads', 'innodb_read_io_threads',
                  'innodb_rollback_on_timeout', 'innodb_sort_buffer_size', 'innodb_sync_array_size',
                  'innodb_sync_debug', 'innodb_use_native_aio', 'innodb_write_io_threads', 'large_pages',
                  'log_slave_updates', 'lower_case_table_names', 'max_digest_length', 'metadata_locks_cache_size',
                  'metadata_locks_hash_instances', 'myisam_mmap_size', 'myisam_recover_options', 'mysqlx_bind_address',
                  'mysqlx_port', 'mysqlx_port_open_timeout', 'mysqlx_socket', 'mysqlx_ssl', 'mysqlx_ssl_ca',
                  'mysqlx_ssl_capath', 'mysqlx_ssl_cert', 'mysqlx_ssl_cipher', 'mysqlx_ssl_crl', 'mysqlx_ssl_crlpath',
                  'mysqlx_ssl_key', 'ndb_batch_size', 'ndb_cluster_connection_pool', 'ndb_cluster_connection_pool_nodeids',
                  'ndb_log_apply_status', 'ndb_log_transaction_id', 'ndb_optimized_node_selection',
                  'Ndb_slave_max_replicated_epoch', 'ndb_wait_setup', 'ndbinfo_database', 'ngram_token_size',
                  'old', 'open_files_limit', 'performance_schema', 'performance_schema_accounts_size',
                  'performance_schema_digests_size', 'performance_schema_error_size', 'performance_schema_events_stages_history_long_size',
                  'performance_schema_events_stages_history_size', 'performance_schema_events_statements_history_long_size',
                  'performance_schema_events_statements_history_size', 'performance_schema_events_transactions_history_long_size',
                  'performance_schema_events_transactions_history_size', 'performance_schema_events_waits_history_long_size',
                  'performance_schema_events_waits_history_size', 'performance_schema_hosts_size',
                  'performance_schema_max_cond_classes', 'performance_schema_max_cond_instances', 'performance_schema_max_digest_length',
                  'performance_schema_max_file_classes', 'performance_schema_max_file_handles', 'performance_schema_max_file_instances',
                  'performance_schema_max_index_stat', 'performance_schema_max_memory_classes', 'performance_schema_max_metadata_locks',
                  'performance_schema_max_mutex_classes', 'performance_schema_max_mutex_instances',
                  'performance_schema_max_prepared_statements_instances', 'performance_schema_max_program_instances',
                  'performance_schema_max_rwlock_classes', 'performance_schema_max_rwlock_instances',
                  'performance_schema_max_socket_classes', 'performance_schema_max_socket_instances',
                  'performance_schema_max_sql_text_length', 'performance_schema_max_stage_classes',
                  'performance_schema_max_statement_classes', 'performance_schema_max_statement_stack',
                  'performance_schema_max_table_handles', 'performance_schema_max_table_instances',
                  'performance_schema_max_table_lock_stat', 'performance_schema_max_thread_classes',
                  'performance_schema_max_thread_instances', 'performance_schema_session_connect_attrs_size',
                  'performance_schema_setup_actors_size', 'performance_schema_setup_objects_size',
                  'performance_schema_users_size', 'relay_log_recovery', 'relay_log_space_limit',
                  'skip_name_resolve', 'skip_show_database', 'slave_type_conversions', 'ssl_cipher',
                  'table_open_cache_instances', 'thread_handling', 'thread_stack', 'time_format',
                  'tls_version', 'report_host', 'report_port', 'report_password', 'report_user']
    