import { MatrixUser } from "matrix-appservice-bridge";
export interface IrcClientConfigSeralized {
    username?: string;
    password?: string;
    nick?: string;
    ipv6?: string;
}
/**
 * Contains IRC client configuration, mostly set by Matrix users. Used to configure
 * IrcUsers.
 */
export declare class IrcClientConfig {
    userId: string | null;
    domain: string;
    private config;
    /**
     * Construct an IRC Client Config.
     * @param {string} userId The user ID who is configuring this config.
     * @param {string} domain The IRC network domain for the IRC client
     * @param {Object} configObj Serialised config information if known.
     */
    constructor(userId: string | null, domain: string, config?: IrcClientConfigSeralized);
    getDomain(): string;
    getUserId(): string | null;
    setUsername(uname: string): void;
    getUsername(): string | undefined;
    setPassword(password?: string): void;
    getPassword(): string | undefined;
    setDesiredNick(nick: string): void;
    getDesiredNick(): string | undefined;
    setIpv6Address(address: string): void;
    getIpv6Address(): string | undefined;
    serialize(removePassword?: boolean): any;
    toString(): string;
    static newConfig(matrixUser: MatrixUser | null, domain: string, nick?: string, username?: string, password?: string): IrcClientConfig;
}
