/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils.fileUtils;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003\u00a8\u0006\n"}, d2={"withReplacedExtensionOrNull", "Ljava/io/File;", "oldExt", "", "newExt", "descendantRelativeTo", "base", "resolveSymlinksGracefully", "Ljava/nio/file/Path;", "rawPath", "util"})
@SourceDebugExtension(value={"SMAP\nfileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 fileUtils.kt\norg/jetbrains/kotlin/utils/fileUtils/FileUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class FileUtilsKt {
    @Nullable
    public static final File withReplacedExtensionOrNull(@NotNull File $this$withReplacedExtensionOrNull, @NotNull String oldExt, @NotNull String newExt) {
        Intrinsics.checkNotNullParameter($this$withReplacedExtensionOrNull, "<this>");
        Intrinsics.checkNotNullParameter(oldExt, "oldExt");
        Intrinsics.checkNotNullParameter(newExt, "newExt");
        String string = $this$withReplacedExtensionOrNull.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        if (StringsKt.endsWith$default(string, oldExt, false, 2, null)) {
            String path = $this$withReplacedExtensionOrNull.getPath();
            Intrinsics.checkNotNull(path);
            String string2 = path.substring(0, path.length() - oldExt.length());
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String pathWithoutExt = string2;
            String pathWithNewExt = pathWithoutExt + newExt;
            return new File(pathWithNewExt);
        }
        return null;
    }

    @NotNull
    public static final File descendantRelativeTo(@NotNull File $this$descendantRelativeTo, @NotNull File base) {
        Intrinsics.checkNotNullParameter($this$descendantRelativeTo, "<this>");
        Intrinsics.checkNotNullParameter(base, "base");
        boolean bl = base.isAbsolute();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FileUtilsKt$descendantRelativeTo$32 = false;
            String $i$a$-assert-FileUtilsKt$descendantRelativeTo$32 = String.valueOf(base);
            throw new AssertionError((Object)$i$a$-assert-FileUtilsKt$descendantRelativeTo$32);
        }
        bl = base.isDirectory();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FileUtilsKt$descendantRelativeTo$42 = false;
            String $i$a$-assert-FileUtilsKt$descendantRelativeTo$42 = String.valueOf(base);
            throw new AssertionError((Object)$i$a$-assert-FileUtilsKt$descendantRelativeTo$42);
        }
        File cwd = FilesKt.normalize(base);
        File file = $this$descendantRelativeTo.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue(file, "getAbsoluteFile(...)");
        File filePath = FilesKt.normalize(file);
        return FilesKt.startsWith(filePath, cwd) ? FilesKt.relativeTo(filePath, cwd) : $this$descendantRelativeTo;
    }

    @NotNull
    public static final Path resolveSymlinksGracefully(@NotNull String rawPath) {
        Object object;
        Object object2;
        Path path;
        Intrinsics.checkNotNullParameter(rawPath, "rawPath");
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        if (StringsKt.contains$default((CharSequence)string, "Windows", false, 2, null) && StringsKt.startsWith$default(rawPath, "/", false, 2, null)) {
            Path path2 = Paths.get(StringsKt.removePrefix(rawPath, (CharSequence)"/"), new String[0]);
            path = path2;
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
        } else {
            Path path3 = Paths.get(rawPath, new String[0]);
            path = path3;
            Intrinsics.checkNotNullExpressionValue(path3, "get(...)");
        }
        Path correctedPath = path;
        try {
            boolean bl = false;
            object2 = Result.constructor-impl(correctedPath.toRealPath(new LinkOption[0]));
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable exception = throwable;
            boolean bl = false;
            if (!(exception instanceof IOException)) {
                throw exception;
            }
            object = Result.constructor-impl(Paths.get(rawPath, new String[0]));
        }
        object2 = object;
        ResultKt.throwOnFailure(object2);
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue(object3, "getOrThrow(...)");
        return (Path)object3;
    }
}

