/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.authentication.authenticators.util.LoAUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.ClaimsRepresentation;
import org.keycloak.util.JsonSerialization;

public class AcrUtils {
    private static final Logger LOGGER = Logger.getLogger(AcrUtils.class);

    public static List<String> getRequiredAcrValues(String claimsParam) {
        return AcrUtils.getAcrValues(claimsParam, null, true);
    }

    public static List<String> getAcrValues(String claimsParam, String acrValuesParam, ClientModel client) {
        List<String> acrValues = AcrUtils.getAcrValues(claimsParam, acrValuesParam, false);
        if (acrValues.isEmpty()) {
            acrValues = AcrUtils.getDefaultAcrValues(client);
        }
        return AcrUtils.enforceMinimumAcr(acrValues, client);
    }

    public static List<String> enforceMinimumAcr(List<String> acrValues, ClientModel client) {
        String minimumAcr = AcrUtils.getMinimumAcrValue(client);
        if (minimumAcr != null) {
            ArrayList<String> acrCopy = new ArrayList<String>(acrValues);
            Map<String, Integer> acrMap = AcrUtils.getAcrLoaMap(client);
            Integer minimumLoa = AcrUtils.getLoaForAcr(minimumAcr, acrMap, client);
            if (minimumLoa == null) {
                LOGGER.warnf("ACR '%s' can not be mapped to a LoA value.", (Object)minimumAcr);
            } else {
                Iterator iterator = acrCopy.iterator();
                while (iterator.hasNext()) {
                    String acrValue = (String)iterator.next();
                    Integer loa = AcrUtils.getLoaForAcr(acrValue, acrMap, client);
                    if (loa == null) {
                        LOGGER.warnf("ACR '%s' can not be mapped to a LoA value.", (Object)acrValue);
                        iterator.remove();
                        continue;
                    }
                    if (loa >= minimumLoa) continue;
                    iterator.remove();
                }
                if (acrCopy.isEmpty()) {
                    acrCopy.add(minimumAcr);
                }
            }
            return acrCopy;
        }
        return acrValues;
    }

    private static Integer getLoaForAcr(String acr, Map<String, Integer> acrMap, ClientModel client) {
        Optional<Integer> loaFromFlows;
        Integer loa = acrMap.get(acr);
        if (loa == null && (loaFromFlows = LoAUtil.getLoAConfiguredInRealmBrowserFlow(client.getRealm()).filter(l -> acr.equals(String.valueOf(l))).findFirst()).isPresent()) {
            loa = loaFromFlows.get();
        }
        return loa;
    }

    private static List<String> getAcrValues(String claimsParam, String acrValuesParam, boolean essential) {
        ArrayList<String> acrValues = new ArrayList<String>();
        if (acrValuesParam != null && !essential) {
            acrValues.addAll(Arrays.asList(acrValuesParam.split(" ")));
        }
        if (claimsParam != null) {
            try {
                ClaimsRepresentation claims = (ClaimsRepresentation)JsonSerialization.readValue((String)claimsParam, ClaimsRepresentation.class);
                if (claims == null) {
                    LOGGER.warnf("Invalid claims parameter. Claims parameter should be JSON", new Object[0]);
                } else {
                    ClaimsRepresentation.ClaimValue acrClaim = claims.getClaimValue("acr", ClaimsRepresentation.ClaimContext.ID_TOKEN, String.class);
                    if (acrClaim != null && (!essential || acrClaim.isEssential())) {
                        if (acrClaim.getValues() != null) {
                            acrValues.addAll(acrClaim.getValues());
                        } else if (acrClaim.getValue() != null) {
                            acrValues.add((String)acrClaim.getValue());
                        }
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Invalid claims parameter", (Throwable)e);
            }
        }
        return acrValues;
    }

    public static Map<String, Integer> getAcrLoaMap(ClientModel client) {
        Map<String, Integer> result = AcrUtils.getAcrLoaMapForClientOnly(client);
        if (result.isEmpty()) {
            return AcrUtils.getAcrLoaMap(client.getRealm());
        }
        return result;
    }

    private static Map<String, Integer> getAcrLoaMapForClientOnly(ClientModel client) {
        String map = client.getAttribute("acr.loa.map");
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JsonSerialization.readValue((String)map, (TypeReference)new TypeReference<Map<String, Integer>>(){});
        }
        catch (IOException e) {
            LOGGER.warnf("Invalid client configuration (ACR-LOA map) for client '%s'. Error details: %s", (Object)client.getClientId(), (Object)e.getMessage());
            return Collections.emptyMap();
        }
    }

    public static Map<String, Integer> getAcrLoaMap(RealmModel realm) {
        String map = realm.getAttribute("acr.loa.map");
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JsonSerialization.readValue((String)map, (TypeReference)new TypeReference<Map<String, Integer>>(){});
        }
        catch (IOException e) {
            LOGGER.warnf("Invalid realm configuration (ACR-LOA map). Details: %s", (Object)e.getMessage());
            return Collections.emptyMap();
        }
    }

    public static String mapLoaToAcr(int loa, Map<String, Integer> acrLoaMap, Collection<String> acrValues) {
        String acr = null;
        if (!acrLoaMap.isEmpty() && !acrValues.isEmpty()) {
            int maxLoa = -1;
            for (String acrValue : acrValues) {
                Integer mappedLoa = acrLoaMap.get(acrValue);
                if (mappedLoa == null) {
                    try {
                        mappedLoa = Integer.parseInt(acrValue);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warnf("Acr value '%s' cannot be mapped to int", (Object)acrValue);
                    }
                }
                if (mappedLoa == null || mappedLoa <= maxLoa || loa < mappedLoa) continue;
                acr = acrValue;
                maxLoa = mappedLoa;
            }
        }
        return acr;
    }

    public static List<String> getDefaultAcrValues(ClientModel client) {
        return OIDCAdvancedConfigWrapper.fromClientModel(client).getAttributeMultivalued("default.acr.values");
    }

    public static String getMinimumAcrValue(ClientModel client) {
        return OIDCAdvancedConfigWrapper.fromClientModel(client).getMinimumAcrValue();
    }
}

