/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import org.hibernate.AssertionFailure;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.query.SortDirection;

public enum NullPrecedence {
    NONE,
    FIRST,
    LAST;


    public boolean isDefaultOrdering(SortDirection sortOrder, NullOrdering nullOrdering) {
        switch (this) {
            case NONE: {
                return true;
            }
            case FIRST: {
                switch (nullOrdering) {
                    case FIRST: {
                        return true;
                    }
                    case LAST: {
                        return false;
                    }
                    case SMALLEST: {
                        return sortOrder == SortDirection.ASCENDING;
                    }
                    case GREATEST: {
                        return sortOrder == SortDirection.DESCENDING;
                    }
                }
                throw new AssertionFailure("Unrecognized NullOrdering");
            }
            case LAST: {
                switch (nullOrdering) {
                    case LAST: {
                        return true;
                    }
                    case FIRST: {
                        return false;
                    }
                    case SMALLEST: {
                        return sortOrder == SortDirection.DESCENDING;
                    }
                    case GREATEST: {
                        return sortOrder == SortDirection.ASCENDING;
                    }
                }
                throw new AssertionFailure("Unrecognized NullOrdering");
            }
        }
        throw new AssertionFailure("Unrecognized NullPrecedence");
    }

    public static NullPrecedence parse(String name) {
        for (NullPrecedence value : NullPrecedence.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public static NullPrecedence parse(String name, NullPrecedence defaultValue) {
        NullPrecedence value = NullPrecedence.parse(name);
        return value != null ? value : defaultValue;
    }
}

