/*
 * Decompiled with CFR 0.152.
 */
package sun.security.acl;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;

public class GroupImpl
implements Group {
    private Vector<Principal> groupMembers = new Vector(50, 100);
    private String group;

    public GroupImpl(String string) {
        this.group = string;
    }

    @Override
    public boolean addMember(Principal principal) {
        if (this.groupMembers.contains(principal)) {
            return false;
        }
        if (this.group.equals(principal.toString())) {
            throw new IllegalArgumentException();
        }
        this.groupMembers.addElement(principal);
        return true;
    }

    @Override
    public boolean removeMember(Principal principal) {
        return this.groupMembers.removeElement(principal);
    }

    @Override
    public Enumeration<? extends Principal> members() {
        return this.groupMembers.elements();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Group)) {
            return false;
        }
        Group group = (Group)object;
        return this.group.equals(group.toString());
    }

    public boolean equals(Group group) {
        return this.equals((Object)group);
    }

    @Override
    public String toString() {
        return this.group;
    }

    @Override
    public int hashCode() {
        return this.group.hashCode();
    }

    @Override
    public boolean isMember(Principal principal) {
        if (this.groupMembers.contains(principal)) {
            return true;
        }
        Vector<Group> vector = new Vector<Group>(10);
        return this.isMemberRecurse(principal, vector);
    }

    @Override
    public String getName() {
        return this.group;
    }

    boolean isMemberRecurse(Principal principal, Vector<Group> vector) {
        Enumeration<? extends Principal> enumeration = this.members();
        while (enumeration.hasMoreElements()) {
            Group group;
            boolean bl = false;
            Principal principal2 = enumeration.nextElement();
            if (principal2.equals(principal)) {
                return true;
            }
            if (principal2 instanceof GroupImpl) {
                group = (GroupImpl)principal2;
                vector.addElement(this);
                if (!vector.contains(group)) {
                    bl = ((GroupImpl)group).isMemberRecurse(principal, vector);
                }
            } else if (principal2 instanceof Group && !vector.contains(group = (Group)principal2)) {
                bl = group.isMember(principal);
            }
            if (!bl) continue;
            return bl;
        }
        return false;
    }
}

