#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.42.1
visibility:           public
id:                   hledger-1.42.1-FrjxBZoOPIrDA1kAvdmCZ9
key:                  hledger-1.42.1-FrjxBZoOPIrDA1kAvdmCZ9
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  579c4b7fd8d6dff3dac073371a295725
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Stats Hledger.Cli.Commands.Tags
    Hledger.Cli.CompoundBalanceCommand Hledger.Cli.Conf
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.42.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.42.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.42.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.42.1-FrjxBZoOPIrDA1kAvdmCZ9
depends:
    Decimal-0.5.2-JJnAxbNB1tGBgDhgIz1FwP
    Diff-0.5-A8nvOVmSsh0JkAblhshgiC aeson-2.1.2.1-nTcMAwSjFOFbKrX5mWkol
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 extra-1.7.16-74Y9X6JFoGGAtiav1DDKW7
    filepath-1.4.2.2 githash-0.1.6.3-1j6aIIUg6lIDTgLjlwqL8
    hashable-1.4.6.0-AnOmtRToJbI9DS9f6Gdy0i haskeline-0.8.2
    hledger-lib-1.42.1-BoPBl91aBElEB6PCzAFH4P
    lucid-2.11.20250303-IvBKUltVeGNAVlrDd9eIk1
    math-functions-0.3.4.4-DJnG5JBeiOluJInMRHQpa
    megaparsec-9.7.0-30CmWzNYqun9hcXpVgYg36
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    modern-uri-0.3.6.1-IJrgpiEcPJv2jYFSQ9GpCC mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-F8VKcYSaovZCBcCO9TwdYz
    safe-0.3.21-JtmveFmtp7AKwHntYKRiun
    shakespeare-2.1.4-A1Hf81MWlINK8fFkSg654L
    split-0.2.5-Jw4n4gsdaZK4FHILOCxPWx
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5.2-CkViqWwtJin1eNhDHTt6f
    temporary-1.3-C918ulOBEkN7TRyvGivete text-2.0.2
    text-ansi-0.3.0.1-HouYJGynawBLHUZzXFUCPf time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-KDi8IgRcOV5HCm7hBAqDWV
    utf8-string-1.0.2-JqS4SAQdze6LQzXf6ug2xB
    utility-ht-0.0.17.2-1DGVw0gDQGgAL2vXBNYQOk
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

