#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-D0dkEyrBqPqD3zSURJLY5l
key:                  trifecta-2.1.4-D0dkEyrBqPqD3zSURJLY5l
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  c35eaba902e3085234c1d514f2700736
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-D0dkEyrBqPqD3zSURJLY5l
depends:
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-1jE2jTKoqGH3aj9MBDpFLw
    blaze-html-0.9.2.0-7ZP6TBGCXvM5msBno7uCel
    blaze-markup-0.8.3.0-9mvKITBBxoCAOVptmmL5Cl bytestring-0.11.5.3
    charset-0.3.12-HI0REiCCTpyBtRFpI2yBTA
    comonad-5.0.9-JEfnV9aNCafDUYw52R0uoy containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-1OLHvhEE6IQ7FU5Ez7xPTM
    ghc-prim-0.9.1 hashable-1.4.6.0-AnOmtRToJbI9DS9f6Gdy0i
    indexed-traversable-0.1.4-9hXlgoaGrHXBpvZrKSRx7V
    lens-5.3.2-fiszOW9VlT8rCDJtY0rRn mtl-2.2.2
    parsers-0.12.12-83jSz45EDl73E74vH64Y3m
    prettyprinter-1.7.1-AF4Gt6IhKUy3k7s13EBNuD
    prettyprinter-ansi-terminal-1.1.3-FQisb84CsPW4gsLLZgiBMq
    profunctors-5.6.3-7TRwcGddoPPIDmu5JRrCKe
    reducers-3.12.5-3VETzBHFw0MAkorUcVoGUF transformers-0.5.6.2
    unordered-containers-0.2.20-KDi8IgRcOV5HCm7hBAqDWV
    utf8-string-1.0.2-JqS4SAQdze6LQzXf6ug2xB

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

