#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 base-prelude
version:              1.6.1.1
visibility:           public
id:                   base-prelude-1.6.1.1-GKFFatabSp72iGYTIzDMDA
key:                  base-prelude-1.6.1.1-GKFFatabSp72iGYTIzDMDA
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/base-prelude
synopsis:             Featureful preludes formed solely from the "base" package
description:
    A library which aims to reexport all the non-conflicting and
    most general definitions from the \"base\" package.
    This includes APIs for applicatives, arrows, monoids, foldables, traversables,
    exceptions, generics, ST, MVars and STM.
    This package will never have any dependencies other than \"base\".
    Besides a rich prelude it provides limited ones like "BasePrelude.DataTypes",
    which only exports the data-types defined across the \"base\" package,
    and "BasePrelude.Operators", which only exports the common operators.
    /Versioning policy/
    The versioning policy of this package deviates from PVP in the sense
    that its exports in part are transitively determined by the version of \"base\".
    Therefore it'\''s recommended for the users of \"base-prelude\" to specify
    the bounds of \"base\" as well.

category:             Prelude
abi:                  cb5fb7fdc602f9a6f08f8fe149615194
exposed:              True
exposed-modules:
    BasePrelude BasePrelude.DataTypes BasePrelude.Operators

import-dirs:          /usr/lib/ghc-9.4.8/site-local/base-prelude-1.6.1.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/base-prelude-1.6.1.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/base-prelude-1.6.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-base-prelude
hs-libraries:         HSbase-prelude-1.6.1.1-GKFFatabSp72iGYTIzDMDA
depends:              base-4.17.2.1
haddock-interfaces:
    /usr/share/doc/haskell-base-prelude/html/base-prelude.haddock

haddock-html:         /usr/share/doc/haskell-base-prelude/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

