/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.util.Path;

public final class TaskIdentity<T extends Task> {
    @Deprecated
    public final Class<T> type;
    @Deprecated
    public final String name;
    @Deprecated
    public final Path projectPath;
    @Deprecated
    public final Path identityPath;
    @Deprecated
    public final Path buildPath;
    @Deprecated
    public final long uniqueId;
    private final ProjectIdentity projectIdentity;

    TaskIdentity(Class<T> type, String name, ProjectIdentity projectIdentity, long uniqueId) {
        this.name = name;
        this.type = type;
        this.projectIdentity = projectIdentity;
        this.uniqueId = uniqueId;
        this.projectPath = projectIdentity.getProjectPath().child(name);
        this.identityPath = projectIdentity.getBuildTreePath().child(name);
        this.buildPath = projectIdentity.getBuildPath();
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.uniqueId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskIdentity that = (TaskIdentity)o;
        return this.uniqueId == that.uniqueId;
    }

    public int hashCode() {
        return Long.hashCode(this.uniqueId);
    }

    public String toString() {
        return "TaskIdentity{path=" + this.identityPath + ", type=" + this.type + ", uniqueId=" + this.uniqueId + '}';
    }

    public Path getPath() {
        return this.projectPath;
    }

    public Path getBuildTreePath() {
        return this.identityPath;
    }

    @Deprecated
    public String getTaskPath() {
        return this.getPath().getPath();
    }

    @Deprecated
    public String getProjectPath() {
        return this.getProjectIdentity().getProjectPath().getPath();
    }

    @Deprecated
    public String getIdentityPath() {
        return this.getBuildTreePath().getPath();
    }

    @Deprecated
    public String getBuildPath() {
        return this.getProjectIdentity().getBuildPath().getPath();
    }

    public Class<T> getTaskType() {
        return this.type;
    }

    public ProjectIdentity getProjectIdentity() {
        return this.projectIdentity;
    }
}

