/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.SecurityHelper;
import io.sf.carte.echosvg.script.rhino.RhinoClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import org.mozilla.javascript.WrappedException;

class SMSecurityHelper
extends SecurityHelper {
    @Override
    Object runPrivilegedAction(PrivilegedAction<?> privilegedAction) {
        try {
            return AccessController.doPrivileged(privilegedAction);
        }
        catch (Exception exception) {
            throw new WrappedException((Throwable)exception);
        }
    }

    @Override
    Object runPrivilegedAction(PrivilegedAction<?> privilegedAction, Object object) {
        AccessControlContext accessControlContext;
        if (object instanceof AccessControlContext) {
            accessControlContext = (AccessControlContext)object;
        } else {
            RhinoClassLoader rhinoClassLoader = (RhinoClassLoader)object;
            accessControlContext = (AccessControlContext)rhinoClassLoader.getAccessControlObject();
        }
        try {
            return AccessController.doPrivileged(privilegedAction, accessControlContext);
        }
        catch (Exception exception) {
            throw new WrappedException((Throwable)exception);
        }
    }

    @Override
    PermissionCollection getPermissions(CodeSource codeSource) {
        Policy policy = Policy.getPolicy();
        PermissionCollection permissionCollection = null;
        if (policy != null) {
            permissionCollection = policy.getPermissions(codeSource);
        }
        return permissionCollection;
    }
}

