/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;

public class ShellContextFactory
extends ContextFactory {
    private boolean strictMode;
    private boolean warningAsError;
    private int languageVersion = 180;
    private int optimizationLevel;
    private boolean generatingDebug;
    private boolean allowReservedKeywords = true;
    private ErrorReporter errorReporter;
    private String characterEncoding;

    @Override
    protected boolean hasFeature(Context context, int n) {
        switch (n) {
            case 8: 
            case 9: 
            case 11: {
                return this.strictMode;
            }
            case 3: {
                return this.allowReservedKeywords;
            }
            case 12: {
                return this.warningAsError;
            }
            case 10: {
                return this.generatingDebug;
            }
        }
        return super.hasFeature(context, n);
    }

    @Override
    protected void onContextCreated(Context context) {
        context.setLanguageVersion(this.languageVersion);
        context.setOptimizationLevel(this.optimizationLevel);
        if (this.errorReporter != null) {
            context.setErrorReporter(this.errorReporter);
        }
        context.setGeneratingDebug(this.generatingDebug);
        super.onContextCreated(context);
    }

    public void setStrictMode(boolean bl) {
        this.checkNotSealed();
        this.strictMode = bl;
    }

    public void setWarningAsError(boolean bl) {
        this.checkNotSealed();
        this.warningAsError = bl;
    }

    public void setLanguageVersion(int n) {
        Context.checkLanguageVersion(n);
        this.checkNotSealed();
        this.languageVersion = n;
    }

    public void setOptimizationLevel(int n) {
        Context.checkOptimizationLevel(n);
        this.checkNotSealed();
        this.optimizationLevel = n;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        this.errorReporter = errorReporter;
    }

    public void setGeneratingDebug(boolean bl) {
        this.generatingDebug = bl;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    public void setAllowReservedKeywords(boolean bl) {
        this.allowReservedKeywords = bl;
    }
}

