/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.InfixExpression;

public class ObjectProperty
extends InfixExpression {
    public void setNodeType(int n) {
        if (n != 107 && n != 155 && n != 156 && n != 167) {
            throw new IllegalArgumentException("invalid node type: " + n);
        }
        this.setType(n);
    }

    public ObjectProperty() {
        this.type = 107;
    }

    public ObjectProperty(int n) {
        super(n);
        this.type = 107;
    }

    public ObjectProperty(int n, int n2) {
        super(n, n2);
        this.type = 107;
    }

    public void setIsGetterMethod() {
        this.type = 155;
    }

    public boolean isGetterMethod() {
        return this.type == 155;
    }

    public void setIsSetterMethod() {
        this.type = 156;
    }

    public boolean isSetterMethod() {
        return this.type == 156;
    }

    public void setIsNormalMethod() {
        this.type = 167;
    }

    public boolean isNormalMethod() {
        return this.type == 167;
    }

    public boolean isMethod() {
        return this.isGetterMethod() || this.isSetterMethod() || this.isNormalMethod();
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append(this.makeIndent(n + 1));
        if (this.isGetterMethod()) {
            stringBuilder.append("get ");
        } else if (this.isSetterMethod()) {
            stringBuilder.append("set ");
        }
        stringBuilder.append(this.left.toSource(this.getType() == 107 ? 0 : n));
        if (this.type == 107) {
            stringBuilder.append(": ");
        }
        stringBuilder.append(this.right.toSource(this.getType() == 107 ? 0 : n + 1));
        return stringBuilder.toString();
    }
}

