/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.color.Illuminants;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.A98RGBColorProfile;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ChromaticAdaption;
import io.sf.carte.doc.style.css.property.ColorFunction;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ColorSpaceHelper;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.DisplayP3ColorProfile;
import io.sf.carte.doc.style.css.property.LinearSRGBColorProfile;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProPhotoRGBColorProfile;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.Rec2020ColorProfile;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.jclf.math.linear3.Matrices;
import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.DOMException;

class ProfiledRGBColor
extends RGBColor {
    private static final long serialVersionUID = 1L;
    private final String colorSpace;
    private final BaseColor.Space space;

    ProfiledRGBColor(String string) {
        this.colorSpace = string;
        this.space = ColorSpaceHelper.rgbSpaceEnum(string);
    }

    ProfiledRGBColor(ProfiledRGBColor profiledRGBColor) {
        super(profiledRGBColor);
        this.colorSpace = profiledRGBColor.colorSpace;
        this.space = profiledRGBColor.space;
    }

    @Override
    public String getColorSpace() {
        return this.colorSpace;
    }

    @Override
    BaseColor.Space getSpace() {
        return this.space;
    }

    @Override
    PrimitiveValue enforceColorComponentType(PrimitiveValue primitiveValue) {
        return ColorFunction.enforceColorComponentType(primitiveValue);
    }

    @Override
    double rgbComponentNormalized(TypedValue typedValue) {
        double d;
        short s = typedValue.getUnitType();
        if (s == 2) {
            d = (double)typedValue.getFloatValue((short)2) * 0.01;
        } else if (s == 0) {
            d = typedValue.getFloatValue((short)0);
        } else if (typedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            d = 0.0;
        } else {
            throw new DOMException(17, "Wrong component: " + typedValue.getCssText());
        }
        return d;
    }

    @Override
    void setColorComponents(double[] dArray) {
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)0, (float)dArray[0]);
        numberValue.setSubproperty(true);
        numberValue.setAbsolutizedUnit();
        numberValue.setMaximumFractionDigits(4);
        this.setRed(numberValue);
        NumberValue numberValue2 = new NumberValue();
        numberValue2.setFloatValue((short)0, (float)dArray[1]);
        numberValue2.setSubproperty(true);
        numberValue2.setAbsolutizedUnit();
        numberValue2.setMaximumFractionDigits(4);
        this.setGreen(numberValue2);
        NumberValue numberValue3 = new NumberValue();
        numberValue3.setFloatValue((short)0, (float)dArray[2]);
        numberValue3.setSubproperty(true);
        numberValue3.setAbsolutizedUnit();
        numberValue3.setMaximumFractionDigits(4);
        this.setBlue(numberValue3);
    }

    @Override
    public double[] toXYZ(Illuminant illuminant) {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double d = this.rgbComponentNormalized((TypedValue)this.getRed());
        double d2 = this.rgbComponentNormalized((TypedValue)this.getGreen());
        double d3 = this.rgbComponentNormalized((TypedValue)this.getBlue());
        double[] dArray = new double[3];
        switch (this.space) {
            case p3: {
                DisplayP3ColorProfile displayP3ColorProfile = new DisplayP3ColorProfile();
                d = displayP3ColorProfile.linearComponent(d);
                d2 = displayP3ColorProfile.linearComponent(d2);
                d3 = displayP3ColorProfile.linearComponent(d3);
                displayP3ColorProfile.linearRgbToXYZ(d, d2, d3, dArray);
                if (illuminant != Illuminant.D50) break;
                dArray = ColorUtil.d65xyzToD50(dArray);
                break;
            }
            case A98_RGB: {
                A98RGBColorProfile a98RGBColorProfile = new A98RGBColorProfile();
                d = ((ColorProfile)a98RGBColorProfile).linearComponent(d);
                d2 = ((ColorProfile)a98RGBColorProfile).linearComponent(d2);
                d3 = ((ColorProfile)a98RGBColorProfile).linearComponent(d3);
                a98RGBColorProfile.linearRgbToXYZ(d, d2, d3, dArray);
                if (illuminant != Illuminant.D50) break;
                dArray = ColorUtil.d65xyzToD50(dArray);
                break;
            }
            case ProPhoto_RGB: {
                ProPhotoRGBColorProfile proPhotoRGBColorProfile = new ProPhotoRGBColorProfile();
                d = ((ColorProfile)proPhotoRGBColorProfile).linearComponent(d);
                d2 = ((ColorProfile)proPhotoRGBColorProfile).linearComponent(d2);
                d3 = ((ColorProfile)proPhotoRGBColorProfile).linearComponent(d3);
                proPhotoRGBColorProfile.linearRgbToXYZ(d, d2, d3, dArray);
                if (illuminant != Illuminant.D65) break;
                dArray = ColorUtil.d50xyzToD65(dArray);
                break;
            }
            case Rec2020: {
                Rec2020ColorProfile rec2020ColorProfile = new Rec2020ColorProfile();
                d = ((ColorProfile)rec2020ColorProfile).linearComponent(d);
                d2 = ((ColorProfile)rec2020ColorProfile).linearComponent(d2);
                d3 = ((ColorProfile)rec2020ColorProfile).linearComponent(d3);
                rec2020ColorProfile.linearRgbToXYZ(d, d2, d3, dArray);
                if (illuminant != Illuminant.D50) break;
                dArray = ColorUtil.d65xyzToD50(dArray);
                break;
            }
            case Linear_sRGB: {
                LinearSRGBColorProfile linearSRGBColorProfile = new LinearSRGBColorProfile();
                linearSRGBColorProfile.linearRgbToXYZ(d, d2, d3, dArray);
                if (illuminant != Illuminant.D50) break;
                dArray = ColorUtil.d65xyzToD50(dArray);
                break;
            }
            case sRGB: {
                return super.toXYZ(illuminant);
            }
            default: {
                throw new DOMException(9, "Color space is not supported.");
            }
        }
        return dArray;
    }

    @Override
    public double[] toXYZ(double[] dArray) {
        double[] dArray2 = this.toNumberArray();
        ColorProfile colorProfile = this.getColorProfile();
        double[] dArray3 = new double[3];
        colorProfile.linearizeComponents(dArray2);
        colorProfile.linearRgbToXYZ(dArray2, dArray3);
        if (colorProfile.getIlluminant() == Illuminant.D50) {
            if (!Arrays.equals(Illuminants.whiteD50, dArray)) {
                double[][] dArray4 = new double[3][3];
                ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD50, dArray, dArray4);
                double[] dArray5 = new double[3];
                Matrices.multiplyByVector3((double[][])dArray4, (double[])dArray3, (double[])dArray5);
                dArray3 = dArray5;
            }
        } else if (!Arrays.equals(Illuminants.whiteD65, dArray)) {
            double[][] dArray6 = new double[3][3];
            ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD65, dArray, dArray6);
            double[] dArray7 = new double[3];
            Matrices.multiplyByVector3((double[][])dArray6, (double[])dArray3, (double[])dArray7);
            dArray3 = dArray7;
        }
        return dArray3;
    }

    private ColorProfile getColorProfile() {
        ColorProfile colorProfile;
        switch (this.space) {
            case sRGB: {
                colorProfile = new SRGBColorProfile();
                break;
            }
            case p3: {
                colorProfile = new DisplayP3ColorProfile();
                break;
            }
            case A98_RGB: {
                colorProfile = new A98RGBColorProfile();
                break;
            }
            case ProPhoto_RGB: {
                colorProfile = new ProPhotoRGBColorProfile();
                break;
            }
            case Rec2020: {
                colorProfile = new Rec2020ColorProfile();
                break;
            }
            case Linear_sRGB: {
                colorProfile = new LinearSRGBColorProfile();
                break;
            }
            default: {
                throw new DOMException(9, "Color space is not supported.");
            }
        }
        return colorProfile;
    }

    @Override
    double[] toSRGB(boolean bl) {
        double[] dArray;
        double[] dArray2 = null;
        if (this.space == BaseColor.Space.sRGB) {
            return super.toSRGB(bl);
        }
        if (this.space == BaseColor.Space.ProPhoto_RGB) {
            dArray2 = this.toXYZ(Illuminant.D50);
            dArray = ColorUtil.d50xyzToD65(dArray2);
        } else {
            if (this.space == BaseColor.Space.Linear_sRGB) {
                return this.linearToSRGB();
            }
            dArray = this.toXYZ(Illuminant.D65);
        }
        double[] dArray3 = new double[3];
        ColorUtil.d65xyzToSRGB(dArray, dArray3);
        if (!ColorUtil.rangeRoundCheck(dArray3) && bl) {
            if (this.space != BaseColor.Space.ProPhoto_RGB) {
                dArray2 = ColorUtil.d65xyzToD50(dArray);
            }
            double[] dArray4 = new double[3];
            ColorUtil.xyzD50ToLab(dArray2, dArray4);
            SRGBColorProfile sRGBColorProfile = new SRGBColorProfile();
            ColorUtil.clampRGB(dArray4[0], dArray4[1], dArray4[2], sRGBColorProfile, dArray3);
        }
        return dArray3;
    }

    private double[] linearToSRGB() {
        double d = this.rgbComponentNormalized((TypedValue)this.getRed());
        double d2 = this.rgbComponentNormalized((TypedValue)this.getGreen());
        double d3 = this.rgbComponentNormalized((TypedValue)this.getBlue());
        double[] dArray = new double[]{ColorUtil.sRGBCompanding(d), ColorUtil.sRGBCompanding(d2), ColorUtil.sRGBCompanding(d3)};
        return dArray;
    }

    RGBColor toSRGBColor(boolean bl) {
        if (this.space == BaseColor.Space.sRGB) {
            return this;
        }
        double[] dArray = this.toSRGB(bl);
        RGBColor rGBColor = new RGBColor();
        rGBColor.setColorComponents(dArray);
        rGBColor.setAlpha(this.getAlpha().clone());
        return rGBColor;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("color(").append(this.getColorSpace()).append(' ');
        this.appendComponentCssText(stringBuilder, this.getRed()).append(' ');
        this.appendComponentCssText(stringBuilder, this.getGreen()).append(' ');
        this.appendComponentCssText(stringBuilder, this.getBlue());
        if (this.isNonOpaque()) {
            stringBuilder.append(" / ");
            this.appendAlphaChannel(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toMinifiedString() {
        StringBuilder stringBuilder = new StringBuilder(58);
        stringBuilder.append("color(").append(this.getColorSpace()).append(' ');
        this.appendComponentMinifiedCssText(stringBuilder, this.getRed()).append(' ');
        this.appendComponentMinifiedCssText(stringBuilder, this.getGreen()).append(' ');
        this.appendComponentMinifiedCssText(stringBuilder, this.getBlue());
        if (this.isNonOpaque()) {
            stringBuilder.append('/');
            this.appendAlphaChannelMinified(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + Objects.hash(this.colorSpace);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ProfiledRGBColor profiledRGBColor = (ProfiledRGBColor)object;
        return Objects.equals(this.colorSpace, profiledRGBColor.colorSpace);
    }

    @Override
    public ColorValue packInValue() {
        return new ColorFunction(this);
    }

    @Override
    public ProfiledRGBColor clone() {
        return new ProfiledRGBColor(this);
    }
}

