/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseShorthandSetter;
import io.sf.carte.doc.style.css.om.PendingValue;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import java.util.ArrayList;
import java.util.Collections;

class PendingSubstitutionSetter
extends BaseShorthandSetter {
    private boolean priorityImportant = false;
    private LexicalUnit lexicalValue = null;

    PendingSubstitutionSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration, String string) {
        super(baseCSSStyleDeclaration, string);
    }

    @Override
    public void init(LexicalUnit lexicalUnit, boolean bl) {
        this.lexicalValue = lexicalUnit;
        this.priorityImportant = bl;
    }

    @Override
    public boolean assignSubproperties() {
        String[] stringArray;
        PendingValue pendingValue = new PendingValue(this.getShorthandName(), this.lexicalValue);
        for (String string : stringArray = this.getLonghands()) {
            if (!this.priorityImportant && this.styleDeclaration.isPropertyImportant(string)) continue;
            this.styleDeclaration.setProperty(string, pendingValue, this.priorityImportant);
        }
        return true;
    }

    @Override
    public String getCssText() {
        return this.lexicalValue.toString();
    }

    String[] getLonghands() {
        String[] stringArray = this.getShorthandDatabase().getLonghandProperties(this.getShorthandName());
        if ("border".equals(this.getShorthandName())) {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 5);
            Collections.addAll(arrayList, stringArray);
            arrayList.add("border-image-source");
            arrayList.add("border-image-slice");
            arrayList.add("border-image-width");
            arrayList.add("border-image-outset");
            arrayList.add("border-image-repeat");
            stringArray = arrayList.toArray(new String[0]);
        } else if ("font".equals(this.getShorthandName())) {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 6);
            Collections.addAll(arrayList, stringArray);
            arrayList.add("font-variant-caps");
            arrayList.add("font-variant-ligatures");
            arrayList.add("font-variant-position");
            arrayList.add("font-variant-numeric");
            arrayList.add("font-variant-alternates");
            arrayList.add("font-variant-east-asian");
            stringArray = arrayList.toArray(new String[0]);
        }
        return stringArray;
    }

    @Override
    public ShorthandValue createCSSShorthandValue(LexicalUnit lexicalUnit) {
        return ShorthandValue.createCSSShorthandValue(this.getShorthandDatabase(), this.getShorthandName(), lexicalUnit, this.priorityImportant, false);
    }

    @Override
    public String getMinifiedCssText() {
        return LexicalValue.serializeMinifiedSequence(this.lexicalValue);
    }
}

