/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class MaskShorthandSetter
extends ShorthandSetter {
    private StringBuilder layerBuffer = null;
    private StringBuilder miniLayerBuffer = null;
    private int layerCount = 0;
    private final ValueList lstImage = ValueList.createCSValueList();
    private final ValueList lstPosition = ValueList.createCSValueList();
    private final ValueList lstSize = ValueList.createCSValueList();
    private final ValueList lstRepeat = ValueList.createCSValueList();
    private final ValueList lstClip = ValueList.createCSValueList();
    private final ValueList lstOrigin = ValueList.createCSValueList();
    private final ValueList lstMode = ValueList.createCSValueList();
    private final ValueList lstComposite = ValueList.createCSValueList();
    private LexicalUnit geometryBox = null;

    MaskShorthandSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super(baseCSSStyleDeclaration, "mask");
    }

    @Override
    public void init(LexicalUnit lexicalUnit, boolean bl) {
        this.currentValue = lexicalUnit;
        this.setPriority(bl);
        this.countLayers(lexicalUnit);
    }

    void countLayers(LexicalUnit lexicalUnit) {
        this.layerCount = 0;
        int n = 0;
        for (LexicalUnit lexicalUnit2 = lexicalUnit; lexicalUnit2 != null; lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) {
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (n <= 0) continue;
                ++this.layerCount;
                n = 0;
                continue;
            }
            ++n;
        }
        if (n > 0) {
            ++this.layerCount;
        }
    }

    @Override
    StringBuilder getValueItemBuffer() {
        return this.layerBuffer;
    }

    @Override
    StringBuilder getValueItemBufferMini() {
        return this.miniLayerBuffer;
    }

    @Override
    public boolean assignSubproperties() {
        this.layerBuffer = new StringBuilder(64);
        this.miniLayerBuffer = new StringBuilder(64);
        String[] stringArray = this.getShorthandSubproperties();
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        int n = 0;
        while (n < this.layerCount && this.currentValue != null) {
            Object object;
            boolean bl = false;
            hashSet.clear();
            Collections.addAll(hashSet, stringArray);
            while (this.currentValue != null) {
                if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if (!bl) break;
                    this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
                    this.layerBuffer.setLength(0);
                    this.miniLayerBuffer.setLength(0);
                    if (++n != this.layerCount) {
                        this.layerBuffer.append(',');
                        this.miniLayerBuffer.append(',');
                    }
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                    break;
                }
                object = this.currentValue.getLexicalUnitType();
                if (object == LexicalUnit.LexicalType.INHERIT || object == LexicalUnit.LexicalType.INITIAL || object == LexicalUnit.LexicalType.UNSET || object == LexicalUnit.LexicalType.REVERT) {
                    if (this.layerCount != 1 || n != 0 || this.currentValue.getNextLexicalUnit() != null) {
                        bl = false;
                        break;
                    }
                    StyleValue styleValue = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue();
                    this.setSubpropertiesToKeyword(styleValue);
                    this.appendValueItemString(styleValue);
                    this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
                    this.layerBuffer.setLength(0);
                    this.miniLayerBuffer.setLength(0);
                    return true;
                }
                bl = this.assignLayerValue(n, hashSet);
                if (bl) continue;
                this.reportUnknownValue(hashSet);
                break;
            }
            if (!bl) {
                this.layerBuffer.setLength(0);
                this.miniLayerBuffer.setLength(0);
                object = new StringBuilder(64);
                ((StringBuilder)object).append("Invalid layer found: ").append(n);
                if (this.currentValue != null) {
                    ((StringBuilder)object).append(' ').append(this.currentValue.toString());
                }
                this.reportDeclarationError("mask", ((StringBuilder)object).toString());
                return false;
            }
            this.assignPendingValues(n, hashSet);
            if (hashSet.size() <= 0) continue;
            this.resetUnsetProperties(hashSet);
        }
        this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
        this.setListSubpropertyValue("mask-image", this.lstImage);
        this.setListSubpropertyValue("mask-position", this.lstPosition);
        this.setListSubpropertyValue("mask-size", this.lstSize);
        this.setListSubpropertyValue("mask-origin", this.lstOrigin);
        this.setListSubpropertyValue("mask-clip", this.lstClip);
        this.setListSubpropertyValue("mask-repeat", this.lstRepeat);
        this.setListSubpropertyValue("mask-composite", this.lstComposite);
        this.setListSubpropertyValue("mask-mode", this.lstMode);
        this.resetMaskBorderProperties();
        this.flush();
        return true;
    }

    private boolean assignLayerValue(int n, Set<String> set) {
        boolean bl = false;
        if (set.contains("mask-image") && this.testImage(n, set)) {
            this.nextCurrentValue();
            bl = true;
        } else if (set.contains("mask-position") && this.testPosition(this.lstPosition)) {
            set.remove("mask-position");
            this.nextCurrentValue();
            bl = true;
            if (this.currentValue != null && LexicalUnit.LexicalType.OPERATOR_SLASH == this.currentValue.getLexicalUnitType()) {
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.testSize(n, set)) {
                    this.nextCurrentValue();
                } else {
                    StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
                    if (styleDeclarationErrorHandler != null) {
                        styleDeclarationErrorHandler.shorthandSyntaxError("mask", "Size not found after slash");
                    }
                    bl = false;
                }
            }
        } else if (set.contains("mask-mode") && this.testIdentifierProperty(n, set, "mask-mode", this.lstMode)) {
            this.nextCurrentValue();
            set.remove("mask-mode");
            bl = true;
        } else if (set.contains("mask-composite") && this.testIdentifierProperty(n, set, "mask-composite", this.lstComposite)) {
            this.nextCurrentValue();
            set.remove("mask-composite");
            bl = true;
        } else if (set.contains("mask-repeat") && this.testRepeat(this.lstRepeat)) {
            set.remove("mask-repeat");
            bl = true;
        } else if (set.contains("mask-origin") && this.testIdentifierProperty(n, set, "mask-origin", this.lstOrigin)) {
            this.geometryBox = this.currentValue;
            this.nextCurrentValue();
            set.remove("mask-origin");
            bl = true;
        } else if (set.contains("mask-clip") && this.testIdentifierProperty(n, set, "mask-clip", this.lstClip)) {
            this.nextCurrentValue();
            set.remove("mask-clip");
            this.geometryBox = null;
            bl = true;
        }
        return bl;
    }

    private void assignPendingValues(int n, Set<String> set) {
        if (set.contains("mask-clip") && this.geometryBox != null) {
            StyleValue styleValue = this.createCSSValue("mask-clip", this.geometryBox);
            this.lstClip.add(styleValue);
            set.remove("mask-clip");
        }
        this.geometryBox = null;
    }

    @Override
    protected void nextCurrentValue() {
        this.appendValueItemString();
        this.currentValue = this.currentValue.getNextLexicalUnit();
    }

    private void reportUnknownValue(Set<String> set) {
        BaseCSSDeclarationRule baseCSSDeclarationRule = this.styleDeclaration.getParentRule();
        if (baseCSSDeclarationRule != null) {
            StyleDeclarationErrorHandler styleDeclarationErrorHandler = baseCSSDeclarationRule.getStyleDeclarationErrorHandler();
            if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                styleDeclarationErrorHandler.unknownIdentifier("mask", this.currentValue.getStringValue());
            } else {
                LexicalUnit[] lexicalUnitArray = new LexicalUnit[]{this.currentValue};
                styleDeclarationErrorHandler.unassignedShorthandValues("mask", set.toArray(new String[0]), lexicalUnitArray);
            }
        }
    }

    private void resetUnsetProperties(Set<String> set) {
        for (String string : set) {
            StyleValue styleValue = this.defaultPropertyValue(string);
            if ("mask-image".equals(string)) {
                this.lstImage.add(styleValue);
                continue;
            }
            if ("mask-position".equals(string)) {
                this.lstPosition.add(styleValue);
                continue;
            }
            if ("mask-size".equals(string)) {
                ValueList valueList = ValueList.createWSValueList();
                valueList.add(styleValue);
                valueList.add(styleValue);
                this.lstSize.add(valueList);
                continue;
            }
            if ("mask-origin".equals(string)) {
                this.lstOrigin.add(styleValue);
                continue;
            }
            if ("mask-clip".equals(string)) {
                this.lstClip.add(styleValue);
                continue;
            }
            if ("mask-repeat".equals(string)) {
                this.lstRepeat.add(styleValue);
                continue;
            }
            if ("mask-mode".equals(string)) {
                this.lstMode.add(styleValue);
                continue;
            }
            if (!"mask-composite".equals(string)) continue;
            this.lstComposite.add(styleValue);
        }
    }

    private boolean testImage(int n, Set<String> set) {
        if (!this.isAttrTainted() && this.isImage()) {
            this.lstImage.add(this.createCSSValue("mask-image", this.currentValue));
            set.remove("mask-image");
            return true;
        }
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "none".equals(this.currentValue.getStringValue())) {
            this.lstImage.add(this.createCSSValue("mask-image", this.currentValue));
            set.remove("mask-image");
            return true;
        }
        return false;
    }

    private boolean testPosition(ValueList valueList) {
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.testIdentifiers("mask-position") || ValueFactory.isSizeSACUnit(this.currentValue)) {
            ValueList valueList2 = ValueList.createWSValueList();
            StyleValue styleValue = this.createCSSValue("mask-position", this.currentValue);
            valueList2.add(styleValue);
            int n = 1;
            LexicalUnit lexicalUnit = this.currentValue.getNextLexicalUnit();
            while (lexicalUnit != null && n < 4) {
                if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.getShorthandDatabase().isIdentifierValue("mask-position", lexicalUnit.getStringValue()) || ValueFactory.isSizeSACUnit(lexicalUnit)) {
                    styleValue = this.createCSSValue("mask-position", lexicalUnit);
                    valueList2.add(styleValue);
                    n = (short)(n + 1);
                    this.nextCurrentValue();
                    lexicalUnit = this.currentValue.getNextLexicalUnit();
                    continue;
                }
                lexicalUnit = null;
            }
            if (valueList2.getLength() == 1) {
                valueList.add(valueList2.item(0));
            } else if (this.checkPositionProperty(valueList2)) {
                valueList.add(valueList2);
            } else {
                BaseCSSDeclarationRule baseCSSDeclarationRule = this.styleDeclaration.getParentRule();
                if (baseCSSDeclarationRule != null) {
                    CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Wrong value for mask-position");
                    cSSPropertyValueException.setValueText(valueList2.getCssText());
                    baseCSSDeclarationRule.getStyleDeclarationErrorHandler().wrongValue("mask-position", cSSPropertyValueException);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkPositionProperty(ValueList valueList) {
        int n = valueList.getLength();
        if (n == 2) {
            return true;
        }
        if (n == 4) {
            return valueList.item(0).getPrimitiveType() == CSSValue.Type.IDENT && valueList.item(1).getPrimitiveType() != CSSValue.Type.IDENT && valueList.item(2).getPrimitiveType() == CSSValue.Type.IDENT && valueList.item(3).getPrimitiveType() != CSSValue.Type.IDENT;
        }
        if (valueList.item(0).getPrimitiveType() != CSSValue.Type.IDENT) {
            return false;
        }
        if (valueList.item(1).getPrimitiveType() == CSSValue.Type.IDENT && valueList.item(2).getPrimitiveType() != CSSValue.Type.IDENT) {
            return true;
        }
        return valueList.item(1).getPrimitiveType() != CSSValue.Type.IDENT && valueList.item(2).getPrimitiveType() == CSSValue.Type.IDENT;
    }

    private boolean testSize(int n, Set<String> set) {
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.testIdentifiers("mask-size") || ValueFactory.isSizeSACUnit(this.currentValue)) {
            ValueList valueList = ValueList.createWSValueList();
            StyleValue styleValue = this.createCSSValue("mask-size", this.currentValue);
            valueList.add(styleValue);
            this.layerBuffer.append(" /");
            this.miniLayerBuffer.append('/');
            LexicalUnit lexicalUnit = this.currentValue.getNextLexicalUnit();
            if (lexicalUnit != null && (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.getShorthandDatabase().isIdentifierValue("mask-size", lexicalUnit.getStringValue()) || ValueFactory.isSizeSACUnit(lexicalUnit))) {
                styleValue = this.createCSSValue("mask-size", lexicalUnit);
                valueList.add(styleValue);
                this.nextCurrentValue();
            }
            if (valueList.getLength() == 1) {
                this.lstSize.add(valueList.item(0));
            } else {
                this.lstSize.add(valueList);
            }
            set.remove("mask-size");
            return true;
        }
        return false;
    }

    private boolean testRepeat(ValueList valueList) {
        if (LexicalUnit.LexicalType.IDENT == this.currentValue.getLexicalUnitType() && this.testIdentifiers("mask-repeat")) {
            StyleValue styleValue = this.createCSSValue("mask-repeat", this.currentValue);
            String string = styleValue.getCssText();
            this.nextCurrentValue();
            if (string.equals("repeat-y") || string.equals("repeat-x")) {
                valueList.add(styleValue);
            } else if (this.currentValue != null && LexicalUnit.LexicalType.IDENT == this.currentValue.getLexicalUnitType() && this.testIdentifiers("mask-repeat")) {
                ValueList valueList2 = ValueList.createWSValueList();
                valueList2.add(styleValue);
                valueList2.add(this.createCSSValue("mask-repeat", this.currentValue));
                valueList.add(valueList2);
                this.nextCurrentValue();
            } else {
                valueList.add(styleValue);
            }
            return true;
        }
        return false;
    }

    private boolean testIdentifierProperty(int n, Set<String> set, String string, ValueList valueList) {
        if (LexicalUnit.LexicalType.IDENT == this.currentValue.getLexicalUnitType() && this.testIdentifiers(string)) {
            StyleValue styleValue = this.createCSSValue(string, this.currentValue);
            valueList.add(styleValue);
            return true;
        }
        return false;
    }

    @Override
    protected void resetSubproperties() {
        super.resetSubproperties();
        this.resetMaskBorderProperties();
    }

    private void resetMaskBorderProperties() {
        this.setPropertyToDefault("mask-border-source");
        this.setPropertyToDefault("mask-border-slice");
        this.setPropertyToDefault("mask-border-width");
        this.setPropertyToDefault("mask-border-outset");
        this.setPropertyToDefault("mask-border-repeat");
        this.setPropertyToDefault("mask-border-mode");
    }

    @Override
    protected void setSubpropertiesToKeyword(StyleValue styleValue) {
        super.setSubpropertiesToKeyword(styleValue);
        this.setProperty("mask-border-source", styleValue, this.isPriorityImportant());
        this.setProperty("mask-border-slice", styleValue, this.isPriorityImportant());
        this.setProperty("mask-border-width", styleValue, this.isPriorityImportant());
        this.setProperty("mask-border-outset", styleValue, this.isPriorityImportant());
        this.setProperty("mask-border-repeat", styleValue, this.isPriorityImportant());
        this.setProperty("mask-border-mode", styleValue, this.isPriorityImportant());
        this.flush();
    }
}

