/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.font;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class AWTGlyphGeometryCache {
    private static final int INITIAL_CAPACITY = 71;
    private Entry[] table;
    private AtomicInteger count = new AtomicInteger();
    private ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final ReentrantLock tableLock = new ReentrantLock();

    public AWTGlyphGeometryCache() {
        this.table = new Entry[71];
    }

    public AWTGlyphGeometryCache(int n) {
        this.table = new Entry[n];
    }

    public int size() {
        return this.count.get();
    }

    public Value get(char c) {
        int n = this.hashCode(c) & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && entry.match(c)) {
                return (Value)entry.get();
            }
            entry = entry.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value put(char c, Value value) {
        int n;
        int n2 = this.hashCode(c) & Integer.MAX_VALUE;
        this.tableLock.lock();
        try {
            this.removeClearedEntries();
            n = n2 % this.table.length;
            Entry entry = this.table[n];
            if (entry != null) {
                if (entry.hash == n2 && entry.match(c)) {
                    Object t = entry.get();
                    this.table[n] = new Entry(n2, c, value, entry.next);
                    Value value2 = (Value)t;
                    return value2;
                }
                Entry entry2 = entry;
                entry = entry.next;
                while (entry != null) {
                    if (entry.hash == n2 && entry.match(c)) {
                        Object t = entry.get();
                        entry2.next = entry = new Entry(n2, c, value, entry.next);
                        Value value3 = (Value)t;
                        return value3;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
            }
            int n3 = this.table.length;
            if (this.count.getAndIncrement() >= n3 - (n3 >> 2)) {
                this.rehash();
                n = n2 % this.table.length;
            }
        }
        finally {
            this.tableLock.unlock();
        }
        this.table[n] = new Entry(n2, c, value, this.table[n]);
        return null;
    }

    public void clear() {
        this.tableLock.lock();
        try {
            this.table = new Entry[71];
        }
        finally {
            this.tableLock.unlock();
        }
        this.count.lazySet(0);
        this.referenceQueue = new ReferenceQueue();
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i = entryArray.length - 1; i >= 0; --i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n = entry2.hash % this.table.length;
                entry2.next = this.table[n];
                this.table[n] = entry2;
            }
        }
    }

    protected int hashCode(char c) {
        return c;
    }

    protected void removeClearedEntries() {
        Entry entry;
        while ((entry = (Entry)this.referenceQueue.poll()) != null) {
            int n = entry.hash % this.table.length;
            Entry entry2 = this.table[n];
            if (entry2 == entry) {
                this.table[n] = entry.next;
            } else {
                while (entry2 != null) {
                    Entry entry3 = entry2.next;
                    if (entry3 == entry) {
                        entry2.next = entry.next;
                        break;
                    }
                    entry2 = entry3;
                }
            }
            this.count.decrementAndGet();
        }
    }

    protected class Entry
    extends SoftReference<Value> {
        public int hash;
        public char c;
        public Entry next;

        public Entry(int n, char c, Value value, Entry entry) {
            super(value, AWTGlyphGeometryCache.this.referenceQueue);
            this.hash = n;
            this.c = c;
            this.next = entry;
        }

        public boolean match(char c) {
            return this.c == c;
        }
    }

    public static class Value {
        protected Shape outline;
        protected Rectangle2D gmB;
        protected Rectangle2D outlineBounds;

        public Value(Shape shape, Rectangle2D rectangle2D) {
            this.outline = shape;
            this.outlineBounds = shape.getBounds2D();
            this.gmB = rectangle2D;
        }

        public Shape getOutline() {
            return this.outline;
        }

        public Rectangle2D getBounds2D() {
            return this.gmB;
        }

        public Rectangle2D getOutlineBounds2D() {
            return this.outlineBounds;
        }
    }
}

