/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.ParameterType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

final class CombinatorialGeneratedExpressionFactory {
    private static final int MAX_EXPRESSIONS = 256;
    private final String expressionTemplate;
    private final List<List<ParameterType<?>>> parameterTypeCombinations;

    CombinatorialGeneratedExpressionFactory(String expressionTemplate, List<List<ParameterType<?>>> parameterTypeCombinations) {
        this.expressionTemplate = expressionTemplate;
        this.parameterTypeCombinations = parameterTypeCombinations;
    }

    List<GeneratedExpression> generateExpressions() {
        ArrayList<GeneratedExpression> generatedExpressions = new ArrayList<GeneratedExpression>();
        ArrayDeque permutation = new ArrayDeque(this.parameterTypeCombinations.size());
        this.generatePermutations(generatedExpressions, permutation);
        return generatedExpressions;
    }

    private void generatePermutations(List<GeneratedExpression> generatedExpressions, Deque<ParameterType<?>> permutation) {
        if (generatedExpressions.size() >= 256) {
            return;
        }
        if (permutation.size() == this.parameterTypeCombinations.size()) {
            ArrayList permutationCopy = new ArrayList(permutation);
            generatedExpressions.add(new GeneratedExpression(this.expressionTemplate, permutationCopy));
            return;
        }
        List<ParameterType<?>> parameterTypes = this.parameterTypeCombinations.get(permutation.size());
        for (ParameterType<?> parameterType : parameterTypes) {
            if (generatedExpressions.size() >= 256) {
                return;
            }
            permutation.addLast(parameterType);
            this.generatePermutations(generatedExpressions, permutation);
            permutation.removeLast();
        }
    }
}

