define(["exports","./common/playback/playbackmanager.js","./emby-apiclient/connectionmanager.js","./emby-apiclient/events.js","./common/input/api.js","./common/methodtimer.js"],function(_exports,_playbackmanager,_connectionmanager,_events,_api,_methodtimer){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var PlayerName="Remote Control";function sendPlayCommand(instance,apiClient,options,playType){instance=instance.currentSessionId,playType={ItemIds:(options.ids||options.items.map(function(i){return i.Id})).join(","),PlayCommand:playType};return null!=options.startPositionTicks&&(playType.StartPositionTicks=options.startPositionTicks),options.mediaSourceId&&(playType.MediaSourceId=options.mediaSourceId),null!=options.audioStreamIndex&&(playType.AudioStreamIndex=options.audioStreamIndex),null!=options.subtitleStreamIndex&&(playType.SubtitleStreamIndex=options.subtitleStreamIndex),null!=options.startIndex&&(playType.StartIndex=options.startIndex),apiClient.sendPlayCommand(instance,playType)}function sendPlayStateCommand(instance,apiClient,command,options){instance=instance.currentSessionId;return apiClient.sendPlayStateCommand(instance,command,options)}function getCurrentApiClient(instance){instance=instance.currentServerId;return instance?_connectionmanager.default.getApiClient(instance):_connectionmanager.default.currentApiClient()}function sendCommandByName(instance,name,options){name={Name:name};return options&&(name.Arguments=options),instance.sendCommand(name)}function clearPollInterval(instance){instance.pollInterval&&(instance.pollInterval.destroy(),instance.pollInterval=null)}function processUpdatedSessions(instance,sessions,apiClient){var currentTargetId=instance.currentSessionId;!function(instance,session,apiClient){if(session){var serverId=apiClient.serverId(),eventNames=(session.NowPlayingItem&&(session.NowPlayingItem.ServerId=serverId),normalizeImages(session,apiClient),function(){var names=[];return names.push("statechange"),names}(instance.lastPlayerData));instance.lastPlayerData=session;for(var i=0,length=eventNames.length;i<length;i++)_events.default.trigger(instance,eventNames[i],[session])}else instance.lastPlayerData=session,_playbackmanager.default.removeActivePlayer(PlayerName)}(instance,sessions.filter(function(s){return s.Id===currentTargetId})[0],apiClient)}function triggerEvent(instance,eventName,session){"sessionstarted"===eventName&&(eventName="statechange"),session?_events.default.trigger(instance,eventName,[session]):_events.default.trigger(instance,eventName)}function subscribeToPlayerUpdates(instance){var sessionId=instance.currentSessionId||"";getCurrentApiClient(instance).startMessageListener("SessionEvents","100,800,"+sessionId),clearPollInterval(instance),instance.pollInterval=new _methodtimer.default({onInterval:function(){var instance=this,apiClient=getCurrentApiClient(instance);apiClient.isMessageChannelOpen()||apiClient.getSessions({Id:instance.currentSessionId,IncludeAllSessionsIfAdmin:!1}).then(function(sessions){processUpdatedSessions(instance,sessions,apiClient)})}.bind(instance),timeoutMs:5e3,type:"interval"})}function normalizeImages(state,apiClient){state&&state.NowPlayingItem&&((state=state.NowPlayingItem).ImageTags&&state.ImageTags.Primary||state.PrimaryImageTag&&(state.ImageTags=state.ImageTags||{},state.ImageTags.Primary=state.PrimaryImageTag),state.BackdropImageTag&&state.BackdropItemId===state.Id&&(state.BackdropImageTags=[state.BackdropImageTag]),state.BackdropImageTag&&state.BackdropItemId!==state.Id&&(state.ParentBackdropImageTags=[state.BackdropImageTag],state.ParentBackdropItemId=state.BackdropItemId),state.ServerId||(state.ServerId=apiClient.serverId()))}function SessionPlayer(){var self=this;this.name=PlayerName,this.type="mediaplayer",this.isLocalPlayer=!1,this.id="remoteplayer",_events.default.on(_api.default,"SessionEvents",function(e,apiClient,data){!function(instance,sessionEventInfo,apiClient){var triggerTimeUpdate,session,eventName=(sessionEventInfo.EventName||"statechange").toLowerCase();"sessionended"===eventName||"remotecontroldisconnected"===eventName?(instance.lastPlayerData=null,_playbackmanager.default.removeActivePlayer(PlayerName)):(session=sessionEventInfo.SessionInfo)?(normalizeImages(session,apiClient),session.NowPlayingItem&&(session.NowPlayingItem.ServerId=apiClient.serverId()),session.MediaSource||(session.MediaSource=session.NowPlayingItem),session.NextMediaType=sessionEventInfo.NextMediaType,instance.lastPlayerData=session,triggerEvent(instance,eventName,session)):(session=instance.lastPlayerData)&&(apiClient=(apiClient=session.PlayState)||{},triggerTimeUpdate=!1,null!=sessionEventInfo.PositionTicks&&(apiClient.PositionTicks=sessionEventInfo.PositionTicks,triggerTimeUpdate=!0),null!=sessionEventInfo.PlaylistIndex&&(session.PlaylistIndex=sessionEventInfo.PlaylistIndex),null!=sessionEventInfo.PlaylistLength&&(session.PlaylistLength=sessionEventInfo.PlaylistLength),null!=sessionEventInfo.PlaylistItemId&&(session.PlaylistItemId=sessionEventInfo.PlaylistItemId),null!=sessionEventInfo.IsPaused&&(apiClient.IsPaused=sessionEventInfo.IsPaused),null!=sessionEventInfo.VolumeLevel&&(apiClient.VolumeLevel=sessionEventInfo.VolumeLevel),null!=sessionEventInfo.IsMuted&&(apiClient.IsMuted=sessionEventInfo.IsMuted),null!=sessionEventInfo.RepeatMode&&(apiClient.RepeatMode=sessionEventInfo.RepeatMode),null!=sessionEventInfo.Shuffle&&(apiClient.Shuffle=sessionEventInfo.Shuffle),null!=sessionEventInfo.SubtitleOffset&&(apiClient.SubtitleOffset=sessionEventInfo.SubtitleOffset),null!=sessionEventInfo.PlaybackRate&&(apiClient.PlaybackRate=sessionEventInfo.PlaybackRate),"subtitletrackchange"===eventName?apiClient.SubtitleStreamIndex=sessionEventInfo.SubtitleStreamIndex:"audiotrackchange"===eventName&&(apiClient.AudioStreamIndex=sessionEventInfo.AudioStreamIndex),"playlistitemremove"===eventName?triggerEvent(instance,eventName,sessionEventInfo):triggerEvent(instance,eventName),"timeupdate"!==eventName)&&triggerTimeUpdate&&triggerEvent(instance,"timeupdate")}(self,data,apiClient)})}SessionPlayer.prototype.beginPlayerUpdates=function(){this.playerListenerCount=this.playerListenerCount||0,this.playerListenerCount<=0&&(this.playerListenerCount=0,subscribeToPlayerUpdates(this)),this.playerListenerCount++},SessionPlayer.prototype.endPlayerUpdates=function(){var instance;this.playerListenerCount=this.playerListenerCount||0,this.playerListenerCount--,this.playerListenerCount<=0&&(getCurrentApiClient(instance=this).stopMessageListener("SessionEvents"),clearPollInterval(instance),this.playerListenerCount=0)},SessionPlayer.prototype.getPlayerState=function(){return this.lastPlayerData||{}},SessionPlayer.prototype.getTargets=function(){var name,apiClient=getCurrentApiClient(this),sessionQuery={ControllableByUserId:apiClient.getCurrentUserId(),IncludeAllSessionsIfAdmin:!1};return apiClient?(name=this.name,apiClient.getSessions(sessionQuery).then(function(sessions){return sessions.filter(function(s){return s.DeviceId!==apiClient.deviceId()}).map(function(s){return{name:s.DeviceName,deviceName:s.DeviceName,deviceType:s.DeviceType,id:s.Id,playerName:name,appName:s.Client,playableMediaTypes:s.PlayableMediaTypes,isLocalPlayer:!1,supportedCommands:s.SupportedCommands,user:s.UserId?{Id:s.UserId,Name:s.UserName,PrimaryImageTag:s.UserPrimaryImageTag}:null}})})):Promise.resolve([])},SessionPlayer.prototype.sendCommand=function(command){var sessionId=this.currentSessionId;return getCurrentApiClient(this).sendCommand(sessionId,command)},SessionPlayer.prototype.play=function(options){if((options=Object.assign({},options)).shuffle){var _options$items;if(null!=(_options$items=options.items)&&_options$items.length)return this.shuffle(options.items[0]);if(null!=(_options$items=options.ids)&&_options$items.length)return this.shuffle({Id:options.ids[0]})}return options.items&&(options.ids=options.items.map(function(i){return i.Id}),options.items=null),sendPlayCommand(this,getCurrentApiClient(this),options,"PlayNow")},SessionPlayer.prototype.shuffle=function(item){return sendPlayCommand(this,getCurrentApiClient(this),{ids:[item.Id]},"PlayShuffle")},SessionPlayer.prototype.instantMix=function(item){return sendPlayCommand(this,getCurrentApiClient(this),{ids:[item.Id]},"PlayInstantMix")},SessionPlayer.prototype.queue=function(options){return sendPlayCommand(this,getCurrentApiClient(this),options,"PlayLast")},SessionPlayer.prototype.queueNext=function(options){return sendPlayCommand(this,getCurrentApiClient(this),options,"PlayNext")},SessionPlayer.prototype.canPlayMediaType=function(mediaType){switch(mediaType){case"Audio":case"Video":return!0;default:return!1}},SessionPlayer.prototype.stop=function(){return sendPlayStateCommand(this,getCurrentApiClient(this),"stop")},SessionPlayer.prototype.nextTrack=function(){return sendPlayStateCommand(this,getCurrentApiClient(this),"nextTrack")},SessionPlayer.prototype.previousTrack=function(){return sendPlayStateCommand(this,getCurrentApiClient(this),"previousTrack")},SessionPlayer.prototype.seekRelative=function(positionTicks){var apiClient=getCurrentApiClient(this);return apiClient.isMinServerVersion("4.8.0.35")?sendPlayStateCommand(this,apiClient,"seekrelative",{SeekPositionTicks:positionTicks}):sendPlayStateCommand(this,apiClient,"seek",{SeekPositionTicks:positionTicks+this.currentTime()})},SessionPlayer.prototype.seek=function(positionTicks){return sendPlayStateCommand(this,getCurrentApiClient(this),"seek",{SeekPositionTicks:positionTicks})},SessionPlayer.prototype.currentTime=function(val){return null!=val?this.seek(val):((this.lastPlayerData||{}).PlayState||{}).PositionTicks},SessionPlayer.prototype.playbackStartTime=function(){return((this.lastPlayerData||{}).PlayState||{}).PlaybackStartTimeTicks},SessionPlayer.prototype.duration=function(){return((this.lastPlayerData||{}).MediaSource||{}).RunTimeTicks},SessionPlayer.prototype.paused=function(){return((this.lastPlayerData||{}).PlayState||{}).IsPaused},SessionPlayer.prototype.getVolume=function(){return((this.lastPlayerData||{}).PlayState||{}).VolumeLevel},SessionPlayer.prototype.isMuted=function(){return((this.lastPlayerData||{}).PlayState||{}).IsMuted},SessionPlayer.prototype.pause=function(){return sendPlayStateCommand(this,getCurrentApiClient(this),"Pause")},SessionPlayer.prototype.unpause=function(){return sendPlayStateCommand(this,getCurrentApiClient(this),"Unpause")},SessionPlayer.prototype.playPause=function(){return sendPlayStateCommand(this,getCurrentApiClient(this),"PlayPause")},SessionPlayer.prototype.setMute=function(isMuted){return sendCommandByName(this,isMuted?"Mute":"Unmute")},SessionPlayer.prototype.toggleMute=function(){return sendCommandByName(this,"ToggleMute")},SessionPlayer.prototype.setVolume=function(vol){return sendCommandByName(this,"SetVolume",{Volume:vol})},SessionPlayer.prototype.volumeUp=function(){return sendCommandByName(this,"VolumeUp")},SessionPlayer.prototype.volumeDown=function(){return sendCommandByName(this,"VolumeDown")},SessionPlayer.prototype.getAudioStreamIndex=function(){return((this.lastPlayerData||{}).PlayState||{}).AudioStreamIndex},SessionPlayer.prototype.playTrailers=function(item){return sendCommandByName(this,"PlayTrailers",{ItemId:item.Id})},SessionPlayer.prototype.setAudioStreamIndex=function(index){return sendCommandByName(this,"SetAudioStreamIndex",{Index:index})},SessionPlayer.prototype.getSubtitleStreamIndex=function(){return((this.lastPlayerData||{}).PlayState||{}).SubtitleStreamIndex},SessionPlayer.prototype.setSubtitleStreamIndex=function(index,refreshMediaSource){return sendCommandByName(this,"SetSubtitleStreamIndex",{Index:index,RefreshMediaSource:refreshMediaSource})},SessionPlayer.prototype.getMaxStreamingBitrate=function(){},SessionPlayer.prototype.setMaxStreamingBitrate=function(options){},SessionPlayer.prototype.isFullscreen=function(){},SessionPlayer.prototype.toggleFullscreen=function(){return sendCommandByName(this,"ToggleFullscreen")},SessionPlayer.prototype.getRepeatMode=function(){return((this.lastPlayerData||{}).PlayState||{}).RepeatMode},SessionPlayer.prototype.setRepeatMode=function(mode){return sendCommandByName(this,"SetRepeatMode",{RepeatMode:mode})},SessionPlayer.prototype.getShuffle=function(){return((this.lastPlayerData||{}).PlayState||{}).Shuffle},SessionPlayer.prototype.setShuffle=function(mode){return sendCommandByName(this,"SetShuffle",{Shuffle:mode})},SessionPlayer.prototype.getSubtitleOffset=function(){return((this.lastPlayerData||{}).PlayState||{}).SubtitleOffset},SessionPlayer.prototype.setSubtitleOffset=function(value){return sendCommandByName(this,"SetSubtitleOffset",{SubtitleOffset:value})},SessionPlayer.prototype.incrementSubtitleOffset=function(value){return sendCommandByName(this,"IncrementSubtitleOffset",{Increment:value})},SessionPlayer.prototype.getPlaybackRate=function(){return((this.lastPlayerData||{}).PlayState||{}).PlaybackRate},SessionPlayer.prototype.setPlaybackRate=function(value){return sendCommandByName(this,"SetPlaybackRate",{PlaybackRate:value})},SessionPlayer.prototype.displayContent=function(options){return sendCommandByName(this,"DisplayContent",options)},SessionPlayer.prototype.currentMediaSource=function(){return(this.lastPlayerData||{}).MediaSource},SessionPlayer.prototype.isPlaying=function(mediaType){var _this$lastPlayerData=null==(_this$lastPlayerData=this.lastPlayerData)?void 0:_this$lastPlayerData.NowPlayingItem;return _this$lastPlayerData&&(!mediaType||_this$lastPlayerData.MediaType===mediaType)},SessionPlayer.prototype.getPlaylist=function(){return getCurrentApiClient(this).getPlayQueue({Id:this.currentSessionId})},SessionPlayer.prototype.getCurrentPlaylistItemId=function(){return(this.lastPlayerData||{}).PlaylistItemId},SessionPlayer.prototype.getCurrentPlaylistIndex=function(){return(this.lastPlayerData||{}).PlaylistIndex},SessionPlayer.prototype.getCurrentPlaylistLength=function(){return(this.lastPlayerData||{}).PlaylistLength},SessionPlayer.prototype.setCurrentPlaylistItem=function(playlistItemId){return sendCommandByName(this,"SetCurrentPlaylistItem",{PlaylistItemId:playlistItemId})},SessionPlayer.prototype.movePlaylistItem=function(playlistItemId,newIndex){return sendCommandByName(this,"MovePlaylistItem",{PlaylistItemId:playlistItemId,NewIndex:newIndex})},SessionPlayer.prototype.removeFromPlaylist=function(playlistItemIds){return sendCommandByName(this,"RemoveFromPlaylist",{PlaylistItemIds:playlistItemIds.join(",")})},SessionPlayer.prototype.tryPair=function(target){return this.currentSessionId=target.id,Promise.resolve()};_exports.default=SessionPlayer});