/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.ConnectionInfo;
import com.zeroc.Ice.Endpoint;
import com.zeroc.Ice.Exception;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Instrumentation.ChildInvocationObserver;
import com.zeroc.Ice.Instrumentation.InvocationObserver;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.OperationInterruptedException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UnknownException;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.InvocationFutureI;
import com.zeroc.IceInternal.OutgoingAsyncBase;
import com.zeroc.IceInternal.Protocol;
import java.util.concurrent.ExecutionException;

public abstract class OutgoingAsyncBaseI<T>
extends InvocationFutureI<T>
implements OutgoingAsyncBase {
    protected OutputStream _os;
    protected ChildInvocationObserver _childObserver;

    @Override
    public boolean sent() {
        return this.sent(true);
    }

    @Override
    public boolean completed(InputStream is) {
        assert (false);
        return false;
    }

    @Override
    public boolean completed(Exception ex) {
        return this.finished(ex);
    }

    @Override
    public final void attachRemoteObserver(ConnectionInfo info, Endpoint endpt, int requestId) {
        InvocationObserver observer = this.getObserver();
        if (observer != null) {
            int size = this._os.size() - 14 - 4;
            this._childObserver = observer.getRemoteObserver(info, endpt, requestId, size);
            if (this._childObserver != null) {
                this._childObserver.attach();
            }
        }
    }

    @Override
    public final void attachCollocatedObserver(ObjectAdapter adapter, int requestId) {
        InvocationObserver observer = this.getObserver();
        if (observer != null) {
            int size = this._os.size() - 14 - 4;
            this._childObserver = observer.getCollocatedObserver(adapter, requestId, size);
            if (this._childObserver != null) {
                this._childObserver.attach();
            }
        }
    }

    @Override
    public final OutputStream getOs() {
        return this._os;
    }

    public T waitForResponse() {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        try {
            return this.get();
        }
        catch (InterruptedException ex) {
            throw new OperationInterruptedException(ex);
        }
        catch (ExecutionException ee) {
            try {
                throw ee.getCause().fillInStackTrace();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UnknownException(ex);
            }
        }
    }

    protected OutgoingAsyncBaseI(Communicator com, Instance instance, String op) {
        super(com, instance, op);
        this._os = new OutputStream(instance, Protocol.currentProtocolEncoding);
    }

    protected OutgoingAsyncBaseI(Communicator com, Instance instance, String op, OutputStream os) {
        super(com, instance, op);
        this._os = os;
    }

    @Override
    protected boolean sent(boolean done) {
        if (done && this._childObserver != null) {
            this._childObserver.detach();
            this._childObserver = null;
        }
        return super.sent(done);
    }

    @Override
    protected boolean finished(Exception ex) {
        if (this._childObserver != null) {
            this._childObserver.failed(ex.ice_id());
            this._childObserver.detach();
            this._childObserver = null;
        }
        return super.finished(ex);
    }
}

