/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.IceBoxDescriptor;
import com.zeroc.IceGrid.ServerDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.PlainServer;
import com.zeroc.IceGridGUI.Application.Root;
import com.zeroc.IceGridGUI.Application.ServerTemplate;
import com.zeroc.IceGridGUI.Application.ServiceInstance;
import com.zeroc.IceGridGUI.Application.Templates;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.TreeNodeBase;
import com.zeroc.IceGridGUI.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JPopupMenu;

class ServerTemplates
extends Templates {
    private Map<String, TemplateDescriptor> _descriptors;
    private static JPopupMenu _popup;

    public static Map<String, TemplateDescriptor> copyDescriptors(Map<String, TemplateDescriptor> descriptors) {
        HashMap<String, TemplateDescriptor> copy = new HashMap<String, TemplateDescriptor>();
        for (Map.Entry<String, TemplateDescriptor> p : descriptors.entrySet()) {
            copy.put(p.getKey(), ServerTemplate.copyDescriptor(p.getValue()));
        }
        return copy;
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[10] = true;
        actions[11] = true;
        Object clipboard = this.getCoordinator().getClipboard();
        if (clipboard != null && clipboard instanceof TemplateDescriptor) {
            TemplateDescriptor d = (TemplateDescriptor)clipboard;
            actions[14] = d.descriptor instanceof ServerDescriptor;
        }
        return actions;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(10));
            _popup.add(actions.get(11));
        }
        actions.setTarget(this);
        return _popup;
    }

    @Override
    public void newTemplateServer() {
        this.newServerTemplate(new TemplateDescriptor(PlainServer.newServerDescriptor(), new LinkedList<String>(), new TreeMap<String, String>()));
    }

    @Override
    public void newTemplateServerIceBox() {
        this.newServerTemplate(new TemplateDescriptor(PlainServer.newIceBoxDescriptor(), new LinkedList<String>(), new TreeMap<String, String>()));
    }

    @Override
    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        TemplateDescriptor td = ServerTemplate.copyDescriptor((TemplateDescriptor)descriptor);
        if (td.descriptor instanceof IceBoxDescriptor && !this.getRoot().pasteIceBox((IceBoxDescriptor)td.descriptor)) {
            return;
        }
        this.newServerTemplate(td);
    }

    ServerTemplates(Root parent, Map<String, TemplateDescriptor> descriptors) throws UpdateFailedException {
        super(parent, "Server templates");
        this._descriptors = descriptors;
        for (Map.Entry<String, TemplateDescriptor> p : this._descriptors.entrySet()) {
            this.insertChild(new ServerTemplate(false, this, p.getKey(), p.getValue()), false);
        }
    }

    @Override
    Utils.Resolver getResolver() {
        return null;
    }

    Map<String, TemplateDescriptor> getUpdates() {
        HashMap<String, TemplateDescriptor> updates = new HashMap<String, TemplateDescriptor>();
        for (TreeNodeBase p : this._children) {
            ServerTemplate t = (ServerTemplate)p;
            if (!t.getEditable().isNew() && !t.getEditable().isModified()) continue;
            updates.put(t.getId(), (TemplateDescriptor)t.getDescriptor());
        }
        return updates;
    }

    void commit() {
        this._editable.commit();
        for (TreeNodeBase p : this._children) {
            ServerTemplate st = (ServerTemplate)p;
            st.commit();
        }
    }

    List<ServiceInstance> findServiceInstances(String template) {
        LinkedList<ServiceInstance> result = new LinkedList<ServiceInstance>();
        for (TreeNodeBase p : this._children) {
            ServerTemplate t = (ServerTemplate)p;
            result.addAll(t.findServiceInstances(template));
        }
        return result;
    }

    void removeServiceInstances(String template) {
        for (TreeNodeBase p : this._children) {
            ServerTemplate t = (ServerTemplate)p;
            t.removeServiceInstances(template);
        }
    }

    void newServerTemplate(TemplateDescriptor descriptor) {
        ServerTemplate t;
        block2: {
            String id = descriptor.descriptor instanceof IceBoxDescriptor ? this.makeNewChildId("NewIceBoxTemplate") : this.makeNewChildId("NewServerTemplate");
            t = new ServerTemplate(this, id, descriptor);
            try {
                this.insertChild(t, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(t);
    }

    @Override
    void tryAdd(String newId, TemplateDescriptor descriptor) throws UpdateFailedException {
        this.insertChild(new ServerTemplate(true, this, newId, descriptor), true);
        this._descriptors.put(newId, descriptor);
    }

    void update(Map<String, TemplateDescriptor> updates, String[] removeTemplates, Set<String> serviceTemplates) throws UpdateFailedException {
        Root root = this.getRoot();
        this.removeChildren(removeTemplates);
        ArrayList<ServerTemplate> newChildren = new ArrayList<ServerTemplate>();
        LinkedList<ServerTemplate> updatedChildren = new LinkedList<ServerTemplate>();
        for (Map.Entry<String, TemplateDescriptor> entry : updates.entrySet()) {
            String name = entry.getKey();
            TemplateDescriptor templateDescriptor = entry.getValue();
            ServerTemplate child = (ServerTemplate)this.findChild(name);
            if (child == null) {
                newChildren.add(new ServerTemplate(false, this, name, templateDescriptor));
                continue;
            }
            child.rebuild(templateDescriptor);
            updatedChildren.add(child);
        }
        for (String string : serviceTemplates) {
            List<ServiceInstance> serviceInstances = this.findServiceInstances(string);
            for (ServiceInstance q : serviceInstances) {
                ServerTemplate serverTemplate = (ServerTemplate)q.getParent();
                if (updatedChildren.contains(serverTemplate) || newChildren.contains(serverTemplate)) continue;
                serverTemplate.rebuild();
                updatedChildren.add(serverTemplate);
            }
        }
        this.childrenChanged(updatedChildren);
        this.insertChildren(newChildren, true);
    }

    void removeDescriptor(String id) {
        this._descriptors.remove(id);
    }

    @Override
    Object getDescriptor() {
        return this._descriptors;
    }
}

