/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre9Compat;
import org.apache.tomcat.util.res.StringManager;

class Jre16Compat
extends Jre9Compat {
    private static final Log log = LogFactory.getLog(Jre16Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre16Compat.class);
    private static final Class<?> unixDomainSocketAddressClazz;

    Jre16Compat() {
    }

    static boolean isSupported() {
        return unixDomainSocketAddressClazz != null;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.net.UnixDomainSocketAddress");
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug((Object)sm.getString("jre16Compat.javaPre16"), (Throwable)classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error((Object)sm.getString("jre16Compat.unexpected"), (Throwable)illegalArgumentException);
        }
        unixDomainSocketAddressClazz = clazz;
    }
}

