/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLAnonymousClassExpressionImpl;

public class OWLObjectComplementOfImpl
extends OWLAnonymousClassExpressionImpl
implements OWLObjectComplementOf {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLClassExpression operand;

    @Override
    protected int index() {
        return 3003;
    }

    public OWLObjectComplementOfImpl(@Nonnull OWLClassExpression operand) {
        this.operand = OWLAPIPreconditions.checkNotNull(operand, "operand cannot be null");
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        this.addSignatureEntitiesToSetForValue(entities, this.operand);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        this.addAnonymousIndividualsToSetForValue(anons, this.operand);
    }

    @Override
    public ClassExpressionType getClassExpressionType() {
        return ClassExpressionType.OBJECT_COMPLEMENT_OF;
    }

    @Override
    public boolean isClassExpressionLiteral() {
        return !this.operand.isAnonymous();
    }

    @Override
    public OWLClassExpression getOperand() {
        return this.operand;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OWLObjectComplementOf)) {
            return false;
        }
        return ((OWLObjectComplementOf)obj).getOperand().equals(this.operand);
    }

    @Override
    public void accept(@Nonnull OWLClassExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLClassExpressionVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLObjectComplementOf other = (OWLObjectComplementOf)object;
        return this.operand.compareTo(other.getOperand());
    }
}

