/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.decoding.impl;

import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.net.URISupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.binding.impl.BaseSAMLHttpServletRequestDecoder;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.binding.decoding.impl.SimpleSignatureContext;
import org.slf4j.Logger;

public class HTTPRedirectDeflateDecoder
extends BaseSAMLHttpServletRequestDecoder
implements SAMLMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPRedirectDeflateDecoder.class);
    @Nullable
    private BindingDescriptor bindingDescriptor;

    @Override
    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }

    @Nullable
    public BindingDescriptor getBindingDescriptor() {
        return this.bindingDescriptor;
    }

    public void setBindingDescriptor(@Nullable BindingDescriptor descriptor) {
        this.bindingDescriptor = descriptor;
    }

    @Override
    protected void doDecode() throws MessageDecodingException {
        String samlMessageParamName;
        String samlMessageEncoded;
        MessageContext messageContext;
        block15: {
            messageContext = new MessageContext();
            HttpServletRequest request = this.getHttpServletRequest();
            if (!"GET".equalsIgnoreCase(request.getMethod())) {
                throw new MessageDecodingException("This message decoder only supports the HTTP GET method");
            }
            String samlEncoding = StringSupport.trimOrNull(request.getParameter("SAMLEncoding"));
            if (samlEncoding != null && !"urn:oasis:names:tc:SAML:2.0:bindings:URL-Encoding:DEFLATE".equals(samlEncoding)) {
                throw new MessageDecodingException("Request indicated an unsupported SAMLEncoding: " + samlEncoding);
            }
            String relayState = request.getParameter("RelayState");
            this.log.debug("Decoded RelayState: {}", (Object)relayState);
            SAMLBindingSupport.setRelayState(messageContext, relayState);
            samlMessageEncoded = null;
            samlMessageParamName = null;
            if (!Strings.isNullOrEmpty((String)request.getParameter("SAMLRequest"))) {
                samlMessageParamName = "SAMLRequest";
                samlMessageEncoded = request.getParameter("SAMLRequest");
            } else if (!Strings.isNullOrEmpty((String)request.getParameter("SAMLResponse"))) {
                samlMessageParamName = "SAMLResponse";
                samlMessageEncoded = request.getParameter("SAMLResponse");
            }
            assert (samlMessageParamName != null);
            if (samlMessageEncoded != null) {
                try (InputStream samlMessageIns = this.decodeMessage(samlMessageEncoded);){
                    SAMLObject samlMessage = (SAMLObject)this.unmarshallMessage(samlMessageIns);
                    messageContext.setMessage(samlMessage);
                    this.log.debug("Decoded SAML message");
                    break block15;
                }
                catch (IOException e) {
                    throw new MessageDecodingException("InputStream exception decoding SAML message", e);
                }
            }
            throw new MessageDecodingException("No SAMLRequest or SAMLResponse query path parameter, invalid SAML 2 HTTP Redirect message");
        }
        this.populateSimpleSignatureContext(messageContext, samlMessageParamName, samlMessageEncoded);
        this.populateBindingContext(messageContext);
        this.setMessageContext(messageContext);
    }

    protected void populateSimpleSignatureContext(@Nonnull MessageContext messageContext, @Nonnull String samlMessageParamName, @Nonnull String samlMessage) throws MessageDecodingException {
        messageContext.ensureSubcontext(SimpleSignatureContext.class).setSignedContent(this.getSignedContent(samlMessageParamName, samlMessage));
    }

    @Nullable
    private byte[] getSignedContent(@Nonnull String samlMessageParamName, @Nonnull String samlMessage) throws MessageDecodingException {
        String queryString = this.getHttpServletRequest().getQueryString();
        this.log.debug("Constructing signed content string from URL query string {}", (Object)queryString);
        String constructed = this.buildSignedContentString(queryString, samlMessageParamName, samlMessage);
        if (Strings.isNullOrEmpty((String)constructed)) {
            this.log.warn("Could not extract signed content string from query string");
            return null;
        }
        assert (constructed != null);
        this.log.debug("Constructed signed content string for HTTP-Redirect DEFLATE {}", (Object)constructed);
        try {
            return constructed.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("UTF-8 encoding is not supported, this VM is not Java compliant");
            throw new MessageDecodingException("Unable to process message, UTF-8 encoding is not supported");
        }
    }

    @Nullable
    @NotEmpty
    private String buildSignedContentString(@Nullable String queryString, @Nonnull String samlMessageParamName, @Nonnull String samlMessage) throws MessageDecodingException {
        StringBuilder builder = new StringBuilder();
        if (!this.appendSAMLMessageParameter(builder, queryString, samlMessageParamName, samlMessage)) {
            this.log.warn("Could not extract SAML message '{}' from the query string, cannot build simple signature content", (Object)samlMessageParamName);
            return null;
        }
        this.appendParameter(builder, queryString, "RelayState");
        if (!this.appendParameter(builder, queryString, "SigAlg")) {
            this.log.warn("Signature algorithm could not be extracted from request, cannot build simple signature content");
            return null;
        }
        return builder.toString();
    }

    private boolean appendSAMLMessageParameter(@Nonnull StringBuilder builder, @Nullable String queryString, @Nonnull String paramName, @Nonnull String paramValue) {
        List rawParams = URISupport.getRawQueryStringParameters(queryString, paramName).stream().filter(p -> Objects.equals(paramValue, URISupport.doURLDecode((String)p.getSecond()))).collect(CollectionSupport.nonnullCollector(Collectors.toList())).get();
        if (rawParams.isEmpty() || rawParams.size() > 1) {
            this.log.debug("SAML message raw params extraction resulted in an invalid # of params: {}", (Object)rawParams.size());
            return false;
        }
        Pair rawParam = (Pair)rawParams.get(0);
        if (builder.length() > 0) {
            builder.append('&');
        }
        builder.append((String)rawParam.getFirst() + "=" + (String)rawParam.getSecond());
        return true;
    }

    private boolean appendParameter(@Nonnull StringBuilder builder, @Nullable String queryString, @Nullable String paramName) {
        String rawParam = URISupport.getRawQueryStringParameter(queryString, paramName);
        if (rawParam == null) {
            return false;
        }
        if (builder.length() > 0) {
            builder.append('&');
        }
        builder.append(rawParam);
        return true;
    }

    @Nonnull
    protected InputStream decodeMessage(@Nonnull String message) throws MessageDecodingException {
        this.log.debug("Base64 decoding and inflating SAML message");
        try {
            byte[] decodedBytes = Base64Support.decode(message);
            return new NoWrapAutoEndInflaterInputStream(new ByteArrayInputStream(decodedBytes));
        }
        catch (Exception e) {
            this.log.error("Unable to Base64 decode and inflate SAML message: {}", (Object)e.getMessage());
            throw new MessageDecodingException("Unable to Base64 decode and inflate SAML message", e);
        }
    }

    protected void populateBindingContext(@Nonnull MessageContext messageContext) {
        SAMLBindingContext bindingContext = messageContext.ensureSubcontext(SAMLBindingContext.class);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setBindingDescriptor(this.bindingDescriptor);
        bindingContext.setHasBindingSignature(!Strings.isNullOrEmpty((String)this.getHttpServletRequest().getParameter("Signature")));
        bindingContext.setIntendedDestinationEndpointURIRequired(SAMLBindingSupport.isMessageSigned(messageContext));
    }

    private class NoWrapAutoEndInflaterInputStream
    extends InflaterInputStream {
        public NoWrapAutoEndInflaterInputStream(InputStream is) {
            super(is, new Inflater(true));
        }

        @Override
        public void close() throws IOException {
            if (this.inf != null) {
                this.inf.end();
            }
            super.close();
        }
    }
}

