/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import java.util.Arrays;
import java.util.Random;

public class Sort {
    private static final Random prng = new Random();

    public static void stableSort(int[] order, double[] values, int n) {
        for (int i = 0; i < n; ++i) {
            order[i] = i;
        }
        Sort.stableQuickSort(order, values, 0, n, 64);
        Sort.stableInsertionSort(order, values, 0, n, 64);
    }

    public static boolean sort(int[] order, double[] values, double[] weights, int n) {
        int i;
        if (weights == null) {
            weights = Arrays.copyOf(values, values.length);
        }
        boolean r = Sort.sort(order, values, weights, 0, n);
        double medianWeight = 0.0;
        for (i = 0; i < n; ++i) {
            medianWeight += weights[i];
        }
        medianWeight /= 2.0;
        i = 0;
        double soFar = 0.0;
        double nextGroup = 0.0;
        while (i < n) {
            int j;
            for (j = i; j < n && values[order[j]] == values[order[i]]; ++j) {
                double w = weights[order[j]];
                nextGroup += w;
            }
            if (j > i + 1) {
                if (soFar >= medianWeight) {
                    Sort.reverse(order, i, j - i);
                } else if (nextGroup > medianWeight) {
                    double[] scratch = new double[j - i];
                    double netAfter = nextGroup + soFar - 2.0 * medianWeight;
                    double max = weights[order[j - 1]];
                    for (int k = j - i - 1; k >= 0; --k) {
                        double weight = weights[order[i + k]];
                        if (netAfter < 0.0) {
                            scratch[k] = weight;
                            netAfter += weight;
                            continue;
                        }
                        scratch[k] = 2.0 * max + 1.0 - weight;
                        netAfter -= weight;
                    }
                    int[] sub = new int[j - i];
                    Sort.sort(sub, scratch, scratch, 0, j - i);
                    int[] tmp = Arrays.copyOfRange(order, i, j);
                    for (int k = 0; k < j - i; ++k) {
                        order[i + k] = tmp[sub[k]];
                    }
                }
            }
            soFar = nextGroup;
            i = j;
        }
        return r;
    }

    private static boolean sort(int[] order, double[] values, double[] weights, int start, int n) {
        boolean inOrder = true;
        for (int i = start; i < start + n; ++i) {
            if (inOrder && i < start + n - 1) {
                inOrder = values[i] < values[i + 1] || values[i] == values[i + 1] && weights[i] <= weights[i + 1];
            }
            order[i] = i;
        }
        if (inOrder) {
            return true;
        }
        Sort.quickSort(order, values, weights, start, start + n, 64);
        Sort.insertionSort(order, values, weights, start, start + n, 64);
        return false;
    }

    private static void quickSort(int[] order, double[] values, double[] weights, int start, int end, int limit) {
        while (end - start > limit) {
            int pivotIndex = start + prng.nextInt(end - start);
            double pivotValue = values[order[pivotIndex]];
            double pivotWeight = weights[order[pivotIndex]];
            Sort.swap(order, start, pivotIndex);
            int low = start + 1;
            int high = end;
            int i = low;
            while (i < high) {
                double vi = values[order[i]];
                double wi = weights[order[i]];
                if (vi == pivotValue && wi == pivotWeight) {
                    if (low != i) {
                        Sort.swap(order, low, i);
                    } else {
                        ++i;
                    }
                    ++low;
                    continue;
                }
                if (vi > pivotValue || vi == pivotValue && wi > pivotWeight) {
                    Sort.swap(order, i, --high);
                    continue;
                }
                ++i;
            }
            int from = start;
            int to = high - 1;
            i = 0;
            while (from < low && to >= low) {
                Sort.swap(order, from++, to--);
                ++i;
            }
            if ((low = from == low ? to + 1 : from) - start < end - high) {
                Sort.quickSort(order, values, weights, start, low, limit);
                start = high;
                continue;
            }
            Sort.quickSort(order, values, weights, high, end, limit);
            end = low;
        }
    }

    private static void stableQuickSort(int[] order, double[] values, int start, int end, int limit) {
        while (end - start > limit) {
            int pivotIndex = start + prng.nextInt(end - start);
            double pivotValue = values[order[pivotIndex]];
            int pv = order[pivotIndex];
            Sort.swap(order, start, pivotIndex);
            int low = start + 1;
            int high = end;
            int i = low;
            while (i < high) {
                double vi = values[order[i]];
                int pi = order[i];
                if (vi == pivotValue && pi == pv) {
                    if (low != i) {
                        Sort.swap(order, low, i);
                    } else {
                        ++i;
                    }
                    ++low;
                    continue;
                }
                if (vi > pivotValue || vi == pivotValue && pi > pv) {
                    Sort.swap(order, i, --high);
                    continue;
                }
                ++i;
            }
            int from = start;
            int to = high - 1;
            i = 0;
            while (from < low && to >= low) {
                Sort.swap(order, from++, to--);
                ++i;
            }
            if ((low = from == low ? to + 1 : from) - start < end - high) {
                Sort.stableQuickSort(order, values, start, low, limit);
                start = high;
                continue;
            }
            Sort.stableQuickSort(order, values, high, end, limit);
            end = low;
        }
    }

    public static void sort(double[] key, double[] ... values) {
        Sort.sort(key, 0, key.length, values);
    }

    public static void sort(double[] key, int start, int n, double[] ... values) {
        Sort.quickSort(key, values, start, start + n, 8);
        Sort.insertionSort(key, values, start, start + n, 8);
    }

    private static void quickSort(double[] key, double[][] values, int start, int end, int limit) {
        while (end - start > limit) {
            double pivotValue;
            int pivotIndex;
            int a = start;
            int b = (start + end) / 2;
            int c = end - 1;
            double va = key[a];
            double vb = key[b];
            double vc = key[c];
            if (va > vb) {
                if (vc > va) {
                    pivotIndex = a;
                    pivotValue = va;
                } else if (vc < vb) {
                    pivotIndex = b;
                    pivotValue = vb;
                } else {
                    pivotIndex = c;
                    pivotValue = vc;
                }
            } else if (vc > vb) {
                pivotIndex = b;
                pivotValue = vb;
            } else if (vc < va) {
                pivotIndex = a;
                pivotValue = va;
            } else {
                pivotIndex = c;
                pivotValue = vc;
            }
            Sort.swap(start, pivotIndex, key, values);
            int low = start + 1;
            int high = end;
            int i = low;
            while (i < high) {
                double vi = key[i];
                if (vi == pivotValue) {
                    if (low != i) {
                        Sort.swap(low, i, key, values);
                    } else {
                        ++i;
                    }
                    ++low;
                    continue;
                }
                if (vi > pivotValue) {
                    Sort.swap(i, --high, key, values);
                    continue;
                }
                ++i;
            }
            int from = start;
            int to = high - 1;
            i = 0;
            while (from < low && to >= low) {
                Sort.swap(from++, to--, key, values);
                ++i;
            }
            if ((low = from == low ? to + 1 : from) - start < end - high) {
                Sort.quickSort(key, values, start, low, limit);
                start = high;
                continue;
            }
            Sort.quickSort(key, values, high, end, limit);
            end = low;
        }
    }

    private static void insertionSort(double[] key, double[][] values, int start, int end, int limit) {
        block0: for (int i = start + 1; i < end; ++i) {
            double v = key[i];
            int m = Math.max(i - limit, start);
            for (int j = i; j >= m; --j) {
                if (j != m && !(key[j - 1] <= v)) continue;
                if (j >= i) continue block0;
                System.arraycopy(key, j, key, j + 1, i - j);
                key[j] = v;
                for (double[] value : values) {
                    double tmp = value[i];
                    System.arraycopy(value, j, value, j + 1, i - j);
                    value[j] = tmp;
                }
                continue block0;
            }
        }
    }

    private static void swap(int[] order, int i, int j) {
        int t = order[i];
        order[i] = order[j];
        order[j] = t;
    }

    private static void swap(int i, int j, double[] key, double[] ... values) {
        double t = key[i];
        key[i] = key[j];
        key[j] = t;
        for (int k = 0; k < values.length; ++k) {
            t = values[k][i];
            values[k][i] = values[k][j];
            values[k][j] = t;
        }
    }

    public static void checkPartition(int[] order, double[] values, double pivotValue, int start, int low, int high, int end) {
        double v;
        int i;
        if (order.length != values.length) {
            throw new IllegalArgumentException("Arguments must be same size");
        }
        if (start < 0 || low < start || high < low || end < high) {
            throw new IllegalArgumentException(String.format("Invalid indices %d, %d, %d, %d", start, low, high, end));
        }
        for (i = 0; i < low; ++i) {
            v = values[order[i]];
            if (!(v >= pivotValue)) continue;
            throw new IllegalArgumentException(String.format("Value greater than pivot at %d", i));
        }
        for (i = low; i < high; ++i) {
            if (values[order[i]] == pivotValue) continue;
            throw new IllegalArgumentException(String.format("Non-pivot at %d", i));
        }
        for (i = high; i < end; ++i) {
            v = values[order[i]];
            if (!(v <= pivotValue)) continue;
            throw new IllegalArgumentException(String.format("Value less than pivot at %d", i));
        }
    }

    private static void insertionSort(int[] order, double[] values, double[] weights, int start, int n, int limit) {
        block0: for (int i = start + 1; i < n; ++i) {
            int t = order[i];
            double v = values[order[i]];
            double w = weights == null ? 0.0 : weights[order[i]];
            int m = Math.max(i - limit, start);
            for (int j = i; j >= m; --j) {
                if (j != 0 && !(values[order[j - 1]] < v) && (values[order[j - 1]] != v || weights != null && !(weights[order[j - 1]] <= w))) continue;
                if (j >= i) continue block0;
                System.arraycopy(order, j, order, j + 1, i - j);
                order[j] = t;
                continue block0;
            }
        }
    }

    private static void stableInsertionSort(int[] order, double[] values, int start, int n, int limit) {
        block0: for (int i = start + 1; i < n; ++i) {
            int t = order[i];
            double v = values[order[i]];
            int vi = order[i];
            int m = Math.max(i - limit, start);
            for (int j = i; j >= m; --j) {
                if (j != 0 && !(values[order[j - 1]] < v) && (values[order[j - 1]] != v || order[j - 1] > vi)) continue;
                if (j >= i) continue block0;
                System.arraycopy(order, j, order, j + 1, i - j);
                order[j] = t;
                continue block0;
            }
        }
    }

    public static void reverse(int[] order) {
        Sort.reverse(order, 0, order.length);
    }

    public static void reverse(int[] order, int offset, int length) {
        for (int i = 0; i < length / 2; ++i) {
            int t = order[offset + i];
            order[offset + i] = order[offset + length - i - 1];
            order[offset + length - i - 1] = t;
        }
    }

    public static void reverse(double[] order, int offset, int length) {
        for (int i = 0; i < length / 2; ++i) {
            double t = order[offset + i];
            order[offset + i] = order[offset + length - i - 1];
            order[offset + length - i - 1] = t;
        }
    }
}

