/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;

class DBACopyingBinder
extends Binder {
    private static final String CLASS_NAME = DBACopyingBinder.class.getName();

    DBACopyingBinder() {
    }

    @Override
    Binder copyingBinder() {
        return this;
    }

    @Override
    boolean isCopying() {
        return true;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        if (rankInBuffer == 0) {
            stmt.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "bind", "rankInBuffer=0, bindPosition={0}, lastBoundInds[bindPosition]={1}, lastBoundLens[bindPosition]={2}, lastBoundDataLengths[bindPosition]={3}, lastBoundDataOffsets[bindPosition]={4}. ", (String)null, (Throwable)null, (Object)bindPosition, (Object)stmt.lastBoundInds[bindPosition], (Object)stmt.lastBoundLens[bindPosition], (Object)stmt.lastBoundDataLengths[bindPosition], (Object)stmt.lastBoundDataOffsets[bindPosition]);
            bindIndicators[indoffset] = stmt.lastBoundInds[bindPosition];
            bindIndicators[lenoffset] = stmt.lastBoundLens[bindPosition];
            bindDataLengths[bindDataIndex] = stmt.lastBoundDataLengths[bindPosition];
            bindDataOffsets[bindDataIndex] = stmt.lastBoundDataOffsets[bindPosition];
        } else if (bindDataIndex >= stmt.numberOfBindPositions) {
            bindIndicators[indoffset] = bindIndicators[indoffset - 1];
            bindIndicators[lenoffset] = bindIndicators[lenoffset - 1];
            bindDataLengths[bindDataIndex] = bindDataLengths[bindDataIndex - stmt.numberOfBindPositions];
            bindDataOffsets[bindDataIndex] = bindDataOffsets[bindDataIndex - stmt.numberOfBindPositions];
        }
        stmt.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "bind", "bindDataIndex={0}, bindDataLengths[bindDataIndex]={1}, bindDataOffsets[bindDataIndex]={2}. ", (String)null, (Throwable)null, (Object)bindDataIndex, (Object)bindDataLengths[bindDataIndex], (Object)bindDataOffsets[bindDataIndex]);
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : bindData.updateChecksum(bindDataOffsets[bindDataIndex], bindDataLengths[bindDataIndex], PhysicalConnection.CHECKSUM, localCheckSum);
        }
        return localCheckSum;
    }

    @Override
    void lastBoundValueCleanup(OraclePreparedStatement stmt, int bindPosition) {
        if (stmt.lastBoundBlobs != null) {
            stmt.moveTempLobsToFree(stmt.lastBoundBlobs[bindPosition]);
        }
        if (stmt.lastBoundClobs != null) {
            stmt.moveTempLobsToFree(stmt.lastBoundClobs[bindPosition]);
        }
    }
}

