/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.schema;

import java.util.Objects;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.DiffResult;
import org.openapitools.openapidiff.core.model.schema.ChangedNullable;

public class ChangedUniqueItems
implements Changed {
    private final Boolean left;
    private final Boolean right;

    public ChangedUniqueItems(Boolean leftNullable, Boolean rightNullable) {
        this.left = leftNullable;
        this.right = rightNullable;
    }

    @Override
    public DiffResult isChanged() {
        boolean rightValue;
        boolean leftValue = this.left != null && this.left != false;
        boolean bl = rightValue = this.right != null && this.right != false;
        if (!leftValue && rightValue) {
            return DiffResult.INCOMPATIBLE;
        }
        if (leftValue && !rightValue) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.NO_CHANGES;
    }

    public Boolean getLeft() {
        return this.left;
    }

    public Boolean getRight() {
        return this.right;
    }

    public String toString() {
        return "ChangedUniqueItems [left=" + this.left + ", right=" + this.right + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedNullable that = (ChangedNullable)o;
        return Objects.equals(this.left, that.getLeft()) && Objects.equals(this.right, that.getRight());
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

