/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import com.jidesoft.plaf.xerto.XertoUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class SlidingFrameBorder
implements Border,
UIResource {
    public static final int SHADOW_SIZE = 10;
    protected Color _highlight;
    protected Color _lightHighlight;
    protected Color _shadow;
    protected Color _darkShadow;
    protected Insets _insets;
    private static double LOG10 = Math.log(10.0);

    public SlidingFrameBorder(Color highlight, Color lightHighlight, Color shadow, Color darkShadow, Insets insets) {
        this._highlight = highlight;
        this._lightHighlight = lightHighlight;
        this._shadow = shadow;
        this._darkShadow = darkShadow;
        this._insets = insets;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this._insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        if (this._insets.top >= 10) {
            g2.setColor(XertoUtils.getFrameBorderColor());
            g2.drawRect(x, y + this._insets.top - 1, width, height - this._insets.top + 1);
            g2.setColor(this._highlight);
            g2.drawLine(x, y + this._insets.top - 5, x + width, y + this._insets.top - 5);
            g2.setColor(this._lightHighlight);
            g2.drawLine(x, y + this._insets.top - 4, x + width, y + this._insets.top - 4);
            g2.setColor(this._highlight);
            g2.drawLine(x, y + this._insets.top - 3, x + width, y + this._insets.top - 3);
            g2.drawLine(x, y + this._insets.top - 2, x + width, y + this._insets.top - 2);
            SlidingFrameBorder.paintGradient(g2, new Rectangle(x, y, width, this._insets.top - 5), true, 40, false);
        }
        if (this._insets.left >= 10) {
            g2.setColor(XertoUtils.getFrameBorderColor());
            g2.drawRect(x + this._insets.left - 1, y, width - this._insets.left, height);
            g2.setColor(this._highlight);
            g2.drawLine(x + this._insets.left - 5, y, x + this._insets.left - 5, y + height);
            g2.setColor(this._lightHighlight);
            g2.drawLine(x + this._insets.left - 4, y, x + this._insets.left - 4, y + height);
            g2.setColor(this._highlight);
            g2.drawLine(x + this._insets.left - 3, y, x + this._insets.left - 3, y + height);
            g2.drawLine(x + this._insets.left - 2, y, x + this._insets.left - 2, y + height);
            SlidingFrameBorder.paintGradient(g2, new Rectangle(x, y, this._insets.left - 5, height), false, 40, false);
        }
        if (this._insets.bottom >= 10) {
            g2.setColor(XertoUtils.getFrameBorderColor());
            g2.drawRect(x, y, width, height - this._insets.bottom);
            g2.setColor(this._highlight);
            g2.drawLine(x, y + height - this._insets.bottom + 1, x + width, y + height - this._insets.bottom + 1);
            g2.drawLine(x, y + height - this._insets.bottom + 2, x + width, y + height - this._insets.bottom + 2);
            g2.setColor(this._shadow);
            g2.drawLine(x, y + height - this._insets.bottom + 3, x + width, y + height - this._insets.bottom + 3);
            g2.setColor(this._darkShadow);
            g2.drawLine(x, y + height - this._insets.bottom + 4, x + width, y + height - this._insets.bottom + 4);
            SlidingFrameBorder.paintGradient(g2, new Rectangle(x, y + height - this._insets.bottom + 4, width, this._insets.bottom - 5), true, 100, true);
        }
        if (this._insets.right >= 10) {
            g2.setColor(XertoUtils.getFrameBorderColor());
            g2.drawRect(x, y, width - this._insets.right, height);
            g2.setColor(this._highlight);
            g2.drawLine(x + width - this._insets.right + 1, y, x + width - this._insets.right + 1, y + height);
            g2.drawLine(x + width - this._insets.right + 2, y, x + width - this._insets.right + 2, y + height);
            g2.setColor(this._shadow);
            g2.drawLine(x + width - this._insets.right + 3, y, x + width - this._insets.right + 3, y + height);
            g2.setColor(this._darkShadow);
            g2.drawLine(x + width - this._insets.right + 4, y, x + width - this._insets.right + 4, y + height);
            SlidingFrameBorder.paintGradient(g2, new Rectangle(x + width - this._insets.right + 4, y, this._insets.right - 5, height), false, 100, true);
        }
    }

    public static void paintGradient(Graphics g2, Rectangle rect, boolean isVertical, int darkness, boolean lighter) {
        if (isVertical) {
            for (int i = 1; i < rect.height; ++i) {
                int iAlpha = (int)((1.0 - Math.log(i) / LOG10) * (double)darkness);
                g2.setColor(new Color(0, 0, 0, iAlpha));
                if (lighter) {
                    g2.drawLine(rect.x, rect.y + i, rect.x + rect.width, rect.y + i);
                    continue;
                }
                g2.drawLine(rect.x, rect.y + rect.height - i, rect.x + rect.width, rect.y + rect.height - i);
            }
        } else {
            for (int i = 1; i < rect.width; ++i) {
                int iAlpha = (int)((1.0 - Math.log(i) / LOG10) * (double)darkness);
                g2.setColor(new Color(0, 0, 0, iAlpha));
                if (lighter) {
                    g2.drawLine(rect.x + i, rect.y, rect.x + i, rect.y + rect.height);
                    continue;
                }
                g2.drawLine(rect.x + rect.width - i, rect.y, rect.x + rect.width - i, rect.y + rect.height);
            }
        }
    }
}

